<?php
/*
  $Id$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2007 osCommerce

  Released under the GNU General Public License
*/

// look in your $PATH_LOCALE/locale directory for available locales
// or type locale -a on the server.
// Examples:
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
@setlocale(LC_TIME, 'it.UTF8');

define('DATE_FORMAT_SHORT', '%d/%m/%Y');  // this is used for strftime()
define('DATE_FORMAT_LONG', '%A %d %B, %Y'); // this is used for strftime()
define('DATE_FORMAT', 'd/m/Y'); // this is used for date()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');
define('JQUERY_DATEPICKER_I18N_CODE', 'it'); // leave empty for en_US; see http://jqueryui.com/demos/datepicker/#localization
define('JQUERY_DATEPICKER_FORMAT', 'dd/mm/yy'); // see http://docs.jquery.com/UI/Datepicker/formatDate

////
// Return date in raw format
// $date should be in format dd/mm/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function tep_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 0, 2) . substr($date, 3, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 3, 2) . substr($date, 0, 2);
  }
}

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
define('LANGUAGE_CURRENCY', 'EUR');

// Global entries for the <html> tag
define('HTML_PARAMS', 'dir="ltr" lang="IT"');

// charset for web pages and emails
define('CHARSET', 'utf-8');

// page title
define('TITLE', STORE_NAME);

// header text in includes/header.php
define('HEADER_TITLE_CREATE_ACCOUNT', 'Crea account');
define('HEADER_TITLE_MY_ACCOUNT', 'Il mio account');
define('HEADER_TITLE_CART_CONTENTS', 'Carrello');
define('HEADER_TITLE_CHECKOUT', 'Acquista');
define('HEADER_TITLE_TOP', 'Top');
define('HEADER_TITLE_CATALOG', 'Catalogo');
define('HEADER_TITLE_LOGOFF', 'Esci');
define('HEADER_TITLE_LOGIN', 'Entra');

// footer text in includes/footer.php
define('FOOTER_TEXT_REQUESTS_SINCE', 'Richiesto da');

// text for gender
define('MALE', 'Uomo');
define('FEMALE', 'Donna');
define('MALE_ADDRESS', 'Sig.');
define('FEMALE_ADDRESS', 'Sign.');

// text for date of birth example
define('DOB_FORMAT_STRING', 'dd/mm/yyyy');

// checkout procedure text
define('CHECKOUT_BAR_DELIVERY', 'Informazioni sulla spedizione');
define('CHECKOUT_BAR_PAYMENT', 'Informazioni sul pagamento');
define('CHECKOUT_BAR_CONFIRMATION', 'Conferma');
define('CHECKOUT_BAR_FINISHED', 'Fine!');

// pull down default text
define('PULL_DOWN_DEFAULT', 'Scegli');
define('TYPE_BELOW', 'Sotto');

// javascript messages
define('JS_ERROR', 'sono emersi errori durante la procedura.\n\nSegui le istruzioni qui sotto:\n\n');

define('JS_REVIEW_TEXT', '* The \'Review Text\' must have at least ' . REVIEW_TEXT_MIN_LENGTH . ' characters.\n');
define('JS_REVIEW_RATING', '* You must rate the product for your review.\n');

define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Seleziona un metodo di pagamento.\n');

define('JS_ERROR_SUBMITTED', 'Questo modulo è già stato inviato. Si prega di premere OK e attendere che il processo sarà concluso.');

define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Seleziona il metodo di pagamento per questo ordine.');

define('CATEGORY_COMPANY', 'Dettagli della società');
define('CATEGORY_PERSONAL', 'Dati personali');
define('CATEGORY_ADDRESS', 'Il tuo indirizzo');
define('CATEGORY_CONTACT', 'I tuoi contatti');
define('CATEGORY_OPTIONS', 'Opzioni');
define('CATEGORY_PASSWORD', 'La tua password');

define('ENTRY_COMPANY', 'Nome della società:');
define('ENTRY_COMPANY_TEXT', '');
define('ENTRY_GENDER', 'Gentile:');
define('ENTRY_GENDER_ERROR', 'Agenzia investigativa fai da te, i prezzi più bassi sul web');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME', 'Nome:');
define('ENTRY_FIRST_NAME_ERROR', 'La casella Nome deve contenere almeno ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' caratteri.');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME', 'Cognome:');
define('ENTRY_LAST_NAME_ERROR', 'La casella Cognome deve contenere almeno' . ENTRY_LAST_NAME_MIN_LENGTH . ' caratteri.');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH', 'Data di nascita:');
define('ENTRY_DATE_OF_BIRTH_ERROR', 'La data deve essere scritta in questo formato: DD/MM/YYYY (es. 21/05/1970)');
define('ENTRY_DATE_OF_BIRTH_TEXT', '* (es. 21/05/1970)');
define('ENTRY_EMAIL_ADDRESS', 'indirizzo E-mail:');
define('ENTRY_EMAIL_ADDRESS_ERROR', 'La casella E-mail deve contenere almeno ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' caratteri.');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Il tuo indirizzo E-Mail non sembra essere valido - si prega di apportare le correzioni necessarie.');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Il tuo indirizzo E-Mail è già presente, crea un account con un indirizzo diverso.');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_STREET_ADDRESS', 'Via:');
define('ENTRY_STREET_ADDRESS_ERROR', 'La casella Via deve contenere almeno di ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' caratteri.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB', 'Quartiere:');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE', 'Cap:');
define('ENTRY_POST_CODE_ERROR', 'La casella Cap deve contenere almeno ' . ENTRY_POSTCODE_MIN_LENGTH . ' caratteri.');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CITY', 'Città:');
define('ENTRY_CITY_ERROR', 'La casella città deve contenere almeno ' . ENTRY_CITY_MIN_LENGTH . ' characters.');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE', 'State/Province:');
define('ENTRY_STATE_ERROR', 'Your State must contain a minimum of ' . ENTRY_STATE_MIN_LENGTH . ' characters.');
define('ENTRY_STATE_ERROR_SELECT', 'Please select a state from the States pull down menu.');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_COUNTRY', 'Country:');
define('ENTRY_COUNTRY_ERROR', 'You must select a country from the Countries pull down menu.');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER', 'Telephone Number:');
define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Your Telephone Number must contain a minimum of ' . ENTRY_TELEPHONE_MIN_LENGTH . ' characters.');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER', 'Numero di Fax:');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER', 'Newsletter:');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_NEWSLETTER_YES', 'Iscriviti');
define('ENTRY_NEWSLETTER_NO', 'Cancellati');
define('ENTRY_PASSWORD', 'Password:');
define('ENTRY_PASSWORD_ERROR', 'La tua password deve contenere almeno ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'The Password Confirmation must match your Password.');
define('ENTRY_PASSWORD_TEXT', '*');
define('ENTRY_PASSWORD_CONFIRMATION', 'Conferma password:');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Password corrente:');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'La password deve contenere almeno ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_NEW', 'Nuova password:');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'La tua nuova password deve contenere almeno ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'La nuova password inserita deve corrispondere.');
define('PASSWORD_HIDDEN', '--HIDDEN--');

//PIVACF start
define('ENTRY_PIVA', 'Parita Iva:');
define('ENTRY_PIVA_ERROR', 'Numero di Partita Iva scorretto.');
define('ENTRY_PIVA_TEXT', '*');
define('ENTRY_CF', 'Codice Fiscale:');
define('ENTRY_CF_TEXT', '*');
define('ENTRY_CF_ERROR', 'Codice Fiscale scorretto.');
//PIVACF end
define('FORM_REQUIRED_INFORMATION', '* Informazione richiesta');

// constants for use in tep_prev_next_display function

define('TEXT_RESULT_PAGE', 'Result Pages:');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Displaying <strong>%d</strong> to <strong>%d</strong> (of <strong>%d</strong> products)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Displaying <strong>%d</strong> to <strong>%d</strong> (of <strong>%d</strong> orders)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Displaying <strong>%d</strong> to <strong>%d</strong> (of <strong>%d</strong> reviews)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'Displaying <strong>%d</strong> to <strong>%d</strong> (of <strong>%d</strong> new products)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Displaying <strong>%d</strong> to <strong>%d</strong> (of <strong>%d</strong> specials)');

define('PREVNEXT_TITLE_FIRST_PAGE', 'Prima pagina');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Pagina precedente');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Pagina successiva');
define('PREVNEXT_TITLE_LAST_PAGE', 'Ultima pagina');
define('PREVNEXT_TITLE_PAGE_NO', 'Page %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Previous Set of %d Pages');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Next Set of %d Pages');
define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;FIRST');
define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;Prev]');
define('PREVNEXT_BUTTON_NEXT', '[Next&nbsp;&gt;&gt;]');
define('PREVNEXT_BUTTON_LAST', 'LAST&gt;&gt;');

define('IMAGE_BUTTON_ADD_ADDRESS', 'Aggiungi indirizzo');
define('IMAGE_BUTTON_ADDRESS_BOOK', 'Rubrica');
define('IMAGE_BUTTON_BACK', 'Indietro');
define('IMAGE_BUTTON_BUY_NOW', 'Compralo subito');
define('IMAGE_BUTTON_CHANGE_ADDRESS', 'Cambia indirizzo');
define('IMAGE_BUTTON_CHECKOUT', 'Checkout');
define('IMAGE_BUTTON_CONFIRM_ORDER', 'Conferma ordine');
define('IMAGE_BUTTON_CONTINUE', 'Continua');
define('IMAGE_BUTTON_CONTINUE_SHOPPING', 'Continua Shopping');
define('IMAGE_BUTTON_DELETE', 'Cancella');
define('IMAGE_BUTTON_EDIT_ACCOUNT', 'Modifica account');
define('IMAGE_BUTTON_HISTORY', 'Storico ordini');
define('IMAGE_BUTTON_LOGIN', 'Accedi');
define('IMAGE_BUTTON_IN_CART', 'Aggiungi al carrello');
define('IMAGE_BUTTON_NOTIFICATIONS', 'Notifica');
define('IMAGE_BUTTON_QUICK_FIND', 'Ricerca rapida');
define('IMAGE_BUTTON_REMOVE_NOTIFICATIONS', 'Rimuovi notifiche');
define('IMAGE_BUTTON_REVIEWS', 'Commenti');
define('IMAGE_BUTTON_SEARCH', 'Ricerca');
define('IMAGE_BUTTON_SHIPPING_OPTIONS', 'Opzioni di acquisto');
define('IMAGE_BUTTON_TELL_A_FRIEND', 'Avvisa un amico');
define('IMAGE_BUTTON_UPDATE', 'Aggiorna');
define('IMAGE_BUTTON_UPDATE_CART', 'Aggiorna carrello');
define('IMAGE_BUTTON_WRITE_REVIEW', 'Scrivi un commento');

define('SMALL_IMAGE_BUTTON_DELETE', 'Cancella');
define('SMALL_IMAGE_BUTTON_EDIT', 'Modifica');
define('SMALL_IMAGE_BUTTON_VIEW', 'Visualizza');

define('ICON_ARROW_RIGHT', 'altro');
define('ICON_CART', 'nel carrello');
define('ICON_ERROR', 'Errore');
define('ICON_SUCCESS', 'Successo');
define('ICON_WARNING', 'Attenzione');

define('TEXT_GREETING_PERSONAL', 'Ben tornato <span class="greetUser">%s!</span> vuoi vedere quali <a href="%s"><u>nuovi prodotti</u></a> sono disponibili?');
define('TEXT_GREETING_PERSONAL_RELOGON', '<small>If you are not %s, please <a href="%s"><u>log yourself in</u></a> with your account information.</small>');
define('TEXT_GREETING_GUEST', 'Desideri <a href="%s"><u>accedere al sito</u></a>? Oppure preferisci <a href="%s"><u>creare un account</u></a>?');


define('TEXT_SORT_PRODUCTS', 'Ordina prodotti ');
define('TEXT_DESCENDINGLY', 'Decrescente');
define('TEXT_ASCENDINGLY', 'Ascendente');
define('TEXT_BY', ' da ');

define('TEXT_REVIEW_BY', 'da %s');
define('TEXT_REVIEW_WORD_COUNT', '%s parole');
define('TEXT_REVIEW_RATING', 'Rating: %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Data di inserimento: %s');
define('TEXT_NO_REVIEWS', 'Al momento non ci sono recensioni.');

define('TEXT_NO_NEW_PRODUCTS', 'Attualmente non ci sono prodotti.');

define('TEXT_UNKNOWN_TAX_RATE', 'Tasso sconosciuto');

define('TEXT_REQUIRED', '<span class="errorText">Obbligatorio</span>');

define('ERROR_TEP_MAIL', '<font face="Verdana, Arial" size="2" color="#ff0000"><strong><small>TEP ERROR:</small> Cannot send the email through the specified SMTP server. Please check your php.ini setting and correct the SMTP server if necessary.</strong></font>');

define('TEXT_CCVAL_ERROR_INVALID_DATE', 'Data non valida o scaduta, verifichi gentilmente la data immessa.');
define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'I numeri inseriti non sono validi. Per favore controllali e reinseriscili.');
define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'The first four digits of the number entered are: %s. If that number is correct, we do not accept that type of credit card. If it is wrong, please try again.');

define('FOOTER_TEXT_BODY', 'Copyright &copy; ' . date('Y') . ' <a href="' . tep_href_link(FILENAME_DEFAULT) . '">' . STORE_NAME . '</a> Sede legale: Via Braie, 596 – 18033 Camporosso (IM) - P.IVA 01476660087 <br /> Iscritta al Registro delle Imprese di Imperia R.E.A. 129479 del 30/10/2008 - Capitale Sociale Euro 100.000,00 - Socio Unico MAGIA S.S. C.F: 90075630088<a href="http://www.oscommerce.com" target="_blank"></a>');
?>