<?php
class Aste extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("aste", "id", $id);
    }
    
    public function posti_rimanenti() {
        GLOBAL $db;
        $tipo_asta = $this->get("tipo_asta");
        
        # solo per le aste ARENA e PRIVE' 
        if ($tipo_asta == 'A' || $tipo_asta == 'S') {
            
            $sql = "select count(*) as c
                    from iscrizioni i
                    where asta_id=".$this->id();
            try {
                $rs = $db->Esegui($sql);
                $num_iscritti = $rs->Fields("c");
                
                return $this->get("iscrizione_partecipanti") - $num_iscritti;
            } catch (Exception $e) {
                error_log($e->getMessage());
                return false;
            } finally {
                $rs->Close();
            }
        }
        return false;
    }
    
    public function check_new_status($newstatus) {
        GLOBAL $db;
        $tipo_asta = $this->get("tipo_asta");
        
        # se lo stato non  di attesa o di start, va sempre bene
        if ($newstatus != 'W' && $newstatus != 'S' && $newstatus != 'T')
            return true;
        
        # per le aste ARENA e PRIVE' verifichiamo che ci siano i partecipanti
        if ($tipo_asta == 'A' || $tipo_asta == 'S') {
            
            $sql = "select count(*) as c
                    from iscrizioni i
                    where asta_id=".$this->id();
            try {
                $rs = $db->Esegui($sql);
                $num_iscritti = $rs->Fields("c");
                
                if ($num_iscritti < $this->get("iscrizione_partecipanti")) {
                    error_log("Gli iscritti ({$num_iscritti}) non sono sufficienti per far partire l'asta ({$this->get("iscrizione_partecipanti")}).");
                    return false;
                }
            } catch (Exception $e) {
                error_log($e->getMessage());
                return false;
            } finally {
                $rs->Close();
            }
        }
        return true;
    }
    
    public function restituisci_iscrizioni() {
        GLOBAL $db;
        
        $tipo_asta = $this->get("tipo_asta");
        if ($tipo_asta != 'A' && $tipo_asta != 'S')
            return true;
    
        $sql = "select utente_id
                from iscrizioni i
                where asta_id=".$this->id();
        try {
            $rs = $db->Esegui($sql);
            $iscritti = $rs->GetArray();
            error_log("Annullo iscrizioni");
            
            foreach($iscritti as $iscritto) {
                $u = Factory::crea("Utenti");
                $u->load($iscritto["utente_id"]);
                
                $u->update_crediti_utente($this->get("crediti_iscrizione"), $this->get("euro_iscrizione"), "Restituzione iscrizione per mancanza quorum", "", $this->code());
            }
        } catch (Exception $e) {
            error_log($e->getMessage());
        } finally {
            $rs->Close();
        }
    }
    
    
    
    public function spese_gestione_asta() {
        $tipo = $this->get("tipo_asta");
        $code_oggetto = $this->get("code_oggetto");
        $oggetto = Factory::crea("Oggetto");
        $oggetto->loadFromCode($code_oggetto);
        
        $cat = $oggetto->get("code_categoria");
        $bid = $oggetto->get("bidpack");
        error_log($cat);
        
        if ($cat != "BIDPACKMINI")
            return 0;
        if ($tipo == "A")
            return 0;
        if ($bid == 10)
            return 0.5;
        elseif ($bid == 20)
            return 1;
        else
            return 1.5;
    }
    
    public function get_autobid_list() {
        GLOBAL $db;
        
        if ($this->id() == 0)
            return false;
            
        $auction_code = $this->code();
        $sql = "SELECT ab.*, u.utente, a.code as asta_code, a.prezzo_corrente, a.vincitore
                    ,(select token from connessioni where utente_id=ab.utente_id order by id desc limit 1) as token
                    ,(select COALESCE(max(play_time), '2000-01-01') from puntate where utente_id=ab.utente_id and asta_id=a.id) as play_time
                    ,(SELECT COALESCE(SUM(COALESCE(p.crediti, 0)), 0) as count
                        FROM puntate p
                        JOIN aste a on a.id=p.asta_id
                        WHERE p.autobid='S' AND a.code='{$auction_code}' AND utente_id=u.id) as bid_usati
                FROM autobid ab
                JOIN utenti u on u.id=ab.utente_id
                JOIN aste a on a.id=ab.asta_id
                WHERE a.stato='S'
                AND COALESCE(a.vincitore, '')<>u.utente
                AND a.code='{$auction_code}'
                AND ab.pausa=0
                AND u.salvadanaio_bid>=a.crediti_puntata
                ORDER BY play_time, random()";
        $rs = $db->Esegui($sql);
        if ($rs == false)
            JSON_Error("Query fallita.", $sql);
        $autobids = array();
        $i = 0;
        while (!$rs->EOF) {
            $row = $rs->FetchRow();
            $utente_autobid = $row["utente"];
            
            # Qui verifichiamo se l'autobid deve puntare oppure no
            $prezzo_corrente = $row["prezzo_corrente"];
            if (strlen($prezzo_corrente) == 0 || $prezzo_corrente == 0)
                $prezzo_corrente = 0;
            $prezzo_iniziale = $row["prezzo_iniziale"];
            if (strlen($prezzo_iniziale) == 0 || $prezzo_iniziale == 0)
                $prezzo_iniziale = 0;
            $prezzo_finale = $row["prezzo_finale"];
            if (strlen($prezzo_finale) == 0 || $prezzo_finale == 0)
                $prezzo_finale = 1000000;
            $max_crediti = $row["max_crediti"];
            if (strlen($max_crediti) == 0 || $max_crediti == 0)
                $max_crediti = 1000000;
                
            $numero_bid_usati = $row["bid_usati"];
                
            #error_log("AUTOBID Utente: ".$utente_autobid);
            #error_log("AUTOBID Prezzo corrente: ".$prezzo_corrente);
            #error_log("AUTOBID Prezzo iniziale: ".$prezzo_iniziale);
            #error_log("AUTOBID Prezzo finale: ".$prezzo_finale);
            #error_log("AUTOBID Max credito: ".$max_crediti);
            
            //error_log("AUTOBID: ".var_export($row, true));
                
            # verifichiamo se il range di prezzo e' giusto
            if ($prezzo_corrente < $prezzo_iniziale || $prezzo_corrente > $prezzo_finale)
                continue;
                
            # verifichiamo se sono stati superati il numero massimo di bid usabili in autobid
            if ($numero_bid_usati > $max_crediti) 
                    continue;

            #if ($row["vincitore"] == $row["utente"])
            #    $row["vincitore_corrente"] = true;
            #else
            #    $row["vincitore_corrente"] = false;
            error_log("AUTOBID {$utente_autobid} aggiunto!!!");
            $autobids[$i] = $row;
            $i++;
            #$rs->MoveNext();
        }
        return $autobids;
    }
    
    
    public function get_scheduler_list() {
        GLOBAL $db;
        
        if ($this->id() == 0)
            return false;
            
        $auction_code = $this->code();
        $sql = "SELECT ab.*, u.utente, a.code as asta_code, a.prezzo_corrente, a.vincitore
                    ,(select token from connessioni where utente_id=ab.utente_id order by id desc limit 1) as token
                FROM scheduler ab
                JOIN utenti u on u.id=ab.utente_id
                JOIN aste a on a.id=ab.asta_id
                WHERE a.stato='S'
                AND COALESCE(a.vincitore, '')<>u.utente
                AND a.code='{$auction_code}'
                AND u.salvadanaio_bid>=a.crediti_puntata
                ORDER BY random()";
        $rs = $db->Esegui($sql);
        if ($rs == false)
            JSON_Error("Query fallita.", $sql);
        $scheduler = array();
        $i = 0;
        while (!$rs->EOF) {
            $row = $rs->FetchRow();
            $utente_scheduler = $row["utente"];
            
            # Qui verifichiamo se l'autobid deve puntare oppure no
            $prezzo_corrente = $row["prezzo_corrente"];
            if (strlen($prezzo_corrente) == 0 || $prezzo_corrente == 0)
                $prezzo_corrente = 0;
            $prezzo_iniziale = $row["prezzo_iniziale"];
            if (strlen($prezzo_iniziale) == 0 || $prezzo_iniziale == 0)
                $prezzo_iniziale = 0;
            $prezzo_finale = $row["prezzo_finale"];
            if (strlen($prezzo_finale) == 0 || $prezzo_finale == 0)
                $prezzo_finale = 1000000;
                
                
            #error_log("SCHEDULER Utente: ".$utente_scheduler);
            #error_log("SCHEDULER Prezzo corrente: ".$prezzo_corrente);
            #error_log("SCHEDULER Prezzo iniziale: ".$prezzo_iniziale);
            #error_log("SCHEDULER Prezzo finale: ".$prezzo_finale);
            #error_log("SCHEDULER Max credito: ".$max_crediti);
            
            //error_log("SCHEDULER: ".var_export($row, true));
                
            # verifichiamo se il range di prezzo e' giusto
            if ($prezzo_corrente < $prezzo_iniziale || $prezzo_corrente > $prezzo_finale)
                continue;
                
            error_log("SCHEDULER {$utente_scheduler} aggiunto!!!");
            $scheduler[$i] = $row;
            $i++;
            #$rs->MoveNext();
        }
        return $scheduler;
    }
}
?>