<?php
class Carrello  {
    private $m_cart_code;
    private $m_coupon_code;
    private $m_item_number;
    private $m_bids;
	private $m_ordine;
	private $m_oggetti;
    private $m_totale_complessivo;
    private $m_totale_oggetti;
    private $m_totale_spedizioni;
    private $m_totale_gestioni;

    #------------------------------------------
	# Parte STATICA
	#------------------------------------------
	private static $instance = null;

	#------------------------------------------
	public static function getInstance() {
		if (self::$instance == null) {
			if (isset($_SESSION["MARIOCART"]))
				self::$instance = unserialize($_SESSION["MARIOCART"]);
			else {
                $c = __CLASS__;
                self::$instance = new $c;
			}
		}

		return self::$instance;
	}

	#------------------------------------------
	public static function save() {
		$_SESSION["MARIOCART"] = serialize(self::$instance);
	}

	#------------------------------------------
	public static function reset() {
		if (isset($_SESSION["MARIOCART"])) {
			self::$instance = null;
			unset($_SESSION["MARIOCART"]);
			self::getInstance();
		}
	}

	#------------------------------------------
	# Parte DINAMICA
	#------------------------------------------
	private function Carrello() {
        $this->m_item_number = 0;
        $this->m_bids = 0;
        $this->m_cart_code= md5(microtime());
		$this->m_oggetti = array();
		$this->m_user = array();
        $this->m_totale_complessivo = 0;
        $this->m_totale_oggetti = 0;
        $this->m_totale_spedizioni = 0;
        $this->m_totale_gestioni = 0;
	}
	
    public function config($array_params) {
        # potremmo usare questo metodo per rendere dinomica la casse
        # tipo per le classi da usare come ordine ed item.
    }
	
    #----------------------------------------------------------------------------------------
    # FUNZIONI GET
    #----------------------------------------------------------------------------------------
    public function get_cart_code() {
        return $this->m_cart_code;
    }
	
    public function get_coupon_code() {
        return $this->m_coupon_code;
    }
	
    public function get_list() {
        return $this->m_oggetti;
    }
	
    public function get_number() {
        return count($this->m_oggetti);
    }
	
    public function get_bids() {
        return $this->m_bids;
    }
	
    public function get_totale_complessivo() {
        return $this->m_totale_complessivo;
    }
	
    public function get_totale_oggetti() {
        return $this->m_totale_oggetti;
    }
	
    public function get_totale_spedizioni() {
        return $this->m_totale_spedizioni;
    }
	
    public function get_totale_gestioni() {
        return $this->m_totale_gestioni;
    }
	
    #----------------------------------------------------------------------------------------
    # FUNZIONI SET
    #----------------------------------------------------------------------------------------
    
    public function set_cart_code($code) {
        $this->m_cart_code = $code;
    }
	
    public function set_coupon_code($code) {
        $this->m_coupon_code = $code;
    }
	
    public function set_ordine($ordine) {
        $this->m_ordine = $ordine;
        return true;
    }
	
    public function set_user($user) {
        $this->m_user = $user;
        return true;
    }
	
    #----------------------------------------------------------------------------------------
    # AGGIUNGE UN NUOVO item AL CARRELLO
    #----------------------------------------------------------------------------------------
    public function aggiungi_oggetto($item, $qta=1) {
        $code = $item->code();
        $code_asta = $item->getCodeAsta();
        
        if (isset($this->m_oggetti[$code_asta.$code]))
            return true;
            
        $bids = $item->get("bidpack");
        $store = $item->get("store");
        $moltiplicatore = (isset($_SESSION["BIDPACK_MOLTIPLICATORE"])) ? $_SESSION["BIDPACK_MOLTIPLICATORE"] : 1;
        
        # Se store=NO,  un bidpack vero e proprio
        if ($bids > 0 && $store == 'N') {
            $item->set("bidpack", $bids * $moltiplicatore);
            $this->m_bids += $bids * $moltiplicatore;
        }
        else {
            $item->set("bidpack", $bids);
            $this->m_bids += $bids;
        }
            
        $this->m_oggetti[$code_asta.$code]['oggetto'] = $item;
        $this->m_oggetti[$code_asta.$code]['quantita'] = $qta;
        $this->m_totale_complessivo += ($item->get("prezzo_spedizione") + $item->get("prezzo_mariobid") + $item->spese_gestione_asta());
        $this->m_totale_oggetti += $item->get("prezzo_mariobid");
        $this->m_totale_spedizioni += $item->get("prezzo_spedizione");
        $this->m_totale_gestioni += $item->spese_gestione_asta();
        
        return true;
    }
    
    #----------------------------------------------------------------------------------------
    # TOGLIE UN item DAL CARRELLO
    #----------------------------------------------------------------------------------------
    public function rimuovi_oggetto($item) {
        if (!is_object($item))
            $item = $this->m_oggetti[$item]['oggetto'];
            
        $code = $item->code();
        $code_asta = $item->getCodeAsta();
        $bids = $item->get("bidpack");
        $store = $item->get("store");
        
        $this->m_bids -= $bids;
        
        $this->m_totale_complessivo -= ($item->get("prezzo_spedizione") + $item->get("prezzo_mariobid") + $item->spese_gestione_asta());
        $this->m_totale_oggetti -= $item->get("prezzo_mariobid");
        $this->m_totale_spedizioni -= $item->get("prezzo_spedizione");
        $this->m_totale_gestioni -= $item->spese_gestione_asta();
        
        unset($this->m_oggetti[$code_asta.$code]);
        return true;
    }
    
    #----------------------------------------------------------------------------------------
    # CARICA DAL DB
    #----------------------------------------------------------------------------------------
    public function load_db() {
        GLOBAL $db;
         
        // ORDINE
        $ordine = Factory::crea("Ordine");
        $ordine->loadFromCode($this->m_cart_code);
        $o = $ordine->load_oggetti();
        
        // ORDINE OGGETTI
        foreach ($o as $key => $item) {
            $qta = $item->get("quantita");
            $bids = $item->get("bids");
            $code_oggetto = $item->get("code_oggetto");
            $code_asta = $item->get("code_asta");
            $flag_compralo_subito = $item->get("compralo_subito");
            $flag_iscrizione = $item->get("iscrizione");
            
            $oggetto = Factory::crea("Oggetto");
            $oggetto->loadFromCode($code_oggetto);
            $oggetto->setCodeAsta($code_asta);
            if ($flag_compralo_subito == 'S')
                $oggetto->setCompraloSubito(true); 
            if ($flag_iscrizione == 'S')
                $oggetto->setIscrizione(true); 
            if ($bids > 0)
                $oggetto->set("bidpack", $bids);
            $this->aggiungi_oggetto($oggetto, $qta);
        }

        $this->m_bids = $ordine->get('bids');
        $this->m_coupon_code = $ordine->get('coupon');
    }
    
    #----------------------------------------------------------------------------------------
    # SALVA TUTTO SUL DB
    #----------------------------------------------------------------------------------------
    public function store_db() {
        GLOBAL $db;
        
        $db->StartTrans();
        
        // ORDINE
        $ordine = Factory::crea("Ordine");
        $ordine->loadFromCode($this->m_cart_code);
        if ($ordine->id() == 0)
            $ordine->set('code', $this->m_cart_code);
        $ordine->set('account', $this->m_user["utente"]);
        $ordine->set('email', $this->m_user["email"]);
        $ordine->set('bids', $this->m_bids);
        $ordine->set('coupon', $this->m_coupon_code);
        $ordine->set('totale', $this->get_totale_complessivo());
        $ordine->set('totale_oggetti', $this->get_totale_oggetti());
        $ordine->set('spese_spedizione', $this->get_totale_spedizioni());
        $res = Factory::salva($ordine);
        
        $this->m_ordine = $ordine;
        
        // CANCELLIAMO VECCHI OGGETTI
        $ordine->delete_oggetti();
        
        // ORDINE OGGETTI
        foreach ($this->m_oggetti as $key => $item) {
            $oggetto = $item["oggetto"];
            $quantita = $item["quantita"];
            
            $oggetto->setLang('it');
            $itemcarrello = Factory::crea("OrdineOggetto");
            $itemcarrello->set('code_ordine', $this->m_cart_code /*$ordine->code()*/);
            $itemcarrello->set('code_asta', $oggetto->getCodeAsta());
            if ($oggetto->getCompraloSubito()) {
                $itemcarrello->set('compralo_subito', 'S');
            }
            if ($oggetto->getIscrizione()) {
                $itemcarrello->set('iscrizione', 'S');
            }
            $itemcarrello->set('etichetta', $oggetto->name());
            $itemcarrello->set('prezzo', $oggetto->get('prezzo_mariobid') + $oggetto->spese_gestione_asta());
            $itemcarrello->set('quantita', $quantita);
            $itemcarrello->set('categoria', $oggetto->get('code_categoria')); 
            $itemcarrello->set('bids', $oggetto->get("bidpack"));
            $itemcarrello->set('code_oggetto', $oggetto->code());
            $res = Factory::salva($itemcarrello);
        }

        return $db->CompleteTrans();
    }
}
?>