<?php
class Indirizzi extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("utenti_indirizzi", "id", $id);
    }
    
   
	################################################
	# LOAD-FROM-CODE.
    # Carica il record dal suo CODE
	public function loadFromUtenteId($id) {
		GLOBAL $db, $dbpdo;
        $this->init();

		if (is_null($dbpdo) || ($id <= 0))
			return false;
        
        $recordinfo = RecordInfo::campi($this->m_tabella);
        error_log(var_export($recordinfo, true));
        
        /*$strSQL = "SELECT * FROM ".$this->m_tabella." WHERE utente_id={$id}";
		$rs = $db->Esegui($strSQL);  #error_log($strSQL);

		if ($rs == false)
			return false;

		$this->loadFromRecord($rs);
		$rs->Close();*/
        
        $sql = "SELECT * FROM ".$this->m_tabella." WHERE utente_id=:utente_id";
        try {
            $rs = $dbpdo->prepare($sql);
            $rs->bindValue(':utente_id', $id, PDO::PARAM_INT);
            $rs->execute();
            $row = $rs->fetch();
            $this->loadFromRecord($row);
        } catch (PDOException $e) {
            error_log($e->getMessage());
        } finally {
            $rs->closeCursor();
        }
        
		return true;
	}
}
?>