<?php
class Oggetto extends RecordBase {
    private $lang;
    private $context;
    private $code_asta;
    private $flag_compralo_subito;
    private $flag_iscrizione;
    
	public function __construct($id=null) {
        parent::__construct("oggetti", "ident", $id);
        $this->lang = 'it';
        $this->flag_compralo_subito = false;
        $this->flag_iscrizione = false;
    }
    
    /*
     * SET Functions
     */
    
    public function setLang($val) {
        $this->lang = $val;
    }
    public function setContext($val) {
        $this->context = $val;
    }
    public function setCodeAsta($code) {
        $this->code_asta = $code;
    }
    public function setCompraloSubito($bool) {
        $this->flag_compralo_subito = $bool;
    }
    public function setIscrizione($bool) {
        $this->flag_iscrizione = $bool;
    }
    
    /*
     * GET Functions
     */
    
    public function getCodeAsta() {
        return $this->code_asta;
    }
    public function getCompraloSubito() {
        return $this->flag_compralo_subito;
    }
    public function getIscrizione() {
        return $this->flag_iscrizione;
    }
    public function name() {
        $val = $this->get("name_".$this->lang);
        #if ($this->get('bidpack') > 0)
        #    $val .= " ".$this->get('bidpack');
        return $val;
    }
    public function title($number) {
        $val = $this->get("title".$number."_".$this->lang);
        return $val;
    }
    public function description($number) {
        $val = $this->get("description".$number."_".$this->lang);
        return $val;
    }
    public function url_youtube($number) {
        $val = $this->get("url_youtube".$number."_".$this->lang);
        return $val;
    }
    public function shortname() {
        $val = $this->get("shortname_".$this->lang);
        return $val;
    }
    public function url() {
        $val = $this->get("url_".$this->lang);
        return $val;
    }
    public function banner() {
        $val = $this->get("banner_".$this->context);
        return $val;
    }
    public function preview() {
        $val = $this->get("preview_".$this->context);
        return $val;
    }
    public function url_image() {
        $val = $this->get("url_image_".$this->context);
        return $val;
    }
    public function spese_gestione_asta() {
        $cat = $this->get("code_categoria");
        $bid = $this->get("bidpack");
        error_log($cat);
        
        if ($cat != "BIDPACKMINI")
            return 0;
        if ($bid == 10)
            return 0.5;
        elseif ($bid == 20)
            return 1;
        else
            return 1.5;
    }
    
    /*
    prezzo_listino numeric(10,2),
    prezzo_spedizione numeric(10,2),
    store character(1) NOT NULL DEFAULT 'N'::bpchar,
    prezzo_mariobid numeric(10,2),
    bidpack integer NOT NULL DEFAULT 0,
    */
  
}
?>