<?php
require_once("classes/factory.class.php");

abstract class Record extends RecordBase {
    private $m_current_user;

	################################################
	# GET
	public function user() {
		return $this->m_current_user;
	}

	################################################
	# GET SYSRECORD
	public function sysrecord() {
		#return $this->m_sysrecord;
		$oggetto = Factory::crea("SYSRecord", $this->code());
		$oggetto->set("tabella", $this->m_tabella);
		$oggetto->set("classe", get_class($this));
		if (strlen($this->code()) == 0) {
			$code = substr(strtoupper(get_class($this).substr(md5(microtime()), rand(0, 8), 24)), 0, 50);
			$this->set("code", $code);
			$oggetto->set("code", $code);
			Factory::memorizza($this);
		}
		elseif (strlen($oggetto->code()) == 0){
			$oggetto->set("code", $this->code());
		}
		Factory::memorizza($oggetto);
		return $oggetto;
	}
	public function modificabile() {
		#GLOBAL $metautente;

		#if ($this->m_campi["modificabile"] == 'S')
		#if ($metautente->amministratore())
		#	return true;
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			if ($sysrecord->get("modificabile") == 'N')
				return false;
		return true;
	}
	public function attivo() {
		#if ($this->m_campi["attivo"] == 'S')
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			if ($sysrecord->get("attivo") == 'N')
				return false;
		return true;
	}
	public function start() {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			return $sysrecord->get("start");
	}
	public function stop() {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			return $sysrecord->get("stop");
	}
	################################################
	# SET
	
	public function setStart($data) {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			$sysrecord->set("start", $data);
		else
			die("START:: SYSRECORD NON E' OBJECT!!!");
		$this->m_changed = true;
		Factory::memorizza($sysrecord);
	}
	public function setStop($data) {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			$sysrecord->set("stop", $data);
		else
			die("STOP:: SYSRECORD NON E' OBJECT!!!");
		$this->m_changed = true;
		Factory::memorizza($sysrecord);
	}
	public function setEludiCheck($bool) {
			$this->m_eludi_check = $bool;
			return true;
	}

	public function setCode($code="") {
		# genero il CODE:
		if (strlen($this->get("code")) <= 0) {
			if (strlen($code) > 0)
				$this->set("code", $code);
			else
				$this->set("code", substr(strtoupper(get_class($this).substr(md5(microtime()), rand(0, 8), 24)), 0, 50));
		}
		return true;
	}

    public function setUser($user) {
        $this->m_current_user = $user;
		return true;
	}

	################################################
	# INIT.
	public function init($cache=true) {
		return parent::init($cache);
	}

	public function checkObbligatori($messaggio) {
		
	}

	################################################
	# CHECK.
	public function check() {
		return true;
	}
	
	################################################
	# UPDATE.
	public function update() {
        if (is_object($this->m_current_user))
			$username = $user->username();
		else
            $username = $this->m_current_user;
            
        $this->set("lu", $username);
        $this->set("lt", "now()");
        $this->set("tabella", $this->m_tabella);
		
        return parent::update();
	}

	################################################
	# INSERT.
	################################################
	public function insert() {
        if (is_object($this->m_current_user))
			$username = $user->username();
		else
            $username = $this->m_current_user;
            
        $this->set("cu", $username);
        $this->set("ct", "now()");
        $this->set("tabella", $this->m_tabella);
		
        return parent::insert();
	}

    ################################################
	# DELETE.
	################################################
	public function delete() {
		return $res;
	}

	################################################
	# notifica.
	public function notifica() {
		return true;
	}

	################################################
	# DISPLAY.
	################################################
	# - vocetipologia : codice dell'eventuale tipologia da mostrare
	# - pre : stringa da anteporre al nome di default
	# - post : stringa da posporre al nome di default
	# - readonly : se l'oggetto deve essere di pura visualizzazione
	# - fase : eventuale fase (parte) dell'oggetto da visualizzare
	################################################
	public function display($vocetipologia="", $pre="", $post="", $readonly=false, $fase=0) {
		GLOBAL $smarty, $metautente, $db;

		$HTML = new UtilsHtml();
		$HTML->setPrePost($pre, $post);
		$HTML->setReadonly($readonly);

		if (strlen($this->m_codice_classe) == 0)
			return false;

		$oggetto = & $this->metainfo();

		if (strlen($vocetipologia) > 0) {
			$voce = new MetaVoceTipologia();
			$voce->load($vocetipologia);
			$this->m_voce_tipologia = $voce;

 			$this->updateMetaInfo();
		}

		#DEBUG(get_class($this)."::Display()=".$readonly);

		#--------------------------------------------------------------------------------------------------------
		# Funzioni JAVASCRIPT
		#--------------------------------------------------------------------------------------------------------
		if (strlen($this->m_campo_tipologia) > 0) {
			$metatipologia = new MetaTipologia();
			$metatipologia->loadFromCode($this->m_codice_tipologia);
			$metatipologia->loadVoci();

			$smarty->assign("tipologia", $metatipologia);
			$smarty->assign("oggetto", $this->metainfo());
			$smarty->assign("campo_tipologia", $pre.$this->m_campo_tipologia.$post);
			$smarty->display("js_tipologia.inc");
		}

		$date = 0;

		echo "<table id='".$pre.$this->m_codice_classe.$post."' border='0' cellspacing='0' cellpadding='2'>\n";

		#--------------------------------------------------------------------------------------------------------
		# Qui disegno l'eventuale TIPOLOGIA
		if (strlen($this->m_campo_tipologia) > 0) {
			$campo = $oggetto->campo($this->m_campo_tipologia);

			echo "<tr id='div_{$campo->code()}'>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
			$HTML->label($campo);
			echo "</td>\n<td class='sx'>";

			$HTML->combobox($campo, $this, $metatipologia->voci(), "onchange=\"onTipologia_change(this);\"");
			echo "</td></tr>\n\n";
		}

		#--------------------------------------------------------------------------------------------------------
		# Per OGNI CAMPO
		foreach($oggetto->campi() as $campo) {
			# la tipologia l'ho gia' disegnata
			if ($campo->code() == $this->m_campo_tipologia)
				continue;

			# Se e' indicata una voce PRECISA, devo considerare quella:
			if (isset($voce)) {
				if (!$voce->isPresente('V', $campo->code())) {
					#echo $campo->code()." NON e' visibile<br>";
					continue;
				}
			}
			elseif (!$campo->isVisibile($metautente->ruolo()->bit())) {
				continue;
			}

			#------------------------------------------------------
			# Se e' un oggetto, lo disegno:
			if (strlen($campo->classe()) > 0) {
				echo "<tr id='div_{$campo->code()}' class=''>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
				$HTML->label($campo);
				echo "</td>\n<td class='sx'>";

				# se e' una classe
				if (class_exists($campo->classe())) {
					$classe = $campo->classe();
					$o = new $classe();

					if (is_object($this->get($campo->code())))
						$o = $this->get($campo->code());
					elseif (strlen($this->get($campo->code())) > 0)
						$o->loadFromCode($this->get($campo->code()));
					else
						$o->init();

					$o->display(null, $pre.$campo->code().$post, "", $readonly);
				}
				else {
					# provo a caricare un oggetto per il codice:
					$mo = Factory::crea("MetaOggetto", $campo->classe(), true);
					if ($mo->id() > 0) {
						$classe = $mo->phpClasse();
					}
					if (class_exists($classe)) {
						$o = new $classe();
						if (strlen($this->get($campo->code())) > 0)
							$o->loadFromCode($this->get($campo->code()));
						else
							$o->init();
						$o->display(null, $pre.$campo->code().$post, "", $readonly);
					}
					else {
						# dovrebbe essere una tipologia semplice:
						$o = new MetaTipologia();
						$o->loadFromCode($campo->classe());
						$o->loadVoci();
						$o->display(null, $pre, $post, $campo, $this, $readonly);
					}
				}

				echo "</td></tr>\n\n";
				continue;
			}
			#------------------------------------------------------
			# Se e' configurata una sorgente:
			elseif ((strlen($campo->procedura()) > 0) && (strlen($campo->rsCodice()) > 0) && (strlen($campo->rsLabel()) > 0)) {
				echo "<tr id='div_{$campo->code()}' class=''>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
				$HTML->label($campo);
				echo "</td>\n<td class='sx'>";

				$strSQL = $campo->procedura()." ".decodifica_filtri_dinamici($campo->parametri());
				$rs = $db->Esegui($strSQL);

				if (getVar("GET", "debug", 0))
					DEBUG($strSQL);

				if ($rs != FALSE) {
					$recordset = array();
					if (!$campo->isObbligatorio($metautente->ruolo()->bit()))
						$recordset[''] = '';
					while (!$rs->EOF) {
						$recordset[$rs->Fields($campo->rsCodice())] = $rs->Fields($campo->rsLabel());
						$rs->MoveNext();
					}
					$HTML->combobox($campo, $this, $recordset);
				}
 				else
					echo "<span class='grassetto rosso'>IMPOSSIBILE CONTATTARE LA SORGENTE DEI DATI. Contattare gli amministratori del servizio.</span>";
				echo "</td></tr>\n\n";
				continue;
			}
			#------------------------------------------------------
			echo "<tr id='div_{$campo->code()}' class=''>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
			$HTML->label($campo);
			echo "</td>\n"."<td class='sx'>";

			if ($readonly) {
				switch($this->tipo($campo->code())) {
					case "datetime":
						#echo date_translate($this->get($campo->code()), 'us', 'it');
						$HTML->printReadonlyValue(date_translate($this->get($campo->code()), 'us', 'it'));
						break;

					case "int":
					case "real":
					case "char":
					default:
						#echo $this->get($campo->code());
						$HTML->printReadonlyValue($this->get($campo->code()));
						break;
				}
			}
			else {
				switch($this->tipo($campo->code())) {
					case "int":
					case "real":
						$HTML->input($campo, $this, "size='10'");
						break;

					case "datetime":
						$HTML->data($campo, $this, "cal".($date++));
						break;

					case "char":
					default:
						if ($this->dimensioni($campo->code()) > 50)
							$HTML->textarea($campo, $this, 4, 50);
						else
							$HTML->input($campo, $this);
						break;
				}
			}
			echo "</td></tr>\n\n";
		}
		echo "</table>\n";
	}

	
}
?>