<?php
class Transazioni extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("transazioni", "id", $id);
    }
    
   
	################################################
	# LOAD-FROM-CODE.
    # Carica il record dal suo CODE ORDINE
	public function loadFromCodeOrdine($code) {
		GLOBAL $dbpdo;
        $this->init();

		if (is_null($dbpdo) || (strlen($code) <= 0))
			return false;
        
        $recordinfo = RecordInfo::campi($this->m_tabella);
        
        $sql = "SELECT * FROM ".$this->m_tabella." WHERE code_ordine=:code";
        try {
            $rs = $dbpdo->prepare($sql);
            $rs->bindValue(':code', $code, PDO::PARAM_STR);
            $rs->execute();
            $row = $rs->fetch(PDO::FETCH_ASSOC);
            $this->loadFromRecord($row);
        } catch (PDOException $e) {
            error_log($e->getMessage());
        } finally {
            $rs->closeCursor();
        }
        
		return true;
	}
}
?>