<?php
class Utenti extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("utenti", "id", $id);
    }
    
    public function loadFromNickname($nick) {
		GLOBAL $db, $dbpdo;
        $this->init();

		if (is_null($db) || (strlen($nick) <= 0))
			return false;
        
        $recordinfo = RecordInfo::campi($this->m_tabella);
        
        /*$strSQL = "SELECT * FROM ".$this->m_tabella." WHERE utente ilike '{$nick}'";
		$rs = $db->Esegui($strSQL);  #error_log($strSQL);

		if ($rs == false)
			return false;

		$this->loadFromRecord($rs);
		$rs->Close();*/
        
        $sql = "SELECT * FROM ".$this->m_tabella." WHERE utente ilike :nick";
        try {
            $rs = $dbpdo->prepare($sql);
            $rs->bindValue(':nick', $nick, PDO::PARAM_STR);
            $rs->execute();
            $row = $rs->fetch(PDO::FETCH_ASSOC);
            $this->loadFromRecord($row);
        } catch (PDOException $e) {
            error_log($e->getMessage());
        } finally {
            $rs->closeCursor();
        }
        
		return true;
	}
    
    public function loadIndirizzi() {
        GLOBAL $db;
        
        # Dati spedizione:
        $sql = "SELECT *
                FROM utenti_indirizzi
                WHERE utente_id={$this->id()}";
        $rs = $db->Esegui($sql);
        if ($rs) {
            if ($rs->RecordCount())
                return $rs->FetchRow();
        }
        return false;
    }
    
    # AGGIUNGE UN MOVIMENTO AI CONTI
    function update_crediti_utente($bid=0, $euro=0, $causale="", $code_ordine="", $code_asta="") {
        GLOBAL $db;
        
        if ($this->id() <= 0)
            return false;
        
        $db->StartTrans();
        
        $utente_nuovi_euro = $this->get('salvadanaio_euro') + $euro;
        $utente_nuovi_bid = $this->get('salvadanaio_bid') + $bid;
        
        # Movimenti
        $mov = Factory::crea("Movimenti");
        $mov->set('utente_id', $this->id());
        $mov->set('bid', $bid);
        $mov->set('euro', $euro);
        $mov->set('causale', $causale);
        $mov->set('code_ordine', $code_ordine);
        $mov->set('code_asta', $code_asta);
        $mov->set('saldo_euro', $utente_nuovi_euro);
        $mov->set('saldo_bid', $utente_nuovi_bid);
        $res = Factory::salva($mov);
        
        # Utente
        $this->set('salvadanaio_euro', $utente_nuovi_euro);
        $this->set('salvadanaio_bid', $utente_nuovi_bid);
        $res = Factory::salva($this);
        
        return $db->CompleteTrans();
    }
}
?>