<?php

class MetaCampo extends Meta {
	private $m_code_oggetto;
	private $m_help_breve;
	private $m_help_lungo;
	private $m_visibile;
	private $m_obbligatorio;
	private $m_modificabile;
	private $m_note;
	private $m_classe;
	private $m_posizione;
	#----------------------------------------------
	private $m_procedura;
	private $m_parametri;
	private $m_rs_codice;
	private $m_rs_label;
	
	################################################
	# Costruttore. 
	public function __construct() {
		parent::__construct();
		$this->m_help_breve = array();
		$this->m_help_lungo = array();
		$this->m_visibile = 0;
		$this->m_obbligatorio = 0;
		$this->m_modificabile = 0;
		$this->m_posizione = 0;
	}
	
	################################################
	# GET.
	public function codeOggetto() {
		return $this->m_code_oggetto;
	}
	public function helpBreve($lingua=0) {
		return $this->m_help_breve[$lingua];
	}
	public function helpLungo($lingua=0) {
		return $this->m_help_lungo[$lingua];
	}
	public function visibile() {
		return $this->m_visibile;
	}
	public function obbligatorio() {
		return $this->m_obbligatorio;
	}
	public function modificabile() {
		return $this->m_modificabile;
	}
	public function note() {
		return $this->m_note;
	}
	public function classe() {
		return $this->m_classe;
	}
	public function posizione() {
		return $this->m_posizione;
	}
	#----------------------------------------------
	public function procedura() {
		return $this->m_procedura;
	}
	public function parametri() {
		return $this->m_parametri;
	}
	public function rsCodice() {
		return $this->m_rs_codice;
	}
	public function rsLabel() {
		return $this->m_rs_label;
	}
	

	################################################
	# SET.
	public function setCodeOggetto($val) {
		if ($this->m_code_oggetto == $val)
			return;
		$this->m_changed = true;
		$this->m_code_oggetto = $val;
	}
	public function setHelpBreve($val, $lingua=0) {
		if (@$this->m_help_breve[$lingua] == $val)
			return;
		$this->m_changed = true;
		$this->m_help_breve[$lingua] = $val;
	}
	public function setHelpLungo($val, $lingua=0) {
		if (@$this->m_help_lungo[$lingua] == $val)
			return;
		$this->m_changed = true;
		$this->m_help_lungo[$lingua] = $val;
	}
	public function setVisibile($val) {
		if ($this->m_visibile == $val)
			return;
		$this->m_changed = true;
		$this->m_visibile = $val;
	}
	public function setObbligatorio($val) {
		if ($this->m_obbligatorio == $val)
			return;
		$this->m_changed = true;
		$this->m_obbligatorio = $val;
	}
	public function setModificabile($val) {
		if ($this->m_modificabile == $val)
			return;
		$this->m_changed = true;
		$this->m_modificabile = $val;
	}
	public function setNote($val) {
		if ($this->m_note == $val)
			return;
		$this->m_changed = true;
		$this->m_note = $val;
	}
	public function setClasse($val) {
		if ($this->m_classe == $val)
			return;
		$this->m_changed = true;
		$this->m_classe = $val;
	}
	public function setPosizione($val) {
		if ($this->m_posizione == $val)
			return;
		$this->m_changed = true;
		$this->m_posizione = $val;
	}
	#----------------------------------------------
	public function setProcedura($val) {
		if ($this->m_procedura == $val)
			return;
		$this->m_changed = true;
		$this->m_procedura = $val;
	}
	public function setParametri($val) {
		if ($this->m_parametri == $val)
			return;
		$this->m_changed = true;
		$this->m_parametri = $val;
	}
	public function setRsCodice($val) {
		if ($this->m_rs_codice == $val)
			return;
		$this->m_changed = true;
		$this->m_rs_codice = $val;
	}
	public function setRsLabel($val) {
		if ($this->m_rs_label == $val)
			return;
		$this->m_changed = true;
		$this->m_rs_label = $val;
	}
	

	################################################
	# MASK.
	public function isVisibile($numero_livello) {
		GLOBAL $metautente;
		
		if ($metautente->amministratore())
			return true;
		return ($this->m_visibile & pow(2, $numero_livello)) ? true : false;
	}
	
	public function isObbligatorio($numero_livello) {
		return ($this->m_obbligatorio & pow(2, $numero_livello)) ? true : false;
	}
	
	public function isModificabile($numero_livello) {
		return ($this->m_modificabile & pow(2, $numero_livello)) ? true : false;
	}
	
	################################################
	# LOAD.
	public function load($codeOggetto, $codeCampo) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($codeCampo) <= 0) || (strlen($codeOggetto) <= 0))
			return false;
			
		$strSQL = "SELECT * FROM metacampi WHERE code_oggetto=".quote_string($codeOggetto, true).
							" AND code_campo=".quote_string($codeCampo, true);
		$rs = $db->Esegui($strSQL, false);
		
		if ($rs == false)
			return false;
		
		while (!$rs->EOF) {
			$this->loadFromRecord($rs);
			$rs->MoveNext();
		}
		$rs->Close();
		$this->m_changed = false;
		return true;
	}
	
	public function loadFromRecord($rs, $suffisso="campo") {
		GLOBAL $lingue;
		parent::loadFromRecord($rs, "campo");
		if (is_null($rs))
			return false;
		$this->m_code_oggetto = $rs->Fields("code_oggetto");
		foreach($lingue as $key => $lingua) {
			$this->m_help_breve[$key] = $rs->Fields("help_breve".($key+1));
			$this->m_help_lungo[$key] = $rs->Fields("help_lungo".($key+1));
		}
		$this->m_visibile = $rs->Fields("visibile");
		$this->m_obbligatorio = $rs->Fields("obbligatorio");
		$this->m_modificabile = $rs->Fields("modificabile");
		$this->m_note = $rs->Fields("note");
		$this->m_classe = $rs->Fields("classe");
		$this->m_posizione = $rs->Fields("ordinale");
		#----------------------------------------------
		$this->m_procedura = $rs->Fields("procedura");
		$this->m_parametri = $rs->Fields("parametri");
		$this->m_rs_codice = $rs->Fields("rs_codice");
		$this->m_rs_label = $rs->Fields("rs_label");
		return true;
	}
	
	################################################
	# UPDATE.
	public function update() {
		GLOBAL $db, $metautente, $lingue;
		
		if (is_null($db) || is_null($metautente) || $this->m_id == 0)
			return false;
			
		if (!$this->m_changed)
			return true;
			
		$strSQL = "UPDATE metacampi SET ".
							"  code_oggetto=".quote_string($this->m_code_oggetto, true).
							", code_campo=".quote_string($this->m_code, true).
							", label_campo=".quote_string($this->m_label[0], true).
							", label2_campo=".quote_string($this->m_label[1], true).
							", label3_campo=".quote_string($this->m_label[2], true);
		foreach($lingue as $key => $lingua) {
			$strSQL .= ", help_breve".($key+1)."=".quote_string($this->m_help_breve[$key], true).
								 ", help_lungo".($key+1)."=".quote_string($this->m_help_lungo[$key], true);
		}
		$strSQL .=", tipo_campo=".quote_string($this->m_tipo, true).
							", visibile=".write_number($this->m_visibile, true).
							", obbligatorio=".write_number($this->m_obbligatorio, true).
							", modificabile=".write_number($this->m_modificabile, true).
							", note=".quote_string($this->m_note, true).
							", classe=".quote_string($this->m_classe, true).
							", ordinale=".write_number($this->m_posizione, true).
							", procedura=".quote_string($this->m_procedura, true).
							", parametri=".quote_string($this->m_parametri, true).
							", rs_codice=".quote_string($this->m_rs_codice, true).
							", rs_label=".quote_string($this->m_rs_label, true).
							", lu=".quote_string($metautente->get("username"), true).
							", lt=getdate()".
							" WHERE id_campo=".write_number($this->m_id, true);
		$rs = $db->Esegui($strSQL) or die($db->ErrorMsg());
		
		if ($rs == false)
			return false;
		
		$this->m_changed = false;
		return true;
	}
	
	################################################
	# INSERT.
	public function insert() {
		GLOBAL $db, $metautente, $lingue;
		
		if (is_null($db) || is_null($metautente) || $this->m_id != 0)
			return false;
			
		if (!$this->m_changed)
			return true;
			
		$strSQL = "INSERT INTO metacampi (code_campo, label_campo, label2_campo, label3_campo, code_oggetto, ";
		foreach($lingue as $key => $lingua) {
			$strSQL .= "help_breve".($key+1).", help_lungo".($key+1).", ";
		}
		$strSQL .= "tipo_campo, visibile, obbligatorio, modificabile, note, classe, ordinale, ".
							 "procedura, parametri, rs_codice, rs_label, cu, ct) VALUES".
							"(".quote_string($this->m_code, true).
							",".quote_string($this->m_label[0], true).
							",".quote_string(@$this->m_label[1], true).
							",".quote_string(@$this->m_label[2], true).
							",".quote_string($this->m_code_oggetto, true);
		foreach($lingue as $key => $lingua) {
			$strSQL .= ",".quote_string(@$this->m_help_breve[$key], true).
								 ",".quote_string(@$this->m_help_lungo[$key], true);
		}
		$strSQL .= ",".quote_string($this->m_tipo, true).
							",".write_number($this->m_visibile, true).
							",".write_number($this->m_obbligatorio, true).
							",".write_number($this->m_modificabile, true).
							",".quote_string($this->m_note, true).
							",".quote_string($this->m_classe, true).
							",".write_number($this->m_posizione, true).
							
							",".quote_string($this->m_procedura, true).
							",".quote_string($this->m_parametri, true).
							",".quote_string($this->m_rs_codice, true).
							",".quote_string($this->m_rs_label, true).
							
							",".quote_string($metautente->get("username"), true).
							",getdate()".
							")";
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
		return true;
		#return $this->load($this->m_code, $this->m_code_oggetto);
	}
	
	################################################
	# REMOVE.
	public function remove($id=0) {
		GLOBAL $db;
		
		if (is_null($db))
			return false;
			
		if ($id == 0)
			$id = $this->m_id;
			
		if ($id == 0)
			return false;
			
		# TODO: serie di check.....
			
		$strSQL = "DELETE metacampi WHERE id_campo=".write_number($id, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
		
		return true;
	}
















	################################################
	# DISPLAY.
	#
	# DA TESTARE!!!!!!!!!
	public function display($record, $readonly=false) {
		GLOBAL $db;

		$HTML = new UtilsHtml();
		$HTML->setPrePost($pre, $post);
		$HTML->setReadonly($readonly);
		
		#------------------------------------------------------
		# Se e' un oggetto, lo disegno:
		if (strlen($this->classe()) > 0) {
			# se e' una classe
			if (class_exists($this->classe())) {
				$classe = $this->classe();
				$o = new $classe();

				if (is_object($record->get($this->code())))
					$o = $record->get($this->code());
				elseif (strlen($record->get($this->code())) > 0)
					$o->loadFromCode($record->get($this->code()));
				else
					$o->init();

				$o->display(null, $pre.$this->code().$post, "", $readonly);
			}
			else {
				# provo a caricare un oggetto per il codice:
				$mo = Factory::crea("MetaOggetto", $this->classe(), true);
				if ($mo->id() > 0) {
					$classe = $mo->phpClasse();
				}
				if (class_exists($classe)) {
					$o = new $classe();
					if (strlen($record->get($campo->code())) > 0)
						$o->loadFromCode($record->get($campo->code()));
					else
						$o->init();
					$o->display(null, $pre.$this->code().$post, "", $readonly);
				}
				else {
					# dovrebbe essere una tipologia semplice:
					$o = new MetaTipologia();
					$o->loadFromCode($this->classe());
					$o->loadVoci();
					$o->display(null, $pre, $post, $this, $record, $readonly);
				}
			}

			return;
		}
		#------------------------------------------------------
		# Se e' configurata una sorgente:
		elseif ((strlen($this->procedura()) > 0) && (strlen($this->rsCodice()) > 0) && (strlen($this->rsLabel()) > 0)) {
			$strSQL = $this->procedura()." ".decodifica_filtri_dinamici($this->parametri());
			$rs = $db->Esegui($strSQL);

			if (getVar("GET", "debug", 0))
				DEBUG($strSQL);

			if ($rs != FALSE) {
				$recordset = array();
				while (!$rs->EOF) {
					$recordset[$rs->Fields($this->rsCodice())] = $rs->Fields($this->rsLabel());
					$rs->MoveNext();
				}
				$HTML->combobox($this, $record, $recordset, "", !$this->isObbligatorio(0), $readonly);
			}
			else
				echo "<span class='grassetto rosso'>IMPOSSIBILE CONTATTARE LA SORGENTE DEI DATI. Contattare gli amministratori del servizio.</span>";
			return;
		}
		#------------------------------------------------------
		if ($readonly) {
			switch($record->tipo($this->code())) {
				case "datetime":
					$value = date_translate($record->get($this->code()), 'us', 'it');
					break;

				case "int":
				case "real":
					$value = $record->get($this->code());

					if ($this->tipo() == 'V')
						if (strlen($value) > 0)
							$value = number_format($value, 2, ",", ".");

					break;
				case "char":
				default:
					$value = $record->get($this->code());
					break;
			}
			$HTML->printReadonlyValue($value);
		}
		else {
			switch($record->tipo($this->code())) {
				case "int":
				case "real":
					$HTML->input($this, $record, "size='10'");
					break;

				case "datetime":
					$HTML->data($this, $record, "cal".($date++));
					break;

				case "char":
				default:
					if ($record->dimensioni($this->code()) > 50)
						$HTML->textarea($this, $record, 4, 50);
					else
						$HTML->input($this, $record);
					break;
			}
		}
	}
}
?>