<?php

/************************************************************************************
* classe META GRUPPO
************************************************************************************/
class MetaGruppo extends Record {
	################################################
	# Costruttore.
	public function __construct() {
		parent::__construct();
		$this->m_tabella = "MetaGruppi";
		$this->m_identity = "id_gruppo";
	}
	
	################################################
	# GET
	public function id() {
		return $this->get("id_gruppo");
	}
	public function code() {
		return $this->get("code_gruppo");
	}
	public function label($lingua=0) {
		return $this->get("label".$lingua."_gruppo");
	}
	
	################################################
	# SET
	
	################################################
	# LOAD.
	public function load($id) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($id) <= 0) || ($id <= 0))
			return false;
			
		$strSQL = "SELECT * FROM MetaGruppi WHERE id_gruppo=".write_number($id, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		$count = $rs->RecordCount();
		$this->loadFromRecord($rs);
		$rs->Close();
		return $count;
	}
	public function loadFromCode($code) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($code) <= 0))
			return false;
			
		$strSQL = "SELECT * FROM MetaGruppi WHERE code_gruppo=".quote_string($code, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		$count = $rs->RecordCount();
		$this->loadFromRecord($rs);
		$rs->Close();
		return $count;
	}
}
?>