<?php
function StampaDiv($testo, $classe)
{
	if (DEBUG)
		echo <<<EOT
			<div class="$classe">$testo</div>
EOT;
}

################################################################################
# AJAX-MESSAGE:
################################################################################
function ajax_message($codice, $messaggio) {
	echo "$codice|$messaggio";
	die();
}
################################################################################
# DEBUG:
################################################################################
function DEBUG($msg="", $newline=true) {
	echo $msg;
	if ($newline)
		echo "<br />\n";
}

################################################################################
# FINISH:
################################################################################
function FINISH($msg="", $newline=true, $line="?") {
	GLOBAL $db;
	
	if ($db->TransNo() > 0) {
		$db->FailTrans();
		
		while ($db->TransNo() > 0)
			$db->CompleteTrans();
	}
	echo $msg;
	if ($newline)
		echo "<br />\n";

	#echo $line .") ". __FILE__ . "<br>";
	die();
}

################################################################################
# HEADER:
################################################################################
function Redirect($pagina, $ritardo=0) {
	/*header("Cache-Control: no-cache");
	header("Expires: -1");
	header("Location:".$pagina);
	die();*/

	echo <<< EOT
<html>
<head>
<script type="text/javascript">
require(["dojo/domReady!"],
function() {
    setTimeout('delayer()', $ritardo);
});
<!--
function delayer(){
    window.location = '{$pagina}';
}
//-->
</script>
</head>
<body>
<h2>Attendere qualche istante...</h2>
<p>Se l'attesa supera qualche secondo, probabilmente c'&egrave; un problema nel caricamento della pagina.<br />
Per spostarsi manualmente, cliccare <a href='{$pagina}'>qui</a>.</p>

</body>
</html>
EOT;
    exit();
}


################################################################################
# Tabella:
################################################################################
# Parametri:
#   $nome_tabella - nome della tabella per la quale viene creato l'oggetto.
################################################################################
function Tabella($nome_tabella, $db) 
{
  if (strcmp($nome_tabella, "MetaProcedure") == 0) 
  	$t = new TabellaSP($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaProcedureParameter") == 0)
  	$t = new TabellaParametriSP($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaTableRefParameter") == 0) 
  	$t = new TabellaRiferimentoParametri($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaTableRefParameterValue") == 0) 
  	$t = new TabellaVoceRiferimento($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaUser") == 0) 
  	$t = new TabellaUtenti($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaGroup") == 0) 
  	$t = new TabellaGruppi($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaUserGroup") == 0)
  	$t = new TabellaAssociazioneUtentiGruppi($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaGroupProcedure") == 0) 
  	$t = new TabellaAssociazioneGruppiSP($db, DEBUG);
  else if (strcmp($nome_tabella, "MetaProcedureBatch") == 0) 
  	$t = new TabellaPrenotazioni($db, DEBUG);
	else if (strcmp($nome_tabella, "PortalLog") == 0) 
  	$t = new TabellaLog($db, DEBUG);
	else if (strcmp($nome_tabella, "PortalNoDate") == 0) 
  	$t = new TabellaNoDate($db, DEBUG);
	else if (strcmp($nome_tabella, "PortalAdvice") == 0) 
  	$t = new TabellaAvvisi($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaTable") == 0) 
  	$t = new TabellaTabelle($db, DEBUG);
	else if (strcmp($nome_tabella, "MetaUserTable") == 0) 
  	$t = new TabellaAssociazioneUtentiTabelle($db, DEBUG);
	else if (strcmp($nome_tabella, "HelpDeskBUG") == 0) 
  	$t = new TabellaHelpDeskBUG($db, DEBUG);
	else if (strcmp($nome_tabella, "SystemData") == 0) 
  	$t = new TabellaSystemData($db, DEBUG);
	else
		StampaErrore(false, "Tabella '".$nome_tabella."' inesistente!", true);
  	
	return $t;
}

################################################################################
# StampaFormSQL:
################################################################################
# Parametri:
#   $strSQL - Stringa che inizializza la textarea.
################################################################################
function StampaFormSQL($strSQL) 
{
	echo <<<EOT
			<br>
      <form action="" method="POST" class="MioForm">
        <div class="header">SQL</div>
      	<div>
        	<textarea name="sql" cols="45" rows="8">$strSQL</textarea>
        </div>
				<div class="footer">
        	<button type="submit" name="Invia">Invia</button>
				</div>
      </form>
			<br>
EOT;
}

################################################################################
# CreaCSV:
################################################################################
# Parametri:
#   $filename - nome del file csv da creare.
################################################################################
function CreaCSV($filename) 
{
	$array_risultati = $_SESSION["recordset"];
	$totale_record = count($array_risultati);
	//$numfields = $recordset->FieldCount();
  $numfields = count($array_risultati[0]) / 1; // Sono doppi perch��un vettore indicizzato 
    																						 // per numero e per nome colonna.
    
  $fd = fopen($filename, "w");
  
  if ($fd == false)
  	return false;
  
  //----------------------------------------------------------------------------
  // Nomi dei campi:
  $nomi_colonne = array_keys($array_risultati[0]);
  fwrite($fd, $nomi_colonne[0]);
  for ($f = 1; $f < $numfields; $f++)
  {
  	fwrite($fd, CSV_FIELD_SEPARATOR);
    fwrite($fd, $nomi_colonne[$f]);
  }
    
  fwrite($fd, "\n");
  
  //----------------------------------------------------------------------------
  // Record:
  // Per ogni riga:
	for ($row=0; $row<$totale_record; $row++)
  {
  	// Per ogni colonna:
  	for ($i=0; $i < $numfields; $i++)
  	{
    	if ($i != 0)
    		fwrite($fd, CSV_FIELD_SEPARATOR);
			//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			$valore = trim($array_risultati[$row][$nomi_colonne[$i]]);
			if (my_is_numeric($valore)) {
				$valore = str_replace(".", ",", $valore);
			}
			//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
			fwrite($fd, $valore);
    }
    fwrite($fd, "\n");
  }
  
  fclose($fd);
  return true;
}

################################################################################
# is_datetime:
################################################################################
# Parametri:
#   $parametro - parametro da controllare sia del formato data (gg/mm/aaaa).
################################################################################
function is_datetime($parametro) 
{
	if (strlen($parametro) == 0)
  	return false;
	if (strlen($parametro) > 10)
  	return false;
  // Delimitatori di testo: barre, punti, trattini
  list ($giorno, $mese, $anno) = split('[/.-]', $parametro);
  return checkdate($mese, $giorno, $anno);
}

################################################################################
# print_html_header:
################################################################################
function print_html_header() 
{
	$titolo = TITOLO;
	$file_css = FILE_CSS;
	
	echo <<<EOT
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<html>
	
	<head>
	<title>$titolo</title>
EOT;
	/*<SCRIPT>
	<!--
	function OnTimer() {
		document.location.reload();
	}
	//-->
	</SCRIPT>*/

	//require_once(FILE_CSS);
	//
	echo <<<EOT
	<link rel='stylesheet' type='text/css' href='css/style.css'></link>
	<script language='javascript' type='text/javascript' src='js/function.js'></script>
	<link rel='shortcut icon' href="images/favicon.ico" type="image/x-icon" />
	</head>
	
	<body>
EOT;
}//<body onLoad="setTimeout('OnTimer()', 300000)">

################################################################################
# print_month:
################################################################################
function print_month($m) {
	switch ($m) {
		case 0:
			$mese = "gennaio";
			break;
		case 1:
			$mese = "febbraio";
			break;
		case 2:
			$mese = "marzo";
			break;
		case 3:
			$mese = "aprile";
			break;
		case 4:
			$mese = "maggio";
			break;
		case 5:
			$mese = "giugno";
			break;
		case 6:
			$mese = "luglio";
			break;
		case 7:
			$mese = "agosto";
			break;
		case 8:
			$mese = "settembre";
			break;
		case 9:
			$mese = "ottobre";
			break;
		case 10:
			$mese = "novembre";
			break;
		case 11:
			$mese = "dicembre";
			break;
	}
	return $mese;
}

################################################################################
# print_week:
################################################################################
function print_week($w) {
	switch ($w) {
		case 0:
			$week = "Domenica";
			break;
		case 1:
			$week = "Luned&igrave;";
			break;
		case 2:
			$week = "Marted&igrave;";
			break;
		case 3:
			$week = "Mercoled&igrave;";
			break;
		case 4:
			$week = "Gioved&igrave;";
			break;
		case 5:
			$week = "Venerd&igrave;";
			break;
		case 6:
			$week = "Sabato";
			break;
	}
	return $week;
}

################################################################################
# print_date:
################################################################################
function print_date($timestamp, $ore=FALSE) {
	$day = getdate($timestamp);
	$week =  print_week($day["wday"]);
	
	$mese = print_month($day["mon"] - 1);
	echo $week.", ".$day["mday"]." ".$mese." ".$day["year"];
	if ($ore)
		printf(" - %d:%02d", $day["hours"], $day["minutes"]);
}

################################################################################
# js_specialchars:
################################################################################
function js_specialchars($stringa) 
{
  /*return 	str_replace(
  						array('"', "'", '�', '�', '�', '�', '�, '�'),
  						array ('&quot;', "\\'", '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						$stringa
  				);*/
  #return $stringa;
return 	str_replace(
  						array("'", '"'),
  						array ("\\'", '&quot;'),
  						$stringa
  				);
}
################################################################################
# my_htmlspecialchars:
################################################################################
function my_htmlspecialchars($stringa) 
{
  /*return 	str_replace(
  						array('"', "'", '<', '>', '�', '�', '�', '�', '�, '�'),
  						array ('&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						$stringa
  				);*/
  return 	str_replace(
  						array("'"),
  						array ("''"),
  						$stringa
  				);
  #return $stringa;
}
function my_htmlspecialchars2($stringa) 
{
  /*return 	str_replace(
  						array('"', "'", '<', '>', '�', '�', '�', '�', '�, '�'),
  						array ('&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						$stringa
  				);*/
  return my_htmlspecialchars($stringa);
}
################################################################################
# my_htmlspecialchars_decode:
################################################################################
function my_htmlspecialchars_decode($stringa) 
{
  /*return 	str_replace(
  						array ('&amp;', '&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						array('&', '"', "'", '<', '>', '�', '�', '�', '�', '�, '�'),
  						$stringa
  				);*/
  return 	str_replace(
  						array("''"),
  						array ("'"),
  						$stringa
  				);
  #return $stringa;
}
################################################################################
# my_htmlspecialchars_decode_safe:
################################################################################
function my_htmlspecialchars_decode_safe($stringa) 
{
  /*return 	str_replace(
  						array ('&amp;', '&quot;', '&#039;', '&lt;', '&gt;', '&#224;', '&#232;', '&#233;', '&#236;', '&#242;', '&#249;'),
  						array('&', '\"', "''", '<', '>', '�', '�', '�', '�', '�, '�'),
  						$stringa
  				);*/
  return $stringa;
}
################################################################################
# my_is_numeric:
################################################################################
function my_is_numeric($stringa_numerica) 
{
  return ereg("^[+-]?[0-9]*\.?[0-9]+$", trim($stringa_numerica));
}
################################################################################
# my_number_format:
################################################################################
function my_number_format($number, $decimals=-1, $dec_point=SEPARATORE_DECIMALI, $thousands_sep=SEPARATORE_MIGLIAIA) {
  $number = trim($number);
  if (!my_is_numeric($number))
  	return "0";
  if ($decimals == -1)
  	return str_replace(".", SEPARATORE_DECIMALI, $number);
  else
  	return number_format($number, $decimals, $dec_point, $thousands_sep);
}
################################################################################
# getVar:
################################################################################
function getVar($tipo, $nome, $default=null) {
	$res = $default;
	switch ($tipo) {
		case "POST":
			$res = (isset($_POST[$nome])) ? $_POST[$nome] : $default;
			#$res = (array_key_exists($nome, $_POST)) ? $_POST[$nome]: $default;
			break;
			
		case "GET":
			$res = (isset($_GET[$nome])) ? $_GET[$nome] : $default;
			break;
			
		case "SESSION":
			$res = (isset($_SESSION[$nome])) ? $_SESSION[$nome] : $default;
			break;
			
		default:
			$res = $default;
			break;
	}
	if (is_null($res))
		return null;
	$res = str_replace("`", "'", $res);
	$res = str_replace("&#8242;", "'", $res);
	$res = str_replace("&#8211;", "-", $res);
	$res = str_replace("''", "'", $res);//Tolgo gli apici che il form introduce.
	$res = str_replace("\'", "'", $res);//Tolgo gli apici che il form introduce.
	$res = str_replace('\\"', '"', $res);//Tolgo event doppi apici che il form introduce.
	return trim($res); #my_htmlspecialchars_decode(my_htmlspecialchars(trim($res)));
}

################################################################################
# assert_type:
################################################################################
function assert_type($tipo, $valore, $link, $opzionale=false) {	
	// Se il param e'opzionale e il suo valore e'NULL:
	if ($opzionale)
		if (strlen($valore) == 0)
			return true;

	switch ($tipo) {
		// INTEGER -------------------------------------
		case "integer":
			if (!(strpos($valore, ".") === false));
			elseif (!(strpos($valore, ",") === false));
			elseif (is_numeric($valore))
				return true;
			break;
		// DECIMAL -------------------------------------
		case "decimal":
			if (is_numeric($valore))
				return true;
			break;
		// CHAR ----------------------------------------
		case "char":
			if (strlen($valore) == 1)
				if ((($valore >= 'A') && ($valore <= 'Z')) || 
						(($valore >= 'a') && ($valore <= 'z')) || 
						(($valore >= '0') && ($valore <= '9')))
					return true;
			break;
		// STRING --------------------------------------
		case "string":
			if (is_string($valore))
				return true;
			break;
		// DATETIME ------------------------------------
		case "datetime":
			if (is_datetime($valore))
				return true;
			break;
	}
	
	$titolo = "Errore";
	$descrizione = "Valore non corretto (".$valore.").";
	
	set_errore($titolo, $descrizione, $link);
}
################################################################################
# check_filtro_dinamico:
################################################################################
function check_filtro_dinamico($filtro) {	
/*FILTRO_UTENTE {UTENTE}
FILTRO_GRUPPO {GRUPPO}
FILTRO_ESERCIZIO {ESERCIZIO}
FILTRO_DATACONTABILE {DATACONTABILE}
FILTRO_IDMAN {IDMAN}*/
	if (strcmp(FILTRO_UTENTE, $filtro) == 0)
		return TRUE;
	if (strcmp(FILTRO_GRUPPO, $filtro) == 0)
		return TRUE;
	if (strcmp(FILTRO_ESERCIZIO, $filtro) == 0)
		return TRUE;
	if (strcmp(FILTRO_DATACONTABILE, $filtro) == 0)
		return TRUE;
	if (strcmp(FILTRO_IDMAN, $filtro) == 0)
		return TRUE;
	if (strcmp("{PRIMO_ANNO}", $filtro) == 0)
		return TRUE;
	if (strcmp("{ULTIMO_ANNO}", $filtro) == 0)
		return TRUE;
	return FALSE;
}
################################################################################
# decodifica_filtri_dinamici:
################################################################################
function decodifica_filtri_dinamici($parametro) {	
	GLOBAL $applicazione, $metautente;
/*FILTRO_UTENTE {UTENTE}
FILTRO_GRUPPO {GRUPPO}
FILTRO_ESERCIZIO {ESERCIZIO}
FILTRO_DATACONTABILE {DATA_CONTABILE}
FILTRO_DATACONTABILE {IDMAN} */
	$parametro = str_replace(FILTRO_UTENTE, $metautente->id(), $parametro);
	$parametro = str_replace(FILTRO_GRUPPO, $metautente->gruppo()->code(), $parametro);
	$parametro = str_replace(FILTRO_ESERCIZIO, $applicazione->esercizio(), $parametro);
	$parametro = str_replace(FILTRO_DATACONTABILE, $applicazione->dataContabile(), $parametro);
	$parametro = str_replace(FILTRO_IDMAN, $metautente->get('idman'), $parametro);
	$parametro = str_replace("{PRIMO_ANNO}", "01/01/".$_SESSION["esercizio"], $parametro);
	$parametro = str_replace("{ULTIMO_ANNO}", "31/12/".$_SESSION["esercizio"], $parametro);
	return $parametro;
}
################################################################################
# IsValidMail:
################################################################################
function IsValidMail($email) {
	return eregi ("^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,6}$", stripslashes(trim($email)));
}
################################################################################
# SendMail:
################################################################################
function SendMail($destinatari, $oggetto, $messaggio) {
  GLOBAL $db;
	
	if (strcmp($destinatari, "") == 0) {
    return FALSE;
	}
	//$destinatari = "daniela.coppo@rettorato.unipmn.it";
	
  // Per inviare email in formato HTML, si deve impostare l'intestazione Content-type.
  $intestazioni  = "MIME-Version: 1.0\r\n";
  $intestazioni .= "Content-type: text/plain; charset=iso-8859-15\r\n";
  $intestazioni .= "Content-Transfer-Encoding: 8bit\r\n";
  $intestazioni .= "Content-Transfer-Encoding: quoted-printable\r\n";
  
  // intestazioni addizionali 
  //$intestazioni .= "From: WebMonitor <webmonitor@rettorato.unipmn.it>";
  $intestazioni .= "From: WebManagement <noreply@rettorato.unipmn.it>";

	if (TEST) {
    $destinatari = "marcello@aspide.net";
		$oggetto = "TEST: ".$oggetto;
		$messaggio = "Messaggio dal sito di TEST. Prego ignorare. \r\n\r\n".$messaggio;
  }
  // ed infine l'invio 
  $res = mail($destinatari, $oggetto, $messaggio, $intestazioni);
  if ($res == FALSE)
		$db->Logga(LOGERROR, "Mail FALLITA!", $destinatari."-".$oggetto."<br>".$messaggio);
	else 
		$db->Logga(LOGINFO, "Mail OK", $destinatari."-".$oggetto."<br>".$messaggio);
	return $res;
}
################################################################################
# Mail_DocenteBO:
################################################################################
function Mail_DocenteBO($tipo, $mail_docente, $codice, $fornitore) {
	GLOBAL $db, $utente;
	
	if (IsValidMail($mail_docente) == FALSE) {
		$db->Logga(LOGERROR, "Mail FALLITA!", "Mail NON valida: ".$mail_docente);
		return FALSE;
	}
		
	$fornitore = my_htmlspecialchars_decode($fornitore);
	$destinatari = $mail_docente;//"daniela.coppo@rettorato.unipmn.it";

  switch ($tipo) {
  	// CREAZIONE NUOVO BO:
  	case STATUS_IN_VALIDAZIONE:
  		$oggetto = "Richiesta di ordine codice $codice";
  		$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore � in attesa di validazione presso la segreteria amministrativa.\n\n
Riceverete tramite e-mail informazioni relative al cambio di stato della medesima richiesta.\n\n
Vi ricordiamo il link cui collegarvi con il vostro profilo per la gestione delle vostre richieste:\n
http://www.rettorato.unipmn.it/webmonitor.";
  		break;
  		
  	// VALIDAZIONE:
  	case STATUS_VALIDATO:
  		$strSQL = "pl_leggi_mandate ".$codice;
			$rs_mail_docente = $db->Esegui($strSQL);
			if ($rs_mail_docente != FALSE) {
				$numero = $rs_mail_docente->Fields("nman");
			}
			
			$strSQL = "SELECT u.Username, u.Mail, e.CodiceEnte, e.NomeDatabase ".
								"FROM MetaUserGroup ug ".
								"INNER JOIN MetaGroup g ON ug.CodGroup = g.CodGroup ".
								"INNER JOIN MetaUser u ON ug.CodUser = u.CodUser ".
								"INNER JOIN Pl_Enti e ON g.CodiceEnte = e.CodiceEnte ".
								"WHERE u.CodUser=".$_SESSION["ordine"]["id_utente"];
			$rs_nome_db = $db->Esegui($strSQL);
			if ($rs_nome_db != FALSE) {
				$nome_db = $rs_nome_db->Fields("NomeDatabase");
				$destinatari = $rs_nome_db->Fields("Mail");
			}
  		$oggetto = "Validazione ordine codice $codice";
  		$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore � stata validata dalla segreteria amministrativa e registrata sul db $nome_db con il numero $numero.\n\n
Al seguente link http://www.rettorato.unipmn.it/webmonitor nella sezione 'Archivio' potete verificare l'avvenuta validazione.";
  		break;
  		
  	// ANNULLAMENTO:
  	case STATUS_ANNULLATO:
  		$strSQL = "SELECT u.Username, u.Mail, e.CodiceEnte, e.NomeDatabase ".
								"FROM MetaUserGroup ug ".
								"INNER JOIN MetaGroup g ON ug.CodGroup = g.CodGroup ".
								"INNER JOIN MetaUser u ON ug.CodUser = u.CodUser ".
								"INNER JOIN Pl_Enti e ON g.CodiceEnte = e.CodiceEnte ".
								"WHERE u.CodUser=".$_SESSION["ordine"]["id_utente"];
			$rs_nome_db = $db->Esegui($strSQL);
			if ($rs_nome_db != FALSE) {
				$nome_db = $rs_nome_db->Fields("NomeDatabase");
				$destinatari = $rs_nome_db->Fields("Mail");
			}
  		$oggetto = "Annullamento ordine codice $codice";
  		$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore � stata annullata dalla segreteria amministrativa.\n\n
Al seguente link http://www.rettorato.unipmn.it/webmonitor nella sezione 'Archivio' potete verificare l'avvenuto annullamento.";
  		break;
  		
  	// RICHIESTA MODIFICA:
  	case STATUS_RICHIESTA_MODIFICA:
  		$strSQL = "pl_leggi_mandate ".$codice;
			$rs_mail_docente = $db->Esegui($strSQL);
			if ($rs_mail_docente != FALSE) {
				$motivo = my_htmlspecialchars_decode($rs_mail_docente->Fields("segnalaupdate"));
			}
  		$strSQL = "SELECT u.Username, u.Mail, e.CodiceEnte, e.NomeDatabase ".
								"FROM MetaUserGroup ug ".
								"INNER JOIN MetaGroup g ON ug.CodGroup = g.CodGroup ".
								"INNER JOIN MetaUser u ON ug.CodUser = u.CodUser ".
								"INNER JOIN Pl_Enti e ON g.CodiceEnte = e.CodiceEnte ".
								"WHERE u.CodUser=".$_SESSION["ordine"]["id_utente"];
			$rs_nome_db = $db->Esegui($strSQL);
			if ($rs_nome_db != FALSE) {
				$nome_db = $rs_nome_db->Fields("NomeDatabase");
				$destinatari = $rs_nome_db->Fields("Mail");
			}
  		$oggetto = "Richiesta modifica all'ordine codice $codice";
  		$messaggio = "La segreteria amministrativa chiede di approntare modifiche alla vostra richiesta di ordine 
codice $codice intestata al fornitore $fornitore.\n\n
Le modifiche si riferiscono ai seguenti campi:\n
$motivo\n\n
Al seguente link http://www.rettorato.unipmn.it/webmonitor potete modificare la vostra richiesta d'ordine secondo le istruzioni della segreteria amministrativa.";
  		break;
  		
  	default:
  		return FALSE;
  }
  // ed infine l'invio 
  return SendMail($destinatari, $oggetto, $messaggio);
}

################################################################################
# Mail_SegretarioBO:
################################################################################
function Mail_SegretarioBO($tipo, $codice, $docente) {
	GLOBAL $db, $utente;
	
	$destinatari = "";
	$strSQL = "SELECT u.Mail FROM MetaUser u JOIN MetaUserGroup ug ON ug.CodUser=u.CodUser AND ug.CodGroup=".$utente->gruppodb.
						#"IN (SELECT CodGroup FROM MetaUserGroup WHERE CodUser=)"
						" WHERE u.Type='segretario'";
	$rs = $db->Esegui($strSQL);
	if ($rs != FALSE) {
		//$mail_segretario = my_htmlspecialchars_decode($rs->Fields("Mail"));
		while (!$rs->EOF) {
			if (IsValidMail($rs->Fields("Mail")))
				$destinatari .= $rs->Fields("Mail").",";
			$rs->MoveNext();
		}
	}
	$destinatari = substr($destinatari, 0, strlen($destinatari) - 1);
  //$destinatari .= "daniela.coppo@rettorato.unipmn.it";	
	//if (IsValidMail($mail_segretario) == FALSE)
		//return FALSE;
	$docente = my_htmlspecialchars_decode($docente);
	
	//$destinatari = "daniela.coppo@rettorato.unipmn.it";
	//$destinatari = $mail_segretario;
	
  switch ($tipo) {
  	// CREAZIONE NUOVO BO:
  	case STATUS_IN_VALIDAZIONE:
  		$oggetto = "Richiesta di ordine codice $codice dal docente $docente.";
  		$messaggio = "E' in attesa di validazione la richiesta di ordine codice $codice inoltrata dall'utente $docente.\n
Vi ricordiamo il link cui collegarvi con il vostro profilo per la gestione delle vostre richieste:\n
http://www.rettorato.unipmn.it/webmonitor.";
  		break;
  		
  	// VALIDAZIONE:
  	case STATUS_VALIDATO:
  		break;
  		
  	// ANNULLAMENTO:
  	case STATUS_ANNULLATO:
  		break;
  		
  	// RICHIESTA MODIFICA:
  	case STATUS_RICHIESTA_MODIFICA:
  		break;
  		
  	default:
  		return FALSE;
  }
  
  // ed infine l'invio 
  return SendMail($destinatari, $oggetto, $messaggio);
}
################################################################################
# Mail_BO:
################################################################################
function Mail_BO($STATO_PRECEDENTE) {
	GLOBAL $db, $utente;
	
	$fornitore = my_htmlspecialchars_decode(@$_SESSION["ordine"]["fornitore"]);
	$codice = @$_SESSION["ordine"]["id"];
	$mail_docente = @$_SESSION["ordine"]["mail_utente"];
	$nome_db = @$_SESSION["ordine"]["nome_database"];
	$motivo = @$_SESSION["ordine"]["update_note"];
	$docente = @$_SESSION["ordine"]["nome_utente"];
	$numero = @$_SESSION["ordine"]["numero"];
	
	#######################################################################################################
  # Controllo che le mail siano corrette:
	#######################################################################################################
  $mail_segretari = "";
	$strSQL = "SELECT u.Mail FROM MetaUser u JOIN MetaUserGroup ug ON ug.CodUser=u.CodUser AND ug.CodGroup=".$utente->gruppodb.
						" WHERE u.Type='segretario'";
	$rs = $db->Esegui($strSQL);
	if ($rs != FALSE) {
		while (!$rs->EOF) {
			if (IsValidMail($rs->Fields("Mail")))
				$mail_segretari .= $rs->Fields("Mail").",";
			else
				$db->Logga(LOGERROR, "Mail FALLITA!", "Mail segretario NON valida: ".$rs->Fields("Mail"));
			$rs->MoveNext();
		}
	}
	$mail_segretari = substr($mail_segretari, 0, strlen($mail_segretari) - 1);
  #die($mail_segretari);
	
	if (IsValidMail($mail_docente) == FALSE) {
		$db->Logga(LOGERROR, "Mail FALLITA!", "Mail docente NON valida: ".$mail_docente);
		#return FALSE;
	}
		
	#######################################################################################################
  # In base alla stato, invio le e-mail a chi di dovere:
	#######################################################################################################
  switch ($_SESSION["ordine"]["stato"]) {
  	// IN VALIDAZIONE:
  	#___________________________________________________________________
  	case STATUS_IN_VALIDAZIONE:
  		// Al DOCENTE
  		if ($STATO_PRECEDENTE != STATUS_RICHIESTA_MODIFICA) {
				$oggetto = "Richiesta di ordine codice $codice";
  			$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore � in attesa di validazione presso la segreteria amministrativa.\n\n
Riceverete tramite e-mail informazioni relative al cambio di stato della medesima richiesta.\n\n
Vi ricordiamo il link cui collegarvi con il vostro profilo per la gestione delle vostre richieste:\n
http://www.rettorato.unipmn.it/webmonitor.";
			}
			else {
				$oggetto = "Conferma invio ordine modificato codice $codice";
  			$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore, da Voi modificata secondo le istruzioni ricevute, � nuovamente in attesa di validazione presso la segreteria amministrativa.\n\n
Riceverete tramite e-mail informazioni relative al cambio di stato della medesima richiesta.\n\n
Vi ricordiamo il link cui collegarvi con il vostro profilo per la gestione delle vostre richieste:\n
http://www.rettorato.unipmn.it/webmonitor.";
			}
			
			$res = SendMail($mail_docente, $oggetto, $messaggio);
  		
			// Ai SEGRETARI
			if ($STATO_PRECEDENTE != STATUS_RICHIESTA_MODIFICA) {
				$oggetto = "Richiesta di ordine codice $codice dal docente $docente.";
  			$messaggio = "E' in attesa di validazione la richiesta di ordine codice $codice inoltrata dall'utente $docente.\n
Vi ricordiamo il link cui collegarvi con il vostro profilo per la gestione delle vostre richieste:\n
http://www.rettorato.unipmn.it/webmonitor.";
  		}
  		else {
  			$oggetto = "Effettuata modifica ordine codice $codice";
				$messaggio = "La richiesta di ordine codice $codice inoltrata dall'utente $docente � in attesa di validazione dopo essere stata modificata dal docente secondo le istruzioni da Voi impartite.
Vi ricordiamo il link cui collegarvi con il vostro profilo per la gestione delle vostre richieste:\n
http://www.rettorato.unipmn.it/webmonitor.";
  		}
  		
  		$res = $res && SendMail($mail_segretari, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// VALIDATO:
  	case STATUS_VALIDATO:
  		// Al DOCENTE
  		$oggetto = "Validazione ordine codice $codice";
  		$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore � stata validata dalla segreteria amministrativa e registrata sul db $nome_db con il numero $numero.\n\n
Al seguente link http://www.rettorato.unipmn.it/webmonitor nella sezione 'Archivio' potete verificare l'avvenuta validazione.";
  		$res = SendMail($mail_docente, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// ANNULLAMENTO:
  	case STATUS_ANNULLATO:
  		// Al DOCENTE
  		$oggetto = "Annullamento ordine codice $codice";
  		$messaggio = "La vostra richiesta di ordine codice $codice intestata al fornitore $fornitore � stata annullata dalla segreteria amministrativa.\n\n
Al seguente link http://www.rettorato.unipmn.it/webmonitor nella sezione 'Archivio' potete verificare l'avvenuto annullamento.";
			$res = SendMail($mail_docente, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// RICHIESTA MODIFICA:
  	case STATUS_RICHIESTA_MODIFICA:
  		// Al DOCENTE
  		$oggetto = "Richiesta modifica all'ordine codice $codice";
  		$messaggio = "La segreteria amministrativa chiede di approntare modifiche alla vostra richiesta di ordine 
codice $codice intestata al fornitore $fornitore.\n\n
Le modifiche si riferiscono ai seguenti campi:\n
$motivo\n\n
Al seguente link http://www.rettorato.unipmn.it/webmonitor potete modificare la vostra richiesta d'ordine secondo le istruzioni della segreteria amministrativa.";
  		$res = SendMail($mail_docente, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// ALTRIMENTI:
  	default:
  		return FALSE;
  }
  return $res;
}
################################################################################
# Mail_BO:
################################################################################
function Mail_Bilancio($STATO) {
	GLOBAL $db, $utente;
	
	$esercizio = $_SESSION["previsione"]["esercizio_corrente"];
	$ufficio = $_SESSION["previsione"]["ufficio"];
	$titolo = "Bilancio di Previsione e PEG $esercizio - $ufficio.";
	
	#######################################################################################################
  # Controllo che le mail degli UFFICI siano corrette:
	#######################################################################################################
  $mail_uffici = "";
	$strSQL = "SELECT u.Mail FROM MetaUser u JOIN MetaUserGroup ug ON ug.CodUser=u.CodUser AND ug.CodGroup=".
						$_SESSION["previsione"]["id_gruppo"].
						" WHERE u.Type='ufficio'";
	$rs = $db->Esegui($strSQL);
	if ($rs != FALSE) {
		while (!$rs->EOF) {
			$email = explode(",", $rs->Fields("Mail"));
			
			for ($i=0; $i<count($email); $i++) {
				if (IsValidMail(trim($email[$i])))
					$mail_uffici .= trim($email[$i]).",";
				else
					$db->Logga(LOGERROR, "Mail FALLITA!", "Mail controller NON valida: ".trim($email[$i]));
			}
			$rs->MoveNext();
		}
		$rs->Close();
	}
	$mail_uffici = substr($mail_uffici, 0, strlen($mail_uffici) - 1);
  unset($email);
	
	#######################################################################################################
  # Controllo che le mail del CONTROLLER siano corrette:
	#######################################################################################################
  $mail_controller = "";
	$strSQL = "SELECT u.Mail FROM MetaUser u ".
						"WHERE u.Type='controller'";
	$rs = $db->Esegui($strSQL);
	if ($rs != FALSE) {
		while (!$rs->EOF) {
			$email = explode(",", $rs->Fields("Mail"));
			
			for ($i=0; $i<count($email); $i++) {
				if (IsValidMail(trim($email[$i])))
					$mail_controller .= trim($email[$i]).",";
				else
					$db->Logga(LOGERROR, "Mail FALLITA!", "Mail controller NON valida: ".trim($email[$i]));
			}
			$rs->MoveNext();
		}
	}
	$mail_controller = substr($mail_controller, 0, strlen($mail_controller) - 1);
	
	#die("UFFICI: $mail_uffici<br>CONTROLLER: $mail_controller.");
  
	#######################################################################################################
  # In base alla stato, invio le e-mail a chi di dovere:
	#######################################################################################################
  switch ($STATO) {
  	#___________________________________________________________________
  	// VALIDAZIONE:
  	case 'V':
  		// Al CONTROLLER
			$oggetto = "Validazione $titolo";
			$messaggio = "E' stata richiesta la validazione per i dati del bilancio di previsione e PEG $esercizio riguardanti l'ufficio $ufficio.";
  		
  		$res = SendMail($mail_controller, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// RICHIESTA MODIFICA:
  	case 'R':
  		// All' UFFICIO
  		$oggetto = "Richiesta modifica $titolo";
			$messaggio = "E' stata richiesta la modifica del bilancio di previsione e PEG $esercizio.";
  		$res = SendMail($mail_uffici, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// STAND-BY:
  	case 'S':
  		// All' UFFICIO
  		$oggetto = "Stand-by $titolo";
			$messaggio = "E' stato posto in stand-by il bilancio di previsione e PEG $esercizio.";
  		$res = SendMail($mail_uffici, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// APPROVATO:
  	case 'A':
  		// All' UFFICIO
  		$oggetto = "Approvazione $titolo";
			$messaggio = "E' stata approvato il bilancio di previsione e PEG $esercizio.";
  		$res = SendMail($mail_uffici, $oggetto, $messaggio);
  		break;
  		
  	#___________________________________________________________________
  	// ALTRIMENTI:
  	default:
  		return FALSE;
  }
  return $res;
}
################################################################################
# mssql_date_encode:
################################################################################
# Parametro: stringa nel formato gg/mm/aaaa.
################################################################################
function mssql_date_encode($stringa, $format='us') {
	if (strlen($stringa) == 0)
		return "";
		
	switch ($format) {
		case 'it':
			list($g,$m,$a) = split("[/.-]", $stringa);
			$data = array($g, $m, $a);
			return implode("/", $data);
			break;
			
		case 'us':
		default:
			list($g,$m,$a) = split("[/.-]", $stringa);
			$data = array($a, $m, $g);
			return implode("-", $data);
			break;
	}
}
################################################################################
# mssql_date_decode:
################################################################################
# Parametro: stringa letta dal db.
# Ritorna una data nel formato gg/mm/aaaa o una stringa vuota.
################################################################################
function mssql_date_decode($stringa) {
	if (strlen($stringa) == 0)
		return "";
		
	switch (DATE_FORMAT) {
		case DATE_IT:
			break;
			
		case DATE_US:
		default:
			list($a,$m,$g) = split("[/.-]", $stringa);
			$data = array($g, $m, $a);
			$stringa = implode("/", $data);
			break;
	}
	if (strcmp($stringa, "01/01/1900") == 0)
		$stringa = "";
	return $stringa;
}
################################################################################
# write_number:
################################################################################
function write_number($stringa, $null=false) {
	return mssql_number($stringa, $null);
}
################################################################################
# mssql_number:
################################################################################
function mssql_number($stringa, $null=false) {
	
	// La stringa e' VUOTA:
	if (strlen($stringa) == 0)
		return ($null) ? "null" : "";
	
	if (preg_match ("/\A(-){0, 1}([0-9]+)((,|.)[0-9]{3, 3})*((,|.)[0-9]){0, 1}([0-9]*)\z/" ,$stringa) == 1)
		return 0;
	
	// ____________________________________________________
	// La stringa NON ha PUNTI:
	if (strpos($stringa, ".") === false) {
		// e nemmeno VIRGOLE
		if (strpos($stringa, ",") === false) {
			return intval($stringa);
		}
		// c'e' almeno UNA virgola:
		else {
			// se ce n'e' piu' d'una:
			if (substr_count($stringa, ",") > 1)
				return 0;
			else
				return str_replace(",", ".", $stringa);
		}
	}
	// ____________________________________________________
	// La stringa NON ha VIRGOLE:
	else if (strpos($stringa, ",") === false) {
		// se c'e' piu' di un PUNTO:
		if (substr_count($stringa, ".") > 1)
			return 0;
		else
			return $stringa;
		
	}
	// ____________________________________________________
	// La stringa ha PUNTI e VIRGOLE:
	else {
		# se l'ultimo e' un PUNTO:
		if (strrpos($stringa, ".") > strrpos($stringa, ",")) {
			$stringa = str_replace(",", "", $stringa);
			if (substr_count($stringa, ".") > 1)
				return 0;
			else
				return $stringa;
		}
		# se l'ultimo e' una VIRGOLA:
		else {
			$stringa = str_replace(".", "", $stringa);
			if (substr_count($stringa, ",") > 1)
				return 0;
			else
				return str_replace(",", ".", $stringa);;
		}
	}
}
################################################################################
# write_date_to_db:
################################################################################
# Parametro: stringa nel formato gg/mm/aaaa.
################################################################################
function write_dateIT_to_db($stringa) {
	if (strlen($stringa) == 0)
		return "null";
		
	if (is_datetime($stringa) == FALSE)
		return "null";
	
	switch (DATE_FORMAT) {
		case DATE_IT:
			return "'".$stringa."'";
			break;
			
		case DATE_US:
		default:
			list($g,$m,$a) = split("[/.-]", $stringa);
			$data = array($a, $m, $g);
			return "'".implode("", $data)."'";
			break;
	}
	return "null";
}
################################################################################
# quote_dateIT:
################################################################################
# Parametro: stringa nel formato gg/mm/aaaa.
################################################################################
function quote_dateIT($stringa) {
	if (is_datetime($stringa) == FALSE)
		return "null";
	
	if (strlen($stringa) == 0)
		return "null";
		
	return "'".$stringa."'";
}
################################################################################
# quote_string:
################################################################################
# Parametro: stringa.
################################################################################
function quote_string($stringa, $null=false) {
	if ($null) {
		if (strlen($stringa) == 0)
			return "null";
		else
			return "'".str_replace(
  						array ('"', "'"),
  						array('"', "''"),
  						$stringa
  				)."'";
	}
	else
		return "'".str_replace(
								array ('"', "'"),
								array('"', "''"),
								$stringa
						)."'";
}
################################################
# QUOTA.
################################################################################
# Parametri: tipo, dimensione, valore.
################################################################################
function quota($tipo, $dimensione=0, $valore=null, $null=false) {
    global $db;

    switch($tipo) {
        case "int4":
        case "int":
        case "tinyint":
        case "smallint":
        case "bigint":
        case "float":
        case "real":
        case "money":
        case "smallmoney":
        case "decimal":
        case "numeric":
            return write_number($valore, $null);
            break;

        case "timestamptz":
        case "datetime":
        case "smalldatetime":
            $data = $db->Data($valore);
            return quote_string($data, $null);
            break;

        case "char":
        default:
            if ($dimensione > 0)
                $valore = substr($valore, 0, $dimensione);
            return quote_string($valore, $null);
            break;
    }
}
################################################################################
# null_if:
################################################################################
# Parametro: stringa.
################################################################################
function null_if($stringa, $alternativa="null") {
	if (strlen($stringa) == 0)
		return $alternativa;
	return $stringa;
}
################################################################################
# toBool:
################################################################################
# Parametro: char (S/N) oppure (1/0).
################################################################################
function toBool($char) {
	if (strcasecmp($char, 'S') == 0)
		return true;
	if (strcasecmp($char, '1') == 0)
		return true;
	if (strcasecmp($char, 't') == 0)
		return true;
	return false;
}
################################################################################
# mime_icon:
################################################################################
# Parametro: filename.
################################################################################
function mime_icon($filename) {
	if (strlen($filename) == 0)
		return "";
		
	$ext = explode(".", $filename);
	
	switch ($ext[count($ext)-1]) {
		case "pdf":
			return "images/mime_pdf.png";
			break;
			
		case "doc":
			return "images/mime_doc.png";
			break;
			
		default:
			return "images/mime_none.png";
			break;
	}
}
################################################################################
# getFloat:
################################################################################
function getFloat($string_number) {
	// cerco se NON ci sono PUNTI:
	if (strpos($string_number, ".") === FALSE) {
		// Sostituisco eventuali virgole con punti:
		return (float)str_replace(",", ".", $string_number);
	}
	// se invece CI SONO:
	else {
		// Se l'ultimo simbolo � un PUNTO:
		if (strrpos($string_number, ".") > strrpos($string_number, ",")) {
			// cancello le virgole:
			$string_number = str_replace(",", "", $string_number);
			return (my_is_numeric($string_number) == FALSE) ? (float)0 : (float)$string_number;
		}
		// se l'ultimo � una VIRGOLA:
		else {
			// cancello i punti:
			$string_number = str_replace(".", "", $string_number);
			// sostituisco la virgola con il punto:
			$string_number = str_replace(",", ".", $string_number);
			return (my_is_numeric($string_number) == FALSE) ? (float)0 : (float)$string_number;
		}
	}
}
################################################################################
# ShowMessage:
################################################################################
function ShowMessagePO($tipo, $title, $msg, $link=null, $caption=null, $showHeader=false) {
	// Tipo di messaggio da visualizzare:
	switch ($tipo) {
		default:
		case MSG_ERROR:
			$img_src = ICON_ERROR;
			break;
		case MSG_WARNING:
			$img_src = ICON_WARNING;
			break;
		case MSG_INFO:
			$img_src = ICON_INFO;
			break;
		case MSG_ASK:
			$img_src = ICON_ASK;
			break;
	}
	//require_once("header.inc.php");
	if ($showHeader) {
		print_html_header();
		require_once("header.inc.php");
	}
	
	echo <<<EOT
		<center>
		<form name="frmMessaggio" action="$link" method="POST" class="message_form" style='width: 400px; margin: 10px;'>
			<table border='0'><tr><td><img src="$img_src" /></td><td class="titolo" width="90%">$title</td></tr></table>
			<div></div>
			<div class='sx'>$msg</div>
EOT;
	if ($link)
		echo <<<EOT
			<br>
			<div class='centrato'>
				<button type="submit" name="Indietro">$caption</button>
			</div>
EOT;
	echo "</form>\n</center>\n<br /><br /></div>";
	
	if ($showHeader) {
		require_once("footer.php");
		die();
	}
}
################################################################################
# CreaXLS:
################################################################################
# Parametri:
#   $recordset - recordset di origine dati.
# 	$filename - nome del file csv da creare.
################################################################################
function CreaXLS($recordset, $filename, $campi_si=null) 
{ 
  require_once 'Spreadsheet/Excel/Writer.php';
	$numfields = $recordset->FieldCount();
  
	// Creating a workbook
	$workbook = new Spreadsheet_Excel_Writer();
	// sending HTTP headers
	$workbook->send($filename);
	// Creating a worksheet
	$worksheet =& $workbook->addWorksheet('Movimenti');
	
	// Create a format object
	$titleFormat =& $workbook->addFormat();
	// Set the font family - Helvetica works for OpenOffice calc too...
	$titleFormat->setFontFamily('Helvetica');
	// Set the text to bold
	$titleFormat->setBold();
	// Set the text size
	$titleFormat->setSize('12');
	// Set the text color
	$titleFormat->setColor('navy');
	// Set the bottom border width to "thick"
	$titleFormat->setBottom(2);
	// Set the color of the bottom border
	$titleFormat->setBottomColor('navy'); 
	$titleFormat->setAlign('center'); 
	
	$num_format =& $workbook->addFormat();
	$num_format->setNumFormat('#,#####');

	//----------------------------------------------------------------------------
  // Nomi delle colonne:
  for ($f=0,$c=0; $f < $numfields; $f++) {
   	$field = $recordset->FetchField($f);
   	$worksheet->writeString(0, $c++, $field->name, $titleFormat);
  }
  //----------------------------------------------------------------------------
  // Record:
  $r = 1;
  while (!$recordset->EOF) {
  	for ($f=0,$c=0; $f < $numfields; $f++) {
			$field = $recordset->FetchField($f);
				if ($field->type == "string")
					$worksheet->writeString($r, $c++, $recordset->Fields($field->name));
				elseif ($field->type == "real") {
					$worksheet->writeNumber($r, $c++, $recordset->Fields($field->name), $num_format);
				}
				else
					$worksheet->write($r, $c++, $recordset->Fields($field->name));
    }
		$recordset->MoveNext();
		$r++;
  }
  $workbook->close();
}
################################################################################
# CheckCF:
################################################################################
# Parametri:
# 	$cf - codice fiscale da controllare.
################################################################################
function CheckCF($cf) {
	if($cf == '')
		return false;
	if( strlen($cf) != 16 )
		return false;
	$cf = strtoupper($cf);
	
	if( ! ereg("^[A-Z]{6}[0-9]{2}[A-Z][0-9]{2}[A-Z][0-9]{3}[A-Z]$", $cf) ) {
		return false;
	}
	$s = 0;
	for( $i = 1; $i <= 13; $i += 2 ) {
		$c = $cf[$i];
		if( '0' <= $c && $c <= '9' )
			$s += ord($c) - ord('0');
		else
			$s += ord($c) - ord('A');
	}
	for( $i = 0; $i <= 14; $i += 2 ) {
		$c = $cf[$i];
		switch( $c ){
			case '0':  $s += 1;  break;
			case '1':  $s += 0;  break;
			case '2':  $s += 5;  break;
			case '3':  $s += 7;  break;
			case '4':  $s += 9;  break;
			case '5':  $s += 13;  break;
			case '6':  $s += 15;  break;
			case '7':  $s += 17;  break;
			case '8':  $s += 19;  break;
			case '9':  $s += 21;  break;
			case 'A':  $s += 1;  break;
			case 'B':  $s += 0;  break;
			case 'C':  $s += 5;  break;
			case 'D':  $s += 7;  break;
			case 'E':  $s += 9;  break;
			case 'F':  $s += 13;  break;
			case 'G':  $s += 15;  break;
			case 'H':  $s += 17;  break;
			case 'I':  $s += 19;  break;
			case 'J':  $s += 21;  break;
			case 'K':  $s += 2;  break;
			case 'L':  $s += 4;  break;
			case 'M':  $s += 18;  break;
			case 'N':  $s += 20;  break;
			case 'O':  $s += 11;  break;
			case 'P':  $s += 3;  break;
			case 'Q':  $s += 6;  break;
			case 'R':  $s += 8;  break;
			case 'S':  $s += 12;  break;
			case 'T':  $s += 14;  break;
			case 'U':  $s += 16;  break;
			case 'V':  $s += 10;  break;
			case 'W':  $s += 22;  break;
			case 'X':  $s += 25;  break;
			case 'Y':  $s += 24;  break;
			case 'Z':  $s += 23;  break;
		}
	}
	if( chr($s%26 + ord('A')) != $cf[15] )
		return false;
	return true;
}
################################################################################
# CreaParametriReportDb:
################################################################################
# Parametri:
# 	$report - array con le info per la stampa.
################################################################################
function CreaParametriReportDb($report) {
	GLOBAL $db;

	if ($report["numero_parametri"] == 0) {
		$strSQL = "INSERT INTO pl_temp_stampe VALUES(".
								quote_string($report["codice"], true).", ".
								quote_string($report["rpt_file"], true).", ".
								quote_string($report["formato_pagina"], true).", ".
								quote_string($report["orientazione_pagina"], true).", ".
								quote_string($report["server"], true).", ".
								quote_string($report["db"], true).", ".
								quote_string($report["schema"], true).", ".
								"null, ".
								"null, ".
								"getdate()".
							")";
		$res = $db->Esegui($strSQL);
		if ($res == FALSE)
			return FALSE;
	}
	for ($i=0; $i<$report["numero_parametri"]; $i++) {
		$strSQL = "INSERT INTO pl_temp_stampe VALUES(".
								quote_string($report["codice"], true).", ".
								quote_string($report["rpt_file"], true).", ".
								quote_string($report["formato_pagina"], true).", ".
								quote_string($report["orientazione_pagina"], true).", ".
								quote_string($report["server"], true).", ".
								quote_string($report["db"], true).", ".
								quote_string($report["schema"], true).", ".
								quote_string($report[$i]["nome"], true).", ".
								quote_string($report[$i]["valore"], true).", ".
								"getdate()".
							")";
		$res = $db->Esegui($strSQL);
		if ($res == FALSE)
			return FALSE;
	}
	
	return TRUE;
}



# Controllo della Partita I.V.A.
# Linguaggio: PHP 3

##############################################################
function ControllaPIVA($pi)
{
	if( strlen($pi) == 0 )  return '';
	if( strlen($pi) != 11 )
		return "La lunghezza della partita IVA non &egrave; \n"
		."corretta: la partita IVA dovrebbe essere lunga \n"
		."esattamente 11 caratteri.\n";
	if( ! ereg("^[0-9]+$", $pi) )
		return "La partita IVA contiene dei caratteri non ammessi: \n"
		."la partita IVA dovrebbe contenere solo cifre.\n";
	$s = 0;
	for( $i = 0; $i <= 9; $i += 2 )
		$s += ord($pi[$i]) - ord('0');
	for( $i = 1; $i <= 9; $i += 2 ){
		$c = 2*( ord($pi[$i]) - ord('0') );
		if( $c > 9 )  $c = $c - 9;
		$s += $c;
	}
	if( ( 10 - $s%10 )%10 != ord($pi[10]) - ord('0') )
		return "La partita IVA non &egrave; valida: \n"
		."il codice di controllo non corrisponde.";
	return false;
}

# Controllo del Codice Fiscale
# Linguaggio: PHP 3

function ControllaCF($cf)
{
	if( $cf == '' )  return '';
	if( strlen($cf) != 16 )
		return "La lunghezza del codice fiscale non &egrave; \n"
		."corretta: il codice fiscale dovrebbe essere lungo \n"
		."esattamente 16 caratteri.";
	$cf = strtoupper($cf);
	if( ! ereg("^[A-Z0-9]+$", $cf) ){
		return "Il codice fiscale contiene dei caratteri non validi: \n"
		."i soli caratteri validi sono le lettere e le cifre.";
	}
	$s = 0;
	for( $i = 1; $i <= 13; $i += 2 ){
		$c = $cf[$i];
		if( '0' <= $c && $c <= '9' )
			$s += ord($c) - ord('0');
		else
			$s += ord($c) - ord('A');
	}
	for( $i = 0; $i <= 14; $i += 2 ){
		$c = $cf[$i];
		switch( $c ){
		case '0':  $s += 1;  break;
		case '1':  $s += 0;  break;
		case '2':  $s += 5;  break;
		case '3':  $s += 7;  break;
		case '4':  $s += 9;  break;
		case '5':  $s += 13;  break;
		case '6':  $s += 15;  break;
		case '7':  $s += 17;  break;
		case '8':  $s += 19;  break;
		case '9':  $s += 21;  break;
		case 'A':  $s += 1;  break;
		case 'B':  $s += 0;  break;
		case 'C':  $s += 5;  break;
		case 'D':  $s += 7;  break;
		case 'E':  $s += 9;  break;
		case 'F':  $s += 13;  break;
		case 'G':  $s += 15;  break;
		case 'H':  $s += 17;  break;
		case 'I':  $s += 19;  break;
		case 'J':  $s += 21;  break;
		case 'K':  $s += 2;  break;
		case 'L':  $s += 4;  break;
		case 'M':  $s += 18;  break;
		case 'N':  $s += 20;  break;
		case 'O':  $s += 11;  break;
		case 'P':  $s += 3;  break;
		case 'Q':  $s += 6;  break;
		case 'R':  $s += 8;  break;
		case 'S':  $s += 12;  break;
		case 'T':  $s += 14;  break;
		case 'U':  $s += 16;  break;
		case 'V':  $s += 10;  break;
		case 'W':  $s += 22;  break;
		case 'X':  $s += 25;  break;
		case 'Y':  $s += 24;  break;
		case 'Z':  $s += 23;  break;
		}
	}
	if( chr($s%26 + ord('A')) != $cf[15] )
		return "Il codice fiscale non &egrave; corretto: \n"
		."il codice di controllo non corrisponde.";
	return false;
}

################################################################################
# str2int:
################################################################################
# Parametri:
# 	$string - stringa numerica.
# 	$concat - se prendere solo il primo numero.
################################################################################
function str2int($string, $concat = true) {
    $length = strlen($string);   
    for ($i = 0, $int = '', $concat_flag = true; $i < $length; $i++) {
        if (is_numeric($string[$i]) && $concat_flag) {
            $int .= $string[$i];
        } elseif(!$concat && $concat_flag && strlen($int) > 0) {
            $concat_flag = false;
        }       
    }
   
    return (int) $int;
}

################################################################################
# sendVars:
################################################################################
# Parametri:
# 	$method - .
# 	$page - .
# 	$array_params - .
################################################################################
function sendVars($method, $page, $array_params) {
	# array_params = VETTORE [nome] = valore
	
	$post_data = '';
	
	foreach ($array_params as $name => $value) {
		$post_data .= $name.'='.$value.'&';
	}
	$post_data = substr($post_data, 0, -1); # tolgo l'ultimo '&'
	$content_length = strlen($post_data);
	#die("$method, $page, $post_data");
	
	header('{$method} {$page} HTTP/1.1');
	header('Host: localhost');
	header('Connection: close');
	header('Content-type: application/x-www-form-urlencoded');
	header('Content-length: ' . $content_length);
	header('');
	header($post_data);

	exit();

}



################################################################################
# cifra:
################################################################################
function cifra($str) {
	return base64_encode($str);
}

################################################################################
# decifra:
################################################################################
function decifra($str) {
	return base64_decode($str);
}

################################################################################
# getEasyDb:
# Ritorna un oggetto DB connesso ad EASY, con le credenziali associate al 
# gruppo passato in input.
################################################################################
function getEasyDb($code_gruppo) {
	GLOBAL $db;
	
	$sql = "SELECT e.* FROM metagruppi g
			JOIN PL_ENTI e ON e.codiceente=g.code_ente 
			WHERE g.code='{$code_gruppo}'";
			
	$rs = $db->Esegui($sql);
	if ($rs == FALSE)
		return false;
	
	$user = cifra($rs->Fields("nomeutente"));
	$pass = $rs->Fields("pwdutente");
	$dbnm = $rs->Fields("nomedatabase");
	$serv = $rs->Fields("nomeserver");
	
	$newdb = new DB();
	$newdb->Connetti($serv, $user, $pass);
	
	return $newdb;
}

################################################################################
# dojo_dnd_encode:
################################################################################
function dojo_dnd_encode($elenco) {
    $stringa = "";
    foreach($elenco as $key => $item) {
        $stringa .= "{ data: \"{$item['data']}\", type: [\"{$item['type']}\"] },";
    }
    return "[".substr($stringa, 0, -1)."]";
}
################################################################################
# dojo_encode:
################################################################################
/*function dojo_encode($elenco) {
    $stringa = "";
    foreach($elenco as $key => $item) {
        $stringa .= "{";
        foreach($item as $k => $v) {
            if (is_array($v)) {
                $stringa .= "{$k}: ".dojo_encode(array($v)).",";                
            }
            else
                $stringa .= "{$k}: \"{$v}\",";
        }
        $stringa = substr($stringa, 0, -1)."},";
    }
    return "[".substr($stringa, 0, -1)."]";
}*/
function dojo_encode($elenco, $meta=null) {
    $stringa = "";
    foreach($elenco as $key => $item) {
        $stringa .= "{";
        foreach($item as $k => $v) {
            if (isset($meta[$k])) {
                switch ($meta[$k]) {
                    case 'numeric':
                    case 'decimal':
                    case 'integer':
                    case 'int':
                    case 'real':
                        $value = "{$v}";
                        break;
                    case 'date':
                        $value = "'{$v}'";
                        break;
                    default:
                        $v = str_replace('"', '', $v);
                        $value = "\"{$v}\"";
                        break;
                }
            }
            else
                $value = "\"{$v}\"";
            if ($k === 'ECHO')
                $stringa .= $v.",";
            else
                $stringa .= "{$k}: {$value},";
        }
        $stringa = substr($stringa, 0, -1)."},";
    }
    return "[".substr($stringa, 0, -1)."]";
}
?>
