<?php
class History {
	private $m_segnalibri;
	private $m_indice;

	#------------------------------------------
	# Parte STATICA
	#------------------------------------------
	private static $instance = null;

	#------------------------------------------
	public static function getInstance() {
		if (self::$instance == null) {
			if (isset($_SESSION["HISTORY"]))
				self::$instance = unserialize($_SESSION["HISTORY"]);
			else {
			 $c = __CLASS__;
			 self::$instance = new $c;
			}
		}

		return self::$instance;
	}

	#------------------------------------------
	public static function save() {
		$_SESSION["HISTORY"] = serialize(self::$instance);
	}

	#------------------------------------------
	public static function erase() {
		if (isset($_SESSION["HISTORY"])) {
			self::$instance = null;
			unset($_SESSION["HISTORY"]);
			self::getInstance();
		}
	}

	#------------------------------------------
	# Parte DINAMICA
	#------------------------------------------
	private function History() {
		$this->m_indice = 0;
		$this->m_segnalibri[0] = array('pagina' => ROOT_DIR.INDEX);
	}
	
	#------------------------------------------
	public function ultimo() {
		if ($this->m_indice == 0)
			return ROOT_DIR.INDEX;
		return $this->m_segnalibri[$this->m_indice]["pagina"];
	}
	
	#------------------------------------------
	public function indietro() {
        return ROOT_DIR."indietro.php";
        
		GLOBAL $HISTORY_PAGE_BOOKMARK;
		
		if ($HISTORY_PAGE_BOOKMARK == 1)
			return ROOT_DIR."indietro.php";

		return $this->ultimo();
	}
	
	#------------------------------------------
	public function corrente() {
		return $this->ultimo();
	}

	#------------------------------------------
	public function nuova($pagina=null) {
		GLOBAL $HISTORY_PAGE_BOOKMARK;

		$HISTORY_PAGE_BOOKMARK = 1;

		if (strlen($pagina) == 0)
			$pagina = $_SERVER["REQUEST_URI"];

		$changed = false;

		# se e' la pagina di prima, verifico se e' cambiato il tab.
		if ($this->m_segnalibri[$this->m_indice]["pagina"] != $pagina) {
			$this->m_indice++;
			$this->m_segnalibri[$this->m_indice]["pagina"] = $pagina;
			$changed = true;
		}
		if ($changed)
			self::save();
	}
	
	#------------------------------------------
	public function vaiAvanti() {
		$this->m_indice++;
	}
	
	#------------------------------------------
	public function vaiIndietro() {
		if ($this->m_indice > 0)
			$this->m_indice--;
	}
	
	#------------------------------------------
	private function append($link, $append) {
		#echo "LINK=$link     APPEND=$append<br>";
		if (strpos($link, $append) === FALSE) {
			if (strpos($link, '?') === FALSE)
				$link .= "?".$append;
			else
				$link .= "&".$append;
		}
		return $link;
	}
	
	#------------------------------------------
	public function debug() {
		#echo "<br /><br />Indice corrente=".$this->m_indice."<br /><br />";
		foreach($this->m_segnalibri as $indice => $segnalibro) {
			$colore = ($this->m_indice == $indice) ? "#F00" : "#007";
			echo "<span style='color:{$colore};'>".$indice.") ".$segnalibro["pagina"]."</span><br />";
		}
	}
}

?>
