<?php
class MetaModulo {
	private $m_id;
	private $m_code;
	private $m_label;
	private $m_bit;
	
	################################################
	# Costruttore. ()
	public function __construct() {
	}
	
	################################################
	# GET.
	public function id() {
		return $this->m_id;
	}
	public function code() {
		return $this->m_code;
	}
	public function label() {
		return $this->m_label;
	}
	public function bit() {
		return $this->m_bit;
	}
	public function mask() {
		return pow(2, $this->m_bit);
	}
	
	################################################
	# LOAD.
	################################################
	public function load($code) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($code) <= 0))
			return false;
			
		$strSQL = "SELECT * FROM MetaModuli WHERE code_modulo=".quote_string($code, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		while (!$rs->EOF) {
			$this->loadFromRecord($rs);
			$rs->MoveNext();
		}
		$rs->Close();
		return true;
	}
	
	public function loadFromRecord($rs) {
		if (is_null($rs))
			return false;
		$this->m_id = $rs->Fields("id_modulo");
		$this->m_code = $rs->Fields("code_modulo");
		$this->m_label = $rs->Fields("label_modulo");
		$this->m_bit = $rs->Fields("bit_modulo");
		return true;
	}
}
?>