<?php

class MetaOggetto extends Meta {
	private $m_code_parent;
	private $m_semplice;
	private $m_campi;
	private $m_php_classe;
		
	################################################
	# Costruttore. ()
	public function __construct() {
		parent::__construct();
		$this->m_campi = array();
	}
	
	################################################
	# GET.
	public function codeParent() {
		return $this->m_code_parent;
	}
	public function semplice() {
		return $this->m_semplice;
	}
	public function campi() {
		return $this->m_campi;
	}
	public function campo($chiave) {
		if (array_key_exists($chiave, $this->m_campi))
			return $this->m_campi[$chiave];
		else
			return new MetaCampo();
	}
	public function phpClasse() {
		return $this->m_php_classe;
	}
	
	################################################
	# SET.
	public function setCodeParent($val) {
		if ($this->m_code_parent == $val)
			return;
		$this->m_code_parent = $val;
		$this->m_changed = true;
	}
	public function setSemplice($val) {
		if ($this->m_semplice == $val)
			return;
		$this->m_semplice = $val;
		$this->m_changed = true;
	}
	public function setPhpClasse($val) {
		if ($this->m_php_classe == $val)
			return;
		$this->m_php_classe = $val;
		$this->m_changed = true;
	}

	public function setCampo($chiave, $val) {
		$this->m_campi[$chiave] = $val;
	}

	################################################
	# LOAD.
	public function loadFromCode($code) {
		$this->load($code);
		return $this->loadCampi();
	}
	public function load($code) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($code) <= 0))
			return false;
			
		$strSQL = "SELECT * FROM metaoggetti ".
							"WHERE code_oggetto=".quote_string($code, true);
		$rs = $db->Esegui($strSQL, false);
		
		if ($rs == false)
			return false;
			
		while (!$rs->EOF) {
			$this->loadFromRecord($rs);
			$rs->MoveNext();
		}
		$rs->Close();
		$this->m_changed = false;
		return true;
	}
	
	public function loadFromRecord($rs, $suffisso="oggetto") {
		parent::loadFromRecord($rs, "oggetto");
		if (is_null($rs))
			return false;
		$this->m_code_parent = $rs->Fields("code_parent");
		$this->m_semplice = $rs->Fields("semplice");
		$this->m_php_classe = $rs->Fields("php_classe");
		return true;
	}
	
	public function loadCampi() {
		GLOBAL $db;
		
		if (is_null($db))
			return false;
			
		$strSQL = "SELECT *
								, CONVERT(text, label_campo) as label_campo
								, CONVERT(text, label2_campo) as label2_campo
								, CONVERT(text, label3_campo) as label3_campo
								FROM metacampi
								WHERE code_oggetto=".quote_string($this->m_code, true)."
								ORDER BY ordinale";
		$rs = $db->Esegui($strSQL, false);
		
		if ($rs == false)
			return false;
			
		while (!$rs->EOF) {
			$campo = new MetaCampo();
			$campo->loadFromRecord($rs);
			$this->m_campi[$campo->code()] = $campo; #
			$rs->MoveNext();
		}
		$rs->Close();
	}
	
	################################################
	# UPDATE.
	public function update() {
		GLOBAL $db, $metautente;
		
		if (is_null($db) || is_null($metautente) || $this->m_id == 0)
			return false;
			
		if (!$this->m_changed)
			return true;
			
		$strSQL = "UPDATE metaoggetti SET ".
							"  code_oggetto=".quote_string($this->m_code, true).
							", label_oggetto=".quote_string($this->label(), true).
							", code_parent=".quote_string($this->m_code_parent, true).
							", tipo_oggetto=".quote_string($this->m_tipo, true).
							", semplice=".quote_string($this->m_semplice, true).
							", php_classe=".quote_string($this->m_php_classe, true).
							", lu=".quote_string($metautente->get('username'), true).
							", lt=getdate()".
							" WHERE id_oggetto=".write_number($this->m_id, true);
		$rs = $db->Esegui($strSQL) or die($db->ErrorMsg());
		
		if ($rs == false)
			return false;
		
		$this->m_changed = false;
		return true;
	}
	
	################################################
	# INSERT.
	public function insert() {
		GLOBAL $db, $metautente;
		
		if (is_null($db) || is_null($metautente) || $this->m_id != 0)
			return false;
			
		if (!$this->m_changed)
			return true;
			
		$strSQL = "INSERT INTO metaoggetti (code_oggetto, label_oggetto, code_parent, tipo_oggetto, semplice, php_classe, cu, ct) VALUES".
							"(".quote_string($this->m_code, true).
							",".quote_string($this->label(), true).
							",".quote_string($this->m_code_parent, true).
							",".quote_string($this->m_tipo, true).
							",".quote_string($this->m_semplice, true).
							",".quote_string($this->m_php_classe, true).
							",".quote_string($metautente->get('username'), true).
							",getdate()".
							")";
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
		
		return $this->load($this->m_code);
	}
	
	################################################
	# REMOVE.
	public function remove($id=0) {
		GLOBAL $db;
		
		if (is_null($db))
			return false;
			
		if ($id == 0)
			$id = $this->m_id;
			
		if ($id == 0)
			return false;
			
		# TODO: serie di check.....
			
		$strSQL = "DELETE metaoggetti WHERE id_oggetto=".write_number($id, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
		
		return true;
	}
}
?>