<?php
class MetaRuolo {
	private $m_id;
	private $m_code;
	private $m_label;
	private $m_bit;
	private $m_mask_moduli;
	private $m_changed;
	
	################################################
	# Costruttore. ()
	public function __construct() {
		$this->m_changed = false;
	}
	
	################################################
	# GET.
	public function id() {
		return $this->m_id;
	}
	public function code() {
		return $this->m_code;
	}
	public function label() {
		return $this->m_label;
	}
	public function bit() {
		return $this->m_bit;
	}
	public function maskModuli() {
		return $this->m_mask_moduli;
	}
	public function mask() {
		return pow(2, $this->m_bit);
	}
	
	################################################
	# SET.
	public function setMaskModuli($val) {
		if ($this->m_mask_moduli == $val)
			return;
		$this->m_mask_moduli = $val;
		$this->m_changed = true;
	}
	
	################################################
	# LOAD.
	public function load($code) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($code) <= 0))
			return false;
			
		$strSQL = "SELECT * FROM MetaRuoli WHERE code_ruolo=".quote_string($code, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		while (!$rs->EOF) {
			$this->loadFromRecord($rs);
			$rs->MoveNext();
		}
		$rs->Close();
		$this->m_changed = false;
		return true;
	}
	
	public function loadFromRecord($rs) {
		if (is_null($rs))
			return false;
		$this->m_id = $rs->Fields("id_ruolo");
		$this->m_code = $rs->Fields("code_ruolo");
		$this->m_label = $rs->Fields("label_ruolo");
		$this->m_bit = $rs->Fields("bit_ruolo");
		$this->m_mask_moduli = $rs->Fields("mask_moduli");
		$this->m_changed = false;
		return true;
	}
	
	################################################
	# UPDATE.
	public function update() {
		GLOBAL $db;
		
		if (is_null($db))
			return false;
			
		if (!$this->m_changed)
			return true;
			
		$strSQL = "UPDATE MetaRuoli SET ".
							" mask_moduli=".write_number($this->m_mask_moduli, true).
							" WHERE code_ruolo=".quote_string($this->m_code, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
		
		$this->m_changed = false;
		return true;
	}
}
?>