<?php
require_once("classes/record.class.php");

/************************************************************************************
* classe META UTENTE
************************************************************************************/
class MetaUtente extends Record {
	private $m_virtuale; // se non  in MetaUtenti (es. candidati e assegnisti)
	
	private $m_gruppi;
	private $m_ruoli;
	
	private $m_gruppo;
	private $m_ruolo;
	private $m_idmans;
	public $m_flag_manager;
	
	private $m_anagrafica;
	
	# DA ELIMINARE - messi per compatibilita'
	public $username;
	public $nominativo;
	public $id_utente;
	public $gruppodb;
	public $email;
	
	################################################
	# Costruttore.
	public function __construct() {
		parent::__construct();
		$this->m_tabella = "metautenti";
		$this->m_identity = "id_utente";
		$this->m_gruppi = array();
		$this->m_virtuale = false;
		$this->username = "Anonimo";
		$this->m_idmans = array();
	}
	
	################################################
	# DA ELIMINARE - messi per compatibilita'
	public function IsController() {
		GLOBAL $MODULO;
		return $this->amministratore() || $this->m_flag_manager[$MODULO]["manager"];
	}
	public function IsSegretario() {
		return $this->amministratore() || $this->ruolo()->code() == "segretario";
	}
	public function IsDocente() {
		return $this->ruolo()->code() == "docente";
	}
	public function IsUtente() {
		return $this->amministratore() || $this->ruolo()->code() == "utente";
	}
	public function IsUfficio() {
		return $this->amministratore() || $this->ruolo()->code() == "ufficio";
	}
	public function IsStruttura() {
		return $this->amministratore() || $this->ruolo()->code() == "struttura";
	}
	public function IsPartner() {
		return $this->ruolo()->code() == "partner";
	}
	################################################
	# GET
	public function id() {
		return $this->get("id_utente");
	}
	public function virtuale() {
		return $this->m_virtuale;
	}
	public function username() {
		return $this->get('username');
	}
	public function nominativo() {
		if (!is_object($this->m_anagrafica))
			$this->loadAnagrafica();

		return $this->anagrafica()->get('cognome').' '.$this->anagrafica()->get('nome');
	}
	public function gruppi() {
		return $this->m_gruppi;
	}
	public function ruoli() {
		return $this->m_ruoli;
	}
	public function anagrafica() {
		return $this->m_anagrafica;
	}
	/*public function moduli() {
		return $this->m_gruppi;
	}*/
	public function gruppo() {
		return $this->m_gruppo;
	}
	public function ruolo() {
		return $this->m_ruolo;
	}
	public function amministratore() {
		return toBool($this->get("flag_admin"));
	}
	public function manager($codice_modulo) {
		return $this->amministratore() || $this->m_flag_manager[$codice_modulo]["manager"];
	}
	public function modulo($codice_modulo) {
		if (!isset($this->m_flag_manager[$codice_modulo]))
			return false;
		return $this->amministratore() || $this->m_flag_manager[$codice_modulo]["visibile"];
	}
	public function idmans() {
		return $this->m_idmans;
	}

	################################################
	# SET
	public function setGruppo($metagruppo) {
		$this->m_gruppo = $metagruppo;
	}
	public function setRuolo($metaruolo) {
		$this->m_ruolo = $metaruolo;
	}
	public function setAnagrafica($anagrafica) {
		$this->m_anagrafica = $anagrafica;
	}
	public function setIdmans($idmans) {
		$this->m_idmans = $idmans;
	}
	
	################################################
	# LOGIN.
	public function login($username, $password) {
		GLOBAL $db;
		
		$strSQL = "SELECT u.* FROM metautenti u
							LEFT JOIN SYS_Record r ON r.code=u.code 
							WHERE (r.attivo='S' OR r.attivo IS NULL) AND
							username=".quote_string($username, true).
							" AND password=".quote_string(md5($password), true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;

			
		$count = $rs->RecordCount();
		$this->loadFromRecord($rs);

		# DA ELIMINARE - messi per compatibilita'
		$this->username = $username;
		$this->id_utente = $rs->Fields("id_utente");
		$rs->Close();
		
		return ($count == 1) ? true : false;
	}
	
	public function loginLDAP($username, $password) {
		GLOBAL $messaggio;
		
		$ldapconn = @ldap_connect(LDAP_SERVER, LDAP_PORT);
		if (!$ldapconn) {
			$msg = "Errore interno";
		}
		
		// cerca il DN dell'utente
		if (! $msg) {
			@ldap_set_option($ldapconn, LDAP_OPT_PROTOCOL_VERSION, 3);

			// TODO !!! : questa ricerca potrebbe necessitare di una connessione autenticata !!!
			$sr = @ldap_search($ldapconn, LDAP_BASE, "(&(" . LDAP_LOGINATTRIB . "=" . $username . ")" .LDAP_FILTER . ")");
			if (! $sr) {
				$msg = "Username e/o password errati.";
			}
		}

    // controllo se trovo 1 (e solo 1) DN per l'utente con username
		if (! $msg) {
			$info = @ldap_get_entries($ldapconn, $sr);
			if ($info["count"] != 1) {
				$msg = "Username e/o password errati.";
			}
		}
 
		// provo a connettermi con la password che ha inserito l'utente
		if (! $msg) {
			$dn = $info[0]["dn"];

			$ldapbind = @ldap_bind($ldapconn, $dn, $password);
			if (! $ldapbind) {
				$msg = "Username e/o password errati.";
			}
		}

		// cerca gli attributi dell'utente
		if (! $msg) {
			$sr = ldap_search($ldapconn, $dn, "(objectclass=*)");
			$info = ldap_get_entries($ldapconn, $sr);

			if (! $info) {
				$msg = "Username e/o password errati.";
			}
		}
	
		if ($msg) {
			$messaggio->setTipo(MSG_ERROR);
			$messaggio->setTitolo("Accesso negato");
			$messaggio->setMessaggio($msg, "<br />");
			$this->m_last_message = $messaggio;
			return FALSE;
		} 
		else {
				// AUTENTICATO CON SUCCESSO:
				$this->email = $info[0]["mail"][0];
				// congnome + nome
				#$nome = $info[0]["cn"][0];
				#$cognome = $info[0]["sn"][0];
				$this->nominativo = $info[0]["cn"][0];
				$this->username = $username;
				$this->set("username", $username);
				#echo "Autenticato: $username $nome $mail";
				return true;
		}
	}
	
	################################################
	# ESISTE?.
	public function esiste($username) {
		GLOBAL $db;
		
		$strSQL = "SELECT * FROM metautenti ".
							"WHERE username=".quote_string($username, true);
		$rs = $db->Esegui($strSQL);
		if ($rs == false)
			return false;
			
		$count = $rs->RecordCount();
		$rs->Close();
		
		return ($count == 1) ? true : false;
	}
	
	################################################
	# LOAD.
	public function load($id) {
		GLOBAL $db;
		
		if (is_null($db) || (strlen($id) <= 0) || ($id <= 0))
			return false;
			
		if ($this->virtuale())
			return false;
			
		$strSQL = "SELECT * FROM metautenti WHERE id_utente=".write_number($id, true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		$count = $rs->RecordCount();
		$this->loadFromRecord($rs);
		$rs->Close();

		$this->loadAnagrafica();
		
		return $count;
	}

	public function loadFromUsername($username) {
		GLOBAL $db;

		if (is_null($db) || (strlen($username) <= 0))
			return false;

		$strSQL = "SELECT * FROM metautenti WHERE username=".quote_string($username, true);
		$rs = $db->Esegui($strSQL);

		if ($rs == false)
			return false;

		$this->loadFromRecord($rs);
		$rs->Close();

		$this->loadAnagrafica();

		return true;
	}

	public function loadAnagrafica() {
		GLOBAL $db;

		$anagrafica = new Anagrafica();
		$anagrafica->loadFromCode($this->get("code_anag")); # DEVE essere Anag::code e non pi Anag::code_anag!
		$this->setAnagrafica($anagrafica);
	}

	public function loadGruppi() {
		GLOBAL $db;
		
		if (is_null($db))
			return false;
			
		if ($this->virtuale())
			return false;
		
		$strSQL = "SELECT mg.id_gruppo, mg.label0_gruppo as label FROM MetaAssociazioni ma ".
							"JOIN metagruppi mg ON mg.code_gruppo=ma.code_gruppo ".
							"WHERE ma.username=".quote_string($this->get("username"), true).
							" AND aster='N' AND nega='N'";
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
	
		while (!$rs->EOF) {
			$this->m_gruppi[$rs->Fields("id_gruppo")] = $rs->Fields("label");
			$rs->MoveNext();
		}
		$rs->Close();
		return $this->m_gruppi;
	}
	public function loadRuoli() {
		GLOBAL $db;
		
		if (is_null($db))
			return false;
			
		if ($this->virtuale()) {
			return $this->m_ruoli;
		}
			
		$strSQL = "SELECT ma.code_ruolo, mr.label_ruolo FROM metaassociazioni ma ".
							"LEFT JOIN metaruoli mr ON mr.code_ruolo=ma.code_ruolo ".
							"WHERE ma.username=".quote_string($this->get("username"), true).
							" AND aster='N' AND nega='N'";
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		while (!$rs->EOF) {
			$this->m_ruoli[$rs->Fields("code_ruolo")] = $rs->Fields("label_ruolo");
			$rs->MoveNext();
		}
		$rs->Close();
		return $this->m_ruoli;
	}
	public function loadModuli() {
		GLOBAL $db, $applicazione;
		
		foreach ($applicazione->moduli() as $m => $modulo) {
			$this->m_flag_manager[$modulo->code()] = array();
			$this->m_flag_manager[$modulo->code()]["manager"] = false;
			/*if ($this->ruolo()->maskModuli() & $modulo->mask())
				$this->m_flag_manager[$modulo->code()]["visibile"] = true;
			else
				$this->m_flag_manager[$modulo->code()]["visibile"] = false;
			 */
			$this->m_flag_manager[$modulo->code()]["visibile"] = false;
		}
		
		# se virtuale, non pu essere un manager.
		if ($this->virtuale())
			return true;
		
		# Da qui si vede se uno  manager di qualche modulo.
		if (is_null($db))
			return false;
			
		$strSQL = "SELECT distinct code_modulo, manager FROM metaassociazioni ma ".
							"WHERE (ma.username=".quote_string($this->get("username"), true).
							#" OR ma.code_gruppo=".quote_string($this->gruppo()->code(), true).
							")".
							" AND aster='N' AND nega='N' AND code_modulo IS NOT NULL ".
							#" AND manager='S' ".
							"";#" AND code_ruolo=".quote_string($this->ruolo()->code(), true);
		$rs = $db->Esegui($strSQL);
		
		if ($rs == false)
			return false;
			
		while (!$rs->EOF) {
			if ($rs->fields("manager") == 'S') {
				$this->m_flag_manager[$rs->fields("code_modulo")]["manager"] = true;
			}
			$this->m_flag_manager[$rs->fields("code_modulo")]["visibile"] = true;
			$rs->MoveNext();
		}
		$rs->Close();
		
		return true;
	}



	public function update() {
		GLOBAL $messaggio;

		if ($this->isChanged("username")) {
			if ($this->esiste($this->get("username")) == true) {
				$messaggio->setTipo(MSG_ERROR);
				$messaggio->setTitolo("Modifica utente");
				$messaggio->setMessaggio("Username \"{$this->get("username")}\" gi&agrave; presente.", "<br />");
				$this->m_last_message = $messaggio;
				return false;
			}
		}

		if (is_object($this->m_anagrafica)) {
			if ($this->m_anagrafica->id() > 0)
				$this->m_anagrafica->update();
			else {
				$this->m_anagrafica->insert();
				$this->set("code_anag", $this->m_anagrafica->code());
			}
		}

		if (strlen($this->get('tipo_utente')) == 0)
			$this->set('tipo_utente', 'U');
			
		return parent::update();
	}

	public function insert() {
		GLOBAL $messaggio;


		if ($this->isChanged("username")) {
			if ($this->esiste($this->get("username")) == true) {
				$messaggio->setTipo(MSG_ERROR);
				$messaggio->setTitolo("Nuovo utente");
				$messaggio->setMessaggio("Username \"{$this->get("username")}\" gi&agrave; presente.", "<br />");
				$this->m_last_message = $messaggio;
				return false;
			}
		}

		if (is_object($this->m_anagrafica)) {
			$res = $this->m_anagrafica->insert();
			
			if ($res == false) {
				$messaggio->setTipo(MSG_ERROR);
				$messaggio->setTitolo("Nuovo utente");
				$messaggio->setMessaggio("Errore nel creare l'anagrafica.", "<br />".$this->m_anagrafica->lastMessage());
				$this->m_last_message = $messaggio;
				return false;
			}
			$this->set("code_anag", $this->m_anagrafica->code());

		}

		if (strlen($this->get('tipo_utente')) == 0)
			$this->set('tipo_utente', 'U');

		return parent::insert();
	}
}
?>