<?php
require_once("classes/factory.class.php");

abstract class RecordBase {
	private $m_campi;
	protected $m_changed; # dice se il record e' cambiato.
	protected $m_tabella;
	protected $m_identity;
	private $m_campi_changed; # per ogni campo del record, dice se e' cambiato.
	private $m_last_query;
	protected $m_codice_classe;
	protected $m_last_message; # messaggio

	private $m_init;

	#private $m_sysrecord;
	protected $m_eludi_check;

	protected $m_last_action; # ultima azione {I, U, D}


	################################################
	# Costruttore.
	public function __construct($table=null, $ident="ident", $id=null) {
		$this->m_init = false;
		$this->m_campi = array();
		$this->m_changed = false;
		$this->m_campi_changed = array();
		$this->m_codice_classe = "";
		$this->m_eludi_check = false;
        if (strlen($table))
            $this->m_tabella = $table;
        if (strlen($ident))
            $this->m_identity = $ident;
        
        $this->init();
        
        if (strlen($id))
            $this->load($id);
	}

	################################################
	# CHECK
	protected function checkCampo($chiave) {
		$chiave = strtolower($chiave);

		return array_key_exists($chiave, $this->m_campi);
	}

	################################################
	# GET
	public function id() {
		/*if (isset($this->m_identity))
			return $this->m_campi[$this->m_identity];
		return null;*/
        return $this->m_campi[$this->m_identity];
	}
	public function code() {
		if ($this->checkCampo("code"))
			return $this->m_campi["code"];
		return $this->id();
	}
	public function isChanged($chiave=null) {
		if (is_null($chiave))
			return $this->m_changed;
		elseif ($this->checkCampo($chiave))
			return $this->m_campi_changed[$chiave];
	}
	public function get($chiave) {
		$chiave = strtolower($chiave);

		if ($this->checkCampo($chiave))
			return $this->m_campi[$chiave];
	}
	public function identity() {
		return $this->m_identity;
	}
	#-----------------------------------------------
	public function campi() {
		return $this->m_campi;
	}
	public function tipi() {
		return $this->m_tipi;
	}
	public function tipo($chiave) {
		if ($this->checkCampo($chiave))
			return $this->m_tipi[$chiave];
		else
			return "";
	}
	public function lastQuery() {
		return $this->m_last_query;
	}
	public function lastMessage() {
		return $this->m_last_message;
	}
	public function dimensioni($chiave) {
		if ($this->checkCampo($chiave))
			return $this->m_dimensioni[$chiave];
		else
			return -1;
	}


	public function tabella() {
    return $this->m_tabella;
  }

	
	################################################
	# SET
	public function set($chiave, $valore) {
		$chiave = strtolower($chiave);

		#if (is_null($valore))
		#	return true;
		if (!$this->checkCampo($chiave))
			return false;
		if (!is_object($valore))
			if ($this->m_campi[$chiave] == $valore)
				return true;
		$this->m_campi[$chiave] = $valore;
		$this->m_changed = true;
		$this->m_campi_changed[$chiave] = true;
		return true;
	}
	public function setIdentity($identity) {
		if (!$this->checkCampo($identity))
			return false;
		$this->m_identity = $identity;
	}

	public function setTabella($tabella) {
		$this->m_tabella = $tabella;
	}

	public function setEludiCheck($bool) {
			$this->m_eludi_check = $bool;
			return true;
	}

	
	################################################
	# INIT.
	public function init($cache=true) {
		GLOBAL $db;

		if ($this->m_init)
			return true;

		if (is_null($db))
			return false;

        $this->m_campi = RecordInfo::campi($this->m_tabella);
        $this->m_campi_changed = array();
        foreach ($this->m_campi as $campo => $niente) {
            $this->m_campi_changed[$campo] = false;
        }
		$this->m_changed = false;
		$this->m_init = true;
		return true;
	}

	################################################
	# LOAD.
    # Carica il record dal suo ID ($id scalare) o filtra tramite una WHERE
    # se $id e' un array associativo ('nomecampo' => 'valore')
	public function load($id) {
		GLOBAL $db;

		if (is_null($db))
			return false;

        $this->init();
        
		#--------------------------------------------------
		if (is_array($id)) {
			$strSQL = "SELECT * FROM ".$this->m_tabella;
			if (count($id) > 0)
					$strSQL .= " WHERE ";
			foreach($id as $key => $value) {
				if ($this->checkCampo($key)) {
					$this->set($key, $value);
					$strSQL .= $key."=".$this->quota($key)." AND ";
				}
			}
			$strSQL = substr($strSQL, 0, -5);
		}
		else {
			if (strlen($id) <= 0)
				return false;
			$this->set($this->m_identity, $id);
			$strSQL = "SELECT * FROM ".$this->m_tabella." WHERE ".$this->m_identity."=".$this->quota($this->m_identity);
		}
		#--------------------------------------------------
		$rs = $db->Esegui($strSQL);

		if ($rs == false)
			return false;

		if ($rs->RecordCount() > 0)
			$this->loadFromRecord($rs);
		return $rs->RecordCount();
	}
	################################################
	# LOAD-FROM-CODE.
    # Carica il record dal suo CODE
	public function loadFromCode($code) {
		GLOBAL $db;
        $this->init();

		if (is_null($db) || (strlen($code) <= 0))
			return false;
        
        $recordinfo = RecordInfo::campi($this->m_tabella);
        
        #if (!isset($recordinfo['code']))
        #    return $this->load($code);
        
        #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		# PRIMA CARICO LA TABELLA
		$strSQL = "SELECT t.* FROM ".$this->m_tabella." t 
				   WHERE t.code=".quote_string($code, true);
		$rs = $db->Esegui($strSQL);  #DEBUG($strSQL);

		if ($rs == false)
			return false;

		$this->loadFromRecord($rs);
		$rs->Close();

		#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		# E POI LA SYS_RECORD
		#$sysrecord = Factory::crea("SYSRecord", $code);
		#Factory::memorizza($sysrecord);
		return true;
	}
    
	public function loadFromRecord($rs) {
		GLOBAL $db;
		
		if (is_null($rs))
			return false;
            
        $numfields = $rs->FieldCount();
		for ($f=0; $f<$numfields; $f++) {
			$field = $rs->FetchField($f);
			$nomecampo = strtolower($field->name);
			$this->m_campi[$nomecampo] = $rs->Fields($field->name);
		}
		$this->m_changed = false;
		return true;
	}
    public function loadInput($pre="", $post="") {
        $recordinfo = RecordInfo::campi($this->m_tabella);
        foreach ($recordinfo as $campo => $niente) {
            #$valore = getVar("POST", $campo, false);
            #if ($valore !== false)
            #    $this->set($campo, $valore);
            if (isset($_POST[$campo]))
                $this->set($campo, getVar("POST", $campo));
        }
    }
	/*public function loadInput($oggetto, $messaggio, $voce_tipologia=null, $pre="", $post="") {
		GLOBAL $metautente;

		if (is_object($this->metainfo()))
			$oggetto = $this->metainfo();

		if (!is_object($oggetto)) {
			$messaggio->setTipo(MSG_ERROR);
			$messaggio->setMessaggio("ATTENZIONE!<br />Oggetto NON configurato. (".get_class($this).")");
			return false;
		}

		$ruolo = $metautente->ruolo();
		$res = true;

		#---------------------------------------------------------------------------
		# Faccio l'input per la sysrecord:
		#---------------------------------------------------------------------------
		#if (is_object($this->m_sysrecord))
		#	$this->m_sysrecord->loadInput(null, $messaggio, null, "sys_", "");

		#---------------------------------------------------------------------------
		# Per ogni campo cerco un input:
		#---------------------------------------------------------------------------
		foreach($oggetto->campi() as $chiave => $campo) {

			if ($chiave == $this->m_identity) # non indispensabile, ma per sicurezza...
				continue;

			if ($this->checkCampo($chiave) == false) { # non indispensabile, ma per sicurezza...
				#echo "checkCampo($chiave) = false<br>";
				#DEBUG("------------------------------- $chiave");
				continue;
			}

			# SE NON VISIBILE O NON MODIFICABILE LO IGNORO:
			if (!$campo->isVisibile($ruolo->bit()) || !$campo->isModificabile($ruolo->bit()))
				continue;

			# Se e' un oggetto, leggo i dati:
			if (strlen($campo->classe()) > 0) {
				if (class_exists($campo->classe())) {
					$classe = $campo->classe();

					# se siamo in update l'oggetto esiste gia':
					if (is_object($this->get($campo->code()))) {
						$o = $this->get($campo->code());
					}
					else {
						$o = new $classe();
						if (strlen($this->get($campo->code())) > 0)
							$o->loadFromCode($this->get($campo->code()));
						else
							$o->init();
					}
					$res_subobj = $o->loadInput($o->metainfo(), $messaggio, null, $pre.$campo->code().$post, "");
					if (!$res_subobj) {
						#echo $campo->code()." = FALSE!<br>";
						#echo "Messaggio = ".$messaggio->messaggio();
						$res = FALSE;
					}
					# QUI SIAMO OK!

					# SOLO per gli allegati, NON dobiamo associare l'oggetto se VUOTO:
					if (strtoupper($campo->classe()) == "ALLEGATO") {
						if (strlen($o->get("originale")) > 0)
							$this->set($chiave, $o);
						continue;
					}

					$this->set($chiave, $o);
					continue;
				}
			}

			#DEBUG($chiave.'='.$this->m_tipi[$chiave]);
			if (array_key_exists($pre.$chiave.$post, $_POST)) {
				switch($this->m_tipi[$chiave]) {
					case "timestamptz":
					case "datetime":
						$valore = getVar("POST", $pre.$chiave.$post, false);
						if (($valore !== false) && (strlen($valore) > 0)) {
							#$data = new myDate();
							#$data->setDate($valore, 'it');
							#$valore = $data->stampa('us')." 00:00:00";
							$valore = date_translate($valore, 'it', 'us')." 00:00:00";
						}
						break;

					case "real":
						$valore = getVar("POST", $pre.$chiave.$post, false);
						if (strlen($valore) > 0)
							$valore = write_number($valore, false);
						break;

					default:
						$valore = getVar("POST", $pre.$chiave.$post, false);
						break;
				}
			}
			else
				continue;

			#echo $pre.$chiave.$post."<br>";
			if ($valore === false)
				continue;
			if (!$campo->isVisibile($ruolo->bit()))
				continue;
			if (!is_null($voce_tipologia))
				if (!$voce_tipologia->isPresente('V', $campo->code()))
					continue;
			#DEBUG("*** ".get_class($this).":: ".$chiave." = |".$valore."|");
			$this->set($chiave, $valore);

			if (strlen($valore) == 0) {
				if (!is_null($voce_tipologia)) {
					if ($voce_tipologia->isPresente('V', $campo->code()) && $voce_tipologia->isPresente('O', $campo->code())) {
						$messaggio->setTipo(MSG_ERROR);
						$messaggio->setMessaggio("ATTENZIONE!<br />E' necessario valorizzare tutti i campi obbligatori. ({$campo->label(0)})");
						$res = false;
					}
				}
				else {
					if ($campo->isVisibile($ruolo->bit()) &&
							$campo->isObbligatorio($ruolo->bit()) &&
							$campo->isModificabile($ruolo->bit())) {
						$messaggio->setTipo(MSG_ERROR);
						$messaggio->setMessaggio("ATTENZIONE! E' necessario valorizzare tutti i campi obbligatori. (".$campo->label(0).")");
						$res = false;
					}
					
				}
			}
			#echo "<br><br>";
		}
		#die();
		return $res;
	}*/

    # Qui verifichiamo i campi obbligatori sul DB (NOT NULL) non quelli
    # obbligatori a livello applicativo.
	public function checkObbligatori() {
        return TRUE;
	}

	################################################
	# QUOTA.
	private function quota($chiave) {
		$chiave = strtolower($chiave);
        $tipi = RecordInfo::tipi($this->m_tabella);
        $dimensioni = RecordInfo::dimensioni($this->m_tabella);

		if (is_object($this->m_campi[$chiave]))
			$this->m_campi[$chiave] = $this->m_campi[$chiave]->code();

		#echo $chiave."=".$tipi[$chiave]."<br>";
        #error_log($chiave."=".$tipi[$chiave]);
        
		switch($tipi[$chiave]) {
			case "int4":
			case "int":
			case "real":
			case "numeric":
				return write_number($this->m_campi[$chiave], true);
				break;

			case "timestamptz":
			case "datetime":
				if ($this->m_campi[$chiave] == "getdate()")
					return "getdate()";
				if ($this->m_campi[$chiave] == "now()")
					return "now()";
				# TODO : check della data ed eventuale encode/decode.
				$data = $this->m_campi[$chiave];
				/*if (check_date_format($data, 'it'))
					return "CONVERT (datetime, ".quote_string($data, true).", 103)"; # 103=dd/mm/yyyy
				else
					return quote_string($data, true);*/
				$data = date_translate($data, 'it', 'us');
				return quote_string($data, true);
				break;

			case "date":
				if ($this->m_campi[$chiave] == "getdate()")
					return "getdate()";
				if ($this->m_campi[$chiave] == "now()")
					return "now()";
				# TODO : check della data ed eventuale encode/decode.
				$data = $this->m_campi[$chiave];
                /*if (check_date_format($data, 'it'))
					return "CONVERT (datetime, ".quote_string($data, true).", 103)"; # 103=dd/mm/yyyy
				else
					return quote_string($data, true);*/
                $data = date_translate($data, 'it', 'us');
				return quote_string($data, true);
				break;

			case "char":
			default:
				if ($dimensioni[$chiave] > 0)
					$this->m_campi[$chiave] = substr($this->m_campi[$chiave], 0, $dimensioni[$chiave]);
				return quote_string($this->m_campi[$chiave], true);
				
				break;
		}
	}

	################################################
	# CHECK.
	public function check() {
		return true;
	}

	################################################
	# UPDATE.
	public function update() {
		GLOBAL $db, $metautente;
        
        if ($this->m_changed == false)
			return true;
		#if (is_null($db) || (strlen($this->m_identity) <= 0) || ($this->m_campi[$this->m_identity] <= 0))
		#	return false;
        if (is_null($db) || (strlen("ident") <= 0) || ($this->m_campi["ident"] <= 0))
			return false;
        

		$this->m_last_action = 'U';

		#---------------------------------------------------------------------------
		# CHECK
		#---------------------------------------------------------------------------
		
        
        #---------------------------------------------------------------------------
		$strSQL1 = "UPDATE ".$this->m_tabella." SET  ";
		$strSQL2 = $strSQL3 = "  ";

		foreach($this->m_campi as $chiave => $campo) {
			if ($chiave == $this->m_identity) # non indispensabile, ma per sicurezza...
				continue;

			if ($this->m_campi_changed[$chiave] == false)
				continue;

			#DEBUG($chiave."=".$this->quota($chiave));
			$strSQL2 .= $chiave."=".$this->quota($chiave).", ";
		}
		$strSQL2 = substr($strSQL2, 0, -2); # tolgo l'ultima virgola.
		$strSQL3 .= " WHERE {$this->m_identity}=".$this->quota($this->m_identity).";";
		
		#-------------------------------------------------------------
		if (strlen($strSQL2) > 0) {
            #DEBUG($strSQL1.$strSQL2.$strSQL3);
			$res = $db->Esegui($strSQL1.$strSQL2.$strSQL3);
			$this->m_last_query .= $strSQL1.$strSQL2.$strSQL3."<br>";
		}
        #die("UPDATE");
		#-------------------------------------------------------------
		return $res;
	}

	################################################
	# INSERT.
	################################################
	/**
	 * inserisce un nuovo record.
	 *
	 * @return string|bool Ritorna il CODE del nuovo record o FALSE.
	 *
	 */
	public function insert() {
		GLOBAL $db;

		#DEBUG("INSERT::".get_class($this));
		if (is_null($db) || (strlen($this->m_identity) <= 0))
			return false;

		# genero il CODE:
		if (strlen($this->get("code")) <= 0)
			$this->set("code", substr(strtoupper(get_class($this).substr(md5(microtime()), rand(0, 8), 24)), 0, 50));

		$this->m_last_action = 'I';

		#---------------------------------------------------------------------------
		# CHECK
		#---------------------------------------------------------------------------
		if ($this->m_eludi_check)
			$this->setEludiCheck(false);
		elseif ($this->check($this->m_last_message) !== true) {
			$db->FailTrans();
			$db->Logga(LOGWARNING, "", "<b>".get_class($this)."::Insert-CHECK(): ".$this->m_last_message->messaggio()."</b>");
			return false;
		}

		$strSQL = "INSERT INTO ".$this->m_tabella." (";

		foreach($this->m_campi as $chiave => $campo) {
			if ($chiave == $this->m_identity)
				continue;
			#if ($this->m_campi_changed[$chiave] == false) # in insert non serve, anzi.....
			#	continue;
			elseif (is_object($campo)) {
				$strSQL .= $chiave.", ";
			}
			elseif (strlen($this->m_campi[$chiave]) == 0)
				continue;
			else
				$strSQL .= $chiave.", ";
		}
		$strSQL = substr($strSQL, 0, -2); # tolgo l'ultima virgola.
		$strSQL .= ") VALUES (";

		foreach($this->m_campi as $chiave => $campo) {
			if ($chiave == $this->m_identity)
				continue;
			#if ($this->m_campi_changed[$chiave] == false)
			#	continue;

			# Se e' un oggetto, leggo i dati:
			elseif (is_object($campo)) {
				$res = $campo->insert();

				if (!$res)
					return FALSE;
				$strSQL .= "'".$campo->code()."', ";
			}
			elseif (strlen($this->m_campi[$chiave]) == 0)
				continue;
			else
				$strSQL .= $this->quota($chiave).", ";
		}
		$strSQL = substr($strSQL, 0, -2); # tolgo l'ultima virgola.
		$strSQL .= ")";
		#--------------------------------------------------------------

		/*if (strlen($this->code()) > 0) {
			$sysrecord = Factory::crea("SYSRecord");
			if (strlen($sysrecord->code()) == 0) {
				$sysrecord->set("code", $this->code());
				$sysrecord->set("tabella", $this->m_tabella);
			}
		}*/
        #DEBUG("Insert query: ".$strSQL);
        #return false;
        $res = $db->Esegui($strSQL);
		return $res;
	}
}
?>