<?php
/**
 * @author marce
 *
 */

abstract class RecordInfo {
    
    static function campi($tabella) {
        $info = self::info($tabella);
        return $info["CAMPI"];
    }
	static function tipi($tabella) {
        $info = self::info($tabella);
        return $info["TIPI"];
    }
	static function dimensioni($tabella) {
        $info = self::info($tabella);
        return $info["DIMENSIONI"];
    }
	
    /**
	 *
	 * Info sul record
	 *
	 */
	static function info($tabella) {
        GLOBAL $db;
        
        #DEBUG("INIT tabella $tabella");
        
		#---------------------------------------------------------------------------
		# Vediamo se in cache c'e' qualcosa...
		if (CACHE && isset($_SESSION["CACHE"][$tabella])) {
			return $_SESSION["CACHE"][$tabella];
		}
        $m_campi = array();
        $m_tipi = array();
        $m_dimensioni = array();
        
		#---------------------------------------------------------------------------
		# Andiamo allora a leggerli dal db...
		if ((DB_TYPE == "mssql") || (DB_TYPE == "sybase")) {
			$strSQL = "SELECT TOP 1 * FROM {$tabella}";
			$rs = $db->Esegui($strSQL, false);

			if ($rs == false)
				return false;

			$metacol = $db->link->MetaColumns($tabella);

			$numfields = $rs->FieldCount();
			for ($f=0; $f<$numfields; $f++) {
				$field = $rs->FetchField($f);
				$nomecampo = strtolower($field->name);
				$m_campi[$nomecampo] = null;
				$m_tipi[$nomecampo] = $field->type;

				$metafield = $metacol[strtoupper($nomecampo)];
				switch ($field->type) {
					case "text":
						$m_dimensioni[$nomecampo] = $metafield->max_length*1024;
						break;

					default:
						$m_dimensioni[$nomecampo] = $metafield->max_length;#$field->max_length;
						break;
				}

				if ($m_dimensioni[$nomecampo] <= 0)
					$m_dimensioni[$nomecampo] = $field->max_length;
			}
		}
		elseif (DB_TYPE == "pgsql") {
			$strSQL = "SELECT a.attname AS name, t.typname AS type, a.attstorage AS i,
								CASE WHEN a.attlen = -1 THEN a.atttypmod ELSE a.attlen END AS size
								FROM pg_attribute a , pg_class c, pg_type t
                                WHERE c.relname = '{$tabella}'
								AND a.attrelid = c.oid AND a.atttypid = t.oid and a.attnum > 0 and not a.attisdropped";
			$rs = $db->Esegui($strSQL); #DEBUG($strSQL);

			if ($rs == false)
				return false;

			while (!$rs->EOF) {
				$name = $rs->Fields("name");
				$m_campi[$name] = null;
				switch ($rs->Fields("type")) {
					case "int4":
						$m_tipi[$name] = "int4";
						$m_dimensioni[$name] = $rs->Fields("size");
						break;

					case "text":
						$m_tipi[$name] = "text";
						$m_dimensioni[$name] = 64*1024;
						break;

					default:
						$m_tipi[$name] = $rs->Fields("type");
						$m_dimensioni[$name] = $rs->Fields("size") - 4;
						break;
				}
				$rs->MoveNext();
			}
		}

		#---------------------------------------------------------------------------
		# Metto in cache...
		$_SESSION["CACHE"][$tabella]["CAMPI"] = $m_campi;
		$_SESSION["CACHE"][$tabella]["TIPI"] = $m_tipi;
		$_SESSION["CACHE"][$tabella]["DIMENSIONI"] = $m_dimensioni;
        
        return $_SESSION["CACHE"][$tabella];
	}
}
?>