<?php
//require_once('include/funzioni_date.inc.php');

#
# Gestore: Marcello Trucco
# Data Creazione: 29.09.2004
# Data Ultima Modifica: 13.01.2010
# Versione: 0.1
#

/*
/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
\ Classe RS                                                  /
/                                                            \
\ Oggetto che descrive il recordset risultante di una query. /
/                                                            \
\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
*/
class RS {
	private $recordset_array;
    private $current_pos;
    public $EOF;
    

	################################################
	# Costruttore.
	function __construct($stmt) {
		$this->recordset_array = array();
        $this->current_pos = -1;
        $this->init($stmt);
	}
    
    public function __call($name,  $arguments) {
	#	return call_user_func_array(array($this->m_adorecordset, $name), $arguments);
		DEBUG($name);
		print_r($arguments);
		DEBUG('');
		die();
	}
	public function __get($name) {
		#return $this->m_adorecordset->$name;
        if ($name == "EOF")
            return $this->EOF ();
	}
	#-----------------------------------------------------------------------------
	public function init($stmt) {
		$i = 0;
        while( $row = sqlsrv_fetch_array( $stmt, SQLSRV_FETCH_ASSOC) ) {
            
            foreach ($row as $key => $value) {
                $key = strtolower($key);
                $this->recordset_array[$i][$key] = $value;
            }
            $i++;
        }
        sqlsrv_free_stmt( $stmt);
	}
	public function Close() {
        unset($this->recordset_array);
        $this->current_pos = -1;
		return TRUE;
	}
    #-----------------------------------------------------------------------------
	public function get($nomecampo) {
		#return Fields($nomecampo);
        
        $nomecampo = strtolower($nomecampo);
        return $this->recordset_array[$this->current_pos][$nomecampo];
	}
	#-----------------------------------------------------------------------------
	public function Fields($nomecampo) {
        
		switch (ADODB_ASSOC_CASE) {
			case 0: # lower
				$nomecampo = strtolower($nomecampo);
				break;
			case 1: # UPPER
				$nomecampo = strtoupper($nomecampo);
				break;
			
			default:# non faccio nulla.
				break;
		}
		if (defined('UTF8_OUTPUT')) {
			if (UTF8_OUTPUT)
				return utf8_encode($this->m_adorecordset->Fields($nomecampo));
		}
		return $this->m_adorecordset->Fields($nomecampo);
	}

	public function RecordCount() {
		return count($this->recordset_array);
	}
	public function FieldCount() {
        if ($this->RecordCount() == 0)
            return FALSE;
		return count($this->recordset_array[0]);
	}
	public function FetchField($pos) {
		return $this->m_adorecordset->FetchField($pos);
	}


	public function MoveFirst() {
        if ($this->RecordCount() == 0)
            return FALSE;
		$this->current_pos = 0;
	}

	public function MoveNext() {
        if ($this->current_pos == -1)
            return FALSE;
        if ($this->current_pos >= $this->RecordCount())
            return FALSE;
		$this->current_pos++;	
		return true;
	}
    public function EOF() {
		if ($this->current_pos == -1)
            return TRUE;
        if ($this->current_pos > $this->RecordCount())
            return TRUE;
        return FALSE;
	}

	
	public function GetArray() {
		if (get_class($this->m_adorecordset) == 'ADORecordSet_empty')
			return array();
		return $this->m_adorecordset->GetArray();
	}

	public function GetRows() {
		return $this->m_adorecordset->GetRows();
	}

	public function FetchRow() {
		return $this->m_adorecordset->FetchRow();
	}
	
	public function LastPageNo() {
		return $this->m_adorecordset->LastPageNo();
	}
	public function AtFirstPage() {
		return $this->m_adorecordset->AtFirstPage();
	}
	public function AtLastPage() {
		return $this->m_adorecordset->AtLastPage();
	}
}

$ADODB_FETCH_MODE = ADODB_FETCH_ASSOC; //ADODB_FETCH_BOTH;
/*******************************************************************************

/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
\ Classe DB                                                /
/                                                          \
\ Oggetto che descrive il database.                        /
/                                                          \
\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
*/
class DB {
	public $link;
	private $db_type;
	private $last_error_code;
	private $last_error_message;

	private $db_name;
	private $db_host;
	private $db_user;

	private $m_querylist;
	private $m_langid;
	private $m_language;
	
	################################################
	# Costruttore.
	function __construct($db_type=DB_TYPE) {
		$this->db_type = $db_type;
	}
	
	################################################
	function __sleep() {
		return array("db_type", "db_name", "m_langid", "m_language");
	}
	
	################################################
	function __wakeup() {
		$this->Connetti();
		$this->Init();
	}

	################################################
	# GET
	function get($what) {
		switch ($what) {
			case 'type':
				return $this->db_type;
				break;

			case 'host':
				return $this->db_host;
				break;

			case 'user':
				return $this->db_user;
				break;

			case 'database':
				return $this->db_name;
				break;

			case 'langid':
				return $this->m_langid;
				break;

			case 'language':
				return $this->m_language;
				break;
		}
	}
 
	################################################
	# Connetti:
	function Connetti($host=DB_HOST_SERVER, $user=DB_USERNAME_UTENTE, $pwd=DB_PASSWORD_UTENTE, $nomedb="") {
        
		if (strlen($nomedb) > 0)
			$this->db_name = $nomedb;
		elseif (isset($_SESSION["DB_NAME"]) && strlen($_SESSION["DB_NAME"]) > 0)
			$this->db_name = $_SESSION["DB_NAME"];
		else
			$this->db_name = DB_NAME;

		$this->db_host = $host;
		$this->db_user = $user; #decifra($user);

        #$this->link = ADONewConnection($this->db_type);
		#$res = $this->link->PConnect($host, decifra($user), decifra($pwd), $this->db_name);
		#DEBUG("$host, $user, $pwd, $nomedb");
		#DEBUG("$host, ".cifra($user).", ".cifra($pwd).", $this->db_name");
		#DEBUG("$host, ".decifra($user).", ".decifra($pwd).", $this->db_name");
		
        # NEW VERSION
        $connectionInfo = array( "Database"=>$nomedb, "UID"=>$user, "PWD"=>$pwd );
        $this->link = sqlsrv_connect( $host, $connectionInfo);
        if( $this->link === false ) {
             die( print_r( sqlsrv_errors(), true));
        }
        
        return TRUE;
	}

	################################################
	# Init:
	function Init() {
        $this->Esegui("SET NOCOUNT ON", false);
		/*if ($this->db_type == "mssql" || $this->db_type == "mssqlnative") {
			$this->Esegui("SET ANSI_WARNINGS ON", false);
			$this->Esegui("SET ANSI_NULLS ON", false);
			$this->Esegui("SET ANSI_NULL_DFLT_ON ON", false);

			if (strlen($this->m_language) == 0) {
				$rs = $this->Esegui("SELECT @@langid as code, @@language as label", true);
				if ($rs != FALSE) {
					$this->m_langid = strtolower(substr($rs->Fields("label"), 0, 2));
					$this->m_language = $rs->Fields("label");
				}
			}
		}*/
	}
 
	################################################
	# Disconnetti:
	function Disconnetti() {
		return sqlsrv_close($this->link);
	}
 
	################################################
	# Esegui:
	function Esegui($strSQL, $logga=true, $titolo='SQL') {
		if (strlen($strSQL) == 0)
			return true;

		/*if ($this->TransNo() > 0 && $this->HasFailedTrans()) {
			$this->m_querylist .= "*** NOT EXEC *** ".$strSQL."<br>\n";
			#DEBUG("<span style='color:red;'>FAIL TRANS - $strSQL<br>{$this->link->ErrorMsg()}</span>");
			return false;
		}*/

        sqlsrv_configure("WarningsReturnAsErrors", 0);
        
		#$res = $this->link->Execute($strSQL);
        $res = sqlsrv_query( $this->link, $strSQL);

		if ($res == FALSE) {
			#DEBUG("<span style='color:red;'>FAIL - $strSQL<br>{$this->link->ErrorMsg()}</span>");
            $errors = sqlsrv_errors();
			$this->last_error_code = $errors[0]['code'];
			$this->last_error_message = $errors[0]['message'];
			$this->Logga(LOGERROR, "[".$this->last_error_code."] ".$this->last_error_message, $strSQL);
			return FALSE;
		}
		elseif ($logga) {
			#DEBUG("OK - $strSQL");
			$this->Logga(LOGINFO, "$titolo (".sqlsrv_num_rows( $res ).")", $strSQL);
		}

		if ($res != FALSE) {
			$rs = new RS($res);
			return $rs;
		}
		else
			return FALSE;
		#return $res;
	}

	
 
 ################################################
 # Logga:
 function Logga($tipo, $desc, $cmd="") {
 	/*GLOBAL $metautente, $applicazione;

    
        $username = $metautente->get("username");
        if (strlen($username) == 0)
            $username = $metautente->username;

	if ($this->TransNo() == 0) {

		$modulo = (is_object($applicazione)) ? $applicazione->modulo() : "";

		$strSQL = "INSERT INTO ".TABELLA_LOG." ".
								"(sessione, code_modulo, datacreation, username, ip, tipo, Page, Description, Command) ".
								"VALUES(".
								"'".session_id()."', ".
								quote_string($modulo, true).", ".
								time().",".
								quote_string($username, true).", ".
								"'".$_SERVER['REMOTE_ADDR']."', ".
								"'".$tipo."', ".
								quote_string($_SERVER['PHP_SELF'], true).", ".
								quote_string($desc, true).", ".
								quote_string($cmd, true).
							")";
		//echo $strSQL;
		$res = $this->link->Execute($strSQL);
		StampaErrore($res, $strSQL."<br><br>[".$this->link->ErrorNo()."] ".$this->link->ErrorMsg(), false, true);
		return $res;

	}
	else {
		if ($tipo == LOGERROR)
			$this->m_querylist .= "<b>ERRORE - ".$desc."</b><br>\n";
		$this->m_querylist .= $cmd."<br>\n";
	}*/
     return true;
 }
 
	################################################
	# ErrorNo:
	function ErrorNo() {
		return $this->last_error_code;
	}
	
	################################################
	# ErrorMsg:
	function ErrorMsg() {
		return $this->last_error_message;
	}
	
	################################################
	# StartTrans:
	/*function StartTrans($mode="SERIALIZABLE") {
		$this->link->SetTransactionMode($mode);
		return $this->link->StartTrans(); # <-- INIZIO TRANSAZIONE.
	}
	
	################################################
	# CompleteTrans:
	function CompleteTrans($autocomplete=true) {
		$res = $this->link->CompleteTrans($autocomplete); # <-- FINE TRANSAZIONE.
		if ($this->TransNo() == 0) {
			Factory::conferma($res);
			
			if (strlen($this->m_querylist) > 0) {
				if ($res)
					$this->Logga(LOGINFO, "TRANSAZIONE OK", $this->m_querylist);
				else
					$this->Logga(LOGERROR, "TRANSAZIONE FALLITA!", $this->m_querylist);
				$this->m_querylist = "";
			}
		}

		return $res;
	}

	################################################
	# CompleteTrans:
	function HasFailedTrans() {
		return $this->link->HasFailedTrans(); # <-- CHECK FINE TRANSAZIONE.
	}

	################################################
	# CompleteTrans:
	function FailTrans() {
		#$this->Esegui("INSERT INTO TABELLACHENONESISTE VALUES('pippo', 'pluto', 'topolino')");
		return $this->link->FailTrans(); # <-- FORZO ROLLBACK.
	}

	function TransNo() {
		return $this->link->transCnt;
	}
	
	function FailAllTrans() {
		if ($this->TransNo() > 0) {
			$this->FailTrans();

			while ($this->TransNo() > 0)
				$this->CompleteTrans();
		}
	}*/

	################################################
	# :
	function DbName() {
		return $this->db_name;
	}

	function Data($data) {
		# DATA E' ITALIANA
		if (check_date_format($data, 'it')) {
			if ($this->m_langid == 'it')
				;
			else
				$data = date_translate($data, 'it', 'us');
		}
		# DATA NON E' ITALIANA
		elseif (check_date_format($data, 'us')) {
			if ($this->m_langid == 'it')
				$data = date_translate($data, 'us', 'it');
			else
				;
		}
		else
			$data = "";


		return $data;
	}
}
?>
