<?php

/************************************************************************************
* classe SYS Record
************************************************************************************/
class SYSRecord extends RecordBase {

	################################################
	# Costruttore.
	public function __construct($code) {
		parent::__construct("sys_record", "ident", array("code" =>$code));
	}

	################################################
	# GET

	################################################
	# SET

	################################################
	# VALIDITA'.
	public function valido($data="") {
		if (strlen($this->get("start")) == 0 && strlen($this->get("stop")) == 0)
			return true;

		if (strlen($data) == 0)
			$data = date('Y-m-d'); #oggi

		if (strlen($this->get("start")) > 0)
			if (date_sottrazione($this->get("start"), $data, 'g') > 0)
				return false;

		if (strlen($this->get("stop")) > 0)
			if (date_sottrazione($this->get("stop"), $data, 'g') < 0)
				return false;

		return true;
	}

	################################################
	# LOADINPUT
	public function loadInput($oggetto, $messaggio, $voce_tipologia=null, $pre="", $post="") {
		$res = true;

		foreach($this->campi() as $chiave => $campo) {
			if ($chiave == $this->m_identity) # non indispensabile, ma per sicurezza...
				continue;
			if ($this->checkCampo($chiave) == false) { # non indispensabile, ma per sicurezza...
				#echo "checkCampo($chiave) = false<br>";
				continue;
			}

			#DEBUG($chiave.'='.$this->tipo($chiave));
			if (array_key_exists($pre.$chiave.$post, $_POST)) {
				switch($this->tipo($chiave)) {
					case "timestamptz":
					case "datetime":
						$valore = getVar("POST", $pre.$chiave.$post, false);
						if (($valore !== false) && (strlen($valore) > 0)) {
							$valore = date_translate($valore, 'it', 'us')." 00:00:00";
						}
						break;

					case "real":
						$valore = getVar("POST", $pre.$chiave.$post, false);
						if (strlen($valore) > 0)
							$valore = write_number($valore, false);
						break;

					default:
						$valore = getVar("POST", $pre.$chiave.$post, false);
						break;
				}
			}
			else
				continue;

			#echo $pre.$chiave.$post."<br>";
			if ($valore === false)
				continue;

			#DEBUG("*** ".$chiave." = |".$valore."|");
			$this->set($chiave, $valore);
		}
		return $res;
	}

	################################################
	# INSERT
	public function check($messaggio=null) {
		$res = parent::check($messaggio);

		if (strlen($this->get("start")) == 0)
			$this->set("start", '1950-01-01'); #$this->set("start", date("Y-m-d"));

		return $res;
	}

	################################################
	# INSERT
	public function insert() {
		GLOBAL $db, $metautente;

		$this->check();

		$tabella = (strlen($this->get("tabella")) > 0) ? $this->get("tabella") : "sys_record";

		$rs = $db->Esegui("SELECT code FROM sys_record WHERE code=".quote_string($this->get("code"), true));
		#---------------------------------------------------------------------------
		if ($rs != FALSE && $rs->RecordCount() > 0) {
			$sql = "UPDATE sys_record set ".
							"  uu=".quote_string($metautente->username, true).
							", tu=getdate() WHERE code=".quote_string($this->get("code"), true);
		}
		#---------------------------------------------------------------------------
		else {
			$sql = "INSERT INTO sys_record (code, tabella, classe, attivo, modificabile, ui, ti, uu, tu, start, stop) VALUES(".
							quote_string($this->get("code"), true).", ".
							quote_string($tabella, true).", ".
							quote_string($this->get("classe"), true).", ".
							"'S', 'S', ".
							quote_string($metautente->username, true).", ".
							"getdate(), ".
							quote_string($metautente->username, true).", ".
							"getdate(), ".
							quote_string($db->Data($this->get("start")), true).", ".
							quote_string($db->Data($this->get("stop")), true).
							")";
		}
		$res = $db->Esegui($sql, true, "SYSRecord::insert()");
		$this->m_last_query = $sql."<br>";
		#DEBUG("SYSRecord::insert() - ".$sql);
		return $res;
	}

	################################################
	# UPDATE
	public function update() {
		GLOBAL $db, $metautente;

		$this->check();

		$sql = "UPDATE sys_record set ".
						"  attivo=".quote_string($this->get("attivo"), true).
						", modificabile=".quote_string($this->get("modificabile"), true).
						", start=".quote_string($db->Data($this->get("start")), true).
						", stop=".quote_string($db->Data($this->get("stop")), true).
						", uu=".quote_string($metautente->username, true).
						", tu=getdate() WHERE code=".quote_string($this->get("code"), true);
		$res = $db->Esegui($sql, true, "SYSRecord::update()");
		$this->m_last_query = $sql."<br>";
		#DEBUG("SYSRecord::update() - ".$sql);
		return $res;
	}

	################################################
	# DISPLAY.
	public function display($tipo="", $pre="", $post="", $readonly=false, $fase=0) {
		GLOBAL $smarty, $db;

		$HTML = new UtilsHtml();
		$HTML->setReadonly($readonly);

		$smarty->assign("HTML", $HTML);
		$smarty->assign("record", $this);
		$smarty->assign("readonly", $readonly);
		$smarty->display("sysrecord.tpl");
	}
}
?>