<?php
#require_once("classes/clsDate.inc.php");

/**
 * questa funzione fa una "sottrazione" tra 'data1' e 'data2' ritornandone la differenza
 * espressa nell'unita' di tempo indicato da 'unita'.
 * Le date DEVONO essere nel formato US.
 *
 * unita = {'a', 'm', 'g', 'H', 'M', 'S'}
 */
function date_sottrazione($data1, $data2=null, $unita='S') {
	$time1 = strtotime($data1);
  if (is_null($data2))
		$time2 = time();
	else
		$time2 = strtotime($data2);
	
	$delta = $time1-$time2;
	
	if (strcmp($unita, 'S') == 0)
		;
	elseif (strcmp($unita, 'M') == 0)
		$delta = $delta / 60;
	elseif (strcmp($unita, 'H') == 0)
		$delta = $delta / 3600;
	elseif (strcmp($unita, 'g') == 0)
		$delta = $delta / 3600 / 24;
	elseif (strcmp($unita, 'm') == 0) {
		$months = date("n", $time1) - date("n", $time2) - 1;
		$years = date("Y", $time1) - date("Y", $time2);

		$mese_from = date("n", $time2);
		$mese_to = date("n", $time1);

		if ($mese_from == 2)
			$durata_mese_from = 28;
		elseif (in_array($mese_to, array(4, 6, 9, 11)))
			$durata_mese_from = 30;
		else
			$durata_mese_from = 31;

		if ($mese_to == 2)
			$durata_mese_to = 28;
		elseif (in_array($mese_to, array(4, 6, 9, 11)))
			$durata_mese_to = 30;
		else
			$durata_mese_to = 31;

		$days_from = $durata_mese_from - date("j", $time2) + 1;
		$days_to = date("j", $time1);

		# divido SEMPRE per 31 i gg rimanenti.
		#$durata_mese = 31;

		$delta = $years * 12 + $months + $days_from / $durata_mese_from + $days_to / $durata_mese_to;
	}
	# MESI CONTABILI
	elseif (strcmp($unita, 'mc') == 0) {
		#$days = date("j", $time1) - date("j", $time2) + 1;
		$months = date("n", $time1) - date("n", $time2) - 1;
		$years = date("Y", $time1) - date("Y", $time2);

		/*$mese_to = date("n", $time2);

		if ($mese_to == 2)
			$durata_mese = 28;
		elseif (in_array($mese_to, array(4, 6, 9, 11)))
			$durata_mese = 30;
		else
			$durata_mese = 31;*/

		$giorno_from = date("j", $time2);
		$mese_from = date("n", $time2);
		$anno_from = date("Y", $time2);
		$bisestile_from = ($anno_from % 4) ? false : true;

		$giorno_to = date("j", $time1);
		$mese_to = date("n", $time1);
		$anno_to = date("Y", $time1);
		$bisestile_to = ($anno_to % 4) ? false : true;

		/*if ($mese_from == 2 && $bisestile_from) {
			$days_i = 29 - $giorno_from + 1;
			if ($days_i == 29)
				$days_i = 30;
		}
		elseif ($mese_from == 2 && !$bisestile_from) {
			$days_i = 28 - $giorno_from + 1;
			if ($days_i == 28)
				$days_i = 30;
		}
		else {
			$days_i = 30 - $giorno_from + 1;
		}*/
		$days_i = 30 - $giorno_from + 1;

		if ($mese_to == 2 && $bisestile_to) {
			$days_f = min(29, $giorno_to);
			if ($days_f == 29)
				$days_f = 30;
		}
		elseif ($mese_to == 2 && !$bisestile_to) {
			$days_f = min(28, $giorno_to);
			if ($days_f == 28)
				$days_f = 30;
		}
		else {
			$days_f = min(30, $giorno_to);
		}
		
		$delta = $years * 12 + $months + ($days_i + $days_f) / 30;
	}
	elseif (strcmp($unita, 'a') == 0)
		$delta = $delta / 3600 / 24 / 365;
	
	return $delta;
}

################################################################################
# check_date_format:
################################################################################
# Parametri:
#   $date - data da controllare nel solo formato.
#   $format - formato data (it: gg/mm/aaaa, us: aaaa-mm-gg).
################################################################################
function check_date_format($date, $format='it') 
{
	$date = substr($date, 0, 10);
	
	// Delimitatori di testo: barre, punti, trattini
	$arr = split('[/.-]', $date);
	if (count($arr) != 3)
		return false;
	
  if ($format == 'it')
		list ($giorno, $mese, $anno) = $arr;
	else
		list ($anno, $mese, $giorno) = $arr;
		
	if (!is_numeric($giorno))
		return false;
	if (!is_numeric($mese))
		return false;
	if (!is_numeric($anno))
		return false;
		
	if ($giorno > 31 || $giorno <= 0 || $mese > 12 || $mese <=0)
		return false;
		
  return true;
}

################################################################################
# check_date:
################################################################################
# Parametri:
#   $date - data da controllare.
#   $format - formato data (it: gg/mm/aaaa, us: aaaa-mm-gg).
################################################################################
function check_date($date, $format='it') {
	if (check_date_format($date, $format) == false)
        return false;
	
    if ($format == 'it')
		list ($giorno, $mese, $anno) = split('[/.-]', $date);
	else
		list ($anno, $mese, $giorno) = split('[/.-]', $date);
		
  return checkdate($mese, $giorno, $anno);
}

################################################################################
# date_translate:
################################################################################
# Parametri: 
# 	$format_input - data nel formato originale.
# 	$format_output - data nel formato da convertire.
################################################################################
function date_translate($date, $format_input='it', $format_output='us') {
	if (strlen($date) == 0)
		return "";
	$date = substr($date, 0, 10);
	
	if (check_date_format($date, $format_output) == true)
		return $date;
	elseif (check_date_format($date, $format_input) == false) {
			return false;
	}
	
	switch ($format_input) {
		case 'it':
			list($g,$m,$a) = split("[/.-]", $date);
			if ($format_output == 'us')
				return $a."-".$m."-".$g;
			break;
			
		case 'us':
		default:
			list($a,$m,$g) = split("[/.-]", $date);
			if ($format_output == 'it')
				return $g."/".$m."/".$a;
			break;
	}
	return false;
}

################################################################################
# date_add:
################################################################################
# Parametri:
# 	$format_input - data nel formato originale.
# 	$format_output - data nel formato da convertire.
################################################################################
function my_date_add($date, $num, $type='g', $format_input='us', $format_output='us') {
	if (strlen($date) == 0)
		return "";
	$date = substr($date, 0, 10);

	if (check_date_format($date, $format_input) == false) {
		return false;
	}

	switch ($format_input) {
		case 'it':
			list($g,$m,$a) = split("[/.-]", $date);
			break;

		case 'us':
		default:
			list($a,$m,$g) = split("[/.-]", $date);
			break;
	}

	$num_g = $num_m = $num_a = 0;
	if ($type == 'g')
		$num_g = $num;
	elseif ($type == 'm')
		$num_m = $num;
	elseif ($type == 'a')
		$num_a = $num;



	$t = mktime(0,0,0, $m + $num_m, $g + $num_g, $a + $num_a);

	if ($format_output == 'us')
		return date("Y-m-d", $t);
	else
		return date("d/m/Y", $t);
}
?>