/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_quirks":has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_16["dj_ie"]=true;_16["dj_ie"+maj(ie)]=true;_16["dj_iequirks"]=has("quirks");}if(ff){_16["dj_ff"+maj(ff)]=true;}_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/lang/utils"],function(_19,_1a,_1b,lin,du){return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_1c,_1d){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_1d);du.updateWithPattern(this.opt,_1d,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_1e,_1f){this.scale=_1e;this.offset=_1f;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,_20){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=lin.buildScaler(min,max,_20,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_20,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_21,_22){var du=_22.getObject("lang.utils",true,_21);var _23={},_24=Object.prototype.toString;var _25=function(o){if(o){switch(_24.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _22.delegate(o);}}return o;};_22.mixin(du,{coerceType:function(_26,_27){switch(typeof _26){case "number":return Number(eval("("+_27+")"));case "string":return String(_27);case "boolean":return Boolean(eval("("+_27+")"));}return eval("("+_27+")");},updateWithObject:function(_28,_29,_2a){if(!_29){return _28;}for(var x in _28){if(x in _29&&!(x in _23)){var t=_28[x];if(t&&typeof t=="object"){du.updateWithObject(t,_29[x],_2a);}else{_28[x]=_2a?du.coerceType(t,_29[x]):_25(_29[x]);}}}return _28;},updateWithPattern:function(_2b,_2c,_2d,_2e){if(!_2c||!_2d){return _2b;}for(var x in _2d){if(x in _2c&&!(x in _23)){_2b[x]=_2e?du.coerceType(_2d[x],_2c[x]):_25(_2c[x]);}}return _2b;},merge:function(_2f,_30){if(_30){var _31=_24.call(_2f),_32=_24.call(_30),t,i,l,m;switch(_32){case "[object Array]":if(_32==_31){t=new Array(Math.max(_2f.length,_30.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_2f[i],_30[i]);}return t;}return _30.slice(0);case "[object Object]":if(_32==_31&&_2f){t=_22.delegate(_2f);for(i in _30){if(i in _2f){l=_2f[i];m=_30[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_22.clone(_30[i]);}}return t;}return _22.clone(_30);}}return _30;}});return du;});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(_33,arr,_34,_35,_36,dc,g,m,df,du,has){var _37=0.2;return _34("dojox.charting.plot2d.Pie",[_35,_36],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_38,_39){this.opt=_33.clone(this.defaultParams);du.updateWithObject(this.opt,_39);du.updateWithPattern(this.opt,_39,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(_3a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _33.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_3b.l-_3b.r)/2,ry=(dim.height-_3b.t-_3b.b)/2,r=Math.min(rx,ry),_3c="font" in this.opt?this.opt.font:t.series.font,_3d,_3e=m._degToRad(this.opt.startAngle),_3f=_3e,_40,_41,_42,_43,_44,run=this.run.data,_45=this.events();this.dyn=[];if("radius" in this.opt){r=this.opt.radius;_44=r-this.opt.labelOffset;}var _46={cx:_3b.l+rx,cy:_3b.t+ry,r:r};if(this.opt.shadow||t.shadow){var _47=this.opt.shadow||t.shadow;var _48=_33.clone(_46);_48.cx+=_47.dx;_48.cy+=_47.dy;s.createCircle(_48).setFill(_47.color).setStroke(_47);}if(s.setFilter&&(this.opt.filter||t.filter)){s.createCircle(_46).setFill(t.series.stroke).setFilter(this.opt.filter||t.filter);}if(typeof run[0]=="number"){_40=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_46).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}}else{_40=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_46).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x,i){if(x<0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}}var _49=df.map(run,function(v,i){var _4a=[this.opt,this.run];if(v!==null&&typeof v!="number"){_4a.push(v);}if(this.opt.styleFunc){_4a.push(this.opt.styleFunc(v));}return t.next("slice",_4a,true);},this);if(this.opt.labels){_3d=_3c?g.normalizedLength(g.splitFontString(_3c).size):0;_43=df.foldl1(df.map(_42,function(_4b,i){var _4c=_49[i].series.font;return g._base._getTextBox(_4b,{font:_4c}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_43,ry-_3d)+this.opt.labelOffset;}_44=r-this.opt.labelOffset;}var _4d=new Array(_41.length);arr.some(_41,function(_4e,i){if(_4e<0){return false;}if(_4e==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],_4f=_49[i],_50,o;if(_4e>=1){_50=this._plotFill(_4f.series.fill,dim,_3b);_50=this._shapeFill(_50,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});_50=this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},_46.r);var _51=s.createCircle(_46).setFill(_50).setStroke(_4f.series.stroke);this.dyn.push({fill:_50,stroke:_4f.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_51,x:i,y:typeof v=="number"?v:v.y,cx:_46.cx,cy:_46.cy,cr:r};this._connectEvents(o);_4d[i]=o;}return false;}var end=_3f+_4e*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _52=end-_3f,x1=_46.cx+r*Math.cos(_3f),y1=_46.cy+r*Math.sin(_3f),x2=_46.cx+r*Math.cos(end),y2=_46.cy+r*Math.sin(end);var _53=m._degToRad(this.opt.fanSize);if(_4f.series.fill&&_4f.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_52>_53){var _54=s.createGroup(),_55=Math.ceil(_52/_53),_56=_52/_55;_50=this._shapeFill(_4f.series.fill,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});for(var j=0;j<_55;++j){var _57=j==0?x1:_46.cx+r*Math.cos(_3f+(j-_37)*_56),_58=j==0?y1:_46.cy+r*Math.sin(_3f+(j-_37)*_56),_59=j==_55-1?x2:_46.cx+r*Math.cos(_3f+(j+1+_37)*_56),_5a=j==_55-1?y2:_46.cy+r*Math.sin(_3f+(j+1+_37)*_56);_54.createPath().moveTo(_46.cx,_46.cy).lineTo(_57,_58).arcTo(r,r,0,_56>Math.PI,true,_59,_5a).lineTo(_46.cx,_46.cy).closePath().setFill(this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},r,_3f+(j+0.5)*_56,_3f+(j+0.5)*_56));}_54.createPath().moveTo(_46.cx,_46.cy).lineTo(x1,y1).arcTo(r,r,0,_52>Math.PI,true,x2,y2).lineTo(_46.cx,_46.cy).closePath().setStroke(_4f.series.stroke);_51=_54;}else{_51=s.createPath().moveTo(_46.cx,_46.cy).lineTo(x1,y1).arcTo(r,r,0,_52>Math.PI,true,x2,y2).lineTo(_46.cx,_46.cy).closePath().setStroke(_4f.series.stroke);_50=_4f.series.fill;if(_50&&_50.type==="radial"){_50=this._shapeFill(_50,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});if(this.opt.radGrad==="linear"){_50=this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},r,_3f,end);}}else{if(_50&&_50.type==="linear"){_50=this._plotFill(_50,dim,_3b);_50=this._shapeFill(_50,_51.getBoundingBox());}}_51.setFill(_50);}this.dyn.push({fill:_50,stroke:_4f.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_51,x:i,y:typeof v=="number"?v:v.y,cx:_46.cx,cy:_46.cy,cr:r};this._connectEvents(o);_4d[i]=o;}_3f=end;return false;},this);if(this.opt.labels){var _5b=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_3f=_3e;arr.some(_41,function(_5c,i){if(_5c<=0){return false;}var _5d=_49[i];if(_5c>=1){this.renderLabel(s,_46.cx,_46.cy+_3d/2,_42[i],_5d,this.opt.labelOffset>0);return true;}var end=_3f+_5c*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}if(this.opt.omitLabels&&end-_3f<0.001){return false;}var _5e=(_3f+end)/2,x=_46.cx+_44*Math.cos(_5e),y=_46.cy+_44*Math.sin(_5e)+_3d/2;this.renderLabel(s,_5b?dim.width-x:x,y,_42[i],_5d,this.opt.labelOffset>0);_3f=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_3f=_3e;var _5f=this.opt.omitLabels;var _60=[];arr.forEach(_41,function(_61,i){var end=_3f+_61*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _62=(_3f+end)/2;_60.push({angle:_62,left:Math.cos(_62)<0,theme:_49[i],index:i,omit:_5f?end-_3f<0.001:false});_3f=end;});var _63=g._base._getTextBox("a",{font:_3c}).h;this._getProperLabelRadius(_60,_63,_46.r*1.1);arr.forEach(_60,function(_64,i){if(!_64.omit){var _65=_46.cx-_46.r*2,_66=_46.cx+_46.r*2,_67=g._base._getTextBox(_42[i],{font:_64.theme.series.font}).w,x=_46.cx+_64.labelR*Math.cos(_64.angle),y=_46.cy+_64.labelR*Math.sin(_64.angle),_68=(_64.left)?(_65+_67):(_66-_67),_69=(_64.left)?_65:_68;var _6a=s.createPath().moveTo(_46.cx+_46.r*Math.cos(_64.angle),_46.cy+_46.r*Math.sin(_64.angle));if(Math.abs(_64.labelR*Math.cos(_64.angle))<_46.r*2-_67){_6a.lineTo(x,y);}_6a.lineTo(_68,y).setStroke(_64.theme.series.labelWiring);this.renderLabel(s,_5b?dim.width-_67-_69:_69,y,_42[i],_64.theme,false,"left");}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_4d[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b);}return this;},_getProperLabelRadius:function(_6b,_6c,_6d){var _6e,_6f,_70=1,_71=1;if(_6b.length==1){_6b[0].labelR=_6d;return;}for(var i=0;i<_6b.length;i++){var _72=Math.abs(Math.sin(_6b[i].angle));if(_6b[i].left){if(_70>=_72){_70=_72;_6e=_6b[i];}}else{if(_71>=_72){_71=_72;_6f=_6b[i];}}}_6e.labelR=_6f.labelR=_6d;this._calculateLabelR(_6e,_6b,_6c);this._calculateLabelR(_6f,_6b,_6c);},_calculateLabelR:function(_73,_74,_75){var i=_73.index,_76=_74.length,_77=_73.labelR,_78;while(!(_74[i%_76].left^_74[(i+1)%_76].left)){if(!_74[(i+1)%_76].omit){_78=(Math.sin(_74[i%_76].angle)*_77+((_74[i%_76].left)?(-_75):_75))/Math.sin(_74[(i+1)%_76].angle);_77=(_78<_73.labelR)?_73.labelR:_78;_74[(i+1)%_76].labelR=_77;}i++;}i=_73.index;var j=(i==0)?_76-1:i-1;while(!(_74[i].left^_74[j].left)){if(!_74[j].omit){_78=(Math.sin(_74[i].angle)*_77+((_74[i].left)?_75:(-_75)))/Math.sin(_74[j].angle);_77=(_78<_73.labelR)?_73.labelR:_78;_74[j].labelR=_77;}i--;j--;i=(i<0)?i+_74.length:i;j=(j<0)?j+_74.length:j;}}});});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_79,has,_7a,win){_7a(function(){if(has("highcontrast")){_79.add(win.body(),"dijit_a11y");}});return has;});},"dojox/charting/action2d/Shake":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_7b,_7c,df,dfe,m,gf){var _7d=3;return _7b("dojox.charting.action2d.Shake",_7c,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_7d,shiftY:_7d},optionalParams:{},constructor:function(_7e,_7f,_80){if(!_80){_80={};}this.shiftX=typeof _80.shiftX=="number"?_80.shiftX:_7d;this.shiftY=typeof _80.shiftY=="number"?_80.shiftY:_7d;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _81=o.run.name,_82=o.index,_83=[],_84;if(_81 in this.anim){_84=this.anim[_81][_82];}else{this.anim[_81]={};}if(_84){_84.action.stop(true);}else{this.anim[_81][_82]=_84={};}var _85={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_83.push(gf.animateTransform(_85));}if(o.oultine){_85.shape=o.outline;_83.push(gf.animateTransform(_85));}if(o.shadow){_85.shape=o.shadow;_83.push(gf.animateTransform(_85));}if(!_83.length){delete this.anim[_81][_82];return;}_84.action=df.combine(_83);if(o.type=="onmouseout"){hub.connect(_84.action,"onEnd",this,function(){if(this.anim[_81]){delete this.anim[_81][_82];}});}_84.action.play();}});});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_86,_87,arr){var df=_87.getObject("lang.functional",true,_86);var _88={};var _89="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _8a=function(s){var _8b=[],_8c=_89.call(s,/\s*->\s*/m);if(_8c.length>1){while(_8c.length){s=_8c.pop();_8b=_8c.pop().split(/\s*,\s*|\s+/m);if(_8c.length){_8c.push("(function("+_8b.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){_8b=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_8b.push("$1");s="$1"+s;}if(r){_8b.push("$2");s=s+"$2";}}else{var _8d=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_8d,function(v){if(!t.hasOwnProperty(v)){_8b.push(v);t[v]=1;}});}}}return {args:_8b,body:s};};var _8e=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_87.mixin(df,{rawLambda:function(s){return _8a(s);},buildLambda:function(s){var l=_8a(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _8e(s);}if(_88.hasOwnProperty(s)){return _88[s];}var l=_8a(s);return _88[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_88={};}});return df;});},"dojox/charting/plot2d/Candlesticks":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_8f,_90,arr,has,_91,_92,dc,df,dfr,du,fx){var _93=dfr.lambda("item.purgeGroup()");return _90("dojox.charting.plot2d.Candlesticks",[_91,_92],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_94,_95){this.opt=_8f.clone(this.defaultParams);du.updateWithObject(this.opt,_95);du.updateWithPattern(this.opt,_95,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_96){var _97=_8f.delegate(dc.defaultStats);for(var i=0;i<_96.length;i++){var run=_96[i];if(!run.data.length){continue;}var _98=_97.vmin,_99=_97.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_97.hmin=Math.min(_97.hmin,x);_97.hmax=Math.max(_97.hmax,x);_97.vmin=Math.min(_97.vmin,val.open,val.close,val.high,val.low);_97.vmax=Math.max(_97.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_97.vmin=Math.min(_98,run.ymin);}if("ymax" in run){_97.vmax=Math.max(_99,run.ymax);}}return _97;},getSeriesStats:function(){var _9a=this.collectStats(this.series);_9a.hmin-=0.5;_9a.hmax+=0.5;return _9a;},render:function(dim,_9b){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_9b);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_93);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_9c){_9c.cleanGroup(s);});}var t=this.chart.theme,f,gap,_9d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_9e=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_9d=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();s=run.group;var _9f=t.next("candlestick",[this.opt,run]),_a0=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _a1=t.addMixin(_9f,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_9b.l+gap,y=dim.height-_9b.b,_a2=vt(v.open),_a3=vt(v.close),_a4=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_a4){var tmp=_a4;_a4=low;low=tmp;}if(_9d>=1){var _a5=_a2>_a3;var _a6={x1:_9d/2,x2:_9d/2,y1:y-_a4,y2:y-low},_a7={x:0,y:y-Math.max(_a2,_a3),width:_9d,height:Math.max(_a5?_a2-_a3:_a3-_a2,1)};var _a8=s.createGroup();_a8.setTransform({dx:x,dy:0});var _a9=_a8.createGroup();_a9.createLine(_a6).setStroke(_a1.series.stroke);_a9.createRect(_a7).setStroke(_a1.series.stroke).setFill(_a5?_a1.series.fill:"white");if("mid" in v){_a9.createLine({x1:(_a1.series.stroke.width||1),x2:_9d-(_a1.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_a5?"white":_a1.series.stroke);}run.dyn.fill=_a1.series.fill;run.dyn.stroke=_a1.series.stroke;if(_9e){var o={element:"candlestick",index:j,run:run,shape:_a9,x:x,y:y-Math.max(_a2,_a3),cx:_9d/2,cy:(y-Math.max(_a2,_a3))+(Math.max(_a5?_a2-_a3:_a3-_a2,1)/2),width:_9d,height:Math.max(_a5?_a2-_a3:_a3-_a2,1),data:v};this._connectEvents(o);_a0[j]=o;}}if(this.animate){this._animateCandlesticks(_a8,y-low,_a4-low);}}}this._eventSeries[run.name]=_a0;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_9b);}return this;},tooltipFunc:function(o){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";},_animateCandlesticks:function(_aa,_ab,_ac){fx.animateTransform(_8f.delegate({shape:_aa,duration:1200,transform:[{name:"translate",start:[0,_ab-(_ab/_ac)],end:[0,0]},{name:"scale",start:[1,1/_ac],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(_ad,_ae,df){_ad.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/scaler/primitive":function(){define(["dojo/_base/lang"],function(_af){var _b0=_af.getObject("dojox.charting.scaler.primitive",true);return _af.mixin(_b0,{buildScaler:function(min,max,_b1,_b2){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_b1/(max-min),span:_b1},scaler:_b0};},buildTicks:function(_b3,_b4){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_b5){var _b6=_b5.bounds.from,_b7=_b5.bounds.scale;return function(x){return (x-_b6)*_b7;};},getTransformerFromPlot:function(_b8){var _b9=_b8.bounds.from,_ba=_b8.bounds.scale;return function(x){return x/_ba+_b9;};}});});},"dojox/charting/widget/Sparkline":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_bb,_bc,_bd,_be,_bf,_c0,_c1){_bc("dojox.charting.widget.Sparkline",_be,{theme:_bf,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_bd("> .axis, > .plot, > .action, > .series",n).length){var _c2=document.createElement("div");_c1.set(_c2,{"class":"plot","name":"default","type":this.type});n.appendChild(_c2);var _c3=document.createElement("div");_c1.set(_c3,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_bb.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_c1.set(_c3,i,this[i]);}},this);n.appendChild(_c3);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,_c4){var m=g.matrix={};var _c5={};m._degToRad=function(_c6){return _c5[_c6]||(_c5[_c6]=(Math.PI*_c6/180));};m._radToDeg=function(_c7){return _c7/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _c8=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_c8,r=m.normalize(arg[i]);_c8=new m.Matrix2D();_c8.xx=l.xx*r.xx+l.xy*r.yx;_c8.xy=l.xx*r.xy+l.xy*r.yy;_c8.yx=l.yx*r.xx+l.yy*r.yx;_c8.yy=l.yx*r.xy+l.yy*r.yy;_c8.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_c8.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_c4.mixin(this,_c8);}}else{_c4.mixin(this,arg);}}}};_c4.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_c4.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_c9){var c=Math.cos(_c9);var s=Math.sin(_c9);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_ca){return m.rotate(m._degToRad(_ca));},skewX:function(_cb){return new m.Matrix2D({xy:Math.tan(_cb)});},skewXg:function(_cc){return m.skewX(m._degToRad(_cc));},skewY:function(_cd){return new m.Matrix2D({yx:Math.tan(_cd)});},skewYg:function(_ce){return m.skewY(m._degToRad(_ce));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_cf){return (_cf instanceof m.Matrix2D)?_cf:new m.Matrix2D(_cf);},isIdentity:function(_d0){return _d0.xx==1&&_d0.xy==0&&_d0.yx==0&&_d0.yy==1&&_d0.dx==0&&_d0.dy==0;},clone:function(_d1){var obj=new m.Matrix2D();for(var i in _d1){if(typeof (_d1[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_d1[i]){obj[i]=_d1[i];}}return obj;},invert:function(_d2){var M=m.normalize(_d2),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_d3,x,y){return {x:_d3.xx*x+_d3.xy*y+_d3.dx,y:_d3.yx*x+_d3.yy*y+_d3.dy};},multiplyPoint:function(_d4,a,b){var M=m.normalize(_d4);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_d5,_d6){var M=m.normalize(_d5);_d6=_d6||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:_d6.x,y:_d6.y,width:_d6.width,height:_d6.height};}var p0=m.multiplyPoint(M,_d6.x,_d6.y),p1=m.multiplyPoint(M,_d6.x,_d6.y+_d6.height),p2=m.multiplyPoint(M,_d6.x+_d6.width,_d6.y),p3=m.multiplyPoint(M,_d6.x+_d6.width,_d6.y+_d6.height),_d7=Math.min(p0.x,p1.x,p2.x,p3.x),_d8=Math.min(p0.y,p1.y,p2.y,p3.y),_d9=Math.max(p0.x,p1.x,p2.x,p3.x),_da=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:_d7,y:_d8,width:_d9-_d7,height:_da-_d8};},multiply:function(_db){var M=m.normalize(_db);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_dc,x,y){return m.multiply(m.translate(x,y),_dc,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_dd,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_dd),a,b);}return m._sandwich(m.rotate(_dd),a.x,a.y);},rotategAt:function(_de,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_de),a,b);}return m._sandwich(m.rotateg(_de),a.x,a.y);},skewXAt:function(_df,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_df),a,b);}return m._sandwich(m.skewX(_df),a.x,a.y);},skewXgAt:function(_e0,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_e0),a,b);}return m._sandwich(m.skewXg(_e0),a.x,a.y);},skewYAt:function(_e1,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_e1),a,b);}return m._sandwich(m.skewY(_e1),a.x,a.y);},skewYgAt:function(_e2,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_e2),a,b);}return m._sandwich(m.skewYg(_e2),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/plot2d/Scatter":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(_e3,arr,_e4,has,_e5,_e6,dc,df,dfr,du,fx,_e7){var _e8=dfr.lambda("item.purgeGroup()");return _e4("dojox.charting.plot2d.Scatter",[_e5,_e6],{defaultParams:{shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",styleFunc:null},constructor:function(_e9,_ea){this.opt=_e3.clone(_e3.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_ea);du.updateWithPattern(this.opt,_ea,this.optionalParams);this.animate=this.opt.animate;},render:function(dim,_eb){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_eb);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_e8);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_ec){_ec.cleanGroup(s);});}var t=this.chart.theme,_ed=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _ee=t.next("marker",[this.opt,run]),_ef,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);s=run.group;if(typeof run.data[0]=="number"){_ef=arr.map(run.data,function(v,i){return {x:ht(i+1)+_eb.l,y:dim.height-_eb.b-vt(v)};},this);}else{_ef=arr.map(run.data,function(v,i){return {x:ht(v.x)+_eb.l,y:dim.height-_eb.b-vt(v.y)};},this);}var _f0=new Array(_ef.length),_f1=new Array(_ef.length),_f2=new Array(_ef.length);arr.forEach(_ef,function(c,i){var _f3=run.data[i],_f4;if(this.opt.styleFunc||typeof _f3!="number"){var _f5=typeof _f3!="number"?[_f3]:[];if(this.opt.styleFunc){_f5.push(this.opt.styleFunc(_f3));}_f4=t.addMixin(_ee,"marker",_f5,true);}else{_f4=t.post(_ee,"marker");}var _f6="M"+c.x+" "+c.y+" "+_f4.symbol;if(_f4.marker.shadow){_f0[i]=s.createPath("M"+(c.x+_f4.marker.shadow.dx)+" "+(c.y+_f4.marker.shadow.dy)+" "+_f4.symbol).setStroke(_f4.marker.shadow).setFill(_f4.marker.shadow.color);if(this.animate){this._animateScatter(_f0[i],dim.height-_eb.b);}}if(_f4.marker.outline){var _f7=dc.makeStroke(_f4.marker.outline);_f7.width=2*_f7.width+_f4.marker.stroke.width;_f2[i]=s.createPath(_f6).setStroke(_f7);if(this.animate){this._animateScatter(_f2[i],dim.height-_eb.b);}}var _f8=dc.makeStroke(_f4.marker.stroke),_f9=this._plotFill(_f4.marker.fill,dim,_eb);if(_f9&&(_f9.type==="linear"||_f9.type=="radial")){var _fa=_e7.getColor(_f9,{x:c.x,y:c.y});if(_f8){_f8.color=_fa;}_f1[i]=s.createPath(_f6).setStroke(_f8).setFill(_fa);}else{_f1[i]=s.createPath(_f6).setStroke(_f8).setFill(_f9);}if(this.opt.labels){var _fb=_f1[i].getBoundingBox();this.createLabel(s,_f3,_fb,_f4);}if(this.animate){this._animateScatter(_f1[i],dim.height-_eb.b);}},this);if(_f1.length){run.dyn.marker=_ee.symbol;run.dyn.markerStroke=_f1[_f1.length-1].getStroke();run.dyn.markerFill=_f1[_f1.length-1].getFill();}if(_ed){var _fc=new Array(_f1.length);arr.forEach(_f1,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_f2&&_f2[i]||null,shadow:_f0&&_f0[i]||null,cx:_ef[i].x,cy:_ef[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_fc[i]=o;},this);this._eventSeries[run.name]=_fc;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_eb);}return this;},_animateScatter:function(_fd,_fe){fx.animateTransform(_e3.delegate({shape:_fd,duration:1200,transform:[{name:"translate",start:[0,_fe],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/scan":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_ff,lang,df){var _100={};lang.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _100)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var t,n,z,_101=true;if(lang.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _100)){if(_101){t=[z=a[i]];_101=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_102,on,_103,has,_104){var _105=new _102();var _106;_103(function(){var _107=_104.getBox();_105._rlh=on(window,"resize",function(){var _108=_104.getBox();if(_107.h==_108.h&&_107.w==_108.w){return;}_107=_108;_105.emit("resize");});if(has("ie")==8){var _109=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_109){_109=screen.deviceXDPI;_105.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_106=evt.target;});on(document,"focusout",function(evt){_106=null;});}});_105.getEffectiveBox=function(doc){var box=_104.getBox(doc);var tag=_106&&_106.tagName&&_106.tagName.toLowerCase();if(has("ios")&&_106&&!_106.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_106.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_106.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _105;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_10a,lang,_10b,_10c){var cx=lang.getObject("color",true,_10a);cx.Color=_10b;cx.blend=_10b.blendColors;cx.fromRgb=_10b.fromRgb;cx.fromHex=_10b.fromHex;cx.fromArray=_10b.fromArray;cx.fromString=_10b.fromString;cx.greyscale=_10c.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_10d,_10e){if(lang.isArray(cyan)){_10d=cyan[1],_10e=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10d=cyan.m,_10e=cyan.y,cyan=cyan.c;}}cyan/=100,_10d/=100,_10e/=100;var r=1-cyan,g=1-_10d,b=1-_10e;return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_10f,_110,_111){if(lang.isArray(cyan)){_10f=cyan[1],_110=cyan[2],_111=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10f=cyan.m,_110=cyan.y,_111=cyan.b,cyan=cyan.c;}}cyan/=100,_10f/=100,_110/=100,_111/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_111)+_111);g=1-Math.min(1,_10f*(1-_111)+_111);b=1-Math.min(1,_110*(1-_111)+_111);return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_112,_113){if(lang.isArray(hue)){_112=hue[1],_113=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_112=hue.s,_113=hue.l,hue=hue.h;}}_112/=100;_113/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_112*Math.min(r,1)+(1-_112);g=2*_112*Math.min(g,1)+(1-_112);b=2*_112*Math.min(b,1)+(1-_112);if(_113<0.5){r*=_113,g*=_113,b*=_113;}else{r=(1-_113)*r+2*_113-1;g=(1-_113)*g+2*_113-1;b=(1-_113)*b+2*_113-1;}return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_114,_115){if(lang.isArray(hue)){_114=hue[1],_115=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_114=hue.s,_115=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_114/=100;_115/=100;var r,g,b;if(_114==0){r=_115,b=_115,g=_115;}else{var _116=hue/60,i=Math.floor(_116),f=_116-i;var p=_115*(1-_114);var q=_115*(1-(_114*f));var t=_115*(1-(_114*(1-f)));switch(i){case 0:r=_115,g=t,b=p;break;case 1:r=q,g=_115,b=p;break;case 2:r=p,g=_115,b=t;break;case 3:r=p,g=q,b=_115;break;case 4:r=t,g=p,b=_115;break;case 5:r=_115,g=p,b=q;break;}}return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_10b,{toCmy:function(){var cyan=1-(this.r/255),_117=1-(this.g/255),_118=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_117*100),y:Math.round(_118*100)};},toCmyk:function(){var cyan,_119,_11a,_11b;var r=this.r/255,g=this.g/255,b=this.b/255;_11b=Math.min(1-r,1-g,1-b);cyan=(1-r-_11b)/(1-_11b);_119=(1-g-_11b)/(1-_11b);_11a=(1-b-_11b)/(1-_11b);return {c:Math.round(cyan*100),m:Math.round(_119*100),y:Math.round(_11a*100),b:Math.round(_11b*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11c=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_11c/((l<0.5)?(2*l):(2-2*l));}if(_11c>0){if(max==r&&max!=g){h+=(g-b)/_11c;}if(max==g&&max!=b){h+=(2+(b-r)/_11c);}if(max==b&&max!=r){h+=(4+(r-g)/_11c);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11d=max-min;var h=null,s=(max==0)?0:(_11d/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_11d;}else{if(g==max){h=120+60*(b-r)/_11d;}else{h=240+60*(r-g)/_11d;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_11e,has,_11f,_120,dc,df,dfr,du,fx){var _121=dfr.lambda("item.purgeGroup()");return _11e("dojox.charting.plot2d.OHLC",[_11f,_120],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_122,_123){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_123);du.updateWithPattern(this.opt,_123,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_124){var _125=lang.delegate(dc.defaultStats);for(var i=0;i<_124.length;i++){var run=_124[i];if(!run.data.length){continue;}var _126=_125.vmin,_127=_125.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_125.hmin=Math.min(_125.hmin,x);_125.hmax=Math.max(_125.hmax,x);_125.vmin=Math.min(_125.vmin,val.open,val.close,val.high,val.low);_125.vmax=Math.max(_125.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_125.vmin=Math.min(_126,run.ymin);}if("ymax" in run){_125.vmax=Math.max(_127,run.ymax);}}return _125;},getSeriesStats:function(){var _128=this.collectStats(this.series);_128.hmin-=0.5;_128.hmax+=0.5;return _128;},render:function(dim,_129){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_129);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_121);this._eventSeries={};this.cleanGroup();var s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_12a,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_12b=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_12a=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _12c=t.next("candlestick",[this.opt,run]),s=run.group,_12d=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _12e=t.addMixin(_12c,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_129.l+gap,y=dim.height-_129.b,open=vt(v.open),_12f=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_12a>=1){var hl={x1:_12a/2,x2:_12a/2,y1:y-high,y2:y-low},op={x1:0,x2:((_12a/2)+((_12e.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_12a/2)-((_12e.series.stroke.width||1)/2)),x2:_12a,y1:y-_12f,y2:y-_12f};var _130=s.createGroup();_130.setTransform({dx:x,dy:0});var _131=_130.createGroup();_131.createLine(hl).setStroke(_12e.series.stroke);_131.createLine(op).setStroke(_12e.series.stroke);_131.createLine(cl).setStroke(_12e.series.stroke);run.dyn.stroke=_12e.series.stroke;if(_12b){var o={element:"candlestick",index:j,run:run,shape:_131,x:x,y:y-Math.max(open,_12f),cx:_12a/2,cy:(y-Math.max(open,_12f))+(Math.max(open>_12f?open-_12f:_12f-open,1)/2),width:_12a,height:Math.max(open>_12f?open-_12f:_12f-open,1),data:v};this._connectEvents(o);_12d[j]=o;}}if(this.animate){this._animateOHLC(_130,y-low,high-low);}}}this._eventSeries[run.name]=_12d;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_129);}return this;},_animateOHLC:function(_132,_133,_134){fx.animateTransform(lang.delegate({shape:_132,duration:1200,transform:[{name:"translate",start:[0,_133-(_133/_134)],end:[0,0]},{name:"scale",start:[1,1/_134],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_135,on,_136){function _137(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _138;on(document,"keydown",function(e){if(_137(e)){_138=e.target;e.preventDefault();}else{_138=null;}});on(document,"keyup",function(e){if(_137(e)&&e.target==_138){_138=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _139=function(node,_13a){node.dojoClick=true;return on(node,"click",_13a);};_139.click=_139;_139.press=function(node,_13b){var _13c=on(node,_136.press,function(evt){if(evt.type=="mousedown"&&!_135.isLeft(evt)){return;}_13b(evt);}),_13d=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13b(evt);}});return {remove:function(){_13c.remove();_13d.remove();}};};_139.release=function(node,_13e){var _13f=on(node,_136.release,function(evt){if(evt.type=="mouseup"&&!_135.isLeft(evt)){return;}_13e(evt);}),_140=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13e(evt);}});return {remove:function(){_13f.remove();_140.remove();}};};_139.move=_136.move;return _139;});},"dojox/charting/plot2d/ClusteredColumns":function(){define(["dojo/_base/declare","./Columns","./common"],function(_141,_142,dc){return _141("dojox.charting.plot2d.ClusteredColumns",_142,{getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,width:f.size,thickness:f.size};}});});},"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_143,lang,arr,_144,_145,dom,_146,_147,_148,has,_149,_14a,_14b,_14c,_14d,g,_14e,func){var dc=lang.getObject("charting",true,_143),_14f=func.lambda("item.clear()"),_150=func.lambda("item.purgeGroup()"),_151=func.lambda("item.destroy()"),_152=func.lambda("item.dirty = false"),_153=func.lambda("item.dirty = true"),_154=func.lambda("item.name");var _155=_144(has("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(node,_156){if(!_156){_156={};}this.margins=_156.margins?_156.margins:{l:10,t:10,r:10,b:10};this.stroke=_156.stroke;this.fill=_156.fill;this.delayInMs=_156.delayInMs||200;this.title=_156.title;this.titleGap=_156.titleGap;this.titlePos=_156.titlePos;this.titleFont=_156.titleFont;this.titleFontColor=_156.titleFontColor;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _156){this.htmlLabels=_156.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=dom.byId(node);var box=_146.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){arr.forEach(this.series,_151);arr.forEach(this.stack,_151);func.forIn(this.axes,_151);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_147.destroy(this.chartTitle);}},getCoords:function(){var node=this.node;var s=_145.getComputedStyle(node),_157=_146.getMarginBox(node,s);var abs=_146.position(node,true);_157.x=abs.x;_157.y=abs.y;return _157;},setTheme:function(_158){this.theme=_158.clone();this.dirty=true;return this;},addAxis:function(name,_159){var axis,_15a=_159&&_159.type||"Default";if(typeof _15a=="string"){if(!dc.axis2d||!dc.axis2d[_15a]){throw Error("Can't find axis: "+_15a+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_15a](this,_159);}else{axis=new _15a(this,_159);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_15b){var plot,_15c=_15b&&_15b.type||"Default";if(typeof _15c=="string"){if(!dc.plot2d||!dc.plot2d[_15c]){throw Error("Can't find plot: "+_15c+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_15c](this,_15b);}else{plot=new _15c(this,_15b);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _15d=this.plots[name];delete this.plots[name];this.stack[_15d].destroy();this.stack.splice(_15d,1);func.forIn(this.plots,function(idx,name,_15e){if(idx>_15d){_15e[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_15f){this.runs[run.plot]=_15f;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_154);},setPlotOrder:function(_160){var _161={},_162=func.filter(_160,function(name){if(!(name in this.plots)||(name in _161)){return false;}_161[name]=1;return true;},this);if(_162.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _161)){_162.push(name);}});}var _163=func.map(_162,function(name){return this.stack[this.plots[name]];},this);func.forEach(_163,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_163;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _164=this.plots[name];if(_164){var _165=this.getPlotOrder();_165.splice(_164,1);_165.unshift(name);return this.setPlotOrder(_165);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _166=this.plots[name];if(_166<this.stack.length-1){var _167=this.getPlotOrder();_167.splice(_166,1);_167.push(name);return this.setPlotOrder(_167);}}return this;},addSeries:function(name,data,_168){var run=new _14b(this,data,_168);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _169=this.runs[name];delete this.runs[name];this.series[_169].destroy();this.series.splice(_169,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_169){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data,_16a){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);if(_16a){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_16b){return func.map(func.filter(this.series,function(run){return run.plot==_16b;}),_154);},setSeriesOrder:function(_16c){var _16d,_16e={},_16f=func.filter(_16c,function(name){if(!(name in this.runs)||(name in _16e)){return false;}var run=this.series[this.runs[name]];if(_16d){if(run.plot!=_16d){return false;}}else{_16d=run.plot;}_16e[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _16e)&&run.plot==_16d){_16f.push(name);}});var _170=func.map(_16f,function(name){return this.series[this.runs[name]];},this);this.series=_170.concat(func.filter(this.series,function(run){return run.plot!=_16d;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _171=this.runs[name],_172=this.getSeriesOrder(this.series[_171].plot);if(name!=_172[0]){_172.splice(_171,1);_172.unshift(name);return this.setSeriesOrder(_172);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _173=this.runs[name],_174=this.getSeriesOrder(this.series[_173].plot);if(name!=_174[_174.length-1]){_174.splice(_173,1);_174.push(name);return this.setSeriesOrder(_174);}}return this;},resize:function(_175,_176){switch(arguments.length){case 1:_146.setMarginBox(this.node,_175);break;case 2:_146.setMarginBox(this.node,{w:_175,h:_176});break;}var box=_146.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_177,_178,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_177,_178);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _179,_17a,_17b=axis.getScaler().bounds,s=_17b.span/(_17b.upper-_17b.lower);if(axis.vertical){_179=sy;_17a=dy/s/_179;}else{_179=sx;_17a=dx/s/_179;}axis.setWindow(_179,_17a);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_17c,_17d){var axis=this.axes[name];if(axis){var _17e,_17f,_180=axis.getScaler().bounds;var _181=Math.min(_17c[0],_17c[1]);var _182=Math.max(_17c[0],_17c[1]);_181=_17c[0]<_180.lower?_180.lower:_181;_182=_17c[1]>_180.upper?_180.upper:_182;_17e=(_180.upper-_180.lower)/(_182-_181);_17f=_181-_180.lower;this.setAxisWindow(name,_17e,_17f);if(_17d){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _183=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_184(_183,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_14f);if(!this.theme){this.setTheme(new _14a());}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.assignAxes){plot.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_14f);_184(this.stack,dim);var _185=this.offsets={l:0,r:0,t:0,b:0};var self=this;func.forIn(this.axes,function(axis){if(has("dojo-bidi")){self._resetLeftBottom(axis);}func.forIn(axis.getOffsets(),function(o,i){_185[i]=Math.max(o,_185[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _186=g.normalizedLength(g.splitFontString(this.titleFont).size);_185[this.titlePos=="top"?"t":"b"]+=(_186+this.titleGap);}func.forIn(this.margins,function(o,i){_185[i]+=o;});this.plotArea={width:dim.width-_185.l-_185.r,height:dim.height-_185.t-_185.b};func.forIn(this.axes,_14f);_184(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _187=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_187.l-_187.r),h=Math.max(0,dim.height-_187.t-_187.b);arr.forEach(this.series,_150);func.forIn(this.axes,_150);arr.forEach(this.stack,_150);var _188=this.surface.children;if(_14d.dispose){for(var i=0;i<_188.length;++i){_14d.dispose(_188[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_147.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_187);if(this._nativeClip){this._renderPlotBackground(dim,_187,w,h);}else{this._renderPlotBackground(dim,_187,w,h);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_187),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_187);}if(this.title){var _189=(g.renderer=="canvas")&&this.htmlLabels,_18a=_189||!has("ie")&&!has("opera")&&this.htmlLabels?"html":"gfx",_18b=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_14c.createText[_18a](this,this.surface,dim.width/2,this.titlePos=="top"?_18b+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_187);});this._makeClean();return this;},_renderChartBackground:function(dim,_18c){var t=this.theme,rect;var fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _18d=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node;fill=new _148(_145.get(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _148(_145.get(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(this._nativeClip){fill=_149.prototype._shapeFill(_149.prototype._plotFill(fill,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(fill);}else{fill=_149.prototype._plotFill(fill,dim,_18c);if(_18c.l){rect={x:0,y:0,width:_18c.l,height:dim.height+1};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.r){rect={x:dim.width-_18c.r,y:0,width:_18c.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.t){rect={x:0,y:0,width:dim.width+1,height:_18c.t};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.b){rect={x:0,y:dim.height-_18c.b,width:dim.width+1,height:_18c.b+2};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}}}if(_18d){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_18d);}},_renderPlotBackground:function(dim,_18e,w,h){var t=this.theme;var fill=t.plotarea&&t.plotarea.fill;var _18f=t.plotarea&&t.plotarea.stroke;var rect={x:_18e.l-1,y:_18e.t-1,width:w+2,height:h+2};if(fill){fill=_149.prototype._shapeFill(_149.prototype._plotFill(fill,dim,_18e),rect);this.surface.createRect(rect).setFill(fill);}if(_18f){this.surface.createRect({x:_18e.l,y:_18e.t,width:w+1,height:h+1}).setStroke(_18f);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_190,_191){return name in this.plots?this.stack[this.plots[name]].connect(_190,_191):null;},fireEvent:function(_192,_193,_194){if(_192 in this.runs){var _195=this.series[this.runs[_192]].plot;if(_195 in this.plots){var plot=this.stack[this.plots[_195]];if(plot){plot.fireEvent(_192,_193,_194);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_152);arr.forEach(this.stack,_152);arr.forEach(this.series,_152);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_153);arr.forEach(this.stack,_153);arr.forEach(this.series,_153);this.dirty=true;},_invalidateDependentPlots:function(_196,_197){if(_196 in this.plots){var plot=this.stack[this.plots[_196]],axis,_198=_197?"vAxis":"hAxis";if(plot[_198]){axis=this.axes[plot[_198]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_198]&&p[_198]==plot[_198]){p.dirty=true;}});}}else{plot.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(axis){},formatTruncatedLabel:function(_199,_19a,_19b){}});function _19c(_19d){return {min:_19d.hmin,max:_19d.hmax};};function _19e(_19f){return {min:_19f.vmin,max:_19f.vmax};};function _1a0(_1a1,h){_1a1.hmin=h.min;_1a1.hmax=h.max;};function _1a2(_1a3,v){_1a3.vmin=v.min;_1a3.vmax=v.max;};function _1a4(_1a5,_1a6){if(_1a5&&_1a6){_1a5.min=Math.min(_1a5.min,_1a6.min);_1a5.max=Math.max(_1a5.max,_1a6.max);}return _1a5||_1a6;};function _184(_1a7,_1a8){var _1a9={},axes={};arr.forEach(_1a7,function(plot){var _1aa=_1a9[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1a4(axes[plot.hAxis],_19c(_1aa));}if(plot.vAxis){axes[plot.vAxis]=_1a4(axes[plot.vAxis],_19e(_1aa));}});arr.forEach(_1a7,function(plot){var _1ab=_1a9[plot.name];if(plot.hAxis){_1a0(_1ab,axes[plot.hAxis]);}if(plot.vAxis){_1a2(_1ab,axes[plot.vAxis]);}plot.initializeScalers(_1a8,_1ab);});};return has("dojo-bidi")?_144("dojox.charting.Chart",[_155,_14e]):_155;});},"dojox/charting/plot2d/MarkersOnly":function(){define(["dojo/_base/declare","./Default"],function(_1ac,_1ad){return _1ac("dojox.charting.plot2d.MarkersOnly",_1ad,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define(["dojo/_base/declare","./Default"],function(_1ae,_1af){return _1ae("dojox.charting.plot2d.Areas",_1af,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_1b0,_1b1){return _1b0("dojox.charting.action2d.Base",_1b1,{constructor:function(_1b2,plot){this.chart=_1b2;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1b3,dojo,_1b4,_1b5,_1b6,dom,_1b7,geom,_1b8,_1b9){if(!dojo.isAsync){_1b8(0,function(){var _1ba=["./fx/Toggler"];_1b9(_1ba);});}var _1bb=dojo.fx={};var _1bc={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1bd=function(_1be){this._index=-1;this._animations=_1be||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1b4.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1bd.prototype=new _1b3();lang.extend(_1bd,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1b5.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_1b5.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_1bf,_1c0){if(!this._current){this._current=this._animations[this._index=0];}if(!_1c0&&this._current.status()=="playing"){return this;}var _1c1=_1b5.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_1c2=_1b5.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_1c3=_1b5.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_1c1.remove();_1c2.remove();_1c3.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_1b5.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_1b5.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1b5.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_1c4,_1c5){this.pause();var _1c6=this.duration*_1c4;this._current=null;_1b4.some(this._animations,function(a){if(a.duration<=_1c6){this._current=a;return true;}_1c6-=a.duration;return false;});if(this._current){this._current.gotoPercent(_1c6/this._current.duration,_1c5);}return this;},stop:function(_1c7){if(this._current){if(_1c7){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1b5.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_1bd,_1bc);_1bb.chain=function(_1c8){return new _1bd(_1c8);};var _1c9=function(_1ca){this._animations=_1ca||[];this._connects=[];this._finished=0;this.duration=0;_1b4.forEach(_1ca,function(a){var _1cb=a.duration;if(a.delay){_1cb+=a.delay;}if(this.duration<_1cb){this.duration=_1cb;}this._connects.push(_1b5.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _1b6.Animation({curve:[0,1],duration:this.duration});var self=this;_1b4.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1b5.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_1c9,{_doAction:function(_1cc,args){_1b4.forEach(this._animations,function(a){a[_1cc].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1cd,args){var t=this._pseudoAnimation;t[_1cd].apply(t,args);},play:function(_1ce,_1cf){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1d0,_1d1){var ms=this.duration*_1d0;_1b4.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1d1);});this._call("gotoPercent",arguments);return this;},stop:function(_1d2){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_1b4.forEach(this._connects,function(_1d3){_1d3.remove();});}});lang.extend(_1c9,_1bc);_1bb.combine=function(_1d4){return new _1c9(_1d4);};_1bb.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b6.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1d5=_1b7.get(node,"height");return Math.max(_1d5,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1b5.after(anim,"onStop",fini,true);_1b5.after(anim,"onEnd",fini,true);return anim;};_1bb.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b6.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1b5.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1b5.after(anim,"onStop",fini,true);_1b5.after(anim,"onEnd",fini,true);return anim;};_1bb.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1b7.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1b6.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1b5.after(anim,"beforeBegin",init,true);return anim;};return _1bb;});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_1d6,Base,dfe,df){var _1d7=400,_1d8=dfe.backOut;return _1d6("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_1d9,plot,_1da){this.anim={};if(!_1da){_1da={};}this.duration=_1da.duration?_1da.duration:_1d7;this.easing=_1da.easing?_1da.easing:_1d8;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/plot2d/commonStacked":function(){define(["dojo/_base/lang","./common"],function(lang,_1db){var _1dc=lang.getObject("dojox.charting.plot2d.commonStacked",true);return lang.mixin(_1dc,{collectStats:function(_1dd){var _1de=lang.delegate(_1db.defaultStats);for(var i=0;i<_1dd.length;++i){var run=_1dd[i];for(var j=0;j<run.data.length;j++){var x,y;if(run.data[j]!==null){if(typeof run.data[j]=="number"||!run.data[j].hasOwnProperty("x")){y=_1dc.getIndexValue(_1dd,i,j)[0];x=j+1;}else{x=run.data[j].x;if(x!==null){y=_1dc.getValue(_1dd,i,x)[0];y=y!=null&&y.y?y.y:null;}}_1de.hmin=Math.min(_1de.hmin,x);_1de.hmax=Math.max(_1de.hmax,x);_1de.vmin=Math.min(_1de.vmin,y);_1de.vmax=Math.max(_1de.vmax,y);}}}return _1de;},getIndexValue:function(_1df,i,_1e0){var _1e1=0,v,j,_1e2;for(j=0;j<=i;++j){_1e2=_1e1;v=_1df[j].data[_1e0];if(v!=null){if(isNaN(v)){v=v.y||0;}_1e1+=v;}}return [_1e1,_1e2];},getValue:function(_1e3,i,x){var _1e4=null,j,z,v,_1e5;for(j=0;j<=i;++j){for(z=0;z<_1e3[j].data.length;z++){_1e5=_1e4;v=_1e3[j].data[z];if(v!==null){if(v.x==x){if(!_1e4){_1e4={x:x};}if(v.y!=null){if(_1e4.y==null){_1e4.y=0;}_1e4.y+=v.y;}break;}else{if(v.x>x){break;}}}}}return [_1e4,_1e5];}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_1e6,arr,fx,Hub,has){var fxg=g.fx={};function _1e7(_1e8,end){this.start=_1e8,this.end=end;};_1e7.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1e9(_1ea,end,_1eb){this.start=_1ea,this.end=end;this.units=_1eb;};_1e9.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1ec(_1ed,end){this.start=_1ed,this.end=end;this.temp=new _1e6();};_1ec.prototype.getValue=function(r){return _1e6.blendColors(this.start,this.end,r,this.temp);};function _1ee(_1ef){this.values=_1ef;this.length=_1ef.length;};_1ee.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1f0(_1f1,def){this.values=_1f1;this.def=def?def:{};};_1f0.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1f2(_1f3,_1f4){this.stack=_1f3;this.original=_1f4;};_1f2.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _1f5=new m.Matrix2D();for(var p in t.start){_1f5[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_1f5);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1f6=f.apply(m,val);if(_1f6 instanceof m.Matrix2D){ret.push(_1f6);}},this);return ret;};var _1f7=new _1e6(0,0,0,0);function _1f8(prop,obj,name,def){if(prop.values){return new _1ee(prop.values);}var _1f9,_1fa,end;if(prop.start){_1fa=g.normalizeColor(prop.start);}else{_1fa=_1f9=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1f9){_1f9=obj?(name?obj[name]:obj):def;}end=_1f9;}return new _1ec(_1fa,end);};function _1fb(prop,obj,name,def){if(prop.values){return new _1ee(prop.values);}var _1fc,_1fd,end;if(prop.start){_1fd=prop.start;}else{_1fd=_1fc=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _1fc!="number"){_1fc=obj?obj[name]:def;}end=_1fc;}return new _1e7(_1fd,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_1fe=args.shape,_1ff;Hub.connect(anim,"beforeBegin",anim,function(){_1ff=_1fe.getStroke();var prop=args.color,_200={},_201,_202,end;if(prop){_200.color=_1f8(prop,_1ff,"color",_1f7);}prop=args.style;if(prop&&prop.values){_200.style=new _1ee(prop.values);}prop=args.width;if(prop){_200.width=_1fb(prop,_1ff,"width",1);}prop=args.cap;if(prop&&prop.values){_200.cap=new _1ee(prop.values);}prop=args.join;if(prop){if(prop.values){_200.join=new _1ee(prop.values);}else{_202=prop.start?prop.start:(_1ff&&_1ff.join||0);end=prop.end?prop.end:(_1ff&&_1ff.join||0);if(typeof _202=="number"&&typeof end=="number"){_200.join=new _1e7(_202,end);}}}this.curve=new _1f0(_200,_1ff);});Hub.connect(anim,"onAnimate",_1fe,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_203=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_203.getFill();var prop=args.color,_204={};if(prop){this.curve=_1f8(prop,fill,"",_1f7);}});Hub.connect(anim,"onAnimate",_203,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_205=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_205.getFont();var prop=args.style,_206={},_207,_208,end;if(prop&&prop.values){_206.style=new _1ee(prop.values);}prop=args.variant;if(prop&&prop.values){_206.variant=new _1ee(prop.values);}prop=args.weight;if(prop&&prop.values){_206.weight=new _1ee(prop.values);}prop=args.family;if(prop&&prop.values){_206.family=new _1ee(prop.values);}prop=args.size;if(prop&&prop.units){_208=parseFloat(prop.start?prop.start:(_205.font&&_205.font.size||"0"));end=parseFloat(prop.end?prop.end:(_205.font&&_205.font.size||"0"));_206.size=new _1e9(_208,end,prop.units);}this.curve=new _1f0(_206,font);});Hub.connect(anim,"onAnimate",_205,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_209=args.shape,_20a;Hub.connect(anim,"beforeBegin",anim,function(){_20a=_209.getTransform();this.curve=new _1f2(args.transform,_20a);});Hub.connect(anim,"onAnimate",_209,"setTransform");if(g.renderer==="svg"&&has("ie")>=10){var _20b=[Hub.connect(anim,"onBegin",anim,function(){var _20c=_209.getParent();while(_20c&&_20c.getParent){_20c=_20c.getParent();}if(_20c){_209.__svgContainer=_20c.rawNode.parentNode;}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_209.__svgContainer){var ov=_209.__svgContainer.style.visibility;_209.__svgContainer.style.visibility="visible";var _20d=_209.__svgContainer.offsetHeight;_209.__svgContainer.style.visibility=ov;}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_20b,Hub.disconnect);if(_209.__svgContainer){var ov=_209.__svgContainer.style.visibility;var sn=_209.__svgContainer;_209.__svgContainer.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn=null;}catch(e){}},100);}delete _209.__svgContainer;})];}return anim;};return fxg;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_20e,_20f,_210,_211,_212,lang,on,has){has.add("config-bgIframe",!has("touch"));var _213=new function(){var _214=[];this.pop=function(){var _215;if(_214.length){_215=_214.pop();_215.style.display="";}else{if(has("ie")<9){var burl=_210["dojoBlankHtmlUrl"]||_20e.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_215=document.createElement(html);}else{_215=_211.create("iframe");_215.src="javascript:\"\"";_215.className="dijitBackgroundIframe";_215.setAttribute("role","presentation");_212.set(_215,"opacity",0.1);}_215.tabIndex=-1;}return _215;};this.push=function(_216){_216.style.display="none";_214.push(_216);};}();_20f.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _217=(this.iframe=_213.pop());node.appendChild(_217);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_212.set(_217,{width:"100%",height:"100%"});}}};lang.extend(_20f.BackgroundIframe,{resize:function(node){if(this.iframe){_212.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_213.push(this.iframe);delete this.iframe;}}});return _20f.BackgroundIframe;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_218,_219,m,gf,df,dfe){var _21a=2;return _218("dojox.charting.action2d.Magnify",_219,{defaultParams:{duration:400,easing:dfe.backOut,scale:_21a},optionalParams:{},constructor:function(_21b,plot,_21c){this.scale=_21c&&typeof _21c.scale=="number"?_21c.scale:_21a;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}if(o.element=="spider_plot"||o.element=="spider_poly"){return;}var _21d=o.run.name,_21e=o.index,_21f=[],anim,init,_220;if(_21d in this.anim){anim=this.anim[_21d][_21e];}else{this.anim[_21d]={};}if(anim){anim.action.stop(true);}else{this.anim[_21d][_21e]=anim={};}if(o.type=="onmouseover"){init=m.identity;_220=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_220=1/this.scale;}var _221={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_220,o.cx,o.cy]},init]};if(o.shape){_21f.push(gf.animateTransform(_221));}if(o.outline){_221.shape=o.outline;_21f.push(gf.animateTransform(_221));}if(o.shadow){_221.shape=o.shadow;_21f.push(gf.animateTransform(_221));}if(!_21f.length){delete this.anim[_21d][_21e];return;}anim.action=df.combine(_21f);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_21d]){delete this.anim[_21d][_21e];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_222,lang,_223,when){return _222("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_224){if(_224){this.set(_224);}},_get:function(name,_225){return typeof this[_225.g]==="function"?this[_225.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_226){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _227=this._getAttrNames(name),_228=this._get(name,_227),_229=this[_227.s],_22a;if(typeof _229==="function"){_22a=_229.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_226;}if(this._watchCallbacks){var self=this;when(_22a,function(){self._watchCallbacks(name,_228,_226);});}return this;},_changeAttrValue:function(name,_22b){var _22c=this.get(name);this[name]=_22b;if(this._watchCallbacks){this._watchCallbacks(name,_22c,_22b);}return this;},watch:function(name,_22d){var _22e=this._watchCallbacks;if(!_22e){var self=this;_22e=this._watchCallbacks=function(name,_22f,_230,_231){var _232=function(_233){if(_233){_233=_233.slice();for(var i=0,l=_233.length;i<l;i++){_233[i].call(self,name,_22f,_230);}}};_232(_22e["_"+name]);if(!_231){_232(_22e["*"]);}};}if(!_22d&&typeof name==="function"){_22d=name;name="*";}else{name="_"+name;}var _234=_22e[name];if(typeof _234!=="object"){_234=_22e[name]=[];}_234.push(_22d);var _235={};_235.unwatch=_235.remove=function(){var _236=_223.indexOf(_234,_22d);if(_236>-1){_234.splice(_236,1);}};return _235;}});});},"dojox/charting/plot2d/Markers":function(){define(["dojo/_base/declare","./Default"],function(_237,_238){return _237("dojox.charting.plot2d.Markers",_238,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_239,arr,has,_23a,_23b,dc,df,dfr,du,fx){var _23c=dfr.lambda("item.purgeGroup()");return _239("dojox.charting.plot2d.Bubble",[_23a,_23b],{defaultParams:{animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelFunc:null},constructor:function(_23d,_23e){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_23e);du.updateWithPattern(this.opt,_23e,this.optionalParams);if(!this.opt.labelFunc){this.opt.labelFunc=function(_23f,_240,_241){return this._getLabel(_23f.size,_240,_241);};}this.animate=this.opt.animate;},render:function(dim,_242){var s;if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_242);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_23c);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_243=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}s=run.group;var _244=t.next("circle",[this.opt,run]),_245=arr.map(run.data,function(v){return v?{x:ht(v.x)+_242.l,y:dim.height-_242.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _246=null,_247=null,_248=null,_249=this.opt.styleFunc;var _24a=function(item){if(_249){return t.addMixin(_244,"circle",[item,_249(item)],true);}return t.addMixin(_244,"circle",item,true);};if(_244.series.shadow){_248=arr.map(_245,function(item,i){if(item!==null){var _24b=_24a(run.data[i]),_24c=_24b.series.shadow;var _24d=s.createCircle({cx:item.x+_24c.dx,cy:item.y+_24c.dy,r:item.radius}).setStroke(_24c).setFill(_24c.color);if(this.animate){this._animateBubble(_24d,dim.height-_242.b,item.radius);}return _24d;}return null;},this);if(_248.length){run.dyn.shadow=_248[_248.length-1].getStroke();}}if(_244.series.outline){_247=arr.map(_245,function(item,i){if(item!==null){var _24e=_24a(run.data[i]),_24f=dc.makeStroke(_24e.series.outline);_24f.width=2*_24f.width+_244.series.stroke.width;var _250=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_24f);if(this.animate){this._animateBubble(_250,dim.height-_242.b,item.radius);}return _250;}return null;},this);if(_247.length){run.dyn.outline=_247[_247.length-1].getStroke();}}_246=arr.map(_245,function(item,i){if(item!==null){var _251=_24a(run.data[i]),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _252=this._plotFill(_251.series.fill,dim,_242);_252=this._shapeFill(_252,rect);var _253=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_252).setStroke(_251.series.stroke);if(_253.setFilter&&_251.series.filter){_253.setFilter(_251.series.filter);}if(this.animate){this._animateBubble(_253,dim.height-_242.b,item.radius);}this.createLabel(s,run.data[i],rect,_251);return _253;}return null;},this);if(_246.length){run.dyn.fill=_246[_246.length-1].getFill();run.dyn.stroke=_246[_246.length-1].getStroke();}if(_243){var _254=new Array(_246.length);arr.forEach(_246,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_247&&_247[i]||null,shadow:_248&&_248[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_245[i].x,cy:_245[i].y,cr:_245[i].radius};this._connectEvents(o);_254[i]=o;}},this);this._eventSeries[run.name]=_254;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_242);}return this;},_animateBubble:function(_255,_256,size){fx.animateTransform(lang.delegate({shape:_255,duration:1200,transform:[{name:"translate",start:[0,_256],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_257,dom,_258,lang,on,has,_259,_25a,win){var _25b=has("touch");var ios4=has("ios")<5;var _25c=navigator.pointerEnabled||navigator.msPointerEnabled,_25d=(function(){var _25e={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_25e[type]=!navigator.pointerEnabled?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _25e;})();var _25f,_260,_261,_262,_263,_264,_265,_266;var _267;function _268(_269,_26a,_26b){if(_25c&&_26b){return function(node,_26c){return on(node,_26b,_26c);};}else{if(_25b){return function(node,_26d){var _26e=on(node,_26a,_26d),_26f=on(node,_269,function(evt){if(!_267||(new Date()).getTime()>_267+1000){_26d.call(this,evt);}});return {remove:function(){_26e.remove();_26f.remove();}};};}else{return function(node,_270){return on(node,_269,_270);};}}};function _271(node){do{if(node.dojoClick!==undefined){return node.dojoClick;}}while(node=node.parentNode);};function _272(e,_273,_274){_260=!e.target.disabled&&_271(e.target);if(_260){_261=e.target;_262=e.touches?e.touches[0].pageX:e.clientX;_263=e.touches?e.touches[0].pageY:e.clientY;_264=(typeof _260=="object"?_260.x:(typeof _260=="number"?_260:0))||4;_265=(typeof _260=="object"?_260.y:(typeof _260=="number"?_260:0))||4;if(!_25f){_25f=true;win.doc.addEventListener(_273,function(e){_260=_260&&e.target==_261&&Math.abs((e.touches?e.touches[0].pageX:e.clientX)-_262)<=_264&&Math.abs((e.touches?e.touches[0].pageY:e.clientY)-_263)<=_265;},true);win.doc.addEventListener(_274,function(e){if(_260){_266=(new Date()).getTime();var _275=e.target;if(_275.tagName==="LABEL"){_275=dom.byId(_275.getAttribute("for"))||_275;}setTimeout(function(){on.emit(_275,"click",{bubbles:true,cancelable:true,_dojo_click:true});});}},true);function _276(type){win.doc.addEventListener(type,function(e){if(!e._dojo_click&&(new Date()).getTime()<=_266+1000&&!(e.target.tagName=="INPUT"&&_258.contains(e.target,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(e.target.tagName!="INPUT"||e.target.type=="radio"||e.target.type=="checkbox")&&e.target.tagName!="TEXTAREA"&&e.target.tagName!="AUDIO"&&e.target.tagName!="VIDEO"){e.preventDefault();}}},true);};_276("click");_276("mousedown");_276("mouseup");}}};var _277;if(_25b){if(_25c){_25a(function(){win.doc.addEventListener(_25d.down,function(evt){_272(evt,_25d.move,_25d.up);},true);});}else{_25a(function(){_277=win.body();win.doc.addEventListener("touchstart",function(evt){_267=(new Date()).getTime();var _278=_277;_277=evt.target;on.emit(_278,"dojotouchout",{relatedTarget:_277,bubbles:true});on.emit(_277,"dojotouchover",{relatedTarget:_278,bubbles:true});_272(evt,"touchmove","touchend");},true);function _279(evt){var _27a=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_27a.touches=evt.touches;_27a.altKey=evt.altKey;_27a.changedTouches=evt.changedTouches;_27a.ctrlKey=evt.ctrlKey;_27a.metaKey=evt.metaKey;_27a.shiftKey=evt.shiftKey;_27a.targetTouches=evt.targetTouches;}return _27a;};on(win.doc,"touchmove",function(evt){_267=(new Date()).getTime();var _27b=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_27b){if(_277!==_27b){on.emit(_277,"dojotouchout",{relatedTarget:_27b,bubbles:true});on.emit(_27b,"dojotouchover",{relatedTarget:_277,bubbles:true});_277=_27b;}if(!on.emit(_27b,"dojotouchmove",_279(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_267=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_279(evt));});});}}var _27c={press:_268("mousedown","touchstart",_25d.down),move:_268("mousemove","dojotouchmove",_25d.move),release:_268("mouseup","dojotouchend",_25d.up),cancel:_268(_259.leave,"touchcancel",_25b?_25d.cancel:null),over:_268("mouseover","dojotouchover",_25d.over),out:_268("mouseout","dojotouchout",_25d.out),enter:_259._eventHandler(_268("mouseover","dojotouchover",_25d.over)),leave:_259._eventHandler(_268("mouseout","dojotouchout",_25d.out))};1&&(dojo.touch=_27c);return _27c;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_27d){var _27e=g.gradutils={};function _27f(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _27d.blendColors(new _27d(prev.color),new _27d(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_27e.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _280=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_281=m.rotate(-_280),_282=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_282,pt),pf1=m.multiplyPoint(_282,fill.x1,fill.y1),pf2=m.multiplyPoint(_282,fill.x2,fill.y2),_283=m.multiplyPoint(_281,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_281,p.x-pf1.x,p.y-pf1.y).x/_283;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _27f(o,fill.colors);}return new _27d(fill||[0,0,0,0]);};_27e.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _27e;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_284,_285,_286,_287,has,_288,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_285.blankGif||_284.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_287.getComputedStyle(div),_289=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_289&&(_289=="none"||_289=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_288(function(){if(has("highcontrast")){_286.add(win.body(),"dj_a11y");}});return has;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_28a,lang){var _28b={};lang.setObject("dojo.string",_28b);_28b.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_28b.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_28b.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_28b.substitute=function(_28c,map,_28d,_28e){_28e=_28e||_28a.global;_28d=_28d?lang.hitch(_28e,_28d):function(v){return v;};return _28c.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_28f,key,_290){var _291=lang.getObject(key,false,map);if(_290){_291=lang.getObject(_290,false,_28e).call(_28e,_291,key);}return _28d(_291,key).toString();});};_28b.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _28b;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_292,_293,_294,_295,lang,_296,on,_297,_298){var _299=lang.delegate(_297,{"mouseenter":_296.enter,"mouseleave":_296.leave,"keypress":_294._keypress});var _29a;var _29b=_295("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_29c){var node=_29c;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_29c){return;}while(!node.nextSibling){node=node.parentNode;if(node==_29c){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_29d,_29e,_29f){var ret=true;var _2a0=this.attachScope||this,_2a1=_29e(_29d,"dojoAttachPoint")||_29e(_29d,"data-dojo-attach-point");if(_2a1){var _2a2,_2a3=_2a1.split(/\s*,\s*/);while((_2a2=_2a3.shift())){if(lang.isArray(_2a0[_2a2])){_2a0[_2a2].push(_29d);}else{_2a0[_2a2]=_29d;}ret=(_2a2!="containerNode");this._attachPoints.push(_2a2);}}var _2a4=_29e(_29d,"dojoAttachEvent")||_29e(_29d,"data-dojo-attach-event");if(_2a4){var _2a5,_2a6=_2a4.split(/\s*,\s*/);var trim=lang.trim;while((_2a5=_2a6.shift())){if(_2a5){var _2a7=null;if(_2a5.indexOf(":")!=-1){var _2a8=_2a5.split(":");_2a5=trim(_2a8[0]);_2a7=trim(_2a8[1]);}else{_2a5=trim(_2a5);}if(!_2a7){_2a7=_2a5;}this._attachEvents.push(_29f(_29d,_2a5,lang.hitch(_2a0,_2a7)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_29a||(_29a=_292("./a11yclick"));}else{type=_299[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _2a9=this.attachScope||this;_293.forEach(this._attachPoints,function(_2aa){delete _2a9[_2aa];});this._attachPoints=[];_293.forEach(this._attachEvents,function(_2ab){_2ab.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_298,{dojoAttachEvent:"",dojoAttachPoint:""});return _29b;});},"dojox/charting/plot2d/Lines":function(){define(["dojo/_base/declare","./Default"],function(_2ac,_2ad){return _2ac("dojox.charting.plot2d.Lines",_2ad,{constructor:function(){this.opt.lines=true;}});});},"dijit/registry":function(){define(["dojo/_base/array","dojo/sniff","dojo/_base/window","./main"],function(_2ae,has,win,_2af){var _2b0={},hash={};var _2b1={length:0,add:function(_2b2){if(hash[_2b2.id]){throw new Error("Tried to register widget with id=="+_2b2.id+" but that id is already registered");}hash[_2b2.id]=_2b2;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_2b3){var id;do{id=_2b3+"_"+(_2b3 in _2b0?++_2b0[_2b3]:_2b0[_2b3]=0);}while(hash[id]);return _2af._scopeName=="dijit"?id:_2af._scopeName+"_"+id;},findWidgets:function(root,_2b4){var _2b5=[];function _2b6(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _2b7=node.getAttribute("widgetId");if(_2b7){var _2b8=hash[_2b7];if(_2b8){_2b5.push(_2b8);}}else{if(node!==_2b4){_2b6(node);}}}}};_2b6(root);return _2b5;},_destroyAll:function(){_2af._curFocus=null;_2af._prevFocus=null;_2af._activeStack=[];_2ae.forEach(_2b1.findWidgets(win.body()),function(_2b9){if(!_2b9._destroyed){if(_2b9.destroyRecursive){_2b9.destroyRecursive();}else{if(_2b9.destroy){_2b9.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_2af.registry=_2b1;return _2b1;});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_2ba,_2bb,_2bc){return _2bc("dijit.Destroyable",null,{destroy:function(_2bd){this._destroyed=true;},own:function(){_2ba.forEach(arguments,function(_2be){var _2bf="destroyRecursive" in _2be?"destroyRecursive":"destroy" in _2be?"destroy":"remove";var odh=_2bb.before(this,"destroy",function(_2c0){_2be[_2bf](_2c0);});var hdh=_2bb.after(_2be,_2bf,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dojox/charting/plot2d/StackedAreas":function(){define(["dojo/_base/declare","./Stacked"],function(_2c1,_2c2){return _2c1("dojox.charting.plot2d.StackedAreas",_2c2,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_2c3,_2c4,lang,_2c5,_2c6){var _2c7={};_2c3.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_2c7[name]=_2c5[name];});lang.mixin(_2c7,{defaultDuration:_2c4["defaultDuration"]||200});lang.mixin(_2c6,_2c7);return _2c6;});},"dojox/charting/plot2d/Stacked":function(){define(["dojo/_base/declare","./Default","./commonStacked"],function(_2c8,_2c9,_2ca){return _2c8("dojox.charting.plot2d.Stacked",_2c9,{getSeriesStats:function(){var _2cb=_2ca.collectStats(this.series);return _2cb;},buildSegments:function(i,_2cc){var run=this.series[i],min=_2cc?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_2cc?Math.min(run.data.length-1,Math.ceil(this._hScaler.bounds.to)):run.data.length-1,rseg=null,_2cd=[];for(var j=min;j<=max;j++){var _2ce=_2cc?_2ca.getIndexValue(this.series,i,j):_2ca.getValue(this.series,i,run.data[j]?run.data[j].x:null);if(_2ce[0]!=null&&(_2cc||_2ce[0].y!=null)){if(!rseg){rseg=[];_2cd.push({index:j,rseg:rseg});}rseg.push(_2ce[0]);}else{if(!this.opt.interpolate||_2cc){rseg=null;}}}return _2cd;}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _2cf={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_2cf.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _2cf.bounceIn(n*2)/2;}return (_2cf.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_2cf);return _2cf;});},"dojox/charting/action2d/Highlight":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(lang,_2d0,_2d1,hub,c,_2d2,dfe,dgf){var _2d3=100,_2d4=75,_2d5=50,cc=function(_2d6){return function(){return _2d6;};},hl=function(_2d7){var a=new c.Color(_2d7),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_2d3;if(x.l<_2d5){x.l=_2d4;}else{if(x.l>_2d4){x.l=_2d5;}else{x.l=x.l-_2d5>_2d4-x.l?_2d5:_2d4;}}}var _2d8=c.fromHsl(x);_2d8.a=a.a;return _2d8;},_2d9=function(_2da){var r=hl(_2da);r.a=0.7;return r;};return _2d0("dojox.charting.action2d.Highlight",_2d2,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_2db,plot,_2dc){var a=_2dc&&_2dc.highlight;this.colorFunc=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}if(o.element=="spider_circle"||o.element=="spider_plot"){return;}else{if(o.element=="spider_poly"&&this.colorFunc==hl){this.colorFunc=_2d9;}}var _2dd=o.run.name,_2de=o.index,anim;if(_2dd in this.anim){anim=this.anim[_2dd][_2de];}else{this.anim[_2dd]={};}if(anim){anim.action.stop(true);}else{var _2df=o.shape.getFill();if(!_2df||!(_2df instanceof _2d1)){return;}this.anim[_2dd][_2de]=anim={start:_2df,end:this.colorFunc(_2df)};}var _2e0=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_2e0;_2e0=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_2e0,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_2dd]){delete this.anim[_2dd][_2de];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define(["dojo/_base/declare","../Element"],function(_2e1,_2e2){return _2e1("dojox.charting.axis2d.Base",_2e2,{constructor:function(_2e3,_2e4){this.vertical=_2e4&&_2e4.vertical;this.opt={};this.opt.min=_2e4&&_2e4.min;this.opt.max=_2e4&&_2e4.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_2e5){this.dirty=false;return this;}});});},"dojox/charting/plot2d/Grid":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/sniff","./CartesianBase","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2e6,arr,has,_2e7,dc,du,fx){var _2e8=function(a,b){return a.value-b.value;};return _2e6("dojox.charting.plot2d.Grid",_2e7,{defaultParams:{hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:false,vStripes:false,animate:null,enableCache:false,renderOnAxis:true},optionalParams:{majorHLine:{},minorHLine:{},majorVLine:{},minorVLine:{},hFill:{},vFill:{},hAlternateFill:{},vAlternateFill:{}},constructor:function(_2e9,_2ea){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2ea);du.updateWithPattern(this.opt,_2ea,this.optionalParams);this.animate=this.opt.animate;if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];this._rectFreePool=[];this._rectUsePool=[];}},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._rectFreePool=this._rectFreePool.concat(this._rectUsePool);this._rectUsePool=[];}},createLine:function(_2eb,_2ec){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2ec);_2eb.add(line);}else{line=_2eb.createLine(_2ec);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},createRect:function(_2ed,_2ee){var rect;if(this.opt.enableCache&&this._rectFreePool.length>0){rect=this._rectFreePool.pop();rect.setShape(_2ee);_2ed.add(rect);}else{rect=_2ed.createRect(_2ee);}if(this.opt.enableCache){this._rectUsePool.push(rect);}return rect;},render:function(dim,_2ef){if(this.zoom){return this.performZoom(dim,_2ef);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.getGroup(),ta=this.chart.theme,_2f0,_2f1;if((has("ios")&&has("ios")<6)||has("android")||(has("safari")&&!has("ios"))){var w=Math.max(0,dim.width-_2ef.l-_2ef.r),h=Math.max(0,dim.height-_2ef.t-_2ef.b);s.createRect({x:_2ef.l,y:_2ef.t,width:w,height:h});}if(this._vAxis){_2f1=this._vAxis.getTicks();var _2f2=this._vAxis.getScaler();if(_2f1!=null&&_2f2!=null){var vt=_2f2.scaler.getTransformerFromModel(_2f2);if(this.opt.hStripes){this._renderHRect(_2f1,ta.grid,dim,_2ef,_2f2,vt);}if(this.opt.hMinorLines){_2f0=this.opt.minorHLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderHLines(_2f1.minor,_2f0,dim,_2ef,_2f2,vt);}if(this.opt.hMajorLines){_2f0=this.opt.majorHLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderHLines(_2f1.major,_2f0,dim,_2ef,_2f2,vt);}}}if(this._hAxis){_2f1=this._hAxis.getTicks();var _2f3=this._hAxis.getScaler();if(_2f1!=null&&_2f3!=null){var ht=_2f3.scaler.getTransformerFromModel(_2f3);if(this.opt.vStripes){this._renderVRect(_2f1,ta.grid,dim,_2ef,_2f3,ht);}if(_2f1&&this.opt.vMinorLines){_2f0=this.opt.minorVLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderVLines(_2f1.minor,_2f0,dim,_2ef,_2f3,ht);}if(_2f1&&this.opt.vMajorLines){_2f0=this.opt.majorVLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderVLines(_2f1.major,_2f0,dim,_2ef,_2f3,ht);}}}this.dirty=false;return this;},_renderHLines:function(_2f4,_2f5,dim,_2f6,_2f7,vt){var s=this.getGroup();arr.forEach(_2f4,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._vAxis.opt.leftBottom?_2f7.bounds.from:_2f7.bounds.to)){return;}var y=dim.height-_2f6.b-vt(tick.value);var _2f8=this.createLine(s,{x1:_2f6.l,y1:y,x2:dim.width-_2f6.r,y2:y}).setStroke(_2f5);if(this.animate){this._animateGrid(_2f8,"h",_2f6.l,_2f6.r+_2f6.l-dim.width);}},this);},_renderVLines:function(_2f9,_2fa,dim,_2fb,_2fc,ht){var s=this.getGroup();arr.forEach(_2f9,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._hAxis.opt.leftBottom?_2fc.bounds.from:_2fc.bounds.to)){return;}var x=_2fb.l+ht(tick.value);var _2fd=this.createLine(s,{x1:x,y1:_2fb.t,x2:x,y2:dim.height-_2fb.b}).setStroke(_2fa);if(this.animate){this._animateGrid(_2fd,"v",dim.height-_2fb.b,dim.height-_2fb.b-_2fb.t);}},this);},_renderHRect:function(_2fe,_2ff,dim,_300,_301,vt){var fill,tick,y,y2,_302;var _303=_2fe.major.concat(_2fe.minor);_303.sort(_2e8);if(_303[0].value>_301.bounds.from){_303.splice(0,0,{value:_301.bounds.from});}if(_303[_303.length-1].value<_301.bounds.to){_303.push({value:_301.bounds.to});}var s=this.getGroup();for(var j=0;j<_303.length-1;j++){tick=_303[j];y=dim.height-_300.b-vt(tick.value);y2=dim.height-_300.b-vt(_303[j+1].value);fill=(j%2==0)?(this.opt.hAlternateFill||(_2ff&&_2ff.alternateFill)):(this.opt.hFill||(_2ff&&_2ff.fill));if(fill){_302=this.createRect(s,{x:_300.l,y:y,width:dim.width-_300.r,height:y-y2}).setFill(fill);if(this.animate){this._animateGrid(_302,"h",_300.l,_300.r+_300.l-dim.width);}}}},_renderVRect:function(_304,_305,dim,_306,_307,ht){var fill,tick,x,x2,_308;var _309=_304.major.concat(_304.minor);_309.sort(_2e8);if(_309[0].value>_307.bounds.from){_309.splice(0,0,{value:_307.bounds.from});}if(_309[_309.length-1].value<_307.bounds.to){_309.push({value:_307.bounds.to});}var s=this.getGroup();for(var j=0;j<_309.length-1;j++){tick=_309[j];x=_306.l+ht(tick.value);x2=_306.l+ht(_309[j+1].value);fill=(j%2==0)?(this.opt.vAlternateFill||(_305&&_305.alternateFill)):(this.opt.vFill||(_305&&_305.fill));if(fill){_308=this.createRect(s,{x:x,y:_306.t,width:x2-x,height:dim.width-_306.r}).setFill(fill);if(this.animate){this._animateGrid(_308,"v",dim.height-_306.b,dim.height-_306.b-_306.t);}}}},_animateGrid:function(_30a,type,_30b,size){var _30c=type=="h"?[_30b,0]:[0,_30b];var _30d=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_30a,duration:1200,transform:[{name:"translate",start:_30c,end:[0,0]},{name:"scale",start:_30d,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_30e,dom,_30f,_310,lang,has,_311){var _312;var a11y={_isElementShown:function(elem){var s=_310.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_30f.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _30f.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _313=elem.contentDocument;if("designMode" in _313&&_313.designMode=="on"){return true;}body=_313.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_30f.get(elem,"disabled")){return _312;}else{if(_30f.has(elem,"tabIndex")){return +_30f.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_312;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _314,last,_315,_316,_317,_318,_319={};function _31a(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _31b=a11y._isElementShown,_31c=a11y.effectiveTabIndex;var _31d=function(_31e){for(var _31f=_31e.firstChild;_31f;_31f=_31f.nextSibling){if(_31f.nodeType!=1||(has("ie")<=9&&_31f.scopeName!=="HTML")||!_31b(_31f)){continue;}var _320=_31c(_31f);if(_320>=0){if(_320==0){if(!_314){_314=_31f;}last=_31f;}else{if(_320>0){if(!_315||_320<_316){_316=_320;_315=_31f;}if(!_317||_320>=_318){_318=_320;_317=_31f;}}}var rn=_31a(_31f);if(_30f.get(_31f,"checked")&&rn){_319[rn]=_31f;}}if(_31f.nodeName.toUpperCase()!="SELECT"){_31d(_31f);}}};if(_31b(root)){_31d(root);}function rs(node){return _319[_31a(node)]||node;};return {first:rs(_314),last:rs(last),lowest:rs(_315),highest:rs(_317)};},getFirstInTabbingOrder:function(root,doc){var _321=a11y._getTabNavigable(dom.byId(root,doc));return _321.lowest?_321.lowest:_321.first;},getLastInTabbingOrder:function(root,doc){var _322=a11y._getTabNavigable(dom.byId(root,doc));return _322.last?_322.last:_322.highest;}};1&&lang.mixin(_311,a11y);return a11y;});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_323,df){var _324={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_323.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _324)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_323.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _325=true;for(i in a){if(!(i in _324)){if(_325){z=a[i];_325=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_323.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_323.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_323.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/charting/plot2d/Spider":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/sniff","./Base","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_326,hub,arr,_327,_328,_329,has,Base,_32a,dc,da,g,m,_32b,df,du,_32c){var _32d=0.2;var _32e=_326("dojox.charting.plot2d.Spider",[Base,_32a],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_32c.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_32f,_330){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_330);du.updateWithPattern(this.opt,_330,this.optionalParams);this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.inherited(arguments);this.dyn=[];this.axes=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){if(axis){if(axis.opt.min!=undefined){this.datas[axis.name].min=axis.opt.min;}if(axis.opt.max!=undefined){this.datas[axis.name].max=axis.opt.max;}}return this;},addSeries:function(run){this.series.push(run);var key;for(key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{var _331="__"+key;this.axes.push(_331);this[_331]=key;this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},render:function(dim,_332){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_332.l-_332.r)/2,ry=(dim.height-_332.t-_332.b)/2,r=Math.min(rx,ry),_333=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_334=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_335=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_336=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_337=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_338=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_339=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_33a=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_33b=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_33c=g.normalizedLength(g.splitFontString(_334).size),_33d=m._degToRad(o.startAngle),_33e=_33d,_33f,_340,_341,_342,_343,_344,_345,_346,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_347=o.labelOffset<-10?o.labelOffset:-10,_348=0.2,i,j,_349,len,_34a,_34b,_34c,run,data,min,max,_34d;if(o.labels){_33f=arr.map(this.series,function(s){return s.name;},this);_340=df.foldl1(df.map(_33f,function(_34e){var font=t.series.font;return g._base._getTextBox(_34e,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_340,ry-_33c)+_347;_341=r-_347;}if("radius" in o){r=o.radius;_341=r-_347;}r/=(1+_348);var _34f={cx:_332.l+rx,cy:_332.t+ry,r:r};for(i=this.series.length-1;i>=0;i--){_34c=this.series[i];if(!this.dirty&&!_34c.dirty){t.skip();continue;}_34c.cleanGroup();run=_34c.data;if(run!==null){len=this._getObjectLength(run);if(!_342||_342.length<=0){_342=[],_343=[],_346=[];this._buildPoints(_342,len,_34f,r,_33e,true,dim);this._buildPoints(_343,len,_34f,r*ro,_33e,true,dim);this._buildPoints(_346,len,_34f,_341,_33e,false,dim);if(dv>2){_344=[],_345=[];for(j=0;j<dv-2;j++){_344[j]=[];this._buildPoints(_344[j],len,_34f,r*(ro+(1-ro)*(j+1)/(dv-1)),_33e,true,dim);_345[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _350=s.createGroup(),_351={color:_337,width:_339},_352={color:_338,width:_33a};for(j=_342.length-1;j>=0;--j){_349=_342[j];var st={x:_349.x+(_349.x-_34f.cx)*_348,y:_349.y+(_349.y-_34f.cy)*_348},nd={x:_349.x+(_349.x-_34f.cx)*_348/2,y:_349.y+(_349.y-_34f.cy)*_348/2};_350.createLine({x1:_34f.cx,y1:_34f.cy,x2:st.x,y2:st.y}).setStroke(_351);this._drawArrow(_350,st,nd,_351);}var _353=s.createGroup();for(j=_346.length-1;j>=0;--j){_349=_346[j];_34a=g._base._getTextBox(this.labelKey[j],{font:_334}).w||0;_34b=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";var elem=da.createText[_34b](this.chart,_353,(!_327.isBodyLtr()&&_34b=="html")?(_349.x+_34a-dim.width):_349.x,_349.y,"middle",this.labelKey[j],_334,_336);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _354=s.createGroup();if(spt=="polygon"){_354.createPolyline(_342).setStroke(_352);_354.createPolyline(_343).setStroke(_352);if(_344.length>0){for(j=_344.length-1;j>=0;--j){_354.createPolyline(_344[j]).setStroke(_352);}}}else{_354.createCircle({cx:_34f.cx,cy:_34f.cy,r:r}).setStroke(_352);_354.createCircle({cx:_34f.cx,cy:_34f.cy,r:r*ro}).setStroke(_352);if(_345.length>0){for(j=_345.length-1;j>=0;--j){_354.createCircle({cx:_34f.cx,cy:_34f.cy,r:_345[j]}).setStroke(_352);}}}len=this._getObjectLength(this.datas);var _355=s.createGroup(),k=0;for(var key in this.datas){data=this.datas[key];min=data.min;max=data.max;_34d=max-min;end=_33e+2*Math.PI*k/len;for(i=0;i<dv;i++){var text=min+_34d*i/(dv-1);_349=this._getCoordinate(_34f,r*(ro+(1-ro)*i/(dv-1)),end,dim);text=this._getLabel(text);_34a=g._base._getTextBox(text,{font:_333}).w||0;_34b=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_34b](this.chart,_355,(!_327.isBodyLtr()&&_34b=="html")?(_349.x+_34a-dim.width):_349.x,_349.y,"start",text,_333,_335));}}k++;}this.chart.seriesShapes={};for(i=this.series.length-1;i>=0;i--){_34c=this.series[i];run=_34c.data;if(run!==null){var _356=[],_357=[];k=0;for(key in run){data=this.datas[key];min=data.min;max=data.max;_34d=max-min;var _358=run[key],end=_33e+2*Math.PI*k/len;_349=this._getCoordinate(_34f,r*(ro+(1-ro)*(_358-min)/_34d),end,dim);_356.push(_349);_357.push({sname:_34c.name,key:key,data:_358});k++;}_356[_356.length]=_356[0];_357[_357.length]=_357[0];var _359=this._getBoundary(_356),_35a=t.next("spider",[o,_34c]),ts=_34c.group,f=g.normalizeColor(_35a.series.fill),sk={color:_35a.series.fill,width:_33b};f.a=o.seriesFillAlpha;_34c.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_34c.name];var cs=this._createSeriesEntry(ts,(osps||_343),_356,f,sk,r,ro,ms,at);this.chart.seriesShapes[_34c.name]=cs;this.oldSeriePoints[_34c.name]=_356;var po={element:"spider_poly",index:i,id:"spider_poly_"+_34c.name,run:_34c,plot:this,shape:cs.poly,parent:ts,brect:_359,cx:_34f.cx,cy:_34f.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_34c.name,run:_34c,plot:this,shape:_34c.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var co={element:"spider_circle",index:i,id:"spider_circle_"+_34c.name+i,run:_34c,plot:this,shape:c,parent:ts,tdata:_357[i],cx:_356[i].x,cy:_356[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _35b=ts.createPolyline(osps).setFill(f).setStroke(sk),_35c=[];for(var j=0;j<osps.length;j++){var _35d=osps[j],cr=ms;var _35e=ts.createCircle({cx:_35d.x,cy:_35d.y,r:cr}).setFill(f).setStroke(sk);_35c.push(_35e);}var _35f=arr.map(sps,function(np,j){var sp=osps[j],anim=new _328.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_35b,sc=_35c[j];hub.connect(anim,"onAnimate",function(y){var _360=spl.getShape();_360.points[j].y=y;spl.setShape(_360);var _361=sc.getShape();_361.cy=y;sc.setShape(_361);});return anim;});var _362=arr.map(sps,function(np,j){var sp=osps[j],anim=new _328.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_35b,sc=_35c[j];hub.connect(anim,"onAnimate",function(x){var _363=spl.getShape();_363.points[j].x=x;spl.setShape(_363);var _364=sc.getShape();_364.cx=x;sc.setShape(_364);});return anim;});var _365=_329.combine(_35f.concat(_362));_365.play();return {group:ts,poly:_35b,circles:_35c};},plotEvent:function(o){if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}},tooltipFunc:function(o){if(o.element=="spider_circle"){return o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data;}else{return null;}},_getBoundary:function(_366){var xmax=_366[0].x,xmin=_366[0].x,ymax=_366[0].y,ymin=_366[0].y;for(var i=0;i<_366.length;i++){var _367=_366[i];xmax=Math.max(_367.x,xmax);ymax=Math.max(_367.y,ymax);xmin=Math.min(_367.x,xmin);ymin=Math.min(_367.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_368,end,_369){var len=Math.sqrt(Math.pow(end.x-_368.x,2)+Math.pow(end.y-_368.y,2)),sin=(end.y-_368.y)/len,cos=(end.x-_368.x)/len,_36a={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_36b={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_368,_36a,_36b]).setFill(_369.color).setStroke(_369);},_buildPoints:function(_36c,_36d,_36e,_36f,_370,_371,dim){for(var i=0;i<_36d;i++){var end=_370+2*Math.PI*i/_36d;_36c.push(this._getCoordinate(_36e,_36f,end,dim));}if(_371){_36c.push(this._getCoordinate(_36e,_36f,_370+2*Math.PI,dim));}},_getCoordinate:function(_372,_373,_374,dim){var x=_372.cx+_373*Math.cos(_374);if(has("dojo-bidi")&&this.chart.isRightToLeft()&&dim){x=dim.width-x;}return {x:x,y:_372.cy+_373*Math.sin(_374)};},_getObjectLength:function(obj){var _375=0;if(lang.isObject(obj)){for(var key in obj){_375++;}}return _375;},_getLabel:function(_376){return dc.getLabel(_376,this.opt.fixed,this.opt.precision);}});return _32e;});},"dojox/charting/plot2d/StackedBars":function(){define(["dojo/_base/declare","./Bars","./commonStacked"],function(_377,Bars,_378){return _377("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _379=_378.collectStats(this.series),t;_379.hmin-=0.5;_379.hmax+=0.5;t=_379.hmin,_379.hmin=_379.vmin,_379.vmin=t;t=_379.hmax,_379.hmax=_379.vmax,_379.vmax=t;return _379;},getValue:function(_37a,_37b,_37c,_37d){var y,x;if(_37d){x=_37b;y=_378.getIndexValue(this.series,_37c,x);}else{x=_37a.x-1;y=_378.getValue(this.series,_37c,_37a.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/themes/GreySkies":function(){define(["../SimpleTheme","./common"],function(_37e,_37f){_37f.GreySkies=new _37e();return _37f.GreySkies;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_380,_381,_382,_383,win,_384,_385){function _386(node,_387,_388,_389){var view=_384.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_380.some(_387,function(_38a){var _38b=_38a.corner;var pos=_38a.pos;var _38c=0;var _38d={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_38b.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_38b.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_388){var res=_388(node,_38a.aroundCorner,_38b,_38d,_389);_38c=typeof res=="undefined"?0:res;}var _38e=node.style;var _38f=_38e.display;var _390=_38e.visibility;if(_38e.display=="none"){_38e.visibility="hidden";_38e.display="";}var bb=_381.position(node);_38e.display=_38f;_38e.visibility=_390;var _391={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_38b.charAt(1)],_392={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_38b.charAt(0)],_393=Math.max(view.l,_391),_394=Math.max(view.t,_392),endX=Math.min(view.l+view.w,_391+bb.w),endY=Math.min(view.t+view.h,_392+bb.h),_395=endX-_393,_396=endY-_394;_38c+=(bb.w-_395)+(bb.h-_396);if(best==null||_38c<best.overflow){best={corner:_38b,aroundCorner:_38a.aroundCorner,x:_393,y:_394,w:_395,h:_396,overflow:_38c,spaceAvailable:_38d};}return !_38c;});if(best.overflow&&_388){_388(node,best.aroundCorner,best.corner,best.spaceAvailable,_389);}var l=_381.isBodyLtr(node.ownerDocument),top=best.y,side=l?best.x:view.w-best.x-best.w;if(/relative|absolute/.test(_382.get(win.body(node.ownerDocument),"position"))){top-=_382.get(win.body(node.ownerDocument),"marginTop");side-=(l?1:-1)*_382.get(win.body(node.ownerDocument),l?"marginLeft":"marginRight");}var s=node.style;s.top=top+"px";s[l?"left":"right"]=side+"px";s[l?"right":"left"]="auto";return best;};var _397={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _398={at:function(node,pos,_399,_39a,_39b){var _39c=_380.map(_399,function(_39d){var c={corner:_39d,aroundCorner:_397[_39d],pos:{x:pos.x,y:pos.y}};if(_39a){c.pos.x+=_39d.charAt(1)=="L"?_39a.x:-_39a.x;c.pos.y+=_39d.charAt(0)=="T"?_39a.y:-_39a.y;}return c;});return _386(node,_39c,_39b);},around:function(node,_39e,_39f,_3a0,_3a1){var _3a2;if(typeof _39e=="string"||"offsetWidth" in _39e){_3a2=_381.position(_39e,true);if(/^(above|below)/.test(_39f[0])){var _3a3=_381.getBorderExtents(_39e),_3a4=_39e.firstChild?_381.getBorderExtents(_39e.firstChild):{t:0,l:0,b:0,r:0},_3a5=_381.getBorderExtents(node),_3a6=node.firstChild?_381.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_3a2.y+=Math.min(_3a3.t+_3a4.t,_3a5.t+_3a6.t);_3a2.h-=Math.min(_3a3.t+_3a4.t,_3a5.t+_3a6.t)+Math.min(_3a3.b+_3a4.b,_3a5.b+_3a6.b);}}else{_3a2=_39e;}if(_39e.parentNode){var _3a7=_382.getComputedStyle(_39e).position=="absolute";var _3a8=_39e.parentNode;while(_3a8&&_3a8.nodeType==1&&_3a8.nodeName!="BODY"){var _3a9=_381.position(_3a8,true),pcs=_382.getComputedStyle(_3a8);if(/relative|absolute/.test(pcs.position)){_3a7=false;}if(!_3a7&&/hidden|auto|scroll/.test(pcs.overflow)){var _3aa=Math.min(_3a2.y+_3a2.h,_3a9.y+_3a9.h);var _3ab=Math.min(_3a2.x+_3a2.w,_3a9.x+_3a9.w);_3a2.x=Math.max(_3a2.x,_3a9.x);_3a2.y=Math.max(_3a2.y,_3a9.y);_3a2.h=_3aa-_3a2.y;_3a2.w=_3ab-_3a2.x;}if(pcs.position=="absolute"){_3a7=true;}_3a8=_3a8.parentNode;}}var x=_3a2.x,y=_3a2.y,_3ac="w" in _3a2?_3a2.w:(_3a2.w=_3a2.width),_3ad="h" in _3a2?_3a2.h:(_383.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_3a2.height+", width:"+_3ac+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_3a2.height+", w:"+_3ac+" }","","2.0"),_3a2.h=_3a2.height);var _3ae=[];function push(_3af,_3b0){_3ae.push({aroundCorner:_3af,corner:_3b0,pos:{x:{"L":x,"R":x+_3ac,"M":x+(_3ac>>1)}[_3af.charAt(1)],y:{"T":y,"B":y+_3ad,"M":y+(_3ad>>1)}[_3af.charAt(0)]}});};_380.forEach(_39f,function(pos){var ltr=_3a0;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _3b1=_386(node,_3ae,_3a1,{w:_3ac,h:_3ad});_3b1.aroundNodePos=_3a2;return _3b1;}};return _385.place=_398;});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_3b2,has,_3b3,_3b4,dc,df,dfr,du,fx){var _3b5=dfr.lambda("item.purgeGroup()");return _3b2("dojox.charting.plot2d.Columns",[_3b3,_3b4],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_3b6,_3b7){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_3b7);du.updateWithPattern(this.opt,_3b7,this.optionalParams);this.animate=this.opt.animate;},getSeriesStats:function(){var _3b8=dc.collectSimpleStats(this.series);_3b8.hmin-=0.5;_3b8.hmax+=0.5;return _3b8;},createRect:function(run,_3b9,_3ba){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_3ba);_3b9.add(rect);}else{rect=_3b9.createRect(_3ba);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_3bb){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3bb);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_3b5);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3bc=Math.max(0,this._vScaler.bounds.lower),_3bd=vt(_3bc),_3be=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _3bf=t.next("column",[this.opt,run]),_3c0=new Array(run.data.length);s=run.group;var _3c1=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_3c1?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_3c1?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _3c2=run.data[j];if(_3c2!=null){var val=this.getValue(_3c2,j,i,_3c1),vv=vt(val.y),h=Math.abs(vv-_3bd),_3c3,_3c4;if(this.opt.styleFunc||typeof _3c2!="number"){var _3c5=typeof _3c2!="number"?[_3c2]:[];if(this.opt.styleFunc){_3c5.push(this.opt.styleFunc(_3c2));}_3c3=t.addMixin(_3bf,"column",_3c5,true);}else{_3c3=t.post(_3bf,"column");}if(bar.width>=1&&h>=0){var rect={x:_3bb.l+ht(val.x+0.5)+bar.gap+bar.thickness*i,y:dim.height-_3bb.b-(val.y>_3bc?vv:_3bd),width:bar.width,height:h};if(_3c3.series.shadow){var _3c6=lang.clone(rect);_3c6.x+=_3c3.series.shadow.dx;_3c6.y+=_3c3.series.shadow.dy;_3c4=this.createRect(run,s,_3c6).setFill(_3c3.series.shadow.color).setStroke(_3c3.series.shadow);if(this.animate){this._animateColumn(_3c4,dim.height-_3bb.b+_3bd,h);}}var _3c7=this._plotFill(_3c3.series.fill,dim,_3bb);_3c7=this._shapeFill(_3c7,rect);var _3c8=this.createRect(run,s,rect).setFill(_3c7).setStroke(_3c3.series.stroke);if(_3c8.setFilter&&_3c3.series.filter){_3c8.setFilter(_3c3.series.filter);}run.dyn.fill=_3c8.getFill();run.dyn.stroke=_3c8.getStroke();if(_3be){var o={element:"column",index:j,run:run,shape:_3c8,shadow:_3c4,cx:val.x+0.5,cy:val.y,x:_3c1?j:run.data[j].x,y:_3c1?run.data[j]:run.data[j].y};this._connectEvents(o);_3c0[j]=o;}if(!isNaN(val.py)&&val.py>_3bc){rect.height=vv-vt(val.py);}this.createLabel(s,_3c2,rect,_3c3);if(this.animate){this._animateColumn(_3c8,dim.height-_3bb.b-_3bd,h);}}}}this._eventSeries[run.name]=_3c0;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3bb);}return this;},getValue:function(_3c9,j,_3ca,_3cb){var y,x;if(_3cb){if(typeof _3c9=="number"){y=_3c9;}else{y=_3c9.y;}x=j;}else{y=_3c9.y;x=_3c9.x-1;}return {x:x,y:y};},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_3cc,_3cd,_3ce){if(_3ce==0){_3ce=1;}fx.animateTransform(lang.delegate({shape:_3cc,duration:1200,transform:[{name:"translate",start:[0,_3cd-(_3cd/_3ce)],end:[0,0]},{name:"scale",start:[1,1/_3ce],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_3cf,lang,arr,df){var _3d0={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cf.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _3d0)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cf.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _3d0)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cf.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _3d0)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cf.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _3d0)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cf.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _3d0)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_3d1,g,df,sc){var _3d2=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_3d2,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_3d3){if(!_3d3){return _3d3;}if(typeof _3d3=="string"||_3d3 instanceof _3d1){_3d3={color:_3d3};}return g.makeParameters(g.defaultStroke,_3d3);},augmentColor:function(_3d4,_3d5){var t=new _3d1(_3d4),c=new _3d1(_3d5);c.a=t.a;return c;},augmentStroke:function(_3d6,_3d7){var s=_3d2.makeStroke(_3d6);if(s){s.color=_3d2.augmentColor(s.color,_3d7);}return s;},augmentFill:function(fill,_3d8){var fc,c=new _3d1(_3d8);if(typeof fill=="string"||fill instanceof _3d1){return _3d2.augmentColor(fill,_3d8);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_3d9){var _3da=lang.delegate(_3d2.defaultStats);for(var i=0;i<_3d9.length;++i){var run=_3d9[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _3db=_3da.vmin,_3dc=_3da.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_3da.hmin=Math.min(_3da.hmin,x);_3da.hmax=Math.max(_3da.hmax,x);_3da.vmin=Math.min(_3da.vmin,y);_3da.vmax=Math.max(_3da.vmax,y);}});}if("ymin" in run){_3da.vmin=Math.min(_3db,run.ymin);}if("ymax" in run){_3da.vmax=Math.max(_3dc,run.ymax);}}else{var _3dd=_3da.hmin,_3de=_3da.hmax,_3db=_3da.vmin,_3dc=_3da.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_3da.hmin=Math.min(_3da.hmin,x);_3da.hmax=Math.max(_3da.hmax,x);_3da.vmin=Math.min(_3da.vmin,y);_3da.vmax=Math.max(_3da.vmax,y);}});}if("xmin" in run){_3da.hmin=Math.min(_3dd,run.xmin);}if("xmax" in run){_3da.hmax=Math.max(_3de,run.xmax);}if("ymin" in run){_3da.vmin=Math.min(_3db,run.ymin);}if("ymax" in run){_3da.vmax=Math.max(_3dc,run.ymax);}}break;}}}return _3da;},calculateBarSize:function(_3df,opt,_3e0){if(!_3e0){_3e0=1;}var gap=opt.gap,size=(_3df-2*gap)/_3e0;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_3df-size*_3e0)/2;return {size:size,gap:gap};},collectStackedStats:function(_3e1){var _3e2=lang.clone(_3d2.defaultStats);if(_3e1.length){_3e2.hmin=Math.min(_3e2.hmin,1);_3e2.hmax=df.foldl(_3e1,"seed, run -> Math.max(seed, run.data.length)",_3e2.hmax);for(var i=0;i<_3e2.hmax;++i){var v=_3e1[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_3e2.vmin=Math.min(_3e2.vmin,v);for(var j=1;j<_3e1.length;++j){var t=_3e1[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_3e2.vmax=Math.max(_3e2.vmax,v);}}return _3e2;},curve:function(a,_3e3){var _3e4=a.slice(0);if(_3e3=="x"){_3e4[_3e4.length]=_3e4[0];}var p=arr.map(_3e4,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_3e3)){var dx=item.x-_3e4[i-1].x,dy=_3e4[i-1].y;return "C"+(item.x-(_3e3-1)*(dx/_3e3))+","+dy+" "+(item.x-(dx/_3e3))+","+item.y+" "+item.x+","+item.y;}else{if(_3e3=="X"||_3e3=="x"||_3e3=="S"){var p0,p1=_3e4[i-1],p2=_3e4[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_3e3=="x"){p0=_3e4[_3e4.length-2];}else{p0=p1;}f=1/3;}else{p0=_3e4[i-2];}if(i==(_3e4.length-1)){if(_3e3=="x"){p3=_3e4[1];}else{p3=p2;}f=1/3;}else{p3=_3e4[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3e5=p0p2*f;var _3e6=p1p3*f;if(_3e5>p1p2/2&&_3e6>p1p2/2){_3e5=p1p2/2;_3e6=p1p2/2;}else{if(_3e5>p1p2/2){_3e5=p1p2/2;_3e6=p1p2/2*p1p3/p0p2;}else{if(_3e6>p1p2/2){_3e6=p1p2/2;_3e5=p1p2/2*p0p2/p1p3;}}}if(_3e3=="S"){if(p0==p1){_3e5=0;}if(p2==p3){_3e6=0;}}bz1x=p1.x+_3e5*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3e5*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3e6*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3e6*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3e7,_3e8,_3e9){return sc.doIfLoaded("dojo/number",function(_3ea){return (_3e8?_3ea.format(_3e7,{places:_3e9}):_3ea.format(_3e7))||"";},function(){return _3e8?_3e7.toFixed(_3e9):_3e7.toString();});}});});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3eb,_3ec,_3ed,_3ee,has,_3ef,lang,_3f0,_3f1,_3f2,_3f3,_3f4,_3f5){function _3f6(){};function _3f7(_3f8){return function(obj,_3f9,_3fa,_3fb){if(obj&&typeof _3f9=="string"&&obj[_3f9]==_3f6){return obj.on(_3f9.substring(2).toLowerCase(),lang.hitch(_3fa,_3fb));}return _3f8.apply(_3ed,arguments);};};_3eb.around(_3ed,"connect",_3f7);if(_3ef.connect){_3eb.around(_3ef,"connect",_3f7);}var _3fc=_3ee("dijit._Widget",[_3f3,_3f4,_3f5],{onClick:_3f6,onDblClick:_3f6,onKeyDown:_3f6,onKeyPress:_3f6,onKeyUp:_3f6,onMouseDown:_3f6,onMouseMove:_3f6,onMouseOut:_3f6,onMouseOver:_3f6,onMouseLeave:_3f6,onMouseEnter:_3f6,onMouseUp:_3f6,constructor:function(_3fd){this._toConnect={};for(var name in _3fd){if(this[name]===_3f6){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3fd[name];delete _3fd[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3f6){return _3ed.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3fe){_3ef.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3fe);},attr:function(name,_3ff){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3ef.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3f0("[widgetId]",this.containerNode).map(_3f2.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_3f1(0,function(){var _400=["dijit/_base"];require(_400);});}return _3fc;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_401,_402,_403,lang){lang.extend(_402,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _403("dijit._FocusMixin",null,{_focusManager:_401});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_404,keys,_405,has,_406){var ret=_405("dijit._OnDijitClickMixin",null,{connect:function(obj,_407,_408){return this.inherited(arguments,[obj,_407=="ondijitclick"?_406:_407,_408]);}});ret.a11yclick=_406;return ret;});},"dojox/charting/plot2d/Bars":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(lang,arr,_409,has,_40a,_40b,dc,fx,du,df,dfr){var _40c=dfr.lambda("item.purgeGroup()");return _409("dojox.charting.plot2d.Bars",[_40a,_40b],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_40d,_40e){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_40e);du.updateWithPattern(this.opt,_40e,this.optionalParams);this.animate=this.opt.animate;},getSeriesStats:function(){var _40f=dc.collectSimpleStats(this.series),t;_40f.hmin-=0.5;_40f.hmax+=0.5;t=_40f.hmin,_40f.hmin=_40f.vmin,_40f.vmin=t;t=_40f.hmax,_40f.hmax=_40f.vmax,_40f.vmax=t;return _40f;},createRect:function(run,_410,_411){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_411);_410.add(rect);}else{rect=_410.createRect(_411);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},createLabel:function(_412,_413,bbox,_414){if(this.opt.labels&&this.opt.labelStyle=="outside"){var y=bbox.y+bbox.height/2;var x=bbox.x+bbox.width+this.opt.labelOffset;this.renderLabel(_412,x,y,this._getLabel(isNaN(_413.y)?_413:_413.y),_414,"start");}else{this.inherited(arguments);}},render:function(dim,_415){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_415);}this.dirty=this.isDirty();this.resetEvents();var s;if(this.dirty){arr.forEach(this.series,_40c);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_416=Math.max(0,this._hScaler.bounds.lower),_417=ht(_416),_418=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _419=t.next("bar",[this.opt,run]),_41a=new Array(run.data.length);s=run.group;var _41b=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_41b?Math.max(0,Math.floor(this._vScaler.bounds.from-1)):0;var max=_41b?Math.min(run.data.length,Math.ceil(this._vScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _41c=run.data[j];if(_41c!=null){var val=this.getValue(_41c,j,i,_41b),hv=ht(val.y),w=Math.abs(hv-_417),_41d,_41e;if(this.opt.styleFunc||typeof _41c!="number"){var _41f=typeof _41c!="number"?[_41c]:[];if(this.opt.styleFunc){_41f.push(this.opt.styleFunc(_41c));}_41d=t.addMixin(_419,"bar",_41f,true);}else{_41d=t.post(_419,"bar");}if(w>=0&&bar.height>=1){var rect={x:_415.l+(val.y<_416?hv:_417),y:dim.height-_415.b-vt(val.x+1.5)+bar.gap+bar.thickness*(this.series.length-i-1),width:w,height:bar.height};if(_41d.series.shadow){var _420=lang.clone(rect);_420.x+=_41d.series.shadow.dx;_420.y+=_41d.series.shadow.dy;_41e=this.createRect(run,s,_420).setFill(_41d.series.shadow.color).setStroke(_41d.series.shadow);if(this.animate){this._animateBar(_41e,_415.l+_417,-w);}}var _421=this._plotFill(_41d.series.fill,dim,_415);_421=this._shapeFill(_421,rect);var _422=this.createRect(run,s,rect).setFill(_421).setStroke(_41d.series.stroke);if(_422.setFilter&&_41d.series.filter){_422.setFilter(_41d.series.filter);}run.dyn.fill=_422.getFill();run.dyn.stroke=_422.getStroke();if(_418){var o={element:"bar",index:j,run:run,shape:_422,shadow:_41e,cx:val.y,cy:val.x+1.5,x:_41b?j:run.data[j].x,y:_41b?run.data[j]:run.data[j].y};this._connectEvents(o);_41a[j]=o;}if(!isNaN(val.py)&&val.py>_416){rect.x+=ht(val.py);rect.width-=ht(val.py);}this.createLabel(s,_41c,rect,_41d);if(this.animate){this._animateBar(_422,_415.l+_417,-w);}}}}this._eventSeries[run.name]=_41a;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_415);}return this;},getValue:function(_423,j,_424,_425){var y,x;if(_425){if(typeof _423=="number"){y=_423;}else{y=_423.y;}x=j;}else{y=_423.y;x=_423.x-1;}return {y:y,x:x};},getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);return {gap:f.gap,height:f.size,thickness:0};},_animateBar:function(_426,_427,_428){if(_428==0){_428=1;}fx.animateTransform(lang.delegate({shape:_426,duration:1200,transform:[{name:"translate",start:[_427-(_427/_428),0],end:[0,0]},{name:"scale",start:[1/_428,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_429,lang,_42a,has,win,arr,dom,_42b,_42c){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_42d){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_42d+" ")>=0;};g._addClass=function(node,_42e){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_42e+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_42e);}};g._removeClass=function(node,_42f){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_42f+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _430={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_42b.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _430){div.style.fontSize=p;_430[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _430;};var _431=null;b._getCachedFontMeasurements=function(_432){if(_432||!_431){_431=b._getFontMeasurements();}return _431;};var _433=null,_434={};b._getTextBox=function(text,_435,_436){var m,s,al=arguments.length;var i;if(!_433){_433=_42b.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_433;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_435){for(i in _435){if(i in _434){continue;}s[i]=_435[i];}}if(al>2&&_436){m.className=_436;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _42c.getMarginBox(m);}};b._computeTextLocation=function(_437,_438,_439,_43a){var loc={},_43b=_437.align;switch(_43b){case "end":loc.x=_437.x-_438;break;case "middle":loc.x=_437.x-_438/2;break;default:loc.x=_437.x;break;}var c=_43a?0.75:1;loc.y=_437.y-_439*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_43c=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_43c,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _43d=0;b._getUniqueId=function(){var id;do{id=_429._scopeName+"xUnique"+(++_43d);}while(dom.byId(id));return id;};b._fixMsTouchAction=function(_43e){var r=_43e.rawNode;if(typeof r.style.msTouchAction!="undefined"){r.style.msTouchAction="none";}};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _43f={};return function(type){var t=_43f[type];if(t){return new t();}t=_43f[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_440){return (_440 instanceof _42a)?_440:new _42a(_440);},normalizeParameters:function(_441,_442){var x;if(_442){var _443={};for(x in _441){if(x in _442&&!(x in _443)){_441[x]=_442[x];}}}return _441;},makeParameters:function(_444,_445){var i=null;if(!_445){return lang.delegate(_444);}var _446={};for(i in _444){if(!(i in _446)){_446[i]=lang.clone((i in _445)?_445[i]:_444[i]);}}return _446;},formatNumber:function(x,_447){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _448=val.indexOf(".");if(_448>=0&&val.length-_448>5){val=x.toFixed(4);}}if(x<0){return val;}return _447?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _449=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_449;case "in":return val*72*_449;case "pc":return val*12*_449;case "mm":return val*g.mm_in_pt*_449;case "cm":return val*g.cm_in_pt*_449;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_44a){var ns=typeof _44a=="string"?g[_44a]:_44a;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _44a=="string"){g.renderer=_44a;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/charting/plot2d/CartesianBase":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/has","./Base","../scaler/primitive","dojox/gfx","dojox/gfx/fx","dojox/lang/utils"],function(lang,_44b,hub,has,Base,_44c,gfx,fx,du){return _44b("dojox.charting.plot2d.CartesianBase",Base,{baseParams:{hAxis:"x",vAxis:"y",labels:false,labelOffset:10,fixed:true,precision:1,labelStyle:"inside",htmlLabels:true,omitLabels:true,labelFunc:null},constructor:function(_44d,_44e){this.axes=["hAxis","vAxis"];this.zoom=null;this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};this.hAxis=(_44e&&_44e.hAxis)||"x";this.vAxis=(_44e&&_44e.vAxis)||"y";this.series=[];this.opt=lang.clone(this.baseParams);du.updateWithObject(this.opt,_44e);},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_44f,_450){this.inherited(arguments);if(!_450&&this.chart._nativeClip){var _451=this.chart.offsets,dim=this.chart.dim;var w=Math.max(0,dim.width-_451.l-_451.r),h=Math.max(0,dim.height-_451.t-_451.b);this.group.setClip({x:_451.l,y:_451.t,width:w,height:h});if(!this._clippedGroup){this._clippedGroup=this.group.createGroup();}}},purgeGroup:function(){this.inherited(arguments);this._clippedGroup=null;},getGroup:function(){return this._clippedGroup||this.group;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_452){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_453){var r={};r.x=th(_453[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_453[av.name]);return r;};return _452?t(_452):t;},toData:function(_454){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_455){var r={};r[ah.name]=th(_455.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_455.y-o.b);return r;};return _454?t(_454):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},createLabel:function(_456,_457,bbox,_458){if(this.opt.labels){var x,y,_459=this.opt.labelFunc?this.opt.labelFunc.apply(this,[_457,this.opt.fixed,this.opt.precision]):this._getLabel(isNaN(_457.y)?_457:_457.y);if(this.opt.labelStyle=="inside"){var lbox=gfx._base._getTextBox(_459,{font:_458.series.font});x=bbox.x+bbox.width/2;y=bbox.y+bbox.height/2+lbox.h/4;if(lbox.w>bbox.width||lbox.h>bbox.height){return;}}else{x=bbox.x+bbox.width/2;y=bbox.y-this.opt.labelOffset;}this.renderLabel(_456,x,y,_459,_458,this.opt.labelStyle=="inside");}},performZoom:function(dim,_45a){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_45b=dim.height-_45a.b,_45c=this._hScaler.bounds,_45d=(_45c.from-_45c.lower)*_45c.scale,_45e=this._vScaler.bounds,_45f=(_45e.from-_45e.lower)*_45e.scale,_460=vs/this.lastWindow.vscale,_461=hs/this.lastWindow.hscale,_462=(this.lastWindow.xoffset-_45d)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_463=(_45f-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_464=this.getGroup(),anim=fx.animateTransform(lang.delegate({shape:_464,duration:1200,transform:[{name:"translate",start:[0,0],end:[_45a.l*(1-_461),_45b*(1-_460)]},{name:"scale",start:[1,1],end:[_461,_460]},{name:"original"},{name:"translate",start:[0,0],end:[_462,_463]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_45d,yoffset:_45f});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_465){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_465.hmin,_465.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_44c.buildScaler(_465.hmin,_465.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_465.vmin,_465.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_44c.buildScaler(_465.vmin,_465.vmax,dim.height);}return this;}});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_466,_467,dom,_468,_469,_46a,_46b,lang,on,_46c,has,_46d,win,_46e,a11y,_46f,_470){var _471;var _472=_467([_46d,_46b],{curNode:null,activeStack:[],constructor:function(){var _473=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_466.before(_46a,"empty",_473);_466.before(_46a,"destroy",_473);},registerIframe:function(_474){return this.registerWin(_474.contentWindow,_474);},registerWin:function(_475,_476){var _477=this,body=_475.document&&_475.document.body;if(body){var mdh=on(_475.document,"mousedown, touchstart",function(evt){_477._justMouseDowned=true;setTimeout(function(){_477._justMouseDowned=false;},0);if(evt&&evt.target&&evt.target.parentNode==null){return;}_477._onTouchNode(_476||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){_471=(new Date()).getTime();if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_477._onFocusNode(_476||evt.target);}else{_477._onTouchNode(_476||evt.target);}});var foh=on(body,"focusout",function(evt){if((new Date()).getTime()<_471+100){return;}_477._onBlurNode(_476||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_469.contains(node,"dijitPopup")){node=node.firstChild;}var _478=[];try{while(node){var _479=_468.get(node,"dijitPopupParent");if(_479){node=_46f.byId(_479).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_46e.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_47a=id&&_46f.byId(id);if(_47a&&!(by=="mouse"&&_47a.get("disabled"))){_478.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_478,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_47b,by){var _47c=this.activeStack,_47d=_47c.length-1,_47e=_47b.length-1;if(_47b[_47e]==_47c[_47d]){return;}this.set("activeStack",_47b);var _47f,i;for(i=_47d;i>=0&&_47c[i]!=_47b[i];i--){_47f=_46f.byId(_47c[i]);if(_47f){_47f._hasBeenBlurred=true;_47f.set("focused",false);if(_47f._focusManager==this){_47f._onBlur(by);}this.emit("widget-blur",_47f,by);}}for(i++;i<=_47e;i++){_47f=_46f.byId(_47b[i]);if(_47f){_47f.set("focused",true);if(_47f._focusManager==this){_47f._onFocus(by);}this.emit("widget-focus",_47f,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _480=new _472();_46c(function(){var _481=_480.registerWin(_46e.get(document));if(has("ie")){on(window,"unload",function(){if(_481){_481.remove();_481=null;}});}});_470.focus=function(node){_480.focus(node);};for(var attr in _480){if(!/^_/.test(attr)){_470.focus[attr]=typeof _480[attr]=="function"?lang.hitch(_480,attr):_480[attr];}}_480.watch(function(attr,_482,_483){_470.focus[attr]=_483;});return _480;});},"dojox/charting/widget/Legend":function(){define(["dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Legend","dojox/lang/functional","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(_484,_485,gfx,arr,has,_486,df,dom,_487,_488,_489){var _48a=_484(has("dojo-bidi")?"dojox.charting.widget.NonBidiLegend":"dojox.charting.widget.Legend",_485,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_489.byId(this.chartRef)||_489.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_487.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_487.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_48b){_48b.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_48c){_48c.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_487.destroy(this.legendBody.lastChild);}if(this.horizontal){_488.add(this.domNode,"dojoxLegendHorizontal");this._tr=_487.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _48d=df.map(t.run.data,"Math.max(x, 0)");var _48e=df.map(_48d,"/this",df.foldl(_48d,"+",0));arr.forEach(_48e,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{arr.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{arr.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_48f){var _490=_487.create("td"),icon=_487.create("div",null,_490),text=_487.create("label",null,_490),div=_487.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_488.add(icon,"dojoxLegendIcon dijitInline");_488.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_490);if(++this._inrow===this.horizontal){this._tr=_487.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_487.create("tr",null,this.legendBody);tr.appendChild(_490);}this._makeIcon(div,dyn);text.innerHTML=String(_48f);if(has("dojo-bidi")){text.dir=this.getTextDir(_48f,text.dir);}},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _491=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_491);if(dyn.fill){_491.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_491.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_491.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_491.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_491.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_491.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});return has("dojo-bidi")?_484("dojox.charting.widget.Legend",[_48a,_486]):_48a;});},"dojox/charting/plot2d/StackedLines":function(){define(["dojo/_base/declare","./Stacked"],function(_492,_493){return _492("dojox.charting.plot2d.StackedLines",_493,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define(["dojo/_base/declare","./Columns","./commonStacked"],function(_494,_495,_496){return _494("dojox.charting.plot2d.StackedColumns",_495,{getSeriesStats:function(){var _497=_496.collectStats(this.series);_497.hmin-=0.5;_497.hmax+=0.5;return _497;},getValue:function(_498,_499,_49a,_49b){var x,y;if(_49b){x=_499;y=_496.getIndexValue(this.series,_49a,x);}else{x=_498.x-1;y=_496.getValue(this.series,_49a,_498.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_49c,_49d){return _49c("dojox.charting.Series",_49d,{constructor:function(_49e,data,_49f){lang.mixin(this,_49f);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_4a0,arr,has,_4a1,_4a2,dc,df,dfr,du,fx){var _4a3=dfr.lambda("item.purgeGroup()");var _4a4=1200;return _4a0("dojox.charting.plot2d.Default",[_4a1,_4a2],{defaultParams:{lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_4a5,_4a6){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_4a6);du.updateWithPattern(this.opt,_4a6,this.optionalParams);this.animate=this.opt.animate;},createPath:function(run,_4a7,_4a8){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_4a8);_4a7.add(path);}else{path=_4a7.createPath(_4a8);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_4a9){var run=this.series[i],min=_4a9?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_4a9?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_4aa=[];for(var j=min;j<max;j++){if(run.data[j]!=null&&(_4a9||run.data[j].y!=null)){if(!rseg){rseg=[];_4aa.push({index:j,rseg:rseg});}rseg.push((_4a9&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_4a9){rseg=null;}}}return _4aa;},render:function(dim,_4ab){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_4ab);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_4a3);this._eventSeries={};this.cleanGroup();this.getGroup().setTransform(null);s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_4ac,_4ad,_4ae=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _4af=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_4b0,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_4b1=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;var _4b2=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _4b3=this.buildSegments(i,_4b2);for(var seg=0;seg<_4b3.length;seg++){var _4b4=_4b3[seg];if(_4b2){_4b0=arr.map(_4b4.rseg,function(v,i){return {x:ht(i+_4b4.index+1)+_4ab.l,y:dim.height-_4ab.b-vt(v),data:v};},this);}else{_4b0=arr.map(_4b4.rseg,function(v){return {x:ht(v.x)+_4ab.l,y:dim.height-_4ab.b-vt(v.y),data:v};},this);}if(_4b2&&this.opt.interpolate){while(seg<_4b3.length){seg++;_4b4=_4b3[seg];if(_4b4){_4b0=_4b0.concat(arr.map(_4b4.rseg,function(v,i){return {x:ht(i+_4b4.index+1)+_4ab.l,y:dim.height-_4ab.b-vt(v),data:v};},this));}}}var _4b5=this.opt.tension?dc.curve(_4b0,this.opt.tension):"";if(this.opt.areas&&_4b0.length>1){var fill=this._plotFill(_4af.series.fill,dim,_4ab),_4b6=lang.clone(_4b0);if(this.opt.tension){var _4b7="L"+_4b6[_4b6.length-1].x+","+(dim.height-_4ab.b)+" L"+_4b6[0].x+","+(dim.height-_4ab.b)+" L"+_4b6[0].x+","+_4b6[0].y;run.dyn.fill=s.createPath(_4b5+" "+_4b7).setFill(fill).getFill();}else{_4b6.push({x:_4b0[_4b0.length-1].x,y:dim.height-_4ab.b});_4b6.push({x:_4b0[0].x,y:dim.height-_4ab.b});_4b6.push(_4b0[0]);run.dyn.fill=s.createPolyline(_4b6).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_4ac=_4af.series.stroke;if(_4af.series.outline){_4ad=run.dyn.outline=dc.makeStroke(_4af.series.outline);_4ad.width=2*_4ad.width+_4ac.width;}}if(this.opt.markers){run.dyn.marker=_4af.symbol;}var _4b8=null,_4b9=null,_4ba=null;if(_4ac&&_4af.series.shadow&&_4b0.length>1){var _4bb=_4af.series.shadow,_4bc=arr.map(_4b0,function(c){return {x:c.x+_4bb.dx,y:c.y+_4bb.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_4bc,this.opt.tension)).setStroke(_4bb).getStroke();}else{run.dyn.shadow=s.createPolyline(_4bc).setStroke(_4bb).getStroke();}}if(this.opt.markers&&_4af.marker.shadow){_4bb=_4af.marker.shadow;_4ba=arr.map(_4bc,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_4af.symbol).setStroke(_4bb).setFill(_4bb.color);},this);}}if(this.opt.lines&&_4b0.length>1){var _4bd;if(_4ad){if(this.opt.tension){run.dyn.outline=s.createPath(_4b5).setStroke(_4ad).getStroke();}else{run.dyn.outline=s.createPolyline(_4b0).setStroke(_4ad).getStroke();}}if(this.opt.tension){run.dyn.stroke=(_4bd=s.createPath(_4b5)).setStroke(_4ac).getStroke();}else{run.dyn.stroke=(_4bd=s.createPolyline(_4b0)).setStroke(_4ac).getStroke();}if(_4bd.setFilter&&_4af.series.filter){_4bd.setFilter(_4af.series.filter);}}var _4be=null;if(this.opt.markers){var _4bf=_4af;_4b8=new Array(_4b0.length);_4b9=new Array(_4b0.length);_4ad=null;if(_4bf.marker.outline){_4ad=dc.makeStroke(_4bf.marker.outline);_4ad.width=2*_4ad.width+(_4bf.marker.stroke?_4bf.marker.stroke.width:0);}arr.forEach(_4b0,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4c0=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4c0.push(this.opt.styleFunc(c.data));}_4bf=t.addMixin(_4af,"marker",_4c0,true);}else{_4bf=t.post(_4af,"marker");}var path="M"+c.x+" "+c.y+" "+_4bf.symbol;if(_4ad){_4b9[i]=this.createPath(run,s,path).setStroke(_4ad);}_4b8[i]=this.createPath(run,s,path).setStroke(_4bf.marker.stroke).setFill(_4bf.marker.fill);},this);run.dyn.markerFill=_4bf.marker.fill;run.dyn.markerStroke=_4bf.marker.stroke;if(!_4be&&this.opt.labels){_4be=_4b8[0].getBoundingBox();}if(_4ae){arr.forEach(_4b8,function(s,i){var o={element:"marker",index:i+_4b4.index,run:run,shape:s,outline:_4b9[i]||null,shadow:_4ba&&_4ba[i]||null,cx:_4b0[i].x,cy:_4b0[i].y};if(_4b2){o.x=i+_4b4.index+1;o.y=run.data[i+_4b4.index];}else{o.x=_4b4.rseg[i].x;o.y=run.data[i+_4b4.index].y;}this._connectEvents(o);_4b1[i+_4b4.index]=o;},this);}else{delete this._eventSeries[run.name];}}if(this.opt.labels){var _4c1=_4be?_4be.width:2;var _4c2=_4be?_4be.height:2;arr.forEach(_4b0,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4c3=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4c3.push(this.opt.styleFunc(c.data));}_4bf=t.addMixin(_4af,"marker",_4c3,true);}else{_4bf=t.post(_4af,"marker");}this.createLabel(s,_4b4.rseg[i],{x:c.x-_4c1/2,y:c.y-_4c2/2,width:_4c1,height:_4c2},_4bf);},this);}}run.dirty=false;}if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_4ab);}if(this.animate){var _4c4=this.getGroup();fx.animateTransform(lang.delegate({shape:_4c4,duration:_4a4,transform:[{name:"translate",start:[0,dim.height-_4ab.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_4c5,arr,gfx,_4c6,_4c7,ac,has){var Base=_4c5("dojox.charting.plot2d.Base",_4c6,{constructor:function(_4c8,_4c9){if(_4c9&&_4c9.tooltipFunc){this.tooltipFunc=_4c9.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _4c7.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_4ca){return this;},renderLabel:function(_4cb,x,y,_4cc,_4cd,_4ce,_4cf){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_4cb,x,y,_4cf?_4cf:"middle",_4cc,_4cd.series.font,_4cd.series.fontColor);if(_4ce){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_4d0){return _4c7.getLabel(_4d0,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_4d1,dim,_4d2){this.chart.applyMirroring(this.group,dim,_4d2);}});}return Base;});},"dojox/charting/action2d/Tooltip":function(){define(["dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/connect","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojo/has","dojo/has!dojo-bidi?../bidi/action2d/Tooltip","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(_4d3,lang,_4d4,win,hub,_4d5,_4d6,m,has,_4d7,df){var _4d8=function(o,plot){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(plot.tooltipFunc){return plot.tooltipFunc(o);}else{return o.y;}};var pi4=Math.PI/4,pi2=Math.PI/2;var _4d9=_4d4(has("dojo-bidi")?"dojox.charting.action2d.NonBidiTooltip":"dojox.charting.action2d.Tooltip",_4d6,{defaultParams:{text:_4d8,mouseOver:true},optionalParams:{},constructor:function(_4da,plot,_4db){this.text=_4db&&_4db.text?_4db.text:_4d8;this.mouseOver=_4db&&_4db.mouseOver!=undefined?_4db.mouseOver:true;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_4d3.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||(this.mouseOver&&o.type!=="onmouseover")||(!this.mouseOver&&o.type!=="onclick")){return;}var _4dc={type:"rect"},_4dd=["after-centered","before-centered"];switch(o.element){case "marker":_4dc.x=o.cx;_4dc.y=o.cy;_4dc.w=_4dc.h=1;break;case "circle":_4dc.x=o.cx-o.cr;_4dc.y=o.cy-o.cr;_4dc.w=_4dc.h=2*o.cr;break;case "spider_circle":_4dc.x=o.cx;_4dc.y=o.cy;_4dc.w=_4dc.h=1;break;case "spider_plot":return;case "column":_4dd=["above-centered","below-centered"];case "bar":_4dc=lang.clone(o.shape.getShape());_4dc.w=_4dc.width;_4dc.h=_4dc.height;break;case "candlestick":_4dc.x=o.x;_4dc.y=o.y;_4dc.w=o.width;_4dc.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _4de=m._degToRad(o.plot.opt.startAngle),_4df=(this.angles[o.index]+this.angles[o.index+1])/2+_4de;_4dc.x=o.cx+o.cr*Math.cos(_4df);_4dc.y=o.cy+o.cr*Math.sin(_4df);_4dc.w=_4dc.h=1;if(_4de&&(_4df<0||_4df>2*Math.PI)){_4df=Math.abs(2*Math.PI-Math.abs(_4df));}if(_4df<pi4){}else{if(_4df<pi2+pi4){_4dd=["below-centered","above-centered"];}else{if(_4df<Math.PI+pi4){_4dd=["before-centered","after-centered"];}else{if(_4df<2*Math.PI-pi4){_4dd=["above-centered","below-centered"];}}}}break;}if(has("dojo-bidi")){this._recheckPosition(o,_4dc,_4dd);}var lt=this.chart.getCoords();_4dc.x+=lt.x;_4dc.y+=lt.y;_4dc.x=Math.round(_4dc.x);_4dc.y=Math.round(_4dc.y);_4dc.w=Math.ceil(_4dc.w);_4dc.h=Math.ceil(_4dc.h);this.aroundRect=_4dc;var _4e0=this.text(o,this.plot);if(_4e0){_4d3.show(this._format(_4e0),this.aroundRect,_4dd);}if(!this.mouseOver){this._handle=hub.connect(win.doc,"onclick",this,"onClick");}},onClick:function(){this.process({type:"onmouseout"});},_recheckPosition:function(obj,rect,_4e1){},_format:function(_4e2){return _4e2;}});return has("dojo-bidi")?_4d4("dojox.charting.action2d.Tooltip",[_4d9,_4d7]):_4d9;});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4e3,_4e4){_4e3.switchTo(_4e4);return _4e3;});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_4e5,_4e6,has,on,arr,_4e7,_4e8,_4e9){var _4ea=g.shape={};_4ea.Shape=_4e5("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_4ea.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_4ea.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_4e9;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_4eb){this.shape=g.makeParameters(this.shape,_4eb);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_4ec){if(!_4ec){this.strokeStyle=null;return this;}if(typeof _4ec=="string"||lang.isArray(_4ec)||_4ec instanceof _4e8){_4ec={color:_4ec};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_4ec);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_4ed){this.matrix=_4e9.clone(_4ed?_4e9.normalize(_4ed):_4e9.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_4ee){return _4ee?this.setTransform([this.matrix,_4ee]):this;},applyLeftTransform:function(_4ef){return _4ef?this.setTransform([_4ef,this.matrix]):this;},applyTransform:function(_4f0){return _4f0?this.setTransform([this.matrix,_4f0]):this;},removeShape:function(_4f1){if(this.parent){this.parent.remove(this,_4f1);}return this;},_setParent:function(_4f2,_4f3){this.parent=_4f2;return this._updateParentMatrix(_4f3);},_updateParentMatrix:function(_4f4){this.parentMatrix=_4f4?_4e9.clone(_4f4):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_4e9.multiply(p.matrix,m);}p=p.parent;}return m;}});_4ea._eventsProcessing={on:function(type,_4f5){return on(this.getEventSource(),type,_4ea.fixCallback(this,g.fixTarget,_4f5));},connect:function(name,_4f6,_4f7){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_4f7?lang.hitch(_4f6,_4f7):_4f6);},disconnect:function(_4f8){return _4f8.remove();}};_4ea.fixCallback=function(_4f9,_4fa,_4fb,_4fc){if(!_4fc){_4fc=_4fb;_4fb=null;}if(lang.isString(_4fc)){_4fb=_4fb||_4e6.global;if(!_4fb[_4fc]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_4fc,"\"] is null (scope=\"",_4fb,"\")"].join(""));}return function(e){return _4fa(e,_4f9)?_4fb[_4fc].apply(_4fb,arguments||[]):undefined;};}return !_4fb?function(e){return _4fa(e,_4f9)?_4fc.apply(_4fb,arguments):undefined;}:function(e){return _4fa(e,_4f9)?_4fc.apply(_4fb,arguments||[]):undefined;};};lang.extend(_4ea.Shape,_4ea._eventsProcessing);_4ea.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_4fd){var _4fe=_4fd.getParent();if(_4fe){_4fe.remove(_4fd,true);}this.children.push(_4fd);return _4fd._setParent(this,this._getRealMatrix());},remove:function(_4ff,_500){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4ff){if(_500){}else{_4ff.parent=null;_4ff.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_501){var _502;for(var i=0;i<this.children.length;++i){_502=this.children[i];_502.parent=null;_502.parentMatrix=null;if(_501){_502.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _503=null;arr.forEach(this.children,function(_504){var bb=_504.getBoundingBox();if(bb){var ct=_504.getTransform();if(ct){bb=_4e9.multiplyRectangle(ct,bb);}if(_503){_503.x=Math.min(_503.x,bb.x);_503.y=Math.min(_503.y,bb.y);_503.endX=Math.max(_503.endX,bb.x+bb.width);_503.endY=Math.max(_503.endY,bb.y+bb.height);}else{_503={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_503){_503.width=_503.endX-_503.x;_503.height=_503.endY-_503.y;}return _503;}return null;},_moveChildToFront:function(_505){for(var i=0;i<this.children.length;++i){if(this.children[i]==_505){this.children.splice(i,1);this.children.push(_505);break;}}return this;},_moveChildToBack:function(_506){for(var i=0;i<this.children.length;++i){if(this.children[i]==_506){this.children.splice(i,1);this.children.unshift(_506);break;}}return this;}};_4ea.Surface=_4e5("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_4e7.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_4e7.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_507){},whenLoaded:function(_508,_509){var f=lang.hitch(_508,_509);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_50a){f(_50a);});}}});lang.extend(_4ea.Surface,_4ea._eventsProcessing);_4ea.Rect=_4e5("dojox.gfx.shape.Rect",_4ea.Shape,{constructor:function(_50b){this.shape=g.getDefault("Rect");this.rawNode=_50b;},getBoundingBox:function(){return this.shape;}});_4ea.Ellipse=_4e5("dojox.gfx.shape.Ellipse",_4ea.Shape,{constructor:function(_50c){this.shape=g.getDefault("Ellipse");this.rawNode=_50c;},getBoundingBox:function(){if(!this.bbox){var _50d=this.shape;this.bbox={x:_50d.cx-_50d.rx,y:_50d.cy-_50d.ry,width:2*_50d.rx,height:2*_50d.ry};}return this.bbox;}});_4ea.Circle=_4e5("dojox.gfx.shape.Circle",_4ea.Shape,{constructor:function(_50e){this.shape=g.getDefault("Circle");this.rawNode=_50e;},getBoundingBox:function(){if(!this.bbox){var _50f=this.shape;this.bbox={x:_50f.cx-_50f.r,y:_50f.cy-_50f.r,width:2*_50f.r,height:2*_50f.r};}return this.bbox;}});_4ea.Line=_4e5("dojox.gfx.shape.Line",_4ea.Shape,{constructor:function(_510){this.shape=g.getDefault("Line");this.rawNode=_510;},getBoundingBox:function(){if(!this.bbox){var _511=this.shape;this.bbox={x:Math.min(_511.x1,_511.x2),y:Math.min(_511.y1,_511.y2),width:Math.abs(_511.x2-_511.x1),height:Math.abs(_511.y2-_511.y1)};}return this.bbox;}});_4ea.Polyline=_4e5("dojox.gfx.shape.Polyline",_4ea.Shape,{constructor:function(_512){this.shape=g.getDefault("Polyline");this.rawNode=_512;},setShape:function(_513,_514){if(_513&&_513 instanceof Array){this.inherited(arguments,[{points:_513}]);if(_514&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_513]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _515=[];for(var i=0;i<l;i+=2){_515.push({x:p[i],y:p[i+1]});}this.shape.points=_515;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_4ea.Image=_4e5("dojox.gfx.shape.Image",_4ea.Shape,{constructor:function(_516){this.shape=g.getDefault("Image");this.rawNode=_516;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_4ea.Text=_4e5(_4ea.Shape,{constructor:function(_517){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_517;},getFont:function(){return this.fontStyle;},setFont:function(_518){this.fontStyle=typeof _518=="string"?g.splitFontString(_518):g.makeParameters(g.defaultFont,_518);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_4ea.Creator={createShape:function(_519){switch(_519.type){case g.defaultPath.type:return this.createPath(_519);case g.defaultRect.type:return this.createRect(_519);case g.defaultCircle.type:return this.createCircle(_519);case g.defaultEllipse.type:return this.createEllipse(_519);case g.defaultLine.type:return this.createLine(_519);case g.defaultPolyline.type:return this.createPolyline(_519);case g.defaultImage.type:return this.createImage(_519);case g.defaultText.type:return this.createText(_519);case g.defaultTextPath.type:return this.createTextPath(_519);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_51a){return this.createObject(g.Ellipse,_51a);},createCircle:function(_51b){return this.createObject(g.Circle,_51b);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_51c){return this.createObject(g.Polyline,_51c);},createImage:function(_51d){return this.createObject(g.Image,_51d);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_51e,_51f){return null;}};return _4ea;});},"dojox/charting/Chart2D":function(){define(["dojo/_base/kernel","dojo/_base/lang","..","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(_520,lang,_521,_522){_520.deprecated("dojox.charting.Chart2D","Use dojox.charting.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.Chart2D",_522);});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_523){var _524=lang.getObject("dojox.charting.scaler.linear",true);var _525=3,_526=_523.getNumericLabel;function _527(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _528=function(min,max,_529,_52a,_52b,_52c,span){_529=lang.delegate(_529);if(!_52a){if(_529.fixUpper=="major"){_529.fixUpper="minor";}if(_529.fixLower=="major"){_529.fixLower="minor";}}if(!_52b){if(_529.fixUpper=="minor"){_529.fixUpper="micro";}if(_529.fixLower=="minor"){_529.fixLower="micro";}}if(!_52c){if(_529.fixUpper=="micro"){_529.fixUpper="none";}if(_529.fixLower=="micro"){_529.fixLower="none";}}var _52d=_527(_529.fixLower,["major"])?Math.floor(_529.min/_52a)*_52a:_527(_529.fixLower,["minor"])?Math.floor(_529.min/_52b)*_52b:_527(_529.fixLower,["micro"])?Math.floor(_529.min/_52c)*_52c:_529.min,_52e=_527(_529.fixUpper,["major"])?Math.ceil(_529.max/_52a)*_52a:_527(_529.fixUpper,["minor"])?Math.ceil(_529.max/_52b)*_52b:_527(_529.fixUpper,["micro"])?Math.ceil(_529.max/_52c)*_52c:_529.max;if(_529.useMin){min=_52d;}if(_529.useMax){max=_52e;}var _52f=(!_52a||_529.useMin&&_527(_529.fixLower,["major"]))?min:Math.ceil(min/_52a)*_52a,_530=(!_52b||_529.useMin&&_527(_529.fixLower,["major","minor"]))?min:Math.ceil(min/_52b)*_52b,_531=(!_52c||_529.useMin&&_527(_529.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_52c)*_52c,_532=!_52a?0:(_529.useMax&&_527(_529.fixUpper,["major"])?Math.round((max-_52f)/_52a):Math.floor((max-_52f)/_52a))+1,_533=!_52b?0:(_529.useMax&&_527(_529.fixUpper,["major","minor"])?Math.round((max-_530)/_52b):Math.floor((max-_530)/_52b))+1,_534=!_52c?0:(_529.useMax&&_527(_529.fixUpper,["major","minor","micro"])?Math.round((max-_531)/_52c):Math.floor((max-_531)/_52c))+1,_535=_52b?Math.round(_52a/_52b):0,_536=_52c?Math.round(_52b/_52c):0,_537=_52a?Math.floor(Math.log(_52a)/Math.LN10):0,_538=_52b?Math.floor(Math.log(_52b)/Math.LN10):0,_539=span/(max-min);if(!isFinite(_539)){_539=1;}return {bounds:{lower:_52d,upper:_52e,from:min,to:max,scale:_539,span:span},major:{tick:_52a,start:_52f,count:_532,prec:_537},minor:{tick:_52b,start:_530,count:_533,prec:_538},micro:{tick:_52c,start:_531,count:_534,prec:0},minorPerMajor:_535,microPerMinor:_536,scaler:_524};};return lang.mixin(_524,{buildScaler:function(min,max,span,_53a,_53b,_53c){var h={fixUpper:"none",fixLower:"none",natural:false};if(_53a){if("fixUpper" in _53a){h.fixUpper=String(_53a.fixUpper);}if("fixLower" in _53a){h.fixLower=String(_53a.fixLower);}if("natural" in _53a){h.natural=Boolean(_53a.natural);}}_53c=!_53c||_53c<_525?_525:_53c;if("min" in _53a){min=_53a.min;}if("max" in _53a){max=_53a.max;}if(_53a.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _53a){min=_53a.from;h.useMin=false;}if("to" in _53a){max=_53a.to;h.useMax=false;}if(max<=min){return _528(min,max,h,0,0,0,span);}if(!_53b){_53b=max-min;}var mag=Math.floor(Math.log(_53b)/Math.LN10),_53d=_53a&&("majorTickStep" in _53a)?_53a.majorTickStep:Math.pow(10,mag),_53e=0,_53f=0,_540;if(_53a&&("minorTickStep" in _53a)){_53e=_53a.minorTickStep;}else{do{_53e=_53d/10;if(!h.natural||_53e>0.9){_540=_528(min,max,h,_53d,_53e,0,span);if(_540.bounds.scale*_540.minor.tick>_53c){break;}}_53e=_53d/5;if(!h.natural||_53e>0.9){_540=_528(min,max,h,_53d,_53e,0,span);if(_540.bounds.scale*_540.minor.tick>_53c){break;}}_53e=_53d/2;if(!h.natural||_53e>0.9){_540=_528(min,max,h,_53d,_53e,0,span);if(_540.bounds.scale*_540.minor.tick>_53c){break;}}return _528(min,max,h,_53d,0,0,span);}while(false);}if(_53a&&("microTickStep" in _53a)){_53f=_53a.microTickStep;_540=_528(min,max,h,_53d,_53e,_53f,span);}else{do{_53f=_53e/10;if(!h.natural||_53f>0.9){_540=_528(min,max,h,_53d,_53e,_53f,span);if(_540.bounds.scale*_540.micro.tick>_525){break;}}_53f=_53e/5;if(!h.natural||_53f>0.9){_540=_528(min,max,h,_53d,_53e,_53f,span);if(_540.bounds.scale*_540.micro.tick>_525){break;}}_53f=_53e/2;if(!h.natural||_53f>0.9){_540=_528(min,max,h,_53d,_53e,_53f,span);if(_540.bounds.scale*_540.micro.tick>_525){break;}}_53f=0;}while(false);}return _53f?_540:_528(min,max,h,_53d,_53e,0,span);},buildTicks:function(_541,_542){var step,next,tick,_543=_541.major.start,_544=_541.minor.start,_545=_541.micro.start;if(_542.microTicks&&_541.micro.tick){step=_541.micro.tick,next=_545;}else{if(_542.minorTicks&&_541.minor.tick){step=_541.minor.tick,next=_544;}else{if(_541.major.tick){step=_541.major.tick,next=_543;}else{return null;}}}var _546=1/_541.bounds.scale;if(_541.bounds.to<=_541.bounds.from||isNaN(_546)||!isFinite(_546)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _547=[],_548=[],_549=[];while(next<=_541.bounds.to+_546){if(Math.abs(_543-next)<step/2){tick={value:_543};if(_542.majorLabels){tick.label=_526(_543,_541.major.prec,_542);}_547.push(tick);_543+=_541.major.tick;_544+=_541.minor.tick;_545+=_541.micro.tick;}else{if(Math.abs(_544-next)<step/2){if(_542.minorTicks){tick={value:_544};if(_542.minorLabels&&(_541.minMinorStep<=_541.minor.tick*_541.bounds.scale)){tick.label=_526(_544,_541.minor.prec,_542);}_548.push(tick);}_544+=_541.minor.tick;_545+=_541.micro.tick;}else{if(_542.microTicks){_549.push({value:_545});}_545+=_541.micro.tick;}}next+=step;}return {major:_547,minor:_548,micro:_549};},getTransformerFromModel:function(_54a){var _54b=_54a.bounds.from,_54c=_54a.bounds.scale;return function(x){return (x-_54b)*_54c;};},getTransformerFromPlot:function(_54d){var _54e=_54d.bounds.from,_54f=_54d.bounds.scale;return function(x){return x/_54f+_54e;};}});});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_550){var _551=null;has.add("vml",function(_552,_553,_554){_554.innerHTML="<v:shape adj=\"1\"/>";var _555=("adj" in _554.firstChild);_554.innerHTML="";return _555;});return {load:function(id,_556,load){if(_551&&id!="force"){load(_551);return;}var _557=_550.forceGfxRenderer,_558=!_557&&(lang.isString(_550.gfxRenderer)?_550.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_559,_55a;while(!_557&&_558.length){switch(_558.shift()){case "svg":if("SVGAngle" in win.global){_557="svg";}break;case "vml":if(has("vml")){_557="vml";}break;case "silverlight":try{if(has("ie")){_559=new ActiveXObject("AgControl.AgControl");if(_559&&_559.IsVersionSupported("1.0")){_55a=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_55a=true;}}}catch(e){_55a=false;}finally{_559=null;}if(_55a){_557="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_557="canvas";}break;}}if(_557==="canvas"&&_550.canvasEvents!==false){_557="canvasWithEvents";}if(_550.isDebug){}function _55b(){_556(["dojox/gfx/"+_557],function(_55c){g.renderer=_557;_551=_55c;load(_55c);});};if(_557=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_55b);}else{_55b();}}};});},"dojox/charting/widget/Chart":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/dom-attr","dojo/_base/declare","dojo/query","dijit/_WidgetBase","../Chart","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda"],function(_55d,lang,arr,_55e,_55f,_560,_561,_562,has,_563,du,df,dfl){var _564,_565,_566,_567,_568,_569=function(o){return o;},dc=lang.getObject("dojox.charting");_564=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_565=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=_55d._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=_55d._scopeName+"x.charting.axis2d.Default";}_564(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_566=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=_55d._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=_55d._scopeName+"x.charting.plot2d.Default";}_564(node,type,kw);var dp=eval("("+type+".prototype.baseParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}return o;};_567=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=_55d._scopeName+"x.charting.action2d."+type;}var _56a=eval("("+type+")");if(!_56a){return null;}o.action=_56a;}else{return null;}_564(node,type,kw);return o;};_568=function(node){var ga=lang.partial(_55e.get,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};var _56b=_55f(has("dojo-bidi")?"dojox.charting.widget.NonBidiChart":"dojox.charting.widget.Chart",_561,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);var n=this.domNode;var axes=_560("> .axis",n).map(_565).filter(_569),_56c=_560("> .plot",n).map(_566).filter(_569),_56d=_560("> .action",n).map(_567).filter(_569),_56e=_560("> .series",n).map(_568).filter(_569);n.innerHTML="";var c=this.chart=new _562(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_56c.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_56d.map(function(_56f){return new _56f.action(c,_56f.plot,_56f.kwArgs);});var _570=df.foldl(_56e,function(_571,_572){if(_572.type=="data"){c.addSeries(_572.name,_572.data,_572.kwArgs);_571=true;}else{c.addSeries(_572.name,[0],_572.kwArgs);var kw={};du.updateWithPattern(kw,_572.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_572.kwArgs.sort){kw.sort=lang.clone(_572.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _573;if("valueFn" in _572.kwArgs){var fn=_572.kwArgs.valueFn;_573=arr.map(data,function(x){return fn(_572.data.getValue(x,_572.field,0));});}else{_573=arr.map(data,function(x){return _572.data.getValue(x,_572.field,0);});}c.addSeries(_572.name,_573,_572.kwArgs).render();}});_572.data.fetch(kw);}return _571;},false);if(_570){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize.apply(this.chart,arguments);}});return has("dojo-bidi")?_55f("dojox.charting.widget.Chart",[_56b,_563]):_56b;});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _574=lang.getObject("dojox.charting.scaler.common",true);var _575={};return lang.mixin(_574,{doIfLoaded:function(_576,_577,_578){if(_575[_576]==undefined){try{_575[_576]=require(_576);}catch(e){_575[_576]=null;}}if(_575[_576]){return _577(_575[_576]);}else{return _578();}},getNumericLabel:function(_579,_57a,_57b){var def="";_574.doIfLoaded("dojo/number",function(_57c){def=(_57b.fixed?_57c.format(_579,{places:_57a<0?-_57a:0}):_57c.format(_579))||"";},function(){def=_57b.fixed?_579.toFixed(_57a<0?-_57a:0):_579.toString();});if(_57b.labelFunc){var r=_57b.labelFunc(def,_579,_57a);if(r){return r;}}if(_57b.labels){var l=_57b.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_579){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_579)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_579)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_579)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_57d,g,has){var _57e=lang.getObject("dojox.charting.axis2d.common",true);var _57f=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _580=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _57d.getMarginBox(n).w;}};return lang.mixin(_57e,{createText:{gfx:function(_581,_582,x,y,_583,text,font,_584){return _582.createText({x:x,y:y,text:text,align:_583}).setFont(font).setFill(_584);},html:function(_585,_586,x,y,_587,text,font,_588,_589){var p=win.doc.createElement("div"),s=p.style,_58a;if(_585.getTextDir){p.dir=_585.getTextDir(text);}_57f(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_588;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_589){_58a=_580(p);}if(p.dir=="rtl"){x+=_589?_589:_58a;}win.body().removeChild(p);s.position="relative";if(_589){s.width=_589+"px";switch(_587){case "middle":s.textAlign="center";s.left=(x-_589/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_589)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_587){case "middle":s.left=Math.floor(x-_58a/2)+"px";break;case "end":s.left=Math.floor(x-_58a)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_57f(w);w.width="0px";w.height="0px";wrap.appendChild(p);_585.node.insertBefore(wrap,_585.node.firstChild);if(has("dojo-bidi")){_585.htmlElementsRegistry.push([wrap,x,y,_587,text,font,_588]);}return wrap;}}});});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_58b,_58c,_58d,lang,on,has,_58e,_58f){var _590=_58c("dijit._TemplatedMixin",_58f,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _591=this.declaredClass,_592=this;return _58e.substitute(tmpl,this,function(_593,key){if(key.charAt(0)=="!"){_593=lang.getObject(key.substr(1),false,_592);}if(typeof _593=="undefined"){throw new Error(_591+" template:"+key);}if(_593==null){return "";}return key.charAt(0)=="!"?_593:_593.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_58b(this.templatePath,{sanitize:true});}var _594=_590.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_594)){node=_58d.toDom(this._stringRepl(_594),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_594);}}else{node=_594.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_595){var dest=this.containerNode;if(_595&&dest){while(_595.hasChildNodes()){dest.appendChild(_595.firstChild);}}}});_590._templateCache={};_590.getCachedTemplate=function(_596,_597,doc){var _598=_590._templateCache;var key=_596;var _599=_598[key];if(_599){try{if(!_599.ownerDocument||_599.ownerDocument==(doc||document)){return _599;}}catch(e){}_58d.destroy(_599);}_596=_58e.trim(_596);if(_597||_596.match(/\$\{([^\}]+)\}/g)){return (_598[key]=_596);}else{var node=_58d.toDom(_596,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_596);}return (_598[key]=node);}};if(has("ie")){on(window,"unload",function(){var _59a=_590._templateCache;for(var key in _59a){var _59b=_59a[key];if(typeof _59b=="object"){_58d.destroy(_59b);}delete _59a[key];}});}return _590;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_59c,lang,df){var _59d={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _59d)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _59d)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_59c.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _59d)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_59c.global;f=df.lambda(f);for(var i in obj){if(!(i in _59d)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_59c.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _59d)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_59e,dom,geom,_59f,_5a0){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_59e.body(doc),_5a1=_5a0.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_5a0.create("div",{style:{overflow:"hidden",direction:"ltr"}},_5a1,"last"),ret=geom.position(div).x!=0;_5a1.removeChild(div);body.removeChild(_5a1);return ret;});has.add("position-fixed-support",function(win,doc){var body=_59e.body(doc),_5a2=_5a0.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_5a3=_5a0.create("span",{style:{position:"fixed",left:"0",top:"0"}},_5a2,"last"),ret=geom.position(_5a3).x!=geom.position(_5a2).x;_5a2.removeChild(_5a3);body.removeChild(_5a2);return ret;});var _5a4={getBox:function(doc){doc=doc||_59e.doc;var _5a5=(doc.compatMode=="BackCompat")?_59e.body(doc):doc.documentElement,_5a6=geom.docScroll(doc),w,h;if(has("touch")){var _5a7=_5a4.get(doc);w=_5a7.innerWidth||_5a5.clientWidth;h=_5a7.innerHeight||_5a5.clientHeight;}else{w=_5a5.clientWidth;h=_5a5.clientHeight;}return {l:_5a6.x,t:_5a6.y,w:w,h:h};},get:function(doc){if(has("ie")&&_5a4!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_59e.doc,body=_59e.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _5a8=doc.compatMode=="BackCompat",_5a9=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_5aa=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_5ab=(isWK||_5a8)?body:html,_5ac=pos||geom.position(node),el=node.parentNode,_5ad=function(el){return (isIE<=6||(isIE==7&&_5a8))?false:(has("position-fixed-support")&&(_59f.get(el,"position").toLowerCase()=="fixed"));};if(_5ad(node)){return;}while(el){if(el==body){el=_5ab;}var _5ae=geom.position(el),_5af=_5ad(el),rtl=_59f.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_5ab){_5ae.w=_5a9;_5ae.h=_5aa;if(_5ab==html&&isIE&&rtl){_5ae.x+=_5ab.offsetWidth-_5ae.w;}if(_5ae.x<0||!isIE||isIE>=9){_5ae.x=0;}if(_5ae.y<0||!isIE||isIE>=9){_5ae.y=0;}}else{var pb=geom.getPadBorderExtents(el);_5ae.w-=pb.w;_5ae.h-=pb.h;_5ae.x+=pb.l;_5ae.y+=pb.t;var _5b0=el.clientWidth,_5b1=_5ae.w-_5b0;if(_5b0>0&&_5b1>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_5ae.x+=_5b1;}_5ae.w=_5b0;}_5b0=el.clientHeight;_5b1=_5ae.h-_5b0;if(_5b0>0&&_5b1>0){_5ae.h=_5b0;}}if(_5af){if(_5ae.y<0){_5ae.h+=_5ae.y;_5ae.y=0;}if(_5ae.x<0){_5ae.w+=_5ae.x;_5ae.x=0;}if(_5ae.y+_5ae.h>_5aa){_5ae.h=_5aa-_5ae.y;}if(_5ae.x+_5ae.w>_5a9){_5ae.w=_5a9-_5ae.x;}}var l=_5ac.x-_5ae.x,t=_5ac.y-_5ae.y,r=l+_5ac.w-_5ae.w,bot=t+_5ac.h-_5ae.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_5ab||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_5a8)||isIE>=9)){s=-s;}old=el.scrollLeft;el.scrollLeft+=s;s=el.scrollLeft-old;_5ac.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_5ab||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;el.scrollTop+=s;s=el.scrollTop-old;_5ac.y-=s;}el=(el!=_5ab)&&!_5af&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_5a4);return _5a4;});},"dojox/charting/axis2d/Default":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/has!dojo-bidi?../bidi/axis2d/Default"],function(lang,arr,has,_5b2,_5b3,_5b4,_5b5,lin,_5b6,g,du,df,_5b7){var _5b8=45;var _5b9=_5b2(has("dojo-bidi")?"dojox.charting.axis2d.NonBidiDefault":"dojox.charting.axis2d.Default",_5b5,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_5ba,_5bb){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_5bb);du.updateWithPattern(this.opt,_5bb,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;},setWindow:function(_5bc,_5bd){if(_5bc!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_5be,font,_5bf){if(!_5be.length){return 0;}if(_5be.length>50){_5be.length=50;}if(lang.isObject(_5be[0])){_5be=df.map(_5be,function(_5c0){return _5c0.text;});}if(_5bf){_5be=df.map(_5be,function(_5c1){return lang.trim(_5c1).length==0?"":_5c1.substring(0,_5bf)+this.trailingSymbol;},this);}var s=_5be.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_5c2,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _5c3=0,_5c4=0;var _5c5=function(tick){if(tick.label){this.push(tick.label);}};var _5c6=[];if(this.opt.majorLabels){arr.forEach(tb.major,_5c5,_5c6);_5c3=this._groupLabelWidth(_5c6,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5c3=Math.min(ob.maxLabelSize,_5c3);}}_5c6=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_5c5,_5c6);_5c4=this._groupLabelWidth(_5c6,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5c4=Math.min(ob.maxLabelSize,_5c4);}}this._maxLabelSize={majLabelW:_5c3,minLabelW:_5c4,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_5c7=o.rotation%360,_5c8=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_5c9=this._getMaxLabelSize(min,max,span,_5c7,font,size);if(typeof _5c8!="number"){_5c8=4;}if(_5c9&&o.dropLabels){var cosr=Math.abs(Math.cos(_5c7*Math.PI/180)),sinr=Math.abs(Math.sin(_5c7*Math.PI/180));var _5ca,_5cb;if(_5c7<0){_5c7+=360;}switch(_5c7){case 0:case 180:if(this.vertical){_5ca=_5cb=size;}else{_5ca=_5c9.majLabelW;_5cb=_5c9.minLabelW;}break;case 90:case 270:if(this.vertical){_5ca=_5c9.majLabelW;_5cb=_5c9.minLabelW;}else{_5ca=_5cb=size;}break;default:_5ca=this.vertical?Math.min(_5c9.majLabelW,size/cosr):Math.min(_5c9.majLabelW,size/sinr);var gap1=Math.sqrt(_5c9.minLabelW*_5c9.minLabelW+size*size),gap2=this.vertical?size*cosr+_5c9.minLabelW*sinr:_5c9.minLabelW*cosr+size*sinr;_5cb=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_5ca,_5cb)+_5c8;var _5cc=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_5cc){this._skipInterval=Math.floor((_5ca+_5c8)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_5cd={l:0,r:0,t:0,b:0};if(!s){return _5cd;}var o=this.opt,ta=this.chart.theme.axis,_5ce=this.chart.theme.axis.tick.labelGap,_5cf=o.titleFont||(ta.title&&ta.title.font),_5d0=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_5d1=this.chart.theme.getTick("major",o),_5d2=this.chart.theme.getTick("minor",o),_5d3=_5cf?g.normalizedLength(g.splitFontString(_5cf).size):0,_5d4=o.rotation%360,_5d5=o.leftBottom,cosr=Math.abs(Math.cos(_5d4*Math.PI/180)),sinr=Math.abs(Math.sin(_5d4*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _5ce!="number"){_5ce=4;}if(_5d4<0){_5d4+=360;}var _5d6=this._getMaxLabelSize();if(_5d6){var side;var _5d7=Math.ceil(Math.max(_5d6.majLabelW,_5d6.minLabelW))+1,size=Math.ceil(Math.max(_5d6.majLabelH,_5d6.minLabelH))+1;if(this.vertical){side=_5d5?"l":"r";switch(_5d4){case 0:case 180:_5cd[side]=_5d7;_5cd.t=_5cd.b=size/2;break;case 90:case 270:_5cd[side]=size;_5cd.t=_5cd.b=_5d7/2;break;default:if(_5d4<=_5b8||(180<_5d4&&_5d4<=(180+_5b8))){_5cd[side]=size*sinr/2+_5d7*cosr;_5cd[_5d5?"t":"b"]=size*cosr/2+_5d7*sinr;_5cd[_5d5?"b":"t"]=size*cosr/2;}else{if(_5d4>(360-_5b8)||(180>_5d4&&_5d4>(180-_5b8))){_5cd[side]=size*sinr/2+_5d7*cosr;_5cd[_5d5?"b":"t"]=size*cosr/2+_5d7*sinr;_5cd[_5d5?"t":"b"]=size*cosr/2;}else{if(_5d4<90||(180<_5d4&&_5d4<270)){_5cd[side]=size*sinr+_5d7*cosr;_5cd[_5d5?"t":"b"]=size*cosr+_5d7*sinr;}else{_5cd[side]=size*sinr+_5d7*cosr;_5cd[_5d5?"b":"t"]=size*cosr+_5d7*sinr;}}}break;}_5cd[side]+=_5ce+Math.max(_5d1.length>0?_5d1.length:0,_5d2.length>0?_5d2.length:0)+(o.title?(_5d3+_5d0):0);}else{side=_5d5?"b":"t";switch(_5d4){case 0:case 180:_5cd[side]=size;_5cd.l=_5cd.r=_5d7/2;break;case 90:case 270:_5cd[side]=_5d7;_5cd.l=_5cd.r=size/2;break;default:if((90-_5b8)<=_5d4&&_5d4<=90||(270-_5b8)<=_5d4&&_5d4<=270){_5cd[side]=size*cosr/2+_5d7*sinr;_5cd[_5d5?"r":"l"]=size*sinr/2+_5d7*cosr;_5cd[_5d5?"l":"r"]=size*sinr/2;}else{if(90<=_5d4&&_5d4<=(90+_5b8)||270<=_5d4&&_5d4<=(270+_5b8)){_5cd[side]=size*cosr/2+_5d7*sinr;_5cd[_5d5?"l":"r"]=size*sinr/2+_5d7*cosr;_5cd[_5d5?"r":"l"]=size*sinr/2;}else{if(_5d4<_5b8||(180<_5d4&&_5d4<(180+_5b8))){_5cd[side]=size*cosr+_5d7*sinr;_5cd[_5d5?"r":"l"]=size*sinr+_5d7*cosr;}else{_5cd[side]=size*cosr+_5d7*sinr;_5cd[_5d5?"l":"r"]=size*sinr+_5d7*cosr;}}}break;}_5cd[side]+=_5ce+Math.max(_5d1.length>0?_5d1.length:0,_5d2.length>0?_5d2.length:0)+(o.title?(_5d3+_5d0):0);}}return _5cd;},cleanGroup:function(_5d8){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_5d9,_5da,x,y,_5db,_5dc,font,_5dd,_5de){if(!this.opt.enableCache||_5d9=="html"){return _5b6.createText[_5d9](this.chart,_5da,x,y,_5db,_5dc,font,_5dd,_5de);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_5dc,align:_5db});_5da.add(text);}else{text=_5b6.createText[_5d9](this.chart,_5da,x,y,_5db,_5dc,font,_5dd);}this._textUsePool.push(text);return text;},createLine:function(_5df,_5e0){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_5e0);_5df.add(line);}else{line=_5df.createLine(_5e0);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_5e1){var _5e2=this._isRtl();if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_5e3=o.leftBottom,_5e4=o.rotation%360,_5e5,stop,_5e6,_5e7=0,_5e8,_5e9,_5ea,_5eb,_5ec,_5ed,_5ee=this.chart.theme.axis.tick.labelGap,_5ef=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_5f0=o.titleFont||(ta.title&&ta.title.font),_5f1=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_5f2=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_5f3=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_5f4=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_5f5=this.chart.theme.getTick("major",o),_5f6=this.chart.theme.getTick("minor",o),_5f7=this.chart.theme.getTick("micro",o),_5f8="stroke" in o?o.stroke:ta.stroke,size=_5ef?g.normalizedLength(g.splitFontString(_5ef).size):0,cosr=Math.abs(Math.cos(_5e4*Math.PI/180)),sinr=Math.abs(Math.sin(_5e4*Math.PI/180)),_5f9=_5f0?g.normalizedLength(g.splitFontString(_5f0).size):0;if(typeof _5ee!="number"){_5ee=4;}if(_5e4<0){_5e4+=360;}var _5fa=this._getMaxLabelSize();_5fa=_5fa&&_5fa.majLabelW;if(this.vertical){_5e5={y:dim.height-_5e1.b};stop={y:_5e1.t};_5e6={y:(dim.height-_5e1.b+_5e1.t)/2};_5e8=size*sinr+(_5fa||0)*cosr+_5ee+Math.max(_5f5.length>0?_5f5.length:0,_5f6.length>0?_5f6.length:0)+_5f9+_5f3;_5e9={x:0,y:-1};_5ec={x:0,y:0};_5ea={x:1,y:0};_5eb={x:_5ee,y:0};switch(_5e4){case 0:_5ed="end";_5ec.y=size*0.4;break;case 90:_5ed="middle";_5ec.x=-size;break;case 180:_5ed="start";_5ec.y=-size*0.4;break;case 270:_5ed="middle";break;default:if(_5e4<_5b8){_5ed="end";_5ec.y=size*0.4;}else{if(_5e4<90){_5ed="end";_5ec.y=size*0.4;}else{if(_5e4<(180-_5b8)){_5ed="start";}else{if(_5e4<(180+_5b8)){_5ed="start";_5ec.y=-size*0.4;}else{if(_5e4<270){_5ed="start";_5ec.x=_5e3?0:size*0.4;}else{if(_5e4<(360-_5b8)){_5ed="end";_5ec.x=_5e3?0:size*0.4;}else{_5ed="end";_5ec.y=size*0.4;}}}}}}}if(_5e3){_5e5.x=stop.x=_5e1.l;_5e7=(_5f4&&_5f4=="away")?90:270;_5e6.x=_5e1.l-_5e8+(_5e7==270?_5f9:0);_5ea.x=-1;_5eb.x=-_5eb.x;}else{_5e5.x=stop.x=dim.width-_5e1.r;_5e7=(_5f4&&_5f4=="axis")?90:270;_5e6.x=dim.width-_5e1.r+_5e8-(_5e7==270?0:_5f9);switch(_5ed){case "start":_5ed="end";break;case "end":_5ed="start";break;case "middle":_5ec.x+=size;break;}}}else{_5e5={x:_5e1.l};stop={x:dim.width-_5e1.r};_5e6={x:(dim.width-_5e1.r+_5e1.l)/2};_5e8=size*cosr+(_5fa||0)*sinr+_5ee+Math.max(_5f5.length>0?_5f5.length:0,_5f6.length>0?_5f6.length:0)+_5f9+_5f3;_5e9={x:_5e2?-1:1,y:0};_5ec={x:0,y:0};_5ea={x:0,y:1};_5eb={x:0,y:_5ee};switch(_5e4){case 0:_5ed="middle";_5ec.y=size;break;case 90:_5ed="start";_5ec.x=-size*0.4;break;case 180:_5ed="middle";break;case 270:_5ed="end";_5ec.x=size*0.4;break;default:if(_5e4<(90-_5b8)){_5ed="start";_5ec.y=_5e3?size:0;}else{if(_5e4<(90+_5b8)){_5ed="start";_5ec.x=-size*0.4;}else{if(_5e4<180){_5ed="start";_5ec.y=_5e3?0:-size;}else{if(_5e4<(270-_5b8)){_5ed="end";_5ec.y=_5e3?0:-size;}else{if(_5e4<(270+_5b8)){_5ed="end";_5ec.y=_5e3?size*0.4:0;}else{_5ed="end";_5ec.y=_5e3?size:0;}}}}}}if(_5e3){_5e5.y=stop.y=dim.height-_5e1.b;_5e7=(_5f4&&_5f4=="axis")?180:0;_5e6.y=dim.height-_5e1.b+_5e8-(_5e7?_5f9:0);}else{_5e5.y=stop.y=_5e1.t;_5e7=(_5f4&&_5f4=="away")?180:0;_5e6.y=_5e1.t-_5e8+(_5e7?0:_5f9);_5ea.y=-1;_5eb.y=-_5eb.y;switch(_5ed){case "start":_5ed="end";break;case "end":_5ed="start";break;case "middle":_5ec.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_5fb=(!o.title||!_5e7)&&!_5e4&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_5ea.x*_5f5.length,dy=_5ea.y*_5f5.length,skip=this._skipInterval;s.createLine({x1:_5e5.x,y1:_5e5.y,x2:stop.x,y2:stop.y}).setStroke(_5f8);if(o.title){var _5fc=_5b6.createText[_5fb](this.chart,s,_5e6.x,_5e6.y,"middle",o.title,_5f0,_5f2);if(_5fb=="html"){this.htmlElements.push(_5fc);}else{_5fc.setTransform(g.matrix.rotategAt(_5e7,_5e6.x,_5e6.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _5fd=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _5fe=f(tick.value),elem,x=(_5e2?stop.x:_5e5.x)+_5e9.x*_5fe,y=_5e5.y+_5e9.y*_5fe;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f5);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _5ff=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5ef,o.maxLabelCharCount):{text:tick.label,truncated:false};_5ff=o.maxLabelSize?this.getTextWithLimitLength(_5ff.text,_5ef,o.maxLabelSize,_5ff.truncated):_5ff;elem=this.createText(_5fb,s,x+(_5f5.length>0?dx:0)+_5eb.x+(_5e4?0:_5ec.x),y+(_5f5.length>0?dy:0)+_5eb.y+(_5e4?0:_5ec.y),_5ed,_5ff.text,_5ef,_5f1);if(_5ff.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_5fb);}_5ff.truncated&&this.labelTooltip(elem,this.chart,tick.label,_5ff.text,_5ef,_5fb);if(_5fb=="html"){this.htmlElements.push(elem);}else{if(_5e4){elem.setTransform([{dx:_5ec.x,dy:_5ec.y},g.matrix.rotategAt(_5e4,x+(_5f5.length>0?dx:0)+_5eb.x,y+(_5f5.length>0?dy:0)+_5eb.y)]);}}}},this);dx=_5ea.x*_5f6.length;dy=_5ea.y*_5f6.length;_5fd=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _600=f(tick.value),elem,x=(_5e2?stop.x:_5e5.x)+_5e9.x*_600,y=_5e5.y+_5e9.y*_600;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f6);if(_5fd&&tick.label){var _601=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5ef,o.maxLabelCharCount):{text:tick.label,truncated:false};_601=o.maxLabelSize?this.getTextWithLimitLength(_601.text,_5ef,o.maxLabelSize,_601.truncated):_601;elem=this.createText(_5fb,s,x+(_5f6.length>0?dx:0)+_5eb.x+(_5e4?0:_5ec.x),y+(_5f6.length>0?dy:0)+_5eb.y+(_5e4?0:_5ec.y),_5ed,_601.text,_5ef,_5f1);if(_601.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_5fb);}_601.truncated&&this.labelTooltip(elem,this.chart,tick.label,_601.text,_5ef,_5fb);if(_5fb=="html"){this.htmlElements.push(elem);}else{if(_5e4){elem.setTransform([{dx:_5ec.x,dy:_5ec.y},g.matrix.rotategAt(_5e4,x+(_5f6.length>0?dx:0)+_5eb.x,y+(_5f6.length>0?dy:0)+_5eb.y)]);}}}},this);dx=_5ea.x*_5f7.length;dy=_5ea.y*_5f7.length;arr.forEach(t.micro,function(tick){var _602=f(tick.value),x=_5e5.x+_5e9.x*_602,y=_5e5.y+_5e9.y*_602;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f7);},this);this.dirty=false;return this;},labelTooltip:function(elem,_603,_604,_605,font,_606){var _607=["dijit/Tooltip"];var _608={type:"rect"},_609=["above","below"],_60a=g._base._getTextBox(_605,{font:font}).w||0,_60b=font?g.normalizedLength(g.splitFontString(font).size):0;if(_606=="html"){lang.mixin(_608,_5b4.position(elem.firstChild,true));_608.width=Math.ceil(_60a);_608.height=Math.ceil(_60b);this._events.push({shape:dojo,handle:_5b3.connect(elem.firstChild,"onmouseover",this,function(e){require(_607,function(_60c){_60c.show(_604,_608,_609);});})});this._events.push({shape:dojo,handle:_5b3.connect(elem.firstChild,"onmouseout",this,function(e){require(_607,function(_60d){_60d.hide(_608);});})});}else{var shp=elem.getShape(),lt=_603.getCoords();_608=lang.mixin(_608,{x:shp.x-_60a/2,y:shp.y});_608.x+=lt.x;_608.y+=lt.y;_608.x=Math.round(_608.x);_608.y=Math.round(_608.y);_608.width=Math.ceil(_60a);_608.height=Math.ceil(_60b);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_607,function(_60e){_60e.show(_604,_608,_609);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_607,function(_60f){_60f.hide(_608);});})});}},_isRtl:function(){return false;}});return has("dojo-bidi")?_5b2("dojox.charting.axis2d.Default",[_5b9,_5b7]):_5b9;});},"dojox/charting/plot2d/ClusteredBars":function(){define(["dojo/_base/declare","./Bars","./common"],function(_610,Bars,dc){return _610("dojox.charting.plot2d.ClusteredBars",Bars,{getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,height:f.size,thickness:f.size};}});});},"dojox/charting/action2d/MoveSlice":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/array","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_611,_612,_613,dfe,m,gf,df){var _614=1.05,_615=7;return _611("dojox.charting.action2d.MoveSlice",_613,{defaultParams:{duration:400,easing:dfe.backOut,scale:_614,shift:_615},optionalParams:{},constructor:function(_616,plot,_617){if(!_617){_617={};}this.scale=typeof _617.scale=="number"?_617.scale:_614;this.shift=typeof _617.shift=="number"?_617.shift:_615;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _618=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}this.angles=_612.map(this.angles,function(item){return item+_618;});}var _619=o.index,anim,_61a,_61b,_61c,_61d,_61e=(this.angles[_619]+this.angles[_619+1])/2,_61f=m.rotateAt(-_61e,o.cx,o.cy),_620=m.rotateAt(_61e,o.cx,o.cy);anim=this.anim[_619];if(anim){anim.action.stop(true);}else{this.anim[_619]=anim={};}if(o.type=="onmouseover"){_61c=0;_61d=this.shift;_61a=1;_61b=this.scale;}else{_61c=this.shift;_61d=0;_61a=this.scale;_61b=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_620,{name:"translate",start:[_61c,0],end:[_61d,0]},{name:"scaleAt",start:[_61a,o.cx,o.cy],end:[_61b,o.cx,o.cy]},_61f]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_619];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_621,_622){var _623={};lang.setObject("dojo.colors",_623);var _624=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_621.fromRgb=function(_625,obj){var m=_625.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_622.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _621.fromArray(a,obj);}return _621.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_624(m1,m2,H+1/3)*256,_624(m1,m2,H)*256,_624(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _621.fromArray(a,obj);}}return null;};var _626=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_621.prototype.sanitize=function(){var t=this;t.r=Math.round(_626(t.r,0,255));t.g=Math.round(_626(t.g,0,255));t.b=Math.round(_626(t.b,0,255));t.a=_626(t.a,0,1);return this;};_623.makeGrey=_621.makeGrey=function(g,a){return _621.fromArray([g,g,g,a]);};lang.mixin(_621.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _621;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_627,_628,dlu,dgg){var _629=_627("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_62a){_62a=_62a||{};var def=_629.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_62a[name]);},this);if(_62a.seriesThemes&&_62a.seriesThemes.length){this.colors=null;this.seriesThemes=_62a.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_62a.colors||_629.defaultColors).slice(0);}this.markerThemes=null;if(_62a.markerThemes&&_62a.markerThemes.length){this.markerThemes=_62a.markerThemes.slice(0);}this.markers=_62a.markers?lang.clone(_62a.markers):lang.delegate(_629.defaultMarkers);this.noGradConv=_62a.noGradConv;this.noRadialConv=_62a.noRadialConv;if(_62a.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _62b=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_62b[name]=this[name];}},this);return _62b;},clear:function(){this._current=0;},next:function(_62c,_62d,_62e){var _62f=dlu.merge,_630,_631;if(this.colors){_630=lang.delegate(this.series);_631=lang.delegate(this.marker);var _632=new _628(this.colors[this._current%this.colors.length]),old;if(_630.stroke&&_630.stroke.color){_630.stroke=lang.delegate(_630.stroke);old=new _628(_630.stroke.color);_630.stroke.color=new _628(_632);_630.stroke.color.a=old.a;}else{_630.stroke={color:_632};}if(_631.stroke&&_631.stroke.color){_631.stroke=lang.delegate(_631.stroke);old=new _628(_631.stroke.color);_631.stroke.color=new _628(_632);_631.stroke.color.a=old.a;}else{_631.stroke={color:_632};}if(!_630.fill||_630.fill.type){_630.fill=_632;}else{old=new _628(_630.fill);_630.fill=new _628(_632);_630.fill.a=old.a;}if(!_631.fill||_631.fill.type){_631.fill=_632;}else{old=new _628(_631.fill);_631.fill=new _628(_632);_631.fill.a=old.a;}}else{_630=this.seriesThemes?_62f(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_631=this.markerThemes?_62f(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_630;}var _633=_631&&_631.symbol||this._markers[this._current%this._markers.length];var _634={series:_630,marker:_631,symbol:_633};++this._current;if(_62d){_634=this.addMixin(_634,_62c,_62d);}if(_62e){_634=this.post(_634,_62c);}return _634;},skip:function(){++this._current;},addMixin:function(_635,_636,_637,_638){if(lang.isArray(_637)){arr.forEach(_637,function(m){_635=this.addMixin(_635,_636,m);},this);}else{var t={};if("color" in _637){if(_636=="line"||_636=="area"){lang.setObject("series.stroke.color",_637.color,t);lang.setObject("marker.stroke.color",_637.color,t);}else{lang.setObject("series.fill",_637.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _639="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_639 in _637;if(name in _637){lang.setObject("series."+name,_637[name],t);if(!b){lang.setObject("marker."+name,_637[name],t);}}if(b){lang.setObject("marker."+name,_637[_639],t);}});if("marker" in _637){t.symbol=_637.marker;t.symbol=_637.marker;}_635=dlu.merge(_635,t);}if(_638){_635=this.post(_635,_636);}return _635;},post:function(_63a,_63b){var fill=_63a.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_63b=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_63b=="slice"||_63b=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_63a,{series:{fill:t}});}}return _63a;},getTick:function(name,_63c){var tick=this.axis.tick,_63d=name+"Tick",_63e=dlu.merge;if(tick){if(this.axis[_63d]){tick=_63e(tick,this.axis[_63d]);}}else{tick=this.axis[_63d];}if(_63c){if(tick){if(_63c[_63d]){tick=_63e(tick,_63c[_63d]);}}else{tick=_63c[_63d];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_63f){this.markers[name]=_63f;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_629,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _629;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_640,_641,fx,dom,_642,_643,_644,lang,_645,on,has,_646,_647,_648,_649,_64a,_64b,_64c){var _64d=_641("dijit._MasterTooltip",[_648,_649],{duration:_646.defaultDuration,templateString:_64b,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _64a(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_64e,_64f,_650,rtl,_651){if(this.aroundNode&&this.aroundNode===_64f&&this.containerNode.innerHTML==_64e){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_64e;if(_651){this.set("textDir",_651);}this.containerNode.align=rtl?"right":"left";var pos=_647.around(this.domNode,_64f,_650&&_650.length?_650:_652.defaultPosition,!rtl,lang.hitch(this,"orient"));var _653=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_653.y+((_653.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_653.x+((_653.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_644.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_64f;},orient:function(node,_654,_655,_656,_657){this.connectorNode.style.top="";var _658=_656.h,_659=_656.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_654+"-"+_655];this.domNode.style.width="auto";var size=_643.position(this.domNode);if(has("ie")==9){size.w+=2;}var _65a=Math.min((Math.max(_659,1)),size.w);_643.setMarginBox(this.domNode,{w:_65a});if(_655.charAt(0)=="B"&&_654.charAt(0)=="B"){var bb=_643.position(node);var _65b=this.connectorNode.offsetHeight;if(bb.h>_658){var _65c=_658-((_657.h+_65b)>>1);this.connectorNode.style.top=_65c+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_657.h/2-_65b/2,0),bb.h-_65b)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_659);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_65d){if(this._onDeck&&this._onDeck[1]==_65d){this._onDeck=null;}else{if(this.aroundNode===_65d){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_64d.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_640.forEach(node.children,function(_65e){this._setAutoTextDir(_65e);},this);},_setTextDirAttr:function(_65f){this._set("textDir",_65f);if(_65f=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_64c.showTooltip=function(_660,_661,_662,rtl,_663){if(_662){_662=_640.map(_662,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_652._masterTT){_64c._masterTT=_652._masterTT=new _64d();}return _652._masterTT.show(_660,_661,_662,rtl,_663);};_64c.hideTooltip=function(_664){return _652._masterTT&&_652._masterTT.hide(_664);};var _652=_641("dijit.Tooltip",_648,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_665){_640.forEach(this._connections||[],function(_666){_640.forEach(_666,function(_667){_667.remove();});},this);this._connectIds=_640.filter(lang.isArrayLike(_665)?_665:(_665?[_665]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_640.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_668=this.selector,_669=_668?function(_66a){return on.selector(_668,_66a);}:function(_66b){return _66b;},self=this;return [on(node,_669(_645.enter),function(){self._onHover(this);}),on(node,_669("focusin"),function(){self._onHover(this);}),on(node,_669(_645.leave),lang.hitch(self,"_onUnHover")),on(node,_669("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_665);},addTarget:function(node){var id=node.id||node;if(_640.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_640.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_642.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_640.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_66c){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_66c);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_66d){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _66e=this.getContent(_66d);if(!_66e){return;}_652.show(_66e,_66d,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_66d;this.onShow(_66d,this.position);},close:function(){if(this._connectNode){_652.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_640.forEach(this._connections||[],function(_66f){_640.forEach(_66f,function(_670){_670.remove();});},this);this.inherited(arguments);}});_652._MasterTooltip=_64d;_652.show=_64c.showTooltip;_652.hide=_64c.hideTooltip;_652.defaultPosition=["after-centered","before-centered"];return _652;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_671,_672,gfx,_673){return _672("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_674){this.chart=_674;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _675=this.getGroup().children;if(_673.dispose){for(var i=0;i<_675.length;++i){_673.dispose(_675[i],true);}}if(this.getGroup().rawNode){_671.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_673.dispose){_673.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_671.empty(this.group.rawNode);}this.group.clear();if(_673.dispose){_673.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_676){this.destroyHtmlElements();if(!_676){_676=this.chart.surface;}if(this.group){var _677;var _678=this.getGroup().children;if(_673.dispose){for(var i=0;i<_678.length;++i){_673.dispose(_678[i],true);}}if(this.getGroup().rawNode){_677=this.getGroup().bgNode;_671.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_677){this.getGroup().rawNode.appendChild(_677);}}else{this.group=_676.createGroup();}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_671.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_679,_67a){if(!s||s.length<=0){return {text:"",truncated:_67a||false};}if(!_679||_679<=0){return {text:s,truncated:_67a||false};}var _67b=2,_67c=0.618,_67d=s.substring(0,1)+this.trailingSymbol,_67e=this.getTextWidth(_67d,font);if(_679<=_67e){return {text:_67d,truncated:true};}var _67f=this.getTextWidth(s,font);if(_67f<=_679){return {text:s,truncated:_67a||false};}else{var _680=0,end=s.length;while(_680<end){if(end-_680<=_67b){while(this.getTextWidth(s.substring(0,_680)+this.trailingSymbol,font)>_679){_680-=1;}return {text:(s.substring(0,_680)+this.trailingSymbol),truncated:true};}var _681=_680+Math.round((end-_680)*_67c),_682=this.getTextWidth(s.substring(0,_681),font);if(_682<_679){_680=_681;end=end;}else{_680=_680;end=_681;}}}},getTextWithLimitCharCount:function(s,font,_683,_684){if(!s||s.length<=0){return {text:"",truncated:_684||false};}if(!_683||_683<=0||s.length<=_683){return {text:s,truncated:_684||false};}return {text:s.substring(0,_683)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_685){if(!fill||!fill.type||!fill.space){return fill;}var _686=fill.space,span;switch(fill.type){case "linear":if(_686==="plot"||_686==="shapeX"||_686==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_686;if(_686==="plot"||_686==="shapeX"){span=dim.height-_685.t-_685.b;fill.y1=_685.t+span*fill.y1/100;fill.y2=_685.t+span*fill.y2/100;}if(_686==="plot"||_686==="shapeY"){span=dim.width-_685.l-_685.r;fill.x1=_685.l+span*fill.x1/100;fill.x2=_685.l+span*fill.x2/100;}}break;case "radial":if(_686==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_686;var _687=dim.width-_685.l-_685.r,_688=dim.height-_685.t-_685.b;fill.cx=_685.l+_687*fill.cx/100;fill.cy=_685.t+_688*fill.cy/100;fill.r=fill.r*Math.sqrt(_687*_687+_688*_688)/200;}break;case "pattern":if(_686==="plot"||_686==="shapeX"||_686==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_686;if(_686==="plot"||_686==="shapeX"){span=dim.height-_685.t-_685.b;fill.y=_685.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_686==="plot"||_686==="shapeY"){span=dim.width-_685.l-_685.r;fill.x=_685.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _689=fill.space,span;switch(fill.type){case "linear":if(_689==="shape"||_689==="shapeX"||_689==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_689;if(_689==="shape"||_689==="shapeX"){span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_689==="shape"||_689==="shapeY"){span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_689==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_689;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_689==="shape"||_689==="shapeX"||_689==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_689;if(_689==="shape"||_689==="shapeX"){span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_689==="shape"||_689==="shapeY"){span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_68a,_68b,_68c,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _68d=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_68d;if(arguments.length<4){fill.cx=_68a.x;fill.cy=_68a.y;fill.r=fill.r*_68b/100;return fill;}var _68e=arguments.length<5?_68c:(end+_68c)/2;return {type:"linear",x1:_68a.x,y1:_68a.y,x2:_68a.x+fill.r*_68b*Math.cos(_68e)/100,y2:_68a.y+fill.r*_68b*Math.sin(_68e)/100,colors:fill.colors};}});});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_68f,_690,_691,_692,_693,_694,dom,_695,_696,_697,_698,_699,has,_69a,lang,on,_69b,_69c,_69d,win,_69e,_69f,_6a0){has.add("dijit-legacy-requires",!_69a.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_69b(0,function(){var _6a1=["dijit/_base/manager"];_68f(_6a1);});}var _6a2={};function _6a3(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _6a4(attr){return function(val){_695[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _6a5(a,b){return a===b||(a!==a&&b!==b);};var _6a6=_694("dijit._WidgetBase",[_69c,_69e],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_6a4("lang"),dir:"",_setDirAttr:_6a4("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_692.blankGif||_68f.toUrl("dojo/resources/blank.gif"),_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _6a7=ctor.prototype,_6a8=ctor._setterAttrs=[],_6a9=(ctor._onMap={});for(var name in _6a7.attributeMap){_6a8.push(name);}for(name in _6a7){if(/^on/.test(name)){_6a9[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_6a7.attributeMap||!(name in _6a7.attributeMap)){_6a8.push(name);}}}}},postscript:function(_6aa,_6ab){this.create(_6aa,_6ab);},create:function(_6ac,_6ad){this._introspect();this.srcNodeRef=dom.byId(_6ad);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_6ac){this.params=_6ac;lang.mixin(this,_6ac);}this.postMixInProperties();if(!this.id){this.id=_6a0.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_6a0.add(this);this.buildRendering();var _6ae;if(this.domNode){this._applyAttributes();var _6af=this.srcNodeRef;if(_6af&&_6af.parentNode&&this.domNode!==_6af){_6af.parentNode.replaceChild(this.domNode,_6af);_6ae=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_6ae){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _6b0={};for(var key in this.params||{}){_6b0[key]=this._get(key);}_690.forEach(this.constructor._setterAttrs,function(key){if(!(key in _6b0)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _6b0){this.set(key,_6b0[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _6b1=this.baseClass.split(" ");if(!this.isLeftToRight()){_6b1=_6b1.concat(_690.map(_6b1,function(name){return name+"Rtl";}));}_696.add(this.domNode,_6b1);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_690.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_6b2){this._beingDestroyed=true;this.destroyDescendants(_6b2);this.destroy(_6b2);},destroy:function(_6b3){this._beingDestroyed=true;this.uninitialize();function _6b4(w){if(w.destroyRecursive){w.destroyRecursive(_6b3);}else{if(w.destroy){w.destroy(_6b3);}}};_690.forEach(this._connects,lang.hitch(this,"disconnect"));_690.forEach(this._supportingWidgets,_6b4);if(this.domNode){_690.forEach(_6a0.findWidgets(this.domNode,this.containerNode),_6b4);}this.destroyRendering(_6b3);_6a0.remove(this.id);this._destroyed=true;},destroyRendering:function(_6b5){if(this.bgIframe){this.bgIframe.destroy(_6b5);delete this.bgIframe;}if(this.domNode){if(_6b5){_695.remove(this.domNode,"widgetId");}else{_697.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_6b5){_697.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_6b6){_690.forEach(this.getChildren(),function(_6b7){if(_6b7.destroyRecursive){_6b7.destroyRecursive(_6b6);}});},uninitialize:function(){return false;},_setStyleAttr:function(_6b8){var _6b9=this.domNode;if(lang.isObject(_6b8)){_699.set(_6b9,_6b8);}else{if(_6b9.style.cssText){_6b9.style.cssText+="; "+_6b8;}else{_6b9.style.cssText=_6b8;}}this._set("style",_6b8);},_attrToDom:function(attr,_6ba,_6bb){_6bb=arguments.length>=3?_6bb:this.attributeMap[attr];_690.forEach(lang.isArray(_6bb)?_6bb:[_6bb],function(_6bc){var _6bd=this[_6bc.node||_6bc||"domNode"];var type=_6bc.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_6ba)){_6ba=lang.hitch(this,_6ba);}var _6be=_6bc.attribute?_6bc.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_6bd.tagName){_695.set(_6bd,_6be,_6ba);}else{_6bd.set(_6be,_6ba);}break;case "innerText":_6bd.innerHTML="";_6bd.appendChild(this.ownerDocument.createTextNode(_6ba));break;case "innerHTML":_6bd.innerHTML=_6ba;break;case "class":_696.replace(_6bd,_6ba,this[attr]);break;}},this);},get:function(name){var _6bf=this._getAttrNames(name);return this[_6bf.g]?this[_6bf.g]():this._get(name);},set:function(name,_6c0){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _6c1=this._getAttrNames(name),_6c2=this[_6c1.s];if(lang.isFunction(_6c2)){var _6c3=_6c2.apply(this,Array.prototype.slice.call(arguments,1));}else{var _6c4=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_6c4]&&this[_6c4].tagName,_6c5=tag&&(_6a2[tag]||(_6a2[tag]=_6a3(this[_6c4]))),map=name in this.attributeMap?this.attributeMap[name]:_6c1.s in this?this[_6c1.s]:((_6c5&&_6c1.l in _6c5&&typeof _6c0!="function")||/^aria-|^data-|^role$/.test(name))?_6c4:null;if(map!=null){this._attrToDom(name,_6c0,map);}this._set(name,_6c0);}return _6c3||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_6c6){var _6c7=this[name];this[name]=_6c6;if(this._created&&!_6a5(_6c7,_6c6)){if(this._watchCallbacks){this._watchCallbacks(name,_6c7,_6c6);}this.emit("attrmodified-"+name,{detail:{prevValue:_6c7,newValue:_6c6}});}},_get:function(name){return this[name];},emit:function(type,_6c8,_6c9){_6c8=_6c8||{};if(_6c8.bubbles===undefined){_6c8.bubbles=true;}if(_6c8.cancelable===undefined){_6c8.cancelable=true;}if(!_6c8.detail){_6c8.detail={};}_6c8.detail.widget=this;var ret,_6ca=this["on"+type];if(_6ca){ret=_6ca.apply(this,_6c9?_6c9:[_6c8]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_6c8);}return ret;},on:function(type,func){var _6cb=this._onMap(type);if(_6cb){return _691.after(this,_6cb,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_6a0.findWidgets(this.containerNode):[];},getParent:function(){return _6a0.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_6cc,_6cd){return this.own(_693.connect(obj,_6cc,this,_6cd))[0];},disconnect:function(_6ce){_6ce.remove();},subscribe:function(t,_6cf){return this.own(_69d.subscribe(t,lang.hitch(this,_6cf)))[0];},unsubscribe:function(_6d0){_6d0.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_698.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_699.get(this.domNode,"display")!="none");},placeAt:function(_6d1,_6d2){var _6d3=!_6d1.tagName&&_6a0.byId(_6d1);if(_6d3&&_6d3.addChild&&(!_6d2||typeof _6d2==="number")){_6d3.addChild(this,_6d2);}else{var ref=_6d3?(_6d3.containerNode&&!/after|before|replace/.test(_6d2||"")?_6d3.containerNode:_6d3.domNode):dom.byId(_6d1,this.ownerDocument);_697.place(this.domNode,ref,_6d2);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_6d4){var _6d5=setTimeout(lang.hitch(this,function(){if(!_6d5){return;}_6d5=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_6d4||0);return {remove:function(){if(_6d5){clearTimeout(_6d5);_6d5=null;}return null;}};}});if(has("dojo-bidi")){_6a6.extend(_69f);}return _6a6;});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n"}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","dojo/_base/lang","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(_6d6,lang,_6d7){_6d6.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.widget.Chart2D",_6d7);});