<?php
namespace phoenix;

use \DateTime;

require_once("meta.class.php");

#class EmailInvalidException extends \Exception { }


class Anagrafica extends Meta {

    function __construct() {
        //parent::__construct();
        error_log("Creato ANAGRAFICA");
    }
    
    public function isValida() {
        if ($this->get("validazione") == 'S')
            return true;
        return false;
    }
    
    public function isCompleta() {
        if (strlen($this->get("cognome")) > 0)
            return true;
        return false;
    }
    
    public function luogoNascita() {
        $db = getDB();
        $params = [];
        $params["code"] = $this->get("nascita_nazione_code");
        $rows = $db->select("nazioni", "*", $params);
        
        if ($this->get("nascita_nazione_code") != 'IT') {
            return $rows[0]["label"]." ({$this->get("nascita_nazione_code")}) | ".$this->get("nascita_localita_estera");
        }
        else {
            $params = [];
            $params["code"] = $this->get("nascita_comune_code");
            $rows = $db->select("comuni", "*", $params);
            
            return "Italia (IT) | ".$rows[0]["label"]." ({$rows[0]["sigla"]})";
        }
    }
    
    public function luogoResidenza() {
        $db = getDB();
        $params = [];
        $params["code"] = $this->get("residenza_nazione_code");
        $rows = $db->select("nazioni", "*", $params);
        
        if ($this->get("residenza_nazione_code") != 'IT') {
            return $rows[0]["label"]." ({$this->get("residenza_nazione_code")}) | ".$this->get("residenza_localita_estera");
        }
        else {
            $params = [];
            $params["code"] = $this->get("residenza_comune_code");
            $rows = $db->select("comuni", "*", $params);
            
            return "Italia (IT) | ".$rows[0]["label"]." ({$rows[0]["sigla"]})";
        }
    }
    
    public function documenti() {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $this->id();
        $rows = $db->select("anagrafiche_documenti", "*", $params);
        if ($rows === false)
            throw new \Exception("Impossibile leggere i documenti dell'anagrafica. Contattare l'assistenza.");
        
        return $rows;
    }
    
    public function conti() {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $this->id();
        $rows = $db->select("anagrafiche_banche", "*", $params);
        if ($rows === false)
            throw new \Exception("Impossibile leggere i conti correnti dell'anagrafica. Contattare l'assistenza.");
        
        return $rows;
    }
    
    public function sogni() {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $this->id();
        $rows = $db->select("nodi", "*", $params);
        if ($rows === false)
            throw new \Exception("Impossibile leggere i sogni dell'anagrafica. Contattare l'assistenza.");
        
        return $rows;
    }
    
    public function iscrizioni() {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $this->id();
        $rows = $db->select("relazioni", "*", $params);
        if ($rows === false)
            throw new \Exception("Impossibile leggere le iscrizioni dell'anagrafica. Contattare l'assistenza.");
        
        return $rows;
    }
    
    public function wallet() {
        $wallet = new Wallet();
        $wallet->carica($this->id());
        return $wallet;
    }
    
    public function codiciPromo() {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $this->id();
        $rows = $db->select("promo", "*", $params);
        if ($rows === false)
            throw new \Exception("Impossibile leggere i codici promo dell'anagrafica. Contattare l'assistenza.");
        
        return $rows;
    }
    
    public function carica($user) {
        $db = getDB();
        $params = [];
        $params["utente_id"] = $user->id();
        $rows = $db->select("anagrafiche", "*", $params);
    
        if ($rows === false)
            throw new \Exception("Impossibile leggere l'anagrafica. Contattare l'assistenza.");
        if (count($rows) == 1) {
            $this->_fields = $rows[0];
            #error_log(var_export($rows[0], true));
            return true;
        }
            
        return false;
    
    }
    
    public function salva($user, $params) {
        $db = getDB();
                
        if (strlen($params["nascita_data"])) {
            $nascita_data = DateTime::createFromFormat('d/m/Y', $params["nascita_data"]);
            $nascita_data = $nascita_data->format('Y-m-d');
        }
        if (strlen($params["documento_scadenza"])) {
            $documento_scadenza = DateTime::createFromFormat('d/m/Y', $params["documento_scadenza"]);
            $documento_scadenza = $documento_scadenza->format('Y-m-d');
        }
        $p = [
            "cognome" => $params["cognome"],
            "nome" => $params["nome"],
            "sesso" => $params["sesso"],
            "nascita_nazione_code" => $params["nascita_nazione_code"],
            "nascita_comune_code" => $params["nascita_comune_code"],
            "nascita_localita_estera" => $params["nascita_localita_estera"],
            "nascita_data" => $nascita_data,
            "residenza_indirizzo" => $params["residenza_indirizzo"],
            "residenza_nazione_code" => $params["residenza_nazione_code"],
            "residenza_comune_code" => $params["residenza_comune_code"],
            "residenza_localita_estera" => $params["residenza_localita_estera"],
            "residenza_cap" => $params["residenza_cap"],
            "documento_tipo" => $params["documento_tipo"],
            "documento_numero" => $params["documento_numero"],
            "documento_emittente" => $params["documento_emittente"],
            "documento_scadenza" => $documento_scadenza,
            "cf" => strtoupper($params["cf"]),
            "cellulare" => $params["cellulare"],
            "utente_id" => $user->id()
        ];
        #error_log(var_export($p, true));
        # TODO
        # Qui vanno fatti i check
        
        
        # NASCITA
        if (strlen($p["nascita_nazione_code"]) == 0) {
            throw new \Exception("Nazione di nascita non indicata. E' necessario <b>selezionare un valore dall'elenco</b> (non basta scrivere il nome).");
        }
        elseif ($p["nascita_nazione_code"] == 'IT' && strlen($p["nascita_comune_code"]) == 0) {
            throw new \Exception("Comune di nascita non indicato. E' necessario <b>selezionare un valore dall'elenco</b> (non basta scrivere il nome).");
        }
        elseif ($p["nascita_nazione_code"] != 'IT' && strlen($p["nascita_localita_estera"]) == 0) {
            throw new \Exception("Localit&agrave; estera di nascita non indicata. E' necessario scrivere il nome della localit&agrave;.");
        }
        
        # RESIDENZA
        if (strlen($p["residenza_nazione_code"]) == 0) {
            throw new \Exception("Nazione di residenza non indicata. E' necessario <b>selezionare un valore dall'elenco</b> (non basta scrivere il nome).");
        }
        elseif ($p["residenza_nazione_code"] == 'IT' && strlen($p["residenza_comune_code"]) == 0) {
            throw new \Exception("Comune di residenza non indicato. E' necessario <b>selezionare un valore dall'elenco</b> (non basta scrivere il nome).");
        }
        elseif ($p["residenza_nazione_code"] != 'IT' && strlen($p["residenza_localita_estera"]) == 0) {
            throw new \Exception("Localit&agrave; estera di residenza non indicata. E' necessario scrivere il nome della localit&agrave;.");
        }
        
        # DOCUMENTO
        if ($documento_scadenza <= date("Y-m-d")) {
            throw new \Exception("Documento scaduto.");
        }
           
        # CF
        if (!checkCF($p["cf"])) {
            throw new \Exception("Il codice fiscale inserito non &egrave; valido. Si prega di ricontrollarlo.");
        }
        
        // if (true) {
            // throw new \Exception("OK!!!");
        // }
            
        try {
            if ($this->id() > 0) {
                error_log("Anagrafica::update");
                $where = [ 
                    "utente_id" => $user->id(),
                    "id" => $this->id(),
                ];
                $db->update("anagrafiche", $p, $where);
                return true;
            }
            else {
                error_log("Anagrafica::insert");
                $db->insert("anagrafiche", $p);
                list($error_code, $error_number, $error_text) = $db->error();
                #error_log( var_export($db->error(), true) );
                if ($db->id() > 0) {
                    $ret = $db->id();
                }
                elseif ($error_code == '00000') {
                    $ret = true;
                }
                else
                    $ret = false;
                return $ret;
            }
        }
        catch(Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new \Exception($ex->getMessage());
        }
        return false;
    }
}
?>