<?php
namespace phoenix;

require_once("meta.class.php");

#class EmailInvalidException extends \Exception { }


class AnagraficaBanca extends Meta{

    function __construct() {
        //parent::__construct();
        error_log("Creato ANAGRAFICA BANCA");
    }
    
    
    public function salva($user, $params) {
        $db = getDB();
                
        $p = [
            "anagrafica_id" => $params["anagrafica_id"],
            "tipo_banca" => $params["tipo_banca"],
            "intestatari" => $params["intestatari"],
            "iban" => strtoupper($params["iban"])
        ];
        # TODO
        # Qui vanno fatti i check
        
        if ($p["tipo_banca"] == 'BANCARIO' && substr($p["iban"], 0, 2) != 'IT') {
            throw new \Exception("Se la tipologia del conto &egrave; BANCA, &egrave; necessario che l'IBAN inizi con IT.");
        }
        if ($p["tipo_banca"] == 'BANCARIO' && strlen($p["iban"]) != 27) {
            throw new \Exception("L'IBAN inserito non &egrave; corretto in quanto non contiene 27 caratteri.");
        }
        if ($p["tipo_banca"] == 'BANCARIO' && !checkIBAN($p["iban"])) {
            throw new \Exception("L'IBAN inserito non &egrave; formalmente corretto. Si prega di ricontrollarlo.");
        }
        if ($p["tipo_banca"] == 'PAYPAL' && !IsValidMail($p["iban"])) {
            throw new \Exception("L'account PayPal inserito non &egrave; un'email valida.");
        }
        
        if ($p["tipo_banca"] != 'BANCARIO')
            $p["iban"] = strtolower($p["iban"]);
        
        try {
            error_log("AnagraficaBanca::insert");
            $db->insert("anagrafiche_banche", $p);
            list($error_code, $error_number, $error_text) = $db->error();
            error_log( var_export($db->error(), true) );
            if ($db->id() > 0) {
                return $db->id();
            }
            elseif ($error_code == '00000') {
                return true;
            }
            return false;
        }
        catch(Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new Exception($ex->getMessage());
        }
        return false;
    }
}
?>