<?php
namespace phoenix;

class ManagerNodi {
    
    public function __constructor() {
        
    }
    
    #
    # Cerca tra i figlio o i nipoti (non i pronipoti!) chi ha pi "diritto" a prendersi il donatore
    #
    private function cerca_nodo($codice_sogno_target, $tipo_dteam, $figli) {
        GLOBAL $user, $session;
        $db = getDB();
        $nodi = [];
        $nipoti = [];
        
        foreach($figli as $item) {
            $nodo_figlio = $item["nodo_figlio"];
            $params = [];
            $params["nodo_padre"] = $nodo_figlio;
            $params["donazione"] = $tipo_dteam;
            $rows = $db->select("relazioni", "*", $params);
            if (count($rows) == 0)
                return $nodo_figlio;
            else {
                $nodi[] = [
                    'nodo' => $nodo_figlio,
                    'livello' => 0,
                    'figli' => count($rows)
                ];
                foreach($rows as $item) {
                    $nipoti[] = $item["nodo_figlio"];
                }
            }
        
            $session->log($item);
        }
        
        # Qui vuol dire che nessuno dei 3 figli ha 0 figli a sua volta.
        # Vediamo se c'e' un nipote che ha 0 figli.
        foreach($nipoti as $nodo_nipote) {
            $params = [];
            $params["nodo_padre"] = $nodo_nipote;
            $params["donazione"] = $tipo_dteam;
            $rows = $db->select("relazioni", "*", $params);
            if (count($rows) == 0)
                return $nodo_nipote;
            else {
                $nodi[] = [
                    'nodo' => $nodo_nipote,
                    'livello' => 1,
                    'figli' => count($rows)
                ];
            }
        }
        
        # Qui vuol dire che anche nessun nipote ha 0 figli,
        # quindi cerco chi ha meno figli tra tutti (a parit prendo chi ha livello minore)
        $nodo_candidato = false;
        $livello_candidato = $figli_candidato = 1000;
        foreach($nodi  as $nodo) {
            if ($nodo["figli"] < $figli_candidato) {
                $nodo_candidato = $nodo["nodo"];
                $livello_candidato = $nodo["livello"];
                $figli_candidato = $nodo["figli"];
            }
            elseif ($nodo["figli"] == $figli_candidato && $nodo["livello"] < $livello_candidato) {
                $nodo_candidato = $nodo["nodo"];
                $livello_candidato = $nodo["livello"];
                $figli_candidato = $nodo["figli"];
            }
        }
    
        return $nodo_candidato;
    }
    
    public function dona_libera($codice_sogno_target, $importo, $transazione_id=null) {
        GLOBAL $user, $session;
        
        $nodo = new Nodo();
        $nodo->carica($codice_sogno_target);
        $anagrafica_id = $nodo->get("anagrafica_id");
        try {
            # check con l'utente
            $anagrafica_id_pagante = $user->anagrafica()->id();
        }
        catch(\Exception $ex) {
            $anagrafica_id_pagante = null;
        }
        $session->log("Anagrafica ricevente = ".$anagrafica_id);
        $session->log("Anagrafica pagante = ".$anagrafica_id_pagante);
        
        $wallet_ricevente = new Wallet();
        $wallet_ricevente->carica($anagrafica_id);
        $session->log($wallet_ricevente);
        $saldo_pre = $wallet_ricevente->get("saldo");
        
        $importo_servizio_ic = $importo * COMMISSIONE_LIBERA;
        $importo_servizio_ie = $importo_servizio_ic / (1 + IVA);
        $iva = $importo_servizio_ic - $importo_servizio_ie;
        // error_log("importo: ".$importo);
        // error_log("COMMISSIONE_DTEAM: ".COMMISSIONE_DTEAM);
        // error_log("importo_servizio_ic: ".$importo_servizio_ic);
        // error_log("importo_servizio_ie: ".$importo_servizio_ie);
        // error_log("iva: ".$iva);
        $importo_donazione = $importo - $importo_servizio_ic - 0.35 -0.034 * $importo;
        
        $movimento = new Movimento();
        $p = [
            "importo" => $importo,
            "codice_sogno" => $codice_sogno_target,
            "codice_sogno_ricevente" => $codice_sogno_target,
            "codice_sogno_pagante" => null,
            "transazione" => $transazione_id,
            "importo_servizio_ie" => $importo_servizio_ie,
            "importo_servizio_iva" => $iva,
            "importo_banca" => (COMMISSIONE_FISSA_PAYPAL + COMMISSIONE_PERCENTUALE_PAYPAL * $importo),
            "importo_sognatore" => $importo_donazione,
            "saldo_pre" => $saldo_pre,
            "saldo_post" => ($saldo_pre + $importo_donazione),
            "anagrafica_dare" => $anagrafica_id_pagante,
            "anagrafica_avere" => $anagrafica_id,
            "tipo_movimento" => 'LIBERA'
        ];
        $movimento->nuovo($user, $p, 'AVERE');
        
        #$wallet_ricevente->set("saldo", $p["saldo_post"]);
        #$wallet_ricevente->salva($user);
    }
    
    public function dona_dteam($codice_sogno_pagante, $codice_sogno_target, $tipo_dteam, $transazione_id=null) {
        GLOBAL $user, $session;
        
        $db = getDB();
        
        # Verifichiamo padre compatibile (ovvero che padre faccia parte di un dteam)
        $params = [];
        $params["nodo_figlio"] = $codice_sogno_target;
        $params["donazione"] = $tipo_dteam;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            $session->log("Padre {$tipo_dteam} OK");
            $stato_padre = $rows[0]["stato"];
            $nodo_nonno = $rows[0]["nodo_padre"];
            $anag_padre = $rows[0]["anagrafica_id"];
        }
        else {
            $session->log("ManagerNodi::dona_dteam(): padre ({$codice_sogno_target}) non iscritto al dteam {$tipo_dteam}.");
            return false;
        }
        
        # Verifichiamo se la relazione esiste gi:
        $params = [];
        $params["nodo_figlio"] = $codice_sogno_pagante;
        $params["nodo_padre"] = $codice_sogno_target;
        $params["donazione"] = $tipo_dteam;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            $session->log("Relazione {$codice_sogno_pagante}-{$codice_sogno_target} esistente!");
            return true;
        }
        
        # Verifichiamo se il padre ha posto:
        $params = [];
        $params["nodo_padre"] = $codice_sogno_target;
        $params["donazione"] = $tipo_dteam;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) >= 3) {
            $session->log("Il padre ha gia' 3 figli!");
            # se non c'e' posto, cerchiamo un figlio che ne ha:
            $codice_nodo_target = $this->cerca_nodo($codice_sogno_target, $tipo_dteam, $rows);
            $session->log("Trovato: ".$codice_nodo_target);
            if ($codice_nodo_target === false) {
                $session->log("Nessun nodo trovato! DTeam saturo.");
                return false;
            }
            
            return $this->dona_dteam($codice_sogno_pagante, $codice_nodo_target, $tipo_dteam, $transazione_id);
        }
        # se ha posto, va qui
        
        
        # ---------------------------------------------------------------------------------------------
        # Qui abbiamo trovato il nodo corretto
        # ---------------------------------------------------------------------------------------------
        
        # Registrazione della relazione   
        $relazione = new Relazione();
        $relazione->nuova($user, $codice_sogno_target, $codice_sogno_pagante, 'V', $tipo_dteam);
        
        $importo = $tipo_dteam;
        $importo_banca = COMMISSIONE_FISSA_PAYPAL + COMMISSIONE_PERCENTUALE_PAYPAL * $importo;
        $importo_servizio_ic = $importo * COMMISSIONE_DTEAM - $importo_banca;
        $importo_servizio_ie = $importo_servizio_ic / (1 + IVA);
        $iva = $importo_servizio_ic - $importo_servizio_ie;
        // error_log("importo: ".$importo);
        // error_log("COMMISSIONE_DTEAM: ".COMMISSIONE_DTEAM);
        // error_log("importo_servizio_ic: ".$importo_servizio_ic);
        // error_log("importo_servizio_ie: ".$importo_servizio_ie);
        // error_log("iva: ".$iva);
        $importo_donazioni = $importo - $importo_servizio_ic - $importo_banca; # qui la banca la paghiamo noi
        $importo_donazione_singola = $importo_donazioni / 3;
        
        $nodo_pagante = new Nodo();
        $nodo_pagante->carica($codice_sogno_pagante);
        
        # Verifichiamo nonno e cerchiamo bisnonno
        $params = [];
        $params["nodo_figlio"] = $nodo_nonno;
        $params["donazione"] = $tipo_dteam;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            $session->log("Nonno {$tipo_dteam} OK");
            $stato_nonno = $rows[0]["stato"];
            $nodo_bisnonno = $rows[0]["nodo_padre"];
            $anag_nonno = $rows[0]["anagrafica_id"];
        }
        
        # Verifichiamo bisnonno
        $params = [];
        $params["nodo_figlio"] = $nodo_bisnonno;
        $params["donazione"] = $tipo_dteam;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            $session->log("Bisnonno {$tipo_dteam} OK");
            $stato_bisnonno = $rows[0]["stato"];
            $anag_bisnonno = $rows[0]["anagrafica_id"];
        }
        
        $session->log("Padre: {$codice_sogno_target} (stato={$stato_padre})");
        $session->log("Nonno: {$nodo_nonno} (stato={$stato_nonno})");
        $session->log("Bisnonno: {$nodo_bisnonno} (stato={$stato_bisnonno})");
        
        # Donazioni
        for ($i=0; $i<3; $i++) {
            if ($i == 0) {
                $anagrafica_id = $anag_padre;
                $codice_sogno_ricevente = $codice_sogno_target;
                $stato = $stato_padre;
            }
            elseif ($i == 1) {
                $anagrafica_id = $anag_nonno;
                $codice_sogno_ricevente = $nodo_nonno;
                $stato = $stato_nonno;
            }
            elseif ($i == 2) {
                $anagrafica_id = $anag_bisnonno;
                $codice_sogno_ricevente = $nodo_bisnonno;
                $stato = $stato_bisnonno;
            }
            else {
                $anagrafica_id = 2;
                $codice_sogno_ricevente = "ZZZZZ";
                $stato = "V";
            }
            
            # Verifico stato di abilitazione
            if ($stato == 'X') {
                $anagrafica_id = 2;
                $codice_sogno_ricevente = "ZZZZZ";
                # TODO: log che il nodo non  attivo
            }
            
            $wallet_ricevente = new Wallet();
            $wallet_ricevente->carica($anagrafica_id);
            $session->log($wallet_ricevente);
            $saldo_pre = $wallet_ricevente->get("saldo");
            
            $movimento = new Movimento();
            $p = [
                "importo" => $importo,
                "codice_sogno" => $codice_sogno_target,
                "codice_sogno_ricevente" => $codice_sogno_ricevente,
                "codice_sogno_pagante" => $codice_sogno_pagante,
                "transazione" => $transazione_id,
                "importo_servizio_ie" => $importo_servizio_ie / 3,
                "importo_servizio_iva" => $iva / 3,
                "importo_banca" => $importo_banca / 3,
                "importo_sognatore" => $importo_donazione_singola,
                "saldo_pre" => $saldo_pre,
                "saldo_post" => ($saldo_pre + $importo_donazione_singola),
                "anagrafica_dare" => $nodo_pagante->get("anagrafica_id"),
                "anagrafica_avere" => $anagrafica_id,
                "tipo_movimento" => 'D-TEAM'
            ];
            $movimento->nuovo($user, $p);
            
            #$wallet_ricevente->set("saldo", $p["saldo_post"]);
            #$wallet_ricevente->salva($user);
        
        
        }
        return true;
    } 
}


/*
STATO = [
    verde = ok
    giallo = in scadenza
    rosso = scaduto
    azzurro = da completare / da verificare
]



class ManagerNodi {
    $nodo_iva;
    $nodo_phoenix;
    
    public function add($nodo, $parent) {
    
    }
    public function remove($nodo) {
    
    }
    public function change($nodo_da_spostare, $node_nuovo_padre) {
    
    }
    public function newDonazione($nodo_donante, $importo, $tipo_donazione) {
        inizio_transazione;
        $mporto_netto = $importo - 16%;
        registrazione_log_account($nodo_donante, $importo);
        $importo_commissione = $importo - $importo_netto;
        $importo_iva = $importo_commissione / 1.22;
        $importo_phoenix = $importo_commissione - $importo_iva;
        $nodo_iva->nuovaDonazione($importo_iva, $tipo_donazione);
        $nodo_phoenix->nuovaDonazione($importo_phoenix, $tipo_donazione);
        if ($tipo_donazione == 'L') {
            $padre = $nodo_donante->padre();
            $padre->nuovaDonazione($mporto_netto, $tipo_donazione);
        }
        elseif ($tipo_donazione == 'D') {
            $importo_pro_sogno = $importo_netto / 3;
            for ($i=0; $i<3; $i++) {
                $padre = $nodo_donante->padre();
                if ($padre == false)
                    $padre = $nodo_donante;
                $padre->nuovaDonazione($importo_pro_sogno, $tipo_donazione);
                $nodo_donante = $padre;
            }
        }
        else
            throw_eccezione;
        fine_transazione();
    }
    
    
    public function cercaPadre($codice_nodo_figlio) {
        return $nodo_padre;
    }
    
}
*/
?>