<?php
namespace phoenix;

require_once("meta.class.php");

#class EmailInvalidException extends \Exception { }


class Messaggio extends Meta{

    function __construct() {
        //parent::__construct();
    }
    
    public function crea($user, $sogno, $messaggio) {
        $db = getDB();
        
        $codice_conversazione = md5(microtime());
        $anagrafica_from = $user->anagrafica()->id();
        if (strlen($sogno) == 5) {
            $nodo = new Nodo();
            $nodo->carica($sogno);
            $campo_to = "anagrafica_to";
            $anagrafica_to = $nodo->get("anagrafica_id");
        }
        else {
            $campo_to = "utente_to";
            $anagrafica_to = $sogno;
            $sogno = null;
        }
        
        try {
            $params = [
                "anagrafica_from" => $anagrafica_from,
                $campo_to => $anagrafica_to,
                "codice_sogno" => $sogno
            ];
            $rows = $db->select("messaggi", "codice_conversazione", $params);
        
            if (count($rows) >= 1) {
                $codice_conversazione = $rows[0];
            }
        }
        catch(Exception $ex) {
            error_log($ex->getMessage());
        }
        
        try {
            # INSERT
            $p = [
                "anagrafica_from" => $anagrafica_from,
                $campo_to => $anagrafica_to,
                "testo" => $messaggio,
                "codice_sogno" => $sogno,
                "codice_conversazione" => $codice_conversazione
            ];
            $db->insert("messaggi", $p);
      
            # TODO
            # Qui vanno fatti i check
            
            #------------------------------------------------------------------------------
            # INVIO EMAIL NOTIFICA
            #------------------------------------------------------------------------------
            if (strlen($sogno) > 0) {
                $sql = "select u.email
                        from anagrafiche a
                        join utenti u on u.id=a.utente_id
                        where a.id={$anagrafica_to}";
            }
            else {
                $sql = "select u.email
                        from utenti u 
                        where u.id={$anagrafica_to}";
            }
            $data = $db->query($sql)->fetchAll();
            $email_to = $data[0]["email"];
            $subject = "Messaggio da un utente Phoenix Project"; 
            $arrayto = array($email_to);
            $body_text = "Hai ricevuto un messaggio da un utente. Collegati su <a href='https://phoenixproject.social'>https://phoenixproject.social</a> per leggerlo.";
            request_send_mail($subject, $arrayto, $body_text, $body_text);

            
            #------------------------------------------------------------------------------
            list($error_code, $error_number, $error_text) = $db->error();
            if ($db->id() > 0) {
                return $db->id();
            }
            elseif ($error_code == '00000') {
                return true;
            }
            return false;
        }
        catch(Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new Exception($ex->getMessage());
        }
        return false;
    }
    
    public function rispondi($user, $codice_conversazione, $messaggio) {
        $db = getDB();
        
        $anagrafica_from = $user->anagrafica()->id();
        $campo_from = "anagrafica_from";
        if ($anagrafica_from == 0) {
            $anagrafica_from = $user->id();
            $campo_from = "utente_from";
        }
        
        try {
            $params = [
                "codice_conversazione" => $codice_conversazione
            ];
            $rows = $db->select("messaggi", "*", $params);
        
            if (count($rows) >= 1) {
                $sogno = $rows[0]["codice_sogno"];
                foreach($rows as $row) {
                    if ($row["anagrafica_to"] == $anagrafica_from || $row["utente_to"] == $anagrafica_from) {
                        $anagrafica_to = $row["anagrafica_from"]; 
                        $campo_to = "anagrafica_to";
                        if (strlen($anagrafica_to) == 0) {
                            $anagrafica_to = $row["utente_from"]; 
                            $campo_to = "utente_to";
                        }
                        break;
                    }
                }
            }
        }
        catch(Exception $ex) {
            error_log($ex->getMessage());
        }
        
        try {
            # INSERT
            $p = [
                $campo_from => $anagrafica_from,
                $campo_to => $anagrafica_to,
                "testo" => $messaggio,
                "codice_sogno" => $sogno,
                "codice_conversazione" => $codice_conversazione
            ];
            $db->insert("messaggi", $p);
      
            # TODO
            # Qui vanno fatti i check
            
            #------------------------------------------------------------------------------
            # INVIO EMAIL NOTIFICA
            #------------------------------------------------------------------------------
            if (strlen($sogno) > 0) {
                $sql = "select u.email
                        from anagrafiche a
                        join utenti u on u.id=a.utente_id
                        where a.id={$anagrafica_to}";
            }
            else {
                $sql = "select u.email
                        from utenti u 
                        where u.id={$anagrafica_to}";
            }
            $data = $db->query($sql)->fetchAll();
            $email_to = $data[0]["email"];
            $subject = "Messaggio da un utente Phoenix Project"; 
            $arrayto = array($email_to);
            $body_text = "Hai ricevuto un messaggio da un utente. Collegati su <a href='https://phoenixproject.social'>https://phoenixproject.social</a> per leggerlo.";
            request_send_mail($subject, $arrayto, $body_text, $body_text);
            
            #------------------------------------------------------------------------------
            list($error_code, $error_number, $error_text) = $db->error();
            if ($db->id() > 0) {
                return $db->id();
            }
            elseif ($error_code == '00000') {
                return true;
            }
            return false;
        }
        catch(Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new Exception($ex->getMessage());
        }
        return false;
    }
    
    public function carica($anagrafica_id) {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $anagrafica_id;
        $rows = $db->select("wallet", "*", $params);
    
        if ($rows === false)
            throw new Exception("Impossibile leggere l'anagrafica. Contattare l'assistenza.");
        if (count($rows) == 1) {
            $this->_fields = $rows[0];
            error_log(var_export($rows[0], true));
            return true;
        }
        else {
            error_log("Wallet {$anagrafica_id} inesistente");
            $this->set("anagrafica_id", $anagrafica_id);
            $this->set("saldo", 0);
        }
            
        return false;
    }
}
?>