<?php
namespace phoenix;

require_once("meta.class.php");

#class EmailInvalidException extends \Exception { }


class Movimento extends Meta{

    function __construct() {
        //parent::__construct();
        error_log("-------------------------------------------------------------------------");
        error_log("Creato MOVIMENTO");
    }
    
    public function nuovo($user, $params, $dare_avere='AVERE') {
        
        $p = [
            "importo" => $params["importo"],
            "codice_sogno" => $params["codice_sogno"],
            "codice_sogno_ricevente" => $params["codice_sogno_ricevente"],
            "codice_sogno_pagante" => $params["codice_sogno_pagante"],
            "transazione" => $params["transazione"],
            "importo_servizio_ie" => $params["importo_servizio_ie"],
            "importo_servizio_iva" => $params["importo_servizio_iva"],
            "importo_banca" => $params["importo_banca"],
            "importo_sognatore" => $params["importo_sognatore"],
            "saldo_pre" => $params["saldo_pre"],
            "saldo_post" => $params["saldo_post"],
            "anagrafica_dare" => $params["anagrafica_dare"],
            "anagrafica_avere" => $params["anagrafica_avere"],
            "tipo_movimento" => $params["tipo_movimento"]
        ];
        
        #
        # Un movimento corrisponde ad un deltra sul wallet.
        # Pu essere AVERE se bisogna aggiornare il wallet di chi riceve
        # mentre  DARE se aggiorniamo il wallet di chi paga
        #
        
        $anagrafica_id = ($dare_avere == 'AVERE') ? $p["anagrafica_avere"] : $p["anagrafica_dare"];
        $res = $this->salva($user, $p);
        if ($res !== false) {
            $wallet_ricevente = new Wallet();
            $wallet_ricevente->carica($anagrafica_id);
            $saldo_pre = $wallet_ricevente->get("saldo");
            $wallet_ricevente->set("saldo", $p["saldo_post"]);
            $wallet_ricevente->salva($user);
        }
        return $res;
    }
    
    
    public function salva($user, $params) {
        $db = getDB();
  
        $p = [
            "importo" => $params["importo"],
            "codice_sogno" => $params["codice_sogno"],
            "codice_sogno_ricevente" => $params["codice_sogno_ricevente"],
            "codice_sogno_pagante" => $params["codice_sogno_pagante"],
            "transazione" => $params["transazione"],
            "importo_servizio_ie" => $params["importo_servizio_ie"],
            "importo_servizio_iva" => $params["importo_servizio_iva"],
            "importo_banca" => $params["importo_banca"],
            "importo_sognatore" => $params["importo_sognatore"],
            "saldo_pre" => $params["saldo_pre"],
            "saldo_post" => $params["saldo_post"],
            "anagrafica_dare" => $params["anagrafica_dare"],
            "anagrafica_avere" => $params["anagrafica_avere"],
            "tipo_movimento" => $params["tipo_movimento"]
        ];
        error_log(var_export($p, true));
        # TODO
        # Qui vanno fatti i check
            
        try {
            error_log("Movimento::insert");
            $db->insert("movimenti", $p);
            list($error_code, $error_number, $error_text) = $db->error();
            error_log( var_export($db->error(), true) );
            if ($db->id() > 0) {
                return $db->id();
            }
            elseif ($error_code == '00000') {
                return true;
            }
            return false;
        }
        catch(Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new Exception($ex->getMessage());
        }
        return false;
    }
}
?>