<?php
namespace phoenix;

require_once("meta.class.php");

class Nodo extends Meta {
    private $bisnonno;
    private $nonno;
    private $padre;
    private $figli;
    
    private $codice;
    private $tipo; # se solo libera o anche dteam
    private $stato; # 
    private $ammontare; # euro sul conto
    private $proprieta; #titolo, descrizione, immagine, pubblicabile
    private $account; # account dell'utente collegato
    
    public function __constructor() {
        $this->bisnonno = [];
        $this->nonno = [];
        $this->padre = [];
        $this->figli = [];
        $this->proprieta = [];
    }
    
    public function carica($codice_nodo) {
        GLOBAL $session;
        
        $this->codice = $codice_nodo;
        $db = getDB();
        $params = [];
        $params["codice"] = $this->codice;
        $rows = $db->select("nodi", "*", $params);
    
        if ($rows === false)
            throw new \Exception("Impossibile leggere il nodo. Contattare l'assistenza.");
        if (count($rows) == 0)
            throw new \Exception("Nodo inesistente. Contattare l'assistenza.");
            
        if (count($rows) == 1) {
            $this->_fields = $rows[0];
            #error_log(var_export($rows[0], true));
        }
        
        # relazioni PADRE
        $params = [];
        $params["nodo_figlio"] = $this->codice;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            foreach($rows as $row) {
                $tipo_dteam = $row["donazione"];
                $padre = $row["nodo_padre"];
                #$session->log("PADRE: {$padre}");
                $this->padre[$tipo_dteam] = $row;
            }
        }
        else {
            $session->log("{$codice_nodo} non ha padri");
            return true;
        }
            
        # relazioni NONNO
        foreach($this->padre as $tipo_relazione => $relazione) {
            $params = [];
            $params["nodo_figlio"] = $relazione["nodo_padre"];
            $rows = $db->select("relazioni", "*", $params);
            if (count($rows) > 0) {
                foreach($rows as $row) {
                    $tipo_dteam = $row["donazione"];
                    $padre = $row["nodo_padre"];
                    #$session->log("NONNO: {$padre}");
                    $this->nonno[$tipo_dteam] = $row;
                }
            }
        }
        
        # relazioni BISNONNO
        $params = [];
        $params["nodo_figlio"] = $padre;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            foreach($rows as $row) {
                $tipo_dteam = $row["donazione"];
                $padre = $row["nodo_padre"];
                #$session->log("BISNONNO: {$padre}");
                $this->bisnonno[$tipo_dteam] = $row;
            }
        }
        
        # relazioni FIGLIO
        $params = [];
        $params["nodo_padre"] = $this->codice;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) > 0) {
            foreach($rows as $row) {
                $tipo_dteam = $row["donazione"];
                $figlio = $row["nodo_figlio"];
                $this->figli[$tipo_dteam][] = $row;
            }
        }  
        return false;
    }
    
    public function aggiorna($user) {
        $db = getDB();
        
        try {
            # UPDATE
            if ($this->id() > 0) {
                error_log("Nodo::update");
                $p = [
                    "titolo" => $this->get("titolo"),
                    "descrizione" => $this->get("descrizione"),
                    "stato" => $this->get("stato"),
                    "foto" => $this->get("foto"),
                    "categoria" => $this->get("categoria")
                ];
                $w = [
                    "codice" => $this->codice
                ];
                $db->update("nodi", $p, $w);
            }
      
            error_log(var_export($p, true));
            # TODO
            # Qui vanno fatti i check
            
            list($error_code, $error_number, $error_text) = $db->error();
            error_log( var_export($db->error(), true) );
            if ($db->id() > 0) {
                return $db->id();
            }
            elseif ($error_code == '00000') {
                return true;
            }
            return false;
        }
        catch(\Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new \Exception($ex->getMessage());
        }
        return false;
    }
    
    // public function nuovaDonazione($importo, $tipo) { # importo dato al nodo. Non sa altro
        // registrazione_log_movimenti($nodo_ricevente, $importo, $tipo, $account);
    // }
    
    public function hasFigli($tipo) { 
        if (count($this->figli[$tipo]) > 0)
            return true;
        return false;
    }
    
    public function tipi() { 
        $tipi = array_keys($this->padre);
        if (count($tipi) > 0)
            return $tipi;
        return false;
    }
    
    public function bisnonno($tipo=false) { 
        if (!$tipo)
            return $this->bisnonno;
        elseif (isset($this->bisnonno[$tipo]))
            return $this->bisnonno[$tipo];
        return false; 
    }
    
    public function nonno($tipo=false) { 
        if (!$tipo)
            return $this->nonno;
        elseif (isset($this->nonno[$tipo]))
            return $this->nonno[$tipo];
        return false; 
    }
    
    public function padre($tipo=false) { 
        if (!$tipo)
            return $this->padre;
        elseif (isset($this->padre[$tipo]))
            return $this->padre[$tipo];
        return false; 
    }
    
    public function figli($tipo=false) { 
        if (!$tipo)
            return $this->figli;
        elseif (isset($this->figli[$tipo]))
            return $this->figli[$tipo];
        return false; 
    }
    
    public function setStato($stato) {} 
    
    public function foto($default="default.png") {
        $foto = $this->get("foto");
        if (strlen($foto))
            return $foto;
        return $default;
    } 
    
    
    public function prossimaDonazione($tipo_dteam) {
        $db = getDB();
        
        $codice_sogno = $this->codice;
        $params = [];
        $params["nodo_figlio"] = $codice_sogno;
        $params["donazione"] = $tipo_dteam;
        $rows = $db->select("relazioni", "*", $params);
        if (count($rows) == 0)
            return false;
        else {
            return $rows[0]["prossima_donazione"];
        }
        return false;
    } 
    
    # Vecchia, da eliminare
    public function dona_dteam($codice_sogno_pagante, $stato, $tipo_dteam, $transazione_id) {
        GLOBAL $user, $session;
        
        # Verifichiamo padre compatibile
        if ($this->padre($tipo_dteam) === false) {
            $session->log($this->padre($tipo_dteam));
            error_log("Nodo::dona_dteam(): padre non iscritto al dteam {$tipo_dteam}.");
            return false;
        }
        $session->log("Padre {$tipo_dteam} OK");
        $importo = $tipo_dteam;
        $importo_servizio_ic = $importo * COMMISSIONE_DTEAM;
        $importo_servizio_ie = $importo_servizio_ic / (1 + IVA);
        $iva = $importo_servizio_ic - $importo_servizio_ie;
        
        // error_log("importo: ".$importo);
        // error_log("COMMISSIONE_DTEAM: ".COMMISSIONE_DTEAM);
        // error_log("importo_servizio_ic: ".$importo_servizio_ic);
        // error_log("importo_servizio_ie: ".$importo_servizio_ie);
        // error_log("iva: ".$iva);
        $session->log($this);
        
        $importo_donazioni = $importo - $importo_servizio_ic;
        $importo_donazione_singola = $importo_donazioni / 3;
        
        # Registrazione della relazione   
        $relazione = new Relazione();
        $relazione->nuova($user, $this->codice, $codice_sogno_pagante, $stato, $tipo_dteam);
        
        $nodo_pagante = new Nodo();
        $nodo_pagante->carica($codice_sogno_pagante);
        
        # Donazioni
        for ($i=0; $i<3; $i++) {
            if ($i == 0) {
                $anagrafica_id = $this->get("anagrafica_id");
                $codice_sogno_ricevente = $this->codice;
                $stato = "V";
            }
            elseif ($i == 1) {
                $padre = $this->padre($tipo_dteam);
                $anagrafica_id = $padre["anagrafica_id"];
                $codice_sogno_ricevente = $padre["nodo_padre"];
                $stato = $padre["stato"];
            }
            elseif ($i == 2) {
                $nonno = $this->nonno($tipo_dteam);
                $anagrafica_id = $nonno["anagrafica_id"];
                $codice_sogno_ricevente = $nonno["nodo_padre"];
                $stato = $nonno["stato"];
            }
            else {
                $bisnonno = $this->bisnonno($tipo_dteam);
                $anagrafica_id = $bisnonno["anagrafica_id"];
                $codice_sogno_ricevente = $bisnonno["nodo_padre"];
                $stato = $bisnonno["stato"];
            }
            
            # Verifico stato di abilitazione
            if ($stato != 'V') {
                $anagrafica_id = 2;
                $codice_sogno_ricevente = "ZZZZZ";
                # TODO: log che il nodo non  attivo
            }
            
            $wallet_ricevente = new Wallet();
            $wallet_ricevente->carica($anagrafica_id);
            $session->log($wallet_ricevente);
            $saldo_pre = $wallet_ricevente->get("saldo");
            
            $movimento = new Movimento();
            $p = [
                "importo" => $importo,
                "codice_sogno" => $this->codice,
                "codice_sogno_ricevente" => $codice_sogno_ricevente,
                "codice_sogno_pagante" => $codice_sogno_pagante,
                "transazione" => $transazione_id,
                "importo_servizio_ie" => $importo_servizio_ie / 3,
                "importo_servizio_iva" => $iva / 3,
                "importo_banca" => 0,
                "importo_sognatore" => $importo_donazione_singola,
                "saldo_pre" => $saldo_pre,
                "saldo_post" => ($saldo_pre + $importo_donazione_singola),
                "anagrafica_dare" => $nodo_pagante->get("anagrafica_id"),
                "anagrafica_avere" => $anagrafica_id
            ];
            $movimento->nuovo($user, $p);
            
            $wallet_ricevente->set("saldo", $p["saldo_post"]);
            $wallet_ricevente->salva($user);
        }
        return true;
    } 
    
    public function importi() {
        GLOBAL $session;
        
        $db = getDB();
        
        $sql = "select tipo_movimento, anagrafica_avere, codice_sogno_ricevente, sum(importo_sognatore) as importo
                from movimenti
                where tipo_movimento in ('D-TEAM', 'LIBERA') 
                and codice_sogno_ricevente='{$this->codice}'
                group by codice_sogno_ricevente, anagrafica_avere, tipo_movimento
                order by anagrafica_avere, codice_sogno_ricevente, tipo_movimento";
        $data = $db->query($sql)->fetchAll();
        $session->log($sql);
        foreach($data as $item) {
            $tipo_movimento = $item["tipo_movimento"];
            $codice_sogno = $item["codice_sogno_ricevente"]; 
            $importo = $item["importo"];
            $importi[$tipo_movimento] = $importo;
        }
        
        return $importi;
    }
}


/*
STATO = [
    verde = ok
    giallo = in scadenza
    rosso = scaduto
    azzurro = da completare / da verificare
]



class ManagerNodi {
    $nodo_iva;
    $nodo_phoenix;
    
    public function add($nodo, $parent) {
    
    }
    public function remove($nodo) {
    
    }
    public function change($nodo_da_spostare, $node_nuovo_padre) {
    
    }
    public function newDonazione($nodo_donante, $importo, $tipo_donazione) {
        inizio_transazione;
        $mporto_netto = $importo - 16%;
        registrazione_log_account($nodo_donante, $importo);
        $importo_commissione = $importo - $importo_netto;
        $importo_iva = $importo_commissione / 1.22;
        $importo_phoenix = $importo_commissione - $importo_iva;
        $nodo_iva->nuovaDonazione($importo_iva, $tipo_donazione);
        $nodo_phoenix->nuovaDonazione($importo_phoenix, $tipo_donazione);
        if ($tipo_donazione == 'L') {
            $padre = $nodo_donante->padre();
            $padre->nuovaDonazione($mporto_netto, $tipo_donazione);
        }
        elseif ($tipo_donazione == 'D') {
            $importo_pro_sogno = $importo_netto / 3;
            for ($i=0; $i<3; $i++) {
                $padre = $nodo_donante->padre();
                if ($padre == false)
                    $padre = $nodo_donante;
                $padre->nuovaDonazione($importo_pro_sogno, $tipo_donazione);
                $nodo_donante = $padre;
            }
        }
        else
            throw_eccezione;
        fine_transazione();
    }
    
    
    public function cercaPadre($codice_nodo_figlio) {
        return $nodo_padre;
    }
    
}
*/
?>