<?php
namespace phoenix;

set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB');
require_once("phoenix/user.class.php");
require_once("phoenix/medoo.class.php");

require_once('Smarty/Smarty.class.php');
require_once("Smarty/sysplugins/smarty_internal_compilebase.php");
require_once("Smarty/sysplugins/smarty_internal_resource_string.php");
require_once("Smarty/sysplugins/smarty_internal_templateparser.php");
require_once("Smarty/sysplugins/smarty_internal_templatecompilerbase.php");
require_once("Smarty/sysplugins/smarty_internal_compile_block.php");
require_once("Smarty/sysplugins/smarty_internal_write_file.php");
require_once("Smarty/sysplugins/smarty_internal_templatelexer.php");
// require_once("phoenix/anagrafica.class.php");

// class EmailInvalidException extends \Exception { }
// class EmailExistsException extends \Exception { }
// class EmailEmptyPasswordException extends \Exception { }


class Session {
    public $smarty;
    private $vars;
    function __construct() {
        $this->vars = [];
    }
    
    public function get($varname) {
        if (isset($this->vars[$varname]))
            return $this->vars[$varname];
        elseif (isset($_SESSION[$varname]))
            return $_SESSION[$varname];
        return false;
    }
    
    public function set($varname, $value, $sess=false, $smart=false) {
        $this->vars[$varname] = $value;
        if ($sess)
            $_SESSION[$varname] = $value;
        if ($smart) {
            if (!isset($this->smarty))
                $this->smarty();
            $this->smarty->assign($varname, $value);
        }
    }
    
    public function user() {
        if (isset($_SESSION['USER']))
            $user = unserialize($_SESSION['USER']);
        else
            $user = new User();
        return $user;
    }
    
    public function smarty() {
        if (isset($this->smarty))
            return $this->smarty;
            
        $this->smarty = new \Smarty;
        $this->smarty->template_dir = "templates";
        $this->smarty->compile_dir = "templates_c";
        $this->smarty->cache_dir = "cache";
        $this->smarty->config_dir = "configs";
        $this->smarty->force_compile = true;

        $this->smarty -> left_delimiter = "{%";
        $this->smarty -> right_delimiter = "%}";
        
        #$this->smarty->assign("SERVER", NODE_SERVER);
        #$this->smarty->assign("PORT", NODE_PORT);
        #$this->smarty->assign("MOUNT", NODE_MOUNT);
        $this->smarty->assign("BASE_URL", BASE_URL);
        $this->smarty->assign("REQUEST_URI", $_SERVER["REQUEST_URI"]);
        $this->smarty->assign("URL_STATIC", "/static");
        $this->smarty->assign("TEST", TEST);
        $this->smarty->assign("MONEY_DECIMAL", MONEY_DECIMAL);
        $this->smarty->assign("COSTO_TRANSAZIONE", COSTO_TRANSAZIONE);


        return $this->smarty;
    }
    
    public function log($text) {
        if (is_object($text))
            error_log(var_export($text, true));
        elseif (is_array($text))
            error_log(var_export($text, true));
        else
            error_log($text);
    }
    
    public function checkLogin() {
        if (isset($_SESSION['USER']))
            return true;
        return false;
    }
    
    public function assertLogin($url=null) {
        if (!$this->checkLogin()) {
            if ($url)
                $this->set("REDIRECT_URL_AFTER_LOGIN", $url, true);
            header("Location:/login");
            exit();
        }
    }
    
    public function sogni() {
        $db = getDB();
        // $params = [
            // "stato" => 'P',
            // 'ORDER' => \Medoo::raw('RANDOM()'),
        // ];
        // $rows = $db->select("nodi", "*", $params);
        
        $sql = "select tipo_movimento, anagrafica_avere, codice_sogno_ricevente, sum(importo_sognatore) as importo
                from movimenti
                where tipo_movimento in ('D-TEAM', 'LIBERA')
                group by codice_sogno_ricevente, anagrafica_avere, tipo_movimento
                order by anagrafica_avere, codice_sogno_ricevente, tipo_movimento";
        $data = $db->query($sql)->fetchAll();
        foreach($data as $item) {
            $tipo_movimento = $item["tipo_movimento"];
            $codice_sogno = $item["codice_sogno_ricevente"]; 
            $importo = $item["importo"];
            $importi[$codice_sogno][$tipo_movimento] = $importo;
        }
        
        
        $rows = $db->query("SELECT * FROM nodi WHERE stato='P' ORDER BY RANDOM()")->fetchAll();
        if ($rows === false)
            throw new Exception("Impossibile leggere i sogni dell'anagrafica. Contattare l'assistenza.");
            
        foreach($rows as $key => $item) {
            $codice_sogno = $item["codice"]; 
            $rows[$key]['importi'] = $importi[$codice_sogno];
        }
        
        return $rows;
    }
}
?>