<?php
namespace phoenix;

require_once("meta.class.php");

#class EmailInvalidException extends \Exception { }


class Wallet extends Meta{

    function __construct() {
        //parent::__construct();
    }
    
    public function saldo() {
        return $this->get("saldo");
    }
    
    public function carica($anagrafica_id) {
        $db = getDB();
        $params = [];
        $params["anagrafica_id"] = $anagrafica_id;
        $rows = $db->select("wallet", "*", $params);
    
        if ($rows === false)
            throw new Exception("Impossibile leggere l'anagrafica. Contattare l'assistenza.");
        if (count($rows) == 1) {
            $this->_fields = $rows[0];
            error_log(var_export($rows[0], true));
            return true;
        }
        else {
            error_log("Wallet {$anagrafica_id} inesistente");
            $this->set("anagrafica_id", $anagrafica_id);
            $this->set("saldo", 0);
        }
            
        return false;
    }
    
    public function salva($user) {
        $db = getDB();
        
        try {
            # UPDATE
            if ($this->id() > 0) {
                $p = [
                    "saldo" => $this->get("saldo"),
                    "ut" => date("c")
                ];
                $w = [
                    "anagrafica_id" => $this->get("anagrafica_id")
                ];
                $db->update("wallet", $p, $w);
            }
            # INSERT
            else {
                $p = [
                    "anagrafica_id" => $this->get("anagrafica_id"),
                    "saldo" => $this->get("saldo"),
                    "ut" => date("c")
                ];
                $db->insert("wallet", $p);
            }
      
            # TODO
            # Qui vanno fatti i check
            
            list($error_code, $error_number, $error_text) = $db->error();
            if ($db->id() > 0) {
                return $db->id();
            }
            elseif ($error_code == '00000') {
                return true;
            }
            return false;
        }
        catch(Exception $ex) {
            error_log( var_export($db->error(), true) );
            // $result->setResult(false);
            // $result->setCode("KO");
            // $result->setDescription($ex->getMessage());
            // $result->setLevel(Result::ERROR);
            # throw exception!
            throw new Exception($ex->getMessage());
        }
        return false;
    }
}
?>