<?php
require_once('common.inc.php');
get_header();
check_admin();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_mail = false;
$code_mail = getVar("POST", "code_mail", getVar("GET", "code"));

$record = Factory::crea("Mail");
$record->LoadFromCode($code_mail);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_mail'] ) &&  $_POST['ok_mail'] == "1") {
    $record->loadInput();
    $destinatari = getVar("POST", "receiver");
    $testo_html = getVar("POST", "testo");
    $processed = getVar("POST", "processed");
    
    $destinatari_email = explode(",", $destinatari);
    
    # CHECK
    if (strlen($destinatari) == 0 && $record->get('toall') == 'N') {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un destinatario se non si invia a tutti.", false);
    }
    if (strlen($destinatari) > 0) {
        foreach ($destinatari_email as $dest) {
            if (!IsValidMail($dest)) {
                $errore = true;
                show_message(MSGERROR, "La mail '{$dest}' non &egrave; valida!.", false);
            }
        }
    }
        
    if (strlen($record->get('subject')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario dare un titolo alla mail.", false);
    }
    if (strlen($testo_html) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un testo del messaggio.", false);
    }
    
    if( !$errore ) {
        $destinatari = implode(", ", $destinatari_email);
        $testo  = strip_tags($testo_html, '<br>'); 
        $testo = str_replace('<br>', '\r\n', $testo);
        
        $record->set("receiver", $destinatari);
        $record->set("message_text", $testo);
        $record->set("message_html", $testo_html);
        
        $ok_mail = Factory::salva($record);
    }
}

if (!$errore && $ok_mail) {
    echo <<<EOT
<form action="/admin-page-mail.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Email salvata.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_mail) {
?>
<style>
#testo-wysiwyg-iframe { height: 450px }
</style>
<script>
jQuery(document).ready(function() {
    $("#testo").wysiwyg({
        rmUnusedControls: false,
        controls: {
            increaseFontSize : { visible : true },
			decreaseFontSize : { visible : true },
			cut   : { visible : true },
			copy  : { visible : true },
			paste : { visible : true },
			html  : { visible: true },
			colorpicker: {
                visible: true,
                css: {
                    "color": function (cssValue, Wysiwyg) {
                        var document = Wysiwyg.innerDocument(),
                            defaultTextareaColor = $(document.body).css("color");

                        if (cssValue !== defaultTextareaColor) {
                            return true;
                        }

                        return false;
                    }
                },
                exec: function() {
                    if ($.wysiwyg.controls.colorpicker) {
                        $.wysiwyg.controls.colorpicker.init(this);
                    }
                },
                tooltip: "Colorpicker"
            },
        }
    });
});
</script>


<form action="/admin-page-mail.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Invio email a tutti gli iscritti</h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_email" name="form_email" enctype="multipart/form-data">

    <table class="mytable">
    
    <tr>
        <th><label for="receiver">Destinatari<br><span style="font-size:0.8em;">(separati dalla virgola)</span></label></th>
        <td><input type="text" value="<?php echo $record->get('receiver'); ?>" size="50" name="receiver" id="receiver" /></td>
    </tr>
    
    <tr>
        <th><label for="toall">A tutti gli iscritti</label></th>
        <td><select name="toall" id="toall">
                <option value="N" <?php selected($record->get('toall'), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get('toall'), 'S'); ?>>si</option>
            </select>
        </td>
    </tr>
    
    <tr>
        <th><label for="subject">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get('subject'); ?>" size="50" name="subject" id="subject" /></td>
    </tr>

    <tr>
        <th><label for="testo">Testo</label></th>
        <td><textarea type="text" rows="25" cols="100" name="testo" id="testo"><?php echo $record->get('message_html'); ?></textarea></td>
    </tr>
    
    <tr>
        <th><label for="processed">Processata</label></th>
        <td><select name="processed" id="processed">
                <option value="N" <?php selected($record->get('processed'), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get('processed'), 'S'); ?>>si</option>
            </select>
        </td>
    </tr>

    </table>
    <input type="hidden" name="ok_mail" value="1" />
    <input type="hidden" name="code_mail" value="<?php echo $code_mail; ?>" />
    <button type="submit" class="mybutton">Invia</button>
</form>

<?php 
}

get_footer(); ?>