<?php
/*

Template Name: Admin Iscritti

*/

require_once('common.inc.php');
get_header();
check_admin();
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "SELECT i.*, p.regione as regione_iscritto
        FROM iscritti i
        LEFT JOIN province p ON p.sigla=i.provincia
        ORDER BY i.ident desc";
$rs = $db->Esegui($sql); #DEBUG($sql);

$iscritti = array();
if ($rs != FALSE) {
    $iscritti = $rs->GetArray();
}

if (count($iscritti) == 0) {
    echo "Nessun iscritto presente.";
}
    
if (is_administrator()) 
    echo <<<EOT
    <form method="GET" action="form-iscritto.php">
        <button type="submit" class="blue">Nuovo</button>
    </form>
EOT;

foreach ($iscritti as $key => $item) {
    $background = ($key % 2) ? "#E0D1C2" : "#F5F0EB";
    $button_modifica = "";
    
    # ------------------------------------------------------------------------------------------------
    if (is_administrator()) 
        $button_modifica = <<<EOT
    <form method="GET" action="form-iscritto.php">
        <input type="hidden" name="iscritto" value="{$item['code']}" />
        <button type="submit" class="block blue">Modifica</button>
    </form>
EOT;

    $fb = "";
    if (strlen($item['fb_id']) > 0)
        $fb = "(FB) ";
        
    $validato = "NO";
    if ($item['validato'] == 't')
        $validato = "SI";
        
    $ct = date("d/m/Y", strtotime($item['ct']));
    
    echo <<<EOT
    <div class="row myround myborder" style="background:{$background}">
        <div class="two fifths padded">
            <h3 class="blue">{$fb}{$item['username']}</h3>
            <p>
                Data iscrizione: <span class="bold">{$ct}</span><br />
                Validato: <span class="bold">{$validato}</span><br />
                Ruolo: <span class="bold">{$item['ruolo']}</span>
            </p>
            {$button_modifica}
        </div>
        <div class="three fifths padded">
            <h1 class="orange">{$item['nome']} {$item['cognome']}</h1>
            <p>
                Email: <span class="bold">{$item['email']}</span><br />
                Comune: <span class="bold">{$item['comune']}</span><br />
                Provincia: <span class="bold">{$item['provincia']}</span><br />
                Regione: <span class="bold">{$item['regione_iscritto']}</span><br />
                Sesso: <span class="bold">{$item['sesso']}</span>
            </p>
        </div>
    </div>    
EOT;
    
}
 

get_footer();
?>