<?php
/*

Template Name: Admin Partecipanti

*/

require_once('common.inc.php');
get_header();
check_admin();
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "SELECT ip.email, ip.telefono, u.cognome, u.nome, u.comune, u.provincia, i.titolo, ip.versamento, SUM(quantita) as quantita, SUM(ip.importo) as importo
        FROM iniziative_partecipanti ip
        JOIN iniziative i ON i.code=ip.code_iniziativa
        JOIN iscritti u ON u.code=ip.code_utente
        LEFT JOIN province p ON p.sigla=i.provincia
        --WHERE i.costo_unitario>0
        GROUP BY ip.email, ip.telefono, u.cognome, u.nome, u.comune, u.provincia, i.titolo, ip.versamento
        ORDER BY i.titolo, u.cognome, u.nome";
$rs = $db->Esegui($sql); #DEBUG($sql);

$partecipanti = array();
if ($rs != FALSE) {
    $partecipanti = $rs->GetArray();
}

if (count($partecipanti) == 0) {
    echo "Nessun partecipante presente.";
}
    
$iniziativa = $iniziativa_precedente = "";
foreach ($partecipanti as $key => $item) {
    $background = ($key % 2) ? "#E0D1C2" : "#F5F0EB";
    $button_modifica = "";
    
    $iniziativa = $item['titolo'];
    if ($iniziativa != $iniziativa_precedente) {
        echo "<h1 class='blue'>{$item['titolo']}</h1>";
        $iniziativa_precedente = $iniziativa;
    }
    
    # ------------------------------------------------------------------------------------------------
    /*if (is_administrator()) 
        $button_modifica = <<<EOT
    <form method="GET" action="form-pelosetto.php">
        <input type="hidden" name="pelosetto" value="{$item['code']}" />
        <button type="submit" class="block blue">Modifica</button>
    </form>
EOT;*/
    $item['importo'] = number_format($item['importo'], "2", ",", ".");
    if ($item['versamento'] == 'U')
        $item['versamento'] = "una tantum";
    elseif ($item['versamento'] == 'M')
        $item['versamento'] = "mensile";
    if ($item['quantita'] > 0)
        $che_cosa = <<<EOT
<p>
    Quantit&agrave; ordinata: <span class="green bold" style="font-size: 2em;">{$item['quantita']}</span>
</p>
EOT;
    else
        $che_cosa = <<<EOT
<p>
    Partecipazione: <span class="green bold" style="font-size: 2em;">{$item['importo']}</span> {$item['versamento']}
</p>
EOT;
    
    echo <<<EOT
    <div class="row myround myborder" style="background:{$background}">
        <div class="two fifths padded">
            <h3 class="orange"><span class="orange">{$item['nome']} {$item['cognome']}</span></h3>
            {$che_cosa}
            {$button_modifica}
        </div>
        <div class="three fifths padded">
            <p>
                Email: <span class="bold">{$item['email']}</span><br />
                Telefono: <span class="bold">{$item['telefono']}</span><br />
                Comune: <span class="bold">{$item['comune']}</span><br />
                Provincia: <span class="bold">{$item['provincia']}</span>
            </p>
        </div>
    </div>    
EOT;
    
}
 

get_footer();
?>