<?php
/*

Template Name: Galleria pelosetti

*/

require_once('common.inc.php');
get_header();
check_admin();
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "SELECT *
        FROM pelosetti p
        ORDER BY ident desc";
$rs = $db->Esegui($sql); #DEBUG($sql);

$pelosetti = array();
if ($rs != FALSE) {
    $pelosetti = $rs->GetArray();
}

if ($utente->administrator()) {
    echo <<<EOT
        <form method="GET" action="form-pelosetto.php">
            <button type="submit" class="blue">Nuovo pelosetto</button>
        </form><br>
EOT;
}
if (count($pelosetti) == 0) {
    echo "Nessun pelosetto presente.";
}
    
foreach ($pelosetti as $key => $item) {
    $flag_adottadist = $item['flag_adottadist'];
    $urgente = "";
    if ($item['flag_urgente'] == 'S')
        $urgente = "<span style='font-size:1em; color:#A00; font-weight:bold;'>URGENTE</span>";
    
    $background = ($key % 2) ? "#E0D1C2" : "#F5F0EB";
    
    # ----- DISPONIBILE PER --------------------------------------------------------------------------
    $diponibile_per = "";
    if ($item['flag_adotta'] == 'S')
        $diponibile_per .= "adozione, "; 
    if ($item['flag_adottadist'] == 'S')
        $diponibile_per .= "adozione a distanza, "; 
    if ($item['flag_stallo'] == 'S')
        $diponibile_per .= "stallo, "; 
    if (strlen($diponibile_per) > 0)
        $diponibile_per = substr($diponibile_per, 0, -2);
    else
        $diponibile_per = "non disponibile";
    
    $button_modifica = "";
    $genere_pelosetto = $genere_pelosetti[$item['genere']];
    
    # ----- CALCOLO ETA' -----------------------------------------------------------------------------
    if (strlen($item['nascita_data']))
        $eta = intval(date_sottrazione(date('Y-m-d'), $item['nascita_data'], 'm')); 
    elseif (strlen($item['nascita_anno']))
        $eta = intval(date_sottrazione(date('Y-m-d'), $item['nascita_anno']."-01-01", 'm'));
    else
        $eta = "incerta";
    if ($eta > 24)
        $eta = intval($eta / 12)." anni";
    elseif ($eta == 1)
        $eta = "1 mese";
    elseif ($eta > 1)
        $eta .= " mesi";
        
    # ----- CALCOLO PRESSO CHI -----------------------------------------------------------------------
    if (strlen($item['code_canile']) > 0) {
        $canile = new Anagrafica();
        $canile->loadFromCode($item['code_canile']);
        $attualmente_presso = "{$canile->get('nome')}";
    }
    elseif (strlen($item['stallo_username']) > 0) {
        $u = get_user_from_username($item['stallo_username']);
        $attualmente_presso = "{$u["nome"]} {$u["cognome"]}";
    }
    elseif (strlen($item['stallo_altro_riferimento']) > 0) {
        $attualmente_presso = "{$item['stallo_altro_riferimento']}";
    }
        
    # ------------------------------------------------------------------------------------------------
    if (is_administrator()) 
        $button_modifica = <<<EOT
    <form method="GET" action="form-pelosetto.php">
        <input type="hidden" name="pelosetto" value="{$item['code']}" />
        <button type="submit" class="block blue">Modifica</button>
    </form>
EOT;
    
    echo <<<EOT
    <div class="row myround myborder" style="background:{$background}">
        <div class="one fourths padded">
            <img class="myimage" src="{$item['foto1']}" />
            {$button_modifica}
        </div>
        <div class="three fourths padded">
            
            <p class="titolo_pagina">{$item['nome']}</p>
            {$urgente}
            <p>
                Specie: <span class="bold">{$item['specie']}</span><br />
                Disponibile per: <span class="bold">{$diponibile_per}</span><br />
                Provenienza: <span class="bold">{$item['provenienza']}</span><br />
                Attualmente presso: <span class="bold">{$attualmente_presso} - {$item['comune']}</span><br />
                Genere: <span class="bold">{$genere_pelosetto}</span><br />
                Et&agrave;: <span class="bold">{$eta}</span>
            </p>
EOT;
        
    echo <<<EOT
        </div>
    </div>    
EOT;
    
}
 

get_footer();
?>