<?php
/*

Template Name: Admin Iscritti

*/

require_once('common.inc.php');
get_header();
check_admin();
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "SELECT v.*, i.titolo as iniziativa, u.nome, u.cognome
        FROM versamenti v
        JOIN iscritti u ON u.code=v.code_utente
        LEFT JOIN iniziative_partecipanti ip ON ip.code=v.code_padre
        LEFT JOIN iniziative i ON i.code=ip.code_iniziativa
        ORDER BY i.ident desc, v.versamento_data desc";
$rs = $db->Esegui($sql); #DEBUG($sql);

$versamenti = array();
if ($rs != FALSE) {
    $versamenti = $rs->GetArray();
}
$_SESSION["TEMP"]["risultati"] = $versamenti;

#----- ALLEGATI -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM allegati 
        WHERE code_padre IN (
            SELECT code
            FROM versamenti 
        )";
$rs = $db->Esegui($sql);

$allegati = array();
if ($rs != FALSE) {
    while(!$rs->EOF) {
        $code_versamento = $rs->Fields("code_padre");
        $allegati[$code_versamento][] = $rs->FetchRow();
        #$rs->MoveNext();
    }
}

if (count($versamenti) == 0) {
    echo "Nessun versamento effettuato.";
}
    
/*if (is_administrator()) 
    echo <<<EOT
    <form method="GET" action="form-iscritto.php">
        <button type="submit" class="blue">Nuovo</button>
    </form>
EOT;*/

$iniziativa = $iniziativa_precedente = "";
foreach ($versamenti as $key => $item) {
    $background = ($key % 2) ? "#E0D1C2" : "#F5F0EB";
    $button_modifica = "";
    
    # ------------------------------------------------------------------------------------------------
    if (is_administrator()) 
        $button_modifica = <<<EOT
    <form method="GET" action="form-versamento.php">
        <input type="hidden" name="versamento" value="{$item['code']}" />
        <button type="submit" class="block blue">Modifica</button>
    </form>
EOT;

    # ------------------------------------------------------------------------------------------------
    $text_allegati = "";
    foreach($allegati[$item["code"]] as $allegato) {
        $text_allegati .= <<<EOT
<a class="noicon" href="{$allegato['percorso']}" target="_blank"><i class="icon-file icon-2x" title="{$allegato['titolo']}"></i></a>
EOT;
    }
    
    # ------------------------------------------------------------------------------------------------
    $verificato = "NO";
    if ($item['verificato'] == 'S')
        $verificato = "SI";
        
    $versamento_data = date("d/m/Y", strtotime($item['versamento_data']));
    $versamento_tipo = ($item['versamento_tipo'] == 'U') ? "unico" : "mensile";
    $versamento_modo = ($item['versamento_modo'] == 'D') ? "diretto" : "indiretto";
    $versamento_importo = number_format($item['versamento_importo'], 2, ",", ".");
    
    $iniziativa = $item['iniziativa'];
    if ($iniziativa != $iniziativa_precedente) {
        $iniziativa_precedente = $iniziativa;
        echo <<<EOT
<h3 class="orange">{$item['iniziativa']} <a class="noicon" href="esporta.php?ex=xls&sez=versamenti&cod={$item['code']}" target="_blank"><span class="blue">[ esporta ]</span></a></h3>
EOT;
    }
    
    echo <<<EOT
    <div class="row myround myborder" style="background:{$background}">
        <div class="one ninth half-padded">{$button_modifica}</div>
        
        <div class="one ninth half-padded">{$item['nome']} {$item['cognome']}</div>
        <div class="one ninth half-padded">{$versamento_data}</div>
        <div class="one ninth half-padded">{$versamento_tipo}</div>
        <div class="one ninth half-padded">{$versamento_modo}</div>
        <div class="one ninth half-padded">{$item['versamento_referente']}</div>
        <div class="one ninth half-padded align-center">{$text_allegati}</div>
        <div class="one ninth half-padded align-right">{$versamento_importo}</div>
        <div class="one ninth half-padded align-center">{$verificato}</div>
        
        
        <!--div class="three fifths padded">
            <h1 class="orange">{$item['nome']} {$item['cognome']}</h1>
            <p>
                Email: <span class="bold">{$item['email']}</span><br />
                Comune: <span class="bold">{$item['comune']}</span><br />
                Provincia: <span class="bold">{$item['provincia']}</span><br />
                Regione: <span class="bold">{$item['regione_iscritto']}</span><br />
                Sesso: <span class="bold">{$item['sesso']}</span>
            </p>
        </div-->
    </div>    
EOT;
    
}
 

get_footer();
?>