<?php
class Pelosetto extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("pelosetti", "ident", $id);
    }
    
    public function loadInput() {
        parent::loadInput();
        
        # STALLO SI/NO
        if (strlen($this->get("code_canile")) == 0 && (
            strlen($this->get("stallo_username")) > 0 || strlen($this->get("stallo_altro_riferimento")) > 0
            ))
            $this->set("stallo", "S");
        else
            $this->set("stallo", "N");
            
        # COMUNE ATTUALE DEL PELOSETTO
        if (strlen($this->get("code_canile")) > 0) {
            $anag = new Anagrafica();
            $anag->loadFromCode($this->get("code_canile"));
            $this->set("comune_codice", $anag->get("comune_codice"));
            $this->set("comune", $anag->get("comune"));
            $this->set("provincia", $anag->get("provincia"));
        }
        elseif (strlen($this->get("stallo_username")) > 0) {
            $u = get_user_from_username($this->get("stallo_username"));
            $this->set("comune_codice", $u["comune_codice"]);
            $this->set("comune", $u["comune"]);
            $this->set("provincia", $u["provincia"]);
        }
        elseif (strlen($this->get("stallo_comune_codice")) > 0) {
            $this->set("comune_codice", $this->get("stallo_comune_codice"));
            $this->set("comune", $this->get("stallo_comune"));
            $this->set("provincia", $this->get("stallo_provincia"));
        }
    }
}
?>