<?php

class Utente {
    private $m_iscritto;
	
    public function __construct($iscritto=null) {
        if (!is_null($iscritto))
            $this->m_iscritto = $iscritto;
        else {
            $utente_anonimo = array(
                'username' => '',
                'ident' => 0,
                'code' => '',
                'nome' => 'Anonimo',
                'cognome' => '',
                'email' => '',
                'ruolo' => 'public'
            );
            $this->m_iscritto = $utente_anonimo;
        }
    }
    
    public function __get ( $name ) {
        if (isset($this->m_iscritto[$name]))
            return $this->m_iscritto[$name];
        elseif ($name == "nominativo")
            return $this->m_iscritto["nome"]." ".$this->m_iscritto["cognome"];
        return false;
    }
    
    public function administrator() {
        if ($this->ruolo == "admin")
            return true;
        return false;
    }
    
    public function publisher() {
        if ($this->ruolo == "admin")
            return true;
        if ($this->ruolo == "publisher")
            return true;
        return false;
    }
    
    public function author() {
        if ($this->ruolo == "admin")
            return true;
        if ($this->ruolo == "publisher")
            return true;
        if ($this->ruolo == "author")
            return true;
        return false;
    }
     
    public function logged() {
        if ($this->ident > 0)
            return true;
        return false;
    }
    
    public function __set ( $name, $value ) {
        if (isset($this->m_iscritto[$name]))
            $this->m_iscritto[$name] = $value;
            
        error_log ("Cerco '{$name}' in Utente ma non ne fa parte!", 0);
        return false;
    }
}
?>