<?php
@session_start();
ob_start();

/*if (!isset($_SESSION['USER']) && !isset($LOGIN_PAGE)) {
    header("Location:login.php");
    exit();
}*/
set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB/'.PATH_SEPARATOR.'/var/www/LIB/aspidenet/');
require_once("customize.inc.php");
require_once('aspidenet.inc.php');
require_once('aspidenet/classes/history.class.php');
require_once('Smarty/Smarty.class.php');
require_once("costanti.inc.php");
require_once("funzioni.inc.php");

$SYS = array();
$SYS['BASE_URL'] = BASE_URL;
$SYS['TEST'] = TEST;

/*******************************************************************************
   DATABASE
*******************************************************************************/
function aspide_get_db() {
    $db = new DB(DB_TYPE); 
    $db->Connetti(DB_SERVER, DB_USER, DB_PASS, DB_DBNAME);
    return $db;
}
$db = aspide_get_db();

/*******************************************************************************
   SMARTY
*******************************************************************************/
$smarty = new Smarty;
$smarty->template_dir = "templates";
$smarty->compile_dir = "templates_c";
$smarty->cache_dir = "cache";
$smarty->config_dir = "configs";
#$smarty->debug = true;

#----- AUTOLOAD ------------------------------------------------------------------------------------------------------------------
spl_autoload_register( 'autoloader' );
 
function autoloader( $class ) {
    #error_log ("Cerco '{$class}' in autoloader!", 0);
    $class = strtolower($class);
    if ( file_exists ('classes/' . $class . '.class.php' ) ){
        include_once('classes/' . $class . '.class.php' );
    }
}

#----- UTENTE --------------------------------------------------------------------------------------------------------------------
if (isset($_SESSION['USER']))
    $utente = new Utente($_SESSION['USER']);
else
    $utente = new Utente();
$code_utente = $utente->code; #temporaneo
$smarty->assign("utente", $utente);

#----- USER_AGENT ----------------------------------------------------------------------------------------------------------------
#DEBUG($_SERVER['HTTP_USER_AGENT']);
$bot = is_bot();
if ($bot)
    error_log("E' un bot!");
$smarty->assign("bot", $bot);

#----- COOKIE --------------------------------------------------------------------------------------------------------------------
if (!isset($_SESSION['COOKIES']) && !$bot) {
    $smarty->assign("abilita_cookies", false);
    $_SESSION['COOKIES'] = true; # continuando si accetta.
}
else {
    $abilita_cookies = getVar("POST", "abilita_cookies", $_SESSION['COOKIES']);
    $_SESSION['COOKIES'] = $abilita_cookies;
    $smarty->assign("abilita_cookies", $_SESSION['COOKIES']);
}

#----- FACEBOOK ------------------------------------------------------------------------------------------------------------------
if (!is_user_logged_in()) {
    require_once('fb/facebook.php');

    $facebook_config = array(
        'appId' => '774258785965360',
        'secret' => 'd3e7307abcabc424920d1c3fc900ef64',
        'fileUpload' => false, // optional
        'allowSignedRequest' => false, // optional, but should be set to false for non-canvas apps
    );

    $facebook = new Facebook($facebook_config);
    $user = $facebook->getUser();

    $url_after = getVar("POST", "url", getVar("SESSION", "URL_AFTER"));
    if (strlen($url_after) == 0)
        $url_after = "index.php";

    if ($user) {
        try {
            $user_profile = $facebook->api('/me');
        } 
        catch (FacebookApiException $e) {
            error_log($e);
            $user = null;
        }
        $_SESSION["FACEBOOK"] = $user_profile;
        
        if (try_login(array('fb_id' => $user_profile['id'])) == LOGIN_OK) {
            if (stripos($_SERVER['PHP_SELF'], $url_after) === false) {
                header("Location:".$url_after);
                exit();
            }
        }
        else {
            if (stripos($_SERVER['PHP_SELF'], "form-nuovo-iscritto.php") === false) {
                header("Location:form-nuovo-iscritto.php");
                exit();
            }
        }
    }
    else {
        $login_url = $facebook->getLoginUrl(array('scope' => 'public_profile,email,user_hometown,user_location', 'onlogin' => BASE_URL.$url_after));
    }
}

$smarty->assign("HOMEPAGE", homepage());
$smarty->assign("TEST", TEST);
$smarty->assign("BASE_URL", BASE_URL);
$smarty->assign("pubblicita", true);
$smarty->assign("login_url", $login_url);

$utils = new Utils();
$smarty->assign("utils", $utils);

$history = History::getInstance();
$history->nuova();

$smarty->assign("history", $history);

#------------------------------------------------------------------------------------
# CONTATORI PELOSETTI, ECC ECC
#------------------------------------------------------------------------------------
$contatore_adotta = $contatore_adottadist = $contatore_stallo = $contatore_adottati = 0;
# Adozione
$sql = "SELECT count(*) as numero FROM pelosetti WHERE flag_stato='disponibile' AND flag_adotta='S'";
$rs = $db->Esegui($sql);
if ($rs) {
    $contatore_adotta = $rs->Fields("numero");
    $rs->Close();
}
# Adozione a distanza
$sql = "SELECT count(*) as numero FROM pelosetti WHERE flag_stato='disponibile' AND flag_adottadist='S'";
$rs = $db->Esegui($sql);
if ($rs) {
    $contatore_adottadist = $rs->Fields("numero");
    $rs->Close();
}
# Stallo
$sql = "SELECT count(*) as numero FROM pelosetti WHERE flag_stato='disponibile' AND flag_stallo='S'";
$rs = $db->Esegui($sql);
if ($rs) {
    $contatore_stallo = $rs->Fields("numero");
    $rs->Close();
}
# Adottati
$sql = "SELECT count(*) as numero FROM pelosetti WHERE flag_stato='adottato'";
$rs = $db->Esegui($sql);
if ($rs) {
    $contatore_adottati = $rs->Fields("numero");
    $rs->Close();
}
# Cerchiamo
$sql = "SELECT count(*) as numero FROM cerco WHERE trovato='N'";
$rs = $db->Esegui($sql);
if ($rs) {
    $contatore_cerchiamo = $rs->Fields("numero");
    $rs->Close();
}
# Smarriti
$sql = "SELECT count(*) as numero FROM smarriti WHERE ritrovato='N'";
$rs = $db->Esegui($sql);
if ($rs) {
    $contatore_smarriti = $rs->Fields("numero");
    $rs->Close();
}
$smarty->assign("contatore_adotta", $contatore_adotta);
$smarty->assign("contatore_adottadist", $contatore_adottadist);
$smarty->assign("contatore_stallo", $contatore_stallo);
$smarty->assign("contatore_adottati", $contatore_adottati);
$smarty->assign("contatore_cerchiamo", $contatore_cerchiamo);
$smarty->assign("contatore_smarriti", $contatore_smarriti);
#------------------------------------------------------------------------------------
?>