<?php
require_once("common.inc.php");

$MODULO_CODE = "TEMP";
$formato = getVar("GET", "ex", 'xls');
$sezione = getVar("GET", "sez");
$codice = getVar("GET", "cod");

switch($sezione) {
    case 'versamenti':
        $sql = "SELECT i.titolo as iniziativa, u.cognome, u.nome, v.versamento_data, versamento_tipo, versamento_importo, versamento_modo, versamento_referente, v.note, verificato
                FROM versamenti v
                JOIN iscritti u ON u.code=v.code_utente
                LEFT JOIN iniziative_partecipanti ip ON ip.code=v.code_padre
                LEFT JOIN iniziative i ON i.code=ip.code_iniziativa
                ORDER BY i.ident desc, v.versamento_data desc";
        break;
}

$rs = $db->Esegui($sql); #DEBUG($sql);
$array_risultati = array();
if ($rs != FALSE)
    $array_risultati = $rs->GetArray();

# Oltre i 5000 record (o forse meno), PHPExcel esplode!!!
if (count($array_risultati) > 4000)
  $formato = "csv";
        
#===============================================================================
# CSV
#===============================================================================
if ($formato == 'csv') {
  CreaCSV("/tmp/{$operatore->username()}.csv", $array_risultati);
          
  // Redirect output to a client web browser (Excel5)
	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	header('Content-Type: application/octect-stream');
	header('Content-Disposition: attachment;filename="esportazione.csv"');
	header('Cache-Control: max-age=0');
	header("Content-Transfer-Encoding: text");
  include "/tmp/{$operatore->username()}.csv";
	exit;
}
#===============================================================================
# EXCEL
#===============================================================================
elseif ($formato == 'xls') {
	require_once 'PHPExcel/PHPExcel.php';
	
	$totale_record = count($array_risultati);
	$numfields = count($array_risultati[0]);

	#------------------------------------------------------------------------
  # La CACHE sembra NON funzionare!!!
  #$cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory;
  #$cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_in_memory_serialized;
  /*$cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_phpTemp;
  $cacheSettings = array( 'memoryCacheSize'  => '80MB');
  PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);*/

	#------------------------------------------------------------------------
  // Create new PHPExcel object
	$objPHPExcel = new PHPExcel();
  
	// Set properties
	$objPHPExcel->getProperties()->setCreator("Amici di Giulita")
															 ->setLastModifiedBy("Amici di Giulita")
															 ->setTitle("")
															 ->setSubject("")
															 ->setDescription("")
															 ->setKeywords("")
															 ->setCategory("");

	//----------------------------------------------------------------------------
	// Nomi dei campi:
	$nomi_colonne = array_keys($array_risultati[0]);
	for ($f = 0; $f < $numfields; $f++) {
					$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($f, 1, $nomi_colonne[$f]);
	}

	//----------------------------------------------------------------------------
	// Record:
	// Per ogni riga:
	for ($row=0; $row<$totale_record; $row++) {
					// Per ogni colonna:
					for ($i=0; $i < $numfields; $i++) {
									$valore = trim($array_risultati[$row][$nomi_colonne[$i]]);
									$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($i, $row+2, $valore);
					}
	}

	// Redirect output to a client web browser (Excel5)
	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	header('Content-Type: application/octect-stream');
	header('Content-Disposition: attachment;filename="report.xls"');
	header('Cache-Control: max-age=0');
	header("Content-Transfer-Encoding: binary");

	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
	$objWriter->save('php://output');
	exit;
}
?>
