<?php
/**
 * Template Name: Form adottante
 */

require_once('common.inc.php');
get_header();
$permalink = get_permalink();
check_login($permalink);

$code_pelosetto = getVar("GET", "pelosetto", getVar("POST", "code_pelosetto", getVar("POST", "pelosetto")));


#---------------------------------------------------------------------------------------------------------------------------------

$ok_adottante = false;
$errore = false;

$record = Factory::crea("Adottante");
if (strlen($code_pelosetto) > 0)
    $record->loadFromPelosetto($code_pelosetto);
$record->setUser($utente->username);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_adottante'] ) &&  $_POST['ok_adottante'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('nome')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il nome.", false);
    }
    if (strlen($record->get('cognome')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il cognome.", false);
    }
    if (strlen($record->get('comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il comune.", false);
    }
    if (strlen($record->get('indirizzo')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare l'indirizzo.", false);
    }
    if (strlen($record->get('telefono')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un telefono.", false);
    }
    if (strlen($record->get('email')) > 0 && !IsValidMail($record->get('email'))) {
        $errore = true;
        show_message(MSGERROR, "L'email inserita non &egrave; valida.", false);
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_adottante = true;
        }
    }
}

if (!$errore && $ok_adottante) {
    echo <<<EOT
<form action="page-presentazione-pelosetto.php" method="GET">
    <input type="hidden" name="pelosetto" value="{$code_pelosetto}" />
    <div id="message" class="updated fade"><p><strong>Adottante salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_adottante) {
?>

<script>
jQuery(document).ready(function() {

});
</script>


<form action="indietro.php" method="GET">
    <!--input type="hidden" name="pelosetto" value="<?php echo $code_pelosetto; ?>" /-->
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Scheda adottante</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuova_adottante" name="form_nuova_adottante">

    <table class="mytable">

    <tr>
        <td><label for="nome">Nome</label></td>
        <td><input type="text" required value="<?php echo $record->get("nome"); ?>" size="35" name="nome" id="nome" /></td>
    </tr>

    <tr>
        <td><label for="cognome">Cognome</label></td>
        <td><input type="text" required value="<?php echo $record->get("cognome"); ?>" size="35" name="cognome" id="cognome" /></td>
    </tr>

    <tr>
        <td><label for="cf">Codice fiscale</label></td>
        <td><input type="text" value="<?php echo $record->get("cf"); ?>" size="20" name="cf" id="cf" /></td>
    </tr>
    
    <tr>
        <td><label for="comune">Comune</label></td>
        <td>
            <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
        </td>
    </tr>

    <tr>
        <td><label for="partenza">Localit&agrave;</label></td>
        <td><input type="text" value="<?php echo $record->get("localita"); ?>" size="50" name="localita" id="localita" /></td>
    </tr>

    <tr>
        <td><label for="indirizzo">Indirizzo</label></td>
        <td><input type="text" required value="<?php echo $record->get("indirizzo"); ?>" size="50" name="indirizzo" id="indirizzo" /></td>
    </tr>

    <tr>
        <td><label for="email">Email principale</label></td>
        <td><input type="email" value="<?php echo $record->get("email"); ?>" size="50" name="email" id="email" /></td>
    </tr>

    <tr>
        <td><label for="telefono">Telefono principale</label></td>
        <td><input type="text" required value="<?php echo $record->get("telefono"); ?>" size="50" name="telefono" id="telefono" /></td>
    </tr>

    <tr>
        <td><label for="note">Note</label></td>
        <td><textarea type="text" rows="5" cols="50" name="note" id="note"><?php echo $record->get("note"); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_adottante" value="1" />
    <input type="hidden" name="code_adottante" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_pelosetto" value="<?php echo $code_pelosetto; ?>" />
    <button class="mybutton" type="submit">Salva</button>
</form>



<script>
window.onload=function(){
    // = document.getElementById("versamento_modo");
    //alert(o.value);
    //change_VersamentoModo(o);
};
</script>
<?php 
}

get_footer(); ?>