<?php
/**
 * Template Name: Form allegato
 */

require_once('common.inc.php');
get_header();
check_publisher();


$code_allegato = getVar("GET", 'allegato', getVar("POST", 'code_allegato', ''));
$code_padre = getVar("GET", 'padre', getVar("POST", 'code_padre', ''));

$ok_allegato = false;
$errore = false;

$record = Factory::crea("Allegato");

if(strlen($code_allegato)) {
    $record->loadFromCode($code_allegato);
}
else
    $record->set("code_padre", $code_padre);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_allegato'] ) &&  $_POST['ok_allegato'] == "1") {
    $record->loadInput();
    
    $path_base = BASE_DIR;
    $path_rel = "/uploads/allegati/";
    $ret = upload_file("allegato", $path_base, $path_rel, "allegato_");
    
    if ($ret !== false) {
        $name = $ret["name"];
        error_log("percorso - ".$path_rel.$name);
        $record->set("percorso", $path_rel.$name);
        $record->set("formato", $ret["extension"]);
    }
    
    # CHECK
    #if (strlen($record->get('stallo_altro_riferimento')) > 0 && strlen($record->get('stallo_comune_codice')) == 0) {
    #    $errore = true;
    #    show_message(MSGERROR, "Se si indica un referente per lo stallo &egrave; necessario indicare anche il comune.", false);
    #}
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_allegato = true;
        }
    }
}

if (!$errore && $ok_allegato) {
    echo <<<EOT
<form action="indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Allegato salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_allegato) {
?>

<script>
jQuery(document).ready(function() {
    
});
</script>



<form method="GET" action="indietro.php">
    <button type="submit" class="mybutton">Indietro</button>
</form><br>

<h1 class="titolo_pagina">Allegato</h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_allegato" name="form_allegato" enctype="multipart/form-data">

    <table class="mytable">
        
    <tr>
        <th><label for="titolo">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get("titolo"); ?>" size="15" name="titolo" id="titolo" /></td>
    </tr>

    <tr>
        <th><label for="allegato">Allegato</label></th>
        <td>File accettati: PDF, PNG, JPG, DOC, DOCX<br>
        <input type="file" name="allegato" />
        <?php
        echo $record->get("percorso")."<BR>";
        echo $record->get("formato")."<BR>";
        ?>
        </td>
    </tr>

    <tr>
        <th><label for="code_classificazione">Tipo</label></th>
        <td><select name="code_classificazione" id="code_classificazione">
                <option value="CI" <?php selected($record->get("code_classificazione"), 'CI'); ?>>carta d'identit&agrave;</option>
                <option value="CF" <?php selected($record->get("code_classificazione"), 'CF'); ?>>codice fiscale (C.F.)</option>
                <option value="CICF" <?php selected($record->get("code_classificazione"), 'CICF'); ?>>carta d'identit&agrave; e C.F.</option>
                <option value="ASL" <?php selected($record->get("code_classificazione"), 'ASL'); ?>>documento ASL</option>
                <option value="ALTRO" <?php selected($record->get("code_classificazione"), 'ALTRO'); ?>>altro</option>
            </select></td>
    </tr>
        
    </table>
    <input type="hidden" name="ok_allegato" value="1" />
    <input type="hidden" name="code_allegato" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_padre" value="<?php echo $record->get('code_padre'); ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>
<?php 
}

get_footer(); ?>