<?php
/**
 * Template Name: Form anagrafica referente
 */

require_once('common.inc.php');
get_header();
check_publisher();

$code_anagrafica = getVar("GET", "anagrafica", getVar("POST", "code_anagrafica", getVar("POST", "anagrafica")));
$code_referente = getVar("GET", "referente", getVar("POST", "code_referente", getVar("POST", "referente")));
$permalink = get_permalink();

$ok_referente_anagrafica = false;
$errore = false;

class RecordAnagraficheReferenti extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("anagrafiche_referenti", "ident", $id);
    }
}
$record = Factory::crea("RecordAnagraficheReferenti");
if (strlen($code_referente) > 0) {
    $record->loadFromCode($code_referente);
    $code_anagrafica = $record->get('code_anagrafica');
}

$anag = Factory::crea("Anagrafica");
if (strlen($code_anagrafica) > 0)
    $anag->loadFromCode($code_anagrafica);
    
#----- CHECK ANAGRAFICA
check_anagrafica($anag->get('cu'));

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_referente_anagrafica'] ) &&  $_POST['ok_referente_anagrafica'] == "1") {
    $record->loadInput();
    
    
    # CHECK
    if (strlen($record->get('username')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare uno username.", false);
    }
    else {
        if (check_username($record->get("username")) == true) {
            $errore = true;
            show_message(MSGERROR, "L'username indicato non esiste!", false);
        }
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_referente_anagrafica = true;
        }
    }
}

if (!$errore && $ok_referente_anagrafica) {
    echo <<<EOT
<form action="indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Referente anagrafica salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_referente_anagrafica) {
    
?>

<script>
jQuery(document).ready(function() {
    // COMUNE 
	jQuery( "#comune_cerca" ).autocomplete({
        source: "/json-comuni/",
        minLength: 2,
        select: function( event, ui ) {
            var codice = ui.item.value.substring(2);
            var prov = ui.item.value.substring(0, 2);
            var comune = ui.item.label;
            
            //jQuery("#partenza_cerca").val(comune);
            jQuery("#comune").val(comune);
            jQuery("#provincia").val(prov);
            jQuery("#comune_codice").val(codice);
            
            return false;
        }
    });
});
</script>

<form action="indietro.php" method="POST">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Referente anagrafica</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_referente_anagrafica" name="form_referente_anagrafica">

    <table class="mytable">

    <tr>
        <td><label for="ruolo">Ruolo</label></td>
        <td><select name="ruolo" id="ruolo">
                <option value="REFERENTE" <?php selected($record->get("ruolo"), 'REFERENTE'); ?>>referente</option>
                <option value="RESPONSABILE" <?php selected($record->get("ruolo"), 'RESPONSABILE'); ?>>responsabile</option>
            </select></td>
    </tr>
    
    <tr>
        <td><label for="username">Utente</label></td>
        <td><input type="text" value="<?php echo $record->get("username"); ?>" size="50" name="username" id="username" /></td>
    </tr>

    </table>
    <input type="hidden" name="ok_referente_anagrafica" value="1" />
    <input type="hidden" name="code_anagrafica" value="<?php echo $code_anagrafica; ?>" />
    <input type="hidden" name="code_referente" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $code_utente; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>



<script>
window.onload=function(){
};
</script>
<?php 
}
get_footer(); 
?>