<?php
/**
 * Template Name: Form anagrafica
 */

require_once('common.inc.php');
get_header();
check_publisher();

$code_anagrafica = getVar("GET", "anagrafica", getVar("POST", "code_anagrafica", getVar("POST", "anagrafica")));
$tipo = getVar("POST", "tipo", getVar("GET", "tipo", 'CANILE'));
$permalink = get_permalink();
$nuova = false;
#---------------------------------------------------------------------------------------------------------------------------------

$ok_anagrafica = false;
$errore = false;

$record = Factory::crea("Anagrafica");
if (strlen($code_anagrafica) > 0)
    $record->loadFromCode($code_anagrafica);
else
    $nuova = true;
$record->setUser($utente->username);

#----- CHECK ANAGRAFICA
check_anagrafica($record->get('cu'), $nuova);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_anagrafica'] ) &&  $_POST['ok_anagrafica'] == "1") {
    $record->loadInput();
    $tipo = $record->get("tipo");
    
    # CHECK
    if (strlen($record->get('nome')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare la ragione sociale.", false);
    }
    if (strlen($record->get('comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il comune.", false);
    }
    if (strlen($record->get('email')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare l'email.", false);
    }
    elseif (!IsValidMail($record->get('email'))) {
        $errore = true;
        show_message(MSGERROR, "L'email inserita non &egrave; valida.", false);
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_anagrafica = true;
        }
    }
}

if (!$errore && $ok_anagrafica) {
    echo <<<EOT
<form action="indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Anagrafica salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_anagrafica) {
?>

<script>
jQuery(document).ready(function() {

});
</script>


<form action="/indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Anagrafica</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuova_anagrafica" name="form_nuova_anagrafica">

    <table class="mytable">

    <tr>
        <td><label for="tipo">Tipo</label></td>
        <td><select name="tipo" id="tipo">
                <option value="CANILE" <?php selected($record->get("tipo"), 'CANILE'); ?>>canile</option>
                <option value="NEGOZIO" <?php selected($record->get("tipo"), 'NEGOZIO'); ?>>negozio</option>
            </select></td>
    </tr>
    
    <tr>
        <td><label for="nome">Ragione sociale</label></td>
        <td><input type="text" value="<?php echo $record->get("nome"); ?>" size="50" name="nome" id="nome" /></td>
    </tr>

    <tr>
        <td><label for="piva">Partita IVA</label></td>
        <td><input type="text" value="<?php echo $record->get("piva"); ?>" size="15" name="piva" id="piva" /></td>
    </tr>

    <tr>
        <td><label for="cf">Codice fiscale</label></td>
        <td><input type="text" value="<?php echo $record->get("cf"); ?>" size="20" name="cf" id="cf" /></td>
    </tr>
    
    <tr>
        <td><label for="comune">Comune</label></td>
        <td>
            <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
        </td>
    </tr>

    <tr>
        <td><label for="partenza">Localit&agrave;</label></td>
        <td><input type="text" value="<?php echo $record->get("localita"); ?>" size="50" name="localita" id="localita" /></td>
    </tr>

    <tr>
        <td><label for="indirizzo">Indirizzo</label></td>
        <td><input type="text" value="<?php echo $record->get("indirizzo"); ?>" size="50" name="indirizzo" id="indirizzo" /></td>
    </tr>

    <tr>
        <td><label for="email">Email principale</label></td>
        <td><input type="text" value="<?php echo $record->get("email"); ?>" size="50" name="email" id="email" /></td>
    </tr>

    <tr>
        <td><label for="telefono">Telefono principale</label></td>
        <td><input type="text" value="<?php echo $record->get("telefono"); ?>" size="50" name="telefono" id="telefono" /></td>
    </tr>

    <tr>
        <td><label for="fax">Fax</label></td>
        <td><input type="text" value="<?php echo $record->get("fax"); ?>" size="50" name="fax" id="fax" /></td>
    </tr>

    <tr>
        <td><label for="url_www">URL sito internet</label></td>
        <td><input type="text" value="<?php echo $record->get("url_www"); ?>" size="50" name="url_www" id="url_www" /></td>
    </tr>

    <tr>
        <td><label for="url_coordinate_bancarie">URL coordinate bancarie</label></td>
        <td><input type="text" value="<?php echo $record->get("url_coordinate_bancarie"); ?>" size="50" name="url_coordinate_bancarie" id="url_coordinate_bancarie" /></td>
    </tr>

    <tr>
        <td><label for="note">Note</label></td>
        <td><textarea type="text" rows="5" cols="50" name="note" id="note"><?php echo $record->get("note"); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_anagrafica" value="1" />
    <input type="hidden" name="code_anagrafica" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $code_utente; ?>" />
    <button class="mybutton" type="submit">Salva</button>
</form>



<script>
window.onload=function(){
    // = document.getElementById("versamento_modo");
    //alert(o.value);
    //change_VersamentoModo(o);
};
</script>
<?php 
}
?>
<?php get_footer(); ?>