<?php
/**
 * Template Name: Form articolo
 */

require_once('common.inc.php');
get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_articolo = false;
$code_articolo = getVar("POST", "articolo", getVar("POST", "code_articolo", getVar("GET", "articolo")));

class RecordArticoli extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("articoli", "ident", $id);
    }
}
$record = Factory::crea("RecordArticoli");
if (strlen($code_articolo))
    $record->loadFromCode($code_articolo);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_articolo'] ) &&  $_POST['ok_articolo'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('titolo')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario dare un titolo all'articolo.", false);
    }
    
    $nome_campo = "immagine";
    $path_base = BASE_DIR;
    $path_rel = "/uploads/articoli/";
    
    $name = upload_image($nome_campo, $path_base, $path_rel, "articolo_");
    if ($name !== false) {
        error_log($nome_campo." - ".$path_rel.$name);
        $record->set($nome_campo, $path_rel.$name);
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_articolo = true;
        }
    }
}

if (!$errore && $ok_articolo) {
    echo <<<EOT
<form action="/indietro.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Articolo salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_articolo) {
?>

<script>
jQuery(document).ready(function() {
    $("#testo").wysiwyg({
        rmUnusedControls: false,
        controls: {
            increaseFontSize : { visible : true },
			decreaseFontSize : { visible : true },
			cut   : { visible : true },
			copy  : { visible : true },
			paste : { visible : true },
			html  : { visible: true },
			colorpicker: {
                visible: true,
                css: {
                    "color": function (cssValue, Wysiwyg) {
                        var document = Wysiwyg.innerDocument(),
                            defaultTextareaColor = $(document.body).css("color");

                        if (cssValue !== defaultTextareaColor) {
                            return true;
                        }

                        return false;
                    }
                },
                exec: function() {
                    if ($.wysiwyg.controls.colorpicker) {
                        $.wysiwyg.controls.colorpicker.init(this);
                    }
                },
                tooltip: "Colorpicker"
            },
					
        }
    });
});
</script>


<form action="/indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina"><?php echo $titolo_pagina; ?></h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_nuovo_articolo" name="form_nuovo_articolo" enctype="multipart/form-data">

    <table class="mytable">
    
    <tr>
        <th><label for="categoria">Categoria</label></th>
        <td><select name="categoria" id="categoria">
                <option value="Generica" <?php selected($record->get("categoria"), 'Generica'); ?>>Generica</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="titolo">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get("titolo"); ?>" size="50" name="titolo" id="titolo" /></td>
    </tr>
    
    <tr>
        <th><label for="immagine">Logo</label></th>
        <td><input type="file" value="" size="15" name="immagine" id="immagine" />
        <?php
        if (strlen($record->get("immagine")))
            echo "<img src='{$record->get("immagine")}' height='50px' />";
        ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="testo">Testo</label></th>
        <td><textarea type="text" rows="5" cols="50" name="testo" id="testo"><?php echo $record->get("testo"); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_articolo" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo (strlen($record->get('code_utente'))) ? $record->get('code_utente') : $utente->code; ?>" />
    <input type="hidden" name="code_articolo" value="<?php echo $record->code(); ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>