<?php
/**
 * Template Name: Form login
 */

require_once('common.inc.php');
get_header();

$code = getVar("GET", "code", getVar("POST", "code_verifica", ""));
$errore = false;
$uid = 0;
$u_code = "";

if (strlen($code) > 0) {
    $sql = "SELECT * FROM iscritti WHERE codice_verifica='{$code}'";
    $rs = $db->Esegui($sql);
    if ($rs == false || $rs->RecordCount() == 0) {
        show_message(MSGERROR, "Codice di verifica inesistente o scaduto. Impossibile cambiare la password!", false);
        echo <<<EOT
<form action="/" method="GET">
    <div id="message" class="updated fade"><p><strong>Ritorna alla homepage.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
        get_footer(); 
        exit();
    
    }
    $u = $rs->FetchRow();
    $uid = $u['ident'];
    $u_code = $u['code'];
}

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_cambio_password'] ) &&  $_POST['ok_cambio_password'] == "1") {
    class RecordIscrizioni extends RecordBase {}
    $record = new RecordIscrizioni("iscritti", "ident");
    
    if (is_user_logged_in() || $uid > 0) {
        $u_code = (is_user_logged_in()) ? $utente->code : $u_code;
        
        $password1 = getVar("POST", "password1");
        $password2 = getVar("POST", "password2");
        
        if ($password1 != $password2) {
            $errore = true;
            show_message(MSGERROR, "Le password non corrispondono.", false);
        }
        
        if (strlen($password1) == 0 || strlen($password2) == 0) {
            $errore = true;
            show_message(MSGERROR, "Le password non possono essere vuote!", false);
        }
        
        if (!$errore) {
            $record->loadFromCode($u_code);
            $record->set('password', $password1);
            $record->set('codice_verifica', "");
            $res = $record->update();
            
            if ($res == false)
                show_message(MSGERROR, "Errore nel cambiamento della password!", false);
            else
                show_message(MSGINFO, "La password &egrave; stata cambiata con successo!", false);
                
            echo <<<EOT
<form action="/" method="GET">
    <div id="message" class="updated fade"><p><strong>Ritorna alla homepage.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
            get_footer(); 
            exit();
        }
    }
}

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_rigenera_password'] ) &&  $_POST['ok_rigenera_password'] == "1") {
    $username = getVar("POST", "username");
    $email = getVar("POST", "email");

    $u = get_user_from_username($username);
    if ($u) {
        $u_code = $u['code'];
    }
    else {
        $u = get_user_from_email($email);
        if ($u)
            $u_code = $u['code'];
    }

    if (strlen($u_code) == 0) {
        $errore = true;
        show_message(MSGERROR, "Utente inesistente.", false);
    }
    else {
        $codice = md5(microtime());
        class RecordIscrizioni extends RecordBase {}
        $record = new RecordIscrizioni("iscritti", "ident");
        $record->loadFromCode($u_code);
        $record->set('codice_verifica', $codice);
        $res = $record->update();
        
        $url = $SYS['BASE_URL']."form-cambio-password.php?code=".$codice;
        
        $msg = <<<EOT
E' stata richiesta la rigenerazione della tua password.\r\n
Per completare l'operazione, copia il link sotto nel tuo browser preferito:\r\n
\r\n
{$url}\r\n
EOT;
        $msg_html = <<<EOT
E' stata richiesta la rigenerazione della tua password.<br>
Per completare l'operazione, segui il link sotto:<br>
<br>
<a href="{$url}">Cambia password</a>
EOT;
        send_mail("Rigenera passowd.", $record->get("email"), $msg, $msg_html);
 
        if ($res == false)
            show_message(MSGERROR, "Impossibile continuare!", false);
        else
            show_message(MSGINFO, "La tua richiesta ha avuto successo. Ti abbiamo inviato un messaggio sulla tua email con la procedura per cambiare la password.", false);
                
        echo <<<EOT
<form action="/form-login.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Vai alla pagina di login.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
        get_footer(); 
        exit();
    }
}

if (is_user_logged_in() || $uid > 0) {
?>
<h1 class="titolo_pagina">Cambio password</h1>
<form method="POST" action="<?php get_permalink(); ?>" id="form_cambio_password" name="form_cambio_password" style="max-width: 600px">
    <div class="equalize row">
        <div><label for="password1">Password</label></div>
        <div><input type="password" value="" size="15" name="password1" id="password1" /></div>
        
        <div><label for="password2">Password (inserisci nuovamente per verifica)</label></div>
        <div><input type="password" value="" size="15" name="password2" id="password2" /></div>
    </div>
    <input type="hidden" name="ok_cambio_password" value="1" />
    <input type="hidden" name="code_verifica" value="<?php echo $code; ?>" />
    <button class="mybutton" type="submit">Cambia</button> 
</form>
<?php 
}
else {
?>
<h1 class="titolo_pagina">Richiesta generazione nuova password</h1>
<form method="POST" action="<?php get_permalink(); ?>" id="form_cambio_password" name="form_cambio_password" style="max-width: 400px">
    <div class="equalize row">
        <div class="bold"><label for="username">Inserisci il tuo Username, se lo ricordi</label></div>
        <div><input type="text" value="<?php echo $username; ?>" size="30" name="username" id="username" /></div>
        
        <p class="padded bold orange">Oppure</p>
        
        <div class="bold"><label for="email">Inserisci l'Email con cui ti sei registrato</label></div>
        <div><input type="text" value="<?php echo $email; ?>" size="30" name="email" id="email" /></div>
    </div>
    
    <input type="hidden" name="ok_rigenera_password" value="1" />
    <input type="hidden" name="url" value="<?php echo $url_after; ?>" />
    <button class="mybutton" type="submit">Rigenera</button> 

</form>
<?php 
}

get_footer(); 
?>
