<?php
/**
 * Template Name: Form cerco
 */

require_once('common.inc.php');
get_header();
check_login();


$ok_cerco = false;
$errore = false;

$record = Factory::crea("Cerco");

$code_cerco = getVar("GET", 'cerco', getVar("POST", 'code_cerco', ''));
if(strlen($code_cerco)) {
    $record->loadFromCode($code_cerco);
}

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_cerco'] ) &&  $_POST['ok_cerco'] == "1") {
    $record->loadInput();
    
    
    
    # CHECK
    #if (strlen($record->get('stallo_altro_riferimento')) > 0 && strlen($record->get('stallo_comune_codice')) == 0) {
    #    $errore = true;
    #    show_message(MSGERROR, "Se si indica un referente per lo stallo &egrave; necessario indicare anche il comune.", false);
    #}
    
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_cerco = true;
        }
    }
}

if (!$errore && $ok_cerco) {
    echo <<<EOT
<form action="/indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Richiesta salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_cerco) {
?>

<script>
jQuery(document).ready(function() {
    
});
</script>



<form method="GET" action="/indietro.php">
    <button type="submit" class="mybutton">Indietro</button>
</form><br>

<h1 class="titolo_pagina">Richiesta</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuovo_cerco" name="form_nuovo_cerco" enctype="multipart/form-data">

    <div class="row">
        <div class="one half half-padded mobile">
            <label for="specie">Specie</label>
            <select name="specie" id="specie">
                <option value="">qualunque</option>
                <option value="cane" <?php if ($record->get("specie") == 'CANE') echo "selected='selected'"; ?>>cane</option>
                <option value="gatto" <?php if ($record->get("specie") == 'GATTO') echo "selected='selected'"; ?>>gatto</option>
            </select>
        </div>
        
        <div class="one half half-padded mobile">
            <label for="flt_genere">Genere</label>
            <select name="genere" id="genere">
                <option value="">qualunque</option>
                <option value="M" <?php if ($record->get("genere") == 'M') echo "selected='selected'"; ?>>maschio</option>
                <option value="F" <?php if ($record->get("genere") == 'F') echo "selected='selected'"; ?>>femmina</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="one half half-padded mobile">
            <label for="eta">Et&agrave;</label>
            <select name="eta" id="eta">
                <option value="">qualunque</option>
                <option value="C" <?php if ($record->get("eta") == 'C') echo "selected='selected'"; ?>>cucciolo (fino ad 1 anno)</option>
                <option value="A" <?php if ($record->get("eta") == 'A') echo "selected='selected'"; ?>>adulto (oltre 1 anno)</option>
            </select>
        </div>
        <div class="one half half-padded mobile">
            <label for="taglia">Taglia</label>
            <select name="taglia" id="taglia">
                <option value="">qualunque</option>
                <option value="P" <?php if ($record->get("taglia") == 'P') echo "selected='selected'"; ?>>piccola</option>
                <option value="M" <?php if ($record->get("taglia") == 'M') echo "selected='selected'"; ?>>media</option>
                <option value="G" <?php if ($record->get("taglia") == 'G') echo "selected='selected'"; ?>>grande</option>
            </select>
        </div>
    </div>
    
    <div class="row half-padded">
        <label for="comune">Comune</label>
        <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
    </div>
    
    <div class="row half-padded">
        <label for="note_utente">Note utente (se richiesto per un altro)</label>
        <input type="text" name="note_utente" value="<?php echo $record->get("note_utente"); ?>" />
    </div>
    
    <div class="row half-padded">
        <label for="note">Note</label>
        <textarea rows="4" name="note"><?php echo $record->get("note"); ?></textarea>
    </div>
<?php
if ($utente->publisher()) {
?>
    <div class="row">
        <div class="one half half-padded mobile">
            <label for="trovato">Trovato?</label>
            <select name="trovato" id="trovato">
                <option value="N" <?php if ($record->get("trovato") == 'N') echo "selected='selected'"; ?>>non ancora</option>
                <option value="S" <?php if ($record->get("trovato") == 'S') echo "selected='selected'"; ?>>si</option>
            </select>
        </div>
    </div>
<?php
}
?>   
    
    <input type="hidden" name="ok_cerco" value="1" />
    <input type="hidden" name="code_cerco" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>
<?php 
}

get_footer(); ?>
