<?php
/**
 * Template Name: Form evento
 */

require_once('common.inc.php');
get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_evento = false;
$code_evento = getVar("POST", "code_evento");

class RecordEventi extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("eventi", "ident", $id);
    }
}
$record = Factory::crea("RecordEventi");
if (strlen($code_evento))
    $record->loadFromCode($code_evento);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_evento'] ) &&  $_POST['ok_evento'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('titolo')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario dare un titolo all'evento.", false);
    }
    if (strlen($record->get('comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il comune dove si svolge l'evento.", false);
    }
    if (strlen($record->get('data_inizio')) == 0 || strlen($record->get('data_fine')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare entrambe le date.", false);
    }
    
    else {  #for ($i=1; $i<=1; $i++) {
        $nome_campo = "immagine";
        $path_base = "/var/www/amicidigiulita.it/";
        $path_rel = "uploads/eventi/";
        if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
            $originale = basename($_FILES[$nome_campo]['tmp_name']);
            $path_parts = pathinfo($_FILES[$nome_campo]['name']);
            $extension = strtoupper($path_parts['extension']);

            if (!in_array($extension, array('PNG', 'JPG'))) {
                $errore = true;
                show_message(MSGERROR, "Formato file non permesso!", false);
            }


            if (strlen($originale)) {
                $tipo = $_FILES[$nome_campo]['type'];
                $name = "EVENTO_".substr(md5($originale), 0, 8)."__".$_FILES[$nome_campo]['name'];
                $res = move_uploaded_file($_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
                if ($res) {
                    $record->set($nome_campo, $path_rel.$name);
                }
                else{
                    $errore = true;
                    show_message(MSGERROR, "Upload logo fallito! (1)", false);
                }
            }
        }
        elseif (strlen(basename($_FILES[$nome_campo]['tmp_name'])) > 0) {
            $errore = true;
            show_message(MSGERROR, "Upload logo fallito! (2)", false);
        }
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_evento = true;
        }
    }
}

if (!$errore && $ok_evento) {
    echo <<<EOT
<form action="page-eventi.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Evento salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_evento) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
    $("#testo").wysiwyg({
        rmUnusedControls: false,
        controls: {
            increaseFontSize : { visible : true },
			decreaseFontSize : { visible : true },
			cut   : { visible : true },
			copy  : { visible : true },
			paste : { visible : true },
			html  : { visible: true },
			colorpicker: {
                visible: true,
                css: {
                    "color": function (cssValue, Wysiwyg) {
                        var document = Wysiwyg.innerDocument(),
                            defaultTextareaColor = $(document.body).css("color");

                        if (cssValue !== defaultTextareaColor) {
                            return true;
                        }

                        return false;
                    }
                },
                exec: function() {
                    if ($.wysiwyg.controls.colorpicker) {
                        $.wysiwyg.controls.colorpicker.init(this);
                    }
                },
                tooltip: "Colorpicker"
            },
					
        }
    });
});
</script>


<form action="/indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina"><?php echo $titolo_pagina; ?></h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_nuovo_evento" name="form_nuovo_evento" enctype="multipart/form-data">

    <table class="mytable">
    
    <?php if ($utente->administrator()) { ?>
    <tr>
        <th><label for="noi">Noi</label></th>
        <td><select name="noi" id="noi" class="one fourth">
                <option value="N" <?php selected($record->get("noi"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("noi"), 'S'); ?>>si</option>
            </select></td>
    </tr>
    <?php } ?>
    
    <tr>
        <th><label for="titolo">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get("titolo"); ?>" size="50" name="titolo" id="titolo" /></td>
    </tr>
    
    <tr>
        <th><label for="comune">Comune</label></th>
        <td>
            <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
        </td>
    </tr>

    <tr>
        <th><label for="localita">Localit&agrave;</label></th>
        <td><input type="text" value="<?php echo $record->get("localita"); ?>" size="50" name="localita" id="localita" /></td>
    </tr>

    <tr>
        <th><label for="">Date</label></th>
        <td><div class="row">
                <div class="one fourth">
                    <span class="prefix">Data di inizio</span>
                </div>
                <div class="one fourth">
                    <input type="text" value="<?php echo $record->get("data_inizio"); ?>" size="10" name="data_inizio" id="data_inizio" />
                </div>
                <div class="one fourth">
                    <span class="prefix">Data di fine</span>
                </div>
                <div class="one fourth">
                    <input type="text" value="<?php echo $record->get("data_fine"); ?>" size="10" name="data_fine" id="data_fine" />
                </div>
            </div>
        </td>
    </tr>
    
    <tr>
        <th><label for="immagine">Logo</label></th>
        <td><input type="file" value="" size="15" name="immagine" id="immagine" />
        <?php
        if (strlen($record->get("immagine")))
            echo "<img src='{$record->get("immagine")}' height='50px' />";
        ?>
        </td>
    </tr>

    <tr>
        <th><label for="testo">Testo</label></th>
        <td><textarea type="text" rows="5" cols="50" name="testo" id="testo"><?php echo $record->get("testo"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="url_www">Sito dell'evento (URL)</label></th>
        <td>Inserire l'URL completa della pagina web dell'evento, comprensiva di http://<br />
        <input type="text" value="<?php echo $record->get("url_www"); ?>" size="60" name="url_www" id="url_www" /></td>
    </tr>

    </table>
    <input type="hidden" name="ok_evento" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <input type="hidden" name="code_evento" value="<?php echo $record->code(); ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>