<?php
/**
 * Template Name: Form iniziativa
 */

require_once('common.inc.php');
get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_iniziativa = false;
$code_iniziativa = getVar("POST", "code_iniziativa", getVar("GET", "iniziativa"));

class RecordIniziative extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("iniziative", "ident", $id);
    }
}
$record = Factory::crea("RecordIniziative");
if (strlen($code_iniziativa))
    $record->loadFromCode($code_iniziativa);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_iniziativa'] ) &&  $_POST['ok_iniziativa'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('titolo')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario dare un titolo all'iniziativa.", false);
    }
    if (strlen($record->get('comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il comune dove si svolge l'iniziativa.", false);
    }
    if (strlen($record->get('data_inizio')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare la data di inizio.", false);
    }
    
    else {  #for ($i=1; $i<=1; $i++) {
        $nome_campo = "immagine";
        $path_base = BASE_DIR;
        $path_rel = "/uploads/eventi/";
        
        $name = upload_image($nome_campo, $path_base, $path_rel, "iniziativa_");
        if ($name !== false) {
            error_log($nome_campo." - ".$path_rel.$name);
            $record->set($nome_campo, $path_rel.$name);
        }
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_iniziativa = true;
        }
    }
}

if (!$errore && $ok_iniziativa) {
    echo <<<EOT
<form action="page-iniziative.php?#{$record->code()}" method="GET">
    <div id="message" class="updated fade"><p><strong>Iniziativa salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_iniziativa) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
    
    $("#testo").wysiwyg({
        rmUnusedControls: false,
        controls: {
            increaseFontSize : { visible : true },
			decreaseFontSize : { visible : true },
			cut   : { visible : true },
			copy  : { visible : true },
			paste : { visible : true },
			html  : { visible: true },
			colorpicker: {
                visible: true,
                css: {
                    "color": function (cssValue, Wysiwyg) {
                        var document = Wysiwyg.innerDocument(),
                            defaultTextareaColor = $(document.body).css("color");

                        if (cssValue !== defaultTextareaColor) {
                            return true;
                        }

                        return false;
                    }
                },
                exec: function() {
                    if ($.wysiwyg.controls.colorpicker) {
                        $.wysiwyg.controls.colorpicker.init(this);
                    }
                },
                tooltip: "Colorpicker"
            },
					
        }
    });
});
</script>


<form action="/indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Iniziativa</h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_nuova_iniziativa" name="form_nuova_iniziativa" enctype="multipart/form-data">

    <table class="mytable">
    
    <?php if ($utente->administrator()) { ?>
    <tr>
        <th><label for="noi">Noi</label></th>
        <td><select name="noi" id="noi" class="one fourth">
                <option value="N" <?php selected($record->get("noi"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("noi"), 'S'); ?>>si</option>
            </select></td>
    </tr>
    <?php } ?>
    
    <tr>
        <th><label for="titolo">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get("titolo"); ?>" size="50" name="titolo" id="titolo" /></td>
    </tr>
    
    <tr>
        <th><label for="comune">Comune</label></th>
        <td>
            <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
        </td>
    </tr>

    <tr>
        <th><label for="localita">Localit&agrave;</label></th>
        <td><input type="text" value="<?php echo $record->get("localita"); ?>" size="50" name="localita" id="localita" /></td>
    </tr>

    <tr>
        <th><label for="">Date</label></th>
        <td><div class="row">
                <div class="one fourth">
                    <span class="prefix">Data di inizio</span>
                </div>
                <div class="one fourth">
                    <input type="text" value="<?php echo $record->get("data_inizio"); ?>" size="10" name="data_inizio" id="data_inizio" />
                </div>
                <div class="one fourth">
                    <span class="prefix">Data di fine</span>
                </div>
                <div class="one fourth">
                    <input type="text" value="<?php echo $record->get("data_fine"); ?>" size="10" name="data_fine" id="data_fine" />
                </div>
            </div>
        </td>
    </tr>
    
    <tr>
        <th><label for="immagine">Logo</label></th>
        <td><input type="file" value="" size="15" name="immagine" id="immagine" />
        <?php
        if (strlen($record->get("immagine")))
            echo "<img src='{$record->get("immagine")}' height='50px' />";
        ?>
        </td>
    </tr>

    <tr>
        <th><label for="testo">Testo</label></th>
        <td><textarea type="text" rows="5" cols="50" name="testo" id="testo"><?php echo $record->get("testo"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="url_www">Sito dell'iniziativa (URL)</label></th>
        <td>Inserire l'URL completa della pagina web dell'iniziativa, comprensiva di http://<br />
        <input type="text" value="<?php echo $record->get("url_www"); ?>" size="60" name="url_www" id="url_www" /></td>
    </tr>

    <tr>
        <th><label for="costo_unitario">Costo unitario</label></th>
        <td>Da valorizzare se l'iniziativa &egrave; un prodotto in vendita
        <input type="text" value="<?php echo $record->get("costo_unitario"); ?>" size="60" name="costo_unitario" id="costo_unitario" /></td>
    </tr>

    <tr>
        <th><label for="costo_supplementare">Costo supplementare</label></th>
        <td>Costo extra indipendente dal numero di prodotti acquistati (es: spese di spedizione)
        <input type="text" value="<?php echo $record->get("costo_supplementare"); ?>" size="60" name="costo_supplementare" id="costo_supplementare" /></td>
    </tr>

    <tr>
        <th><label for="costo_supplementare_descrizione">Descrizione dei costi supplementari</label></th>
        <td><textarea type="text" rows="2" cols="50" name="costo_supplementare_descrizione" id="costo_supplementare_descrizione"><?php echo $record->get("costo_supplementare_descrizione"); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_iniziativa" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <input type="hidden" name="code_iniziativa" value="<?php echo $record->code(); ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>


<?php 
}

get_footer(); ?>