<?php
/**
 * Template Name: Form iscritto
 */

require_once('common.inc.php');
get_header();
check_admin();

$ok_iscritto = false;
$code_iscritto = getVar("GET", "iscritto", getVar("POST", "code_iscritto"));
$errore = false;

$permalink = "form-iscritto.php?iscritto=".$code_iscritto;
$username_visibile = (strlen($code_iscritto) == 0 && is_administrator()) ? "text" : "hidden";

class RecordIscrizioni extends RecordBase {}
$record = new RecordIscrizioni("iscritti", "ident");
$record->loadFromCode($code_iscritto);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_iscritto'] ) &&  $_POST['ok_iscritto'] == "1") {
    $record->loadInput();
    
    $username2 = getVar("POST", "username2");
    $password2 = getVar("POST", "password2");
    $email2 = getVar("POST", "email2");
    
#    print_r($record);
    
    # CHECK
    if (
        strlen($record->get('cognome')) == 0 ||
        strlen($record->get('nome')) == 0 ||
        strlen($record->get('username')) == 0 ||
        strlen($record->get('email')) == 0 ||
        strlen($record->get('password')) == 0 ||
        strlen($record->get('comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario valorizzare tutti i campi!", false);
    } 
    else {
        if (!IsValidMail($record->get('email'))) {
            $errore = true;
            show_message(MSGERROR, "L'email inserita non &egrave; valida.", false);
        }
    }
    
    if(!$errore) {
        if (strlen($code_iscritto) == 0)
            $res = $record->insert();
        else
            $res = $record->update() or print($db->ErrorMsg());
        
        if ($res) {
            $ok_iscritto = true;
        }
    }
}

if (!$errore && $ok_iscritto) {
    echo <<<EOT
<form action="admin-iscritti.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Iscritto salvato con successo.</strong></p>
    </div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
 
    
if (!$ok_iscritto) {
    echo <<<EOT
<form action="admin-iscritti.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>
EOT;
?>

<script>
jQuery(document).ready(function() {
    
});
</script>

<h1 class="titolo_pagina">Un amico di Giulita</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuova_iscrizione" name="form_nuova_iscrizione">

    <table class="mytable">

    <tr>
        <th><label for="cognome">Cognome</label></th>
        <td><input type="text" value="<?php echo $record->get('cognome'); ?>" size="20" name="cognome" id="cognome" /></td>
    </tr>

    <tr>
        <th><label for="nome">Nome</label></th>
        <td><input type="text" value="<?php echo $record->get('nome'); ?>" size="20" name="nome" id="nome" /></td>
    </tr>
    
    <tr>
        <th><label for="sesso">Sesso</label></th>
        <td><select name="sesso" id="sesso">
                <option value="M" <?php selected($record->get("sesso"), 'M'); ?>>maschio</option>
                <option value="F" <?php selected($record->get("sesso"), 'F'); ?>>femmina</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="username">Username / Facebook ID</label></th>
        <td><?php echo $record->get('username'); ?><input type="<?php echo $username_visibile; ?>" value="<?php echo $record->get('username'); ?>" name="username" id="username" /></td>
    </tr>
    
    <tr>
        <th><label for="password">Password</label></th>
        <td><input type="password" value="<?php echo $record->get('password'); ?>" size="15" name="password" id="password" /></td>
    </tr>
 
    <tr>
        <th><label for="email">Email</label></th>
        <td><input type="text" value="<?php echo $record->get('email'); ?>" size="40" name="email" id="email" /></td>
    </tr>
<?php 
if (is_administrator()) {
?>
    <tr>
        <th><label for="validato">Validato</label></th>
        <td><select name="validato" id="validato">
                <option value="0" <?php selected($record->get("validato"), 'f'); ?>>no</option>
                <option value="1" <?php selected($record->get("validato"), 't'); ?>>si</option>
            </select></td>
    </tr>

    <tr>
        <th><label for="ruolo">Ruolo</label></th>
        <td><select name="ruolo" id="ruolo">
                <option value="" <?php selected($record->get("ruolo"), ''); ?>></option>
                <option value="publisher" <?php selected($record->get("ruolo"), 'publisher'); ?>>publisher</option>
                <option value="admin" <?php selected($record->get("ruolo"), 'admin'); ?>>admin</option>
            </select></td>
    </tr>
<?php
}
?> 
    <tr>
        <th><label for="comune">Comune</label></th>
        <td>
            <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="diccisudite">Dicci qualcosa su di te</label></th>
        <td><textarea name="diccisudite" id="diccisudite" rows="5" cols="50"><?php echo $record->get('diccisudite'); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_iscritto" value="1" />
    <input type="hidden" name="code_iscritto" value="<?php echo $code_iscritto; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>
<?php 
}

get_footer(); 
?>