<?php
/**
 * Template Name: Form evento
 */

require_once('common.inc.php');
get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_link = false;
$code_link = getVar("GET", "link", getVar("POST", "code_link"));

class RecordLinkUtile extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("link_utili", "ident", $id);
    }
}
$record = Factory::crea("RecordLinkUtile");
if (strlen($code_link))
    $record->loadFromCode($code_link);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_link'] ) &&  $_POST['ok_link'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('titolo')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un titolo.", false);
    }
    if (strlen($record->get('url_www')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare l'URL del link.", false);
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_link = true;
        }
    }
}

if (!$errore && $ok_link) {
    echo <<<EOT
<form action="/indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Link salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_link) {
?>

<script>
jQuery(document).ready(function() {
    
});
</script>


<form action="/indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina"><?php echo $titolo_pagina; ?></h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_nuovo_evento" name="form_nuovo_evento" enctype="multipart/form-data">

    <table class="mytable">
    
    <tr>
        <th><label for="titolo">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get("titolo"); ?>" size="50" name="titolo" id="titolo" /></td>
    </tr>

    <tr>
        <th><label for="url_www">Sito (URL)</label></th>
        <td>Inserire l'URL completa della pagina web, comprensiva di http://<br />
        <input type="text" value="<?php echo $record->get("url_www"); ?>" size="60" name="url_www" id="url_www" /></td>
    </tr>

    </table>
    <input type="hidden" name="ok_link" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <input type="hidden" name="code_link" value="<?php echo $record->code(); ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>